/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComponent;

public class StrecthyTileLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int newAlign;
    int hgap;
    int vgap;
    private static final long serialVersionUID = -7262534875583282631L;
    boolean flag = false;
    Component[] comps = null;
    int laynum = 0;
    private static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;

    public StrecthyTileLayout() {
        this(0, 1, 1);
    }

    public StrecthyTileLayout(int v, int h) {
        this(0, v, h);
    }

    public StrecthyTileLayout(int align) {
        this(align, 1, 1);
    }

    public StrecthyTileLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int align) {
        this.newAlign = align;
        switch (align) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = align;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                dim.height = Math.max(dim.height, d.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                dim.height = Math.max(dim.height, d.height);
                if (i > 0) {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, int lastRowStart, int lastRowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.newAlign) {
                case 0: {
                    x += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x += width;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (lastRowStart != -1) {
                    int ind = lastRowStart + i - rowStart;
                    if (ind >= rowStart) {
                        ind = rowStart - 1;
                    }
                    if (ind == -1) {
                        ind = 0;
                    }
                    y = this.comps[ind].getY() + this.comps[ind].getHeight() + this.vgap;
                }
                m.setLocation(x, y);
                x += m.getWidth() + this.hgap;
            }
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        if (this.flag) {
            return;
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth();
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + this.vgap;
            int rowh = 0;
            int start = 0;
            this.comps = target.getComponents();
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            int lastRowStart = -1;
            int lastRowEnd = -1;
            boolean row = false;
            int totalH = 0;
            int totalW = 0;
            int ctr = 1;
            x = this.hgap;
            totalH = insets.top;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                m.setPreferredSize(new Dimension(target.getPreferredSize().width - 1, m.getPreferredSize().height));
                m.setMinimumSize(new Dimension(target.getMinimumSize().width - 1, m.getMinimumSize().height));
                m.setMaximumSize(new Dimension(target.getMaximumSize().width - 1, m.getMaximumSize().height));
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += this.hgap;
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                lastRowEnd = i - 1;
                totalH += rowh + this.vgap;
                totalW += this.moveComponents(target, insets.left + this.hgap, y, maxwidth - x, rowh, start, i, lastRowStart, lastRowEnd, ltr);
                ++ctr;
                x = d.width;
                y += this.vgap + rowh;
                rowh = d.height;
                lastRowStart = start;
                start = i;
            }
            totalH += rowh;
            this.moveComponents(target, insets.left + this.hgap, y, maxwidth - x, rowh, start, nmembers, lastRowStart, lastRowEnd, ltr);
            totalH += insets.bottom + this.vgap;
            this.flag = true;
            if (target instanceof JComponent) {
                Container c;
                int w = target.getMinimumSize().width;
                int h = target.getMinimumSize().height;
                if (totalH > h) {
                    ((JComponent)target).setPreferredSize(new Dimension(target.getMinimumSize().width, totalH));
                    ((JComponent)target).setMaximumSize(new Dimension(target.getMinimumSize().width, totalH));
                }
                if ((c = target.getParent()) != null) {
                    ((Component)c).doLayout();
                    ((Component)c).validate();
                }
            }
            ++this.laynum;
            this.flag = false;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.setAlignment(this.align);
        }
        this.serialVersionOnStream = 1;
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
                break;
            }
            case 3: {
                str = ",align=leading";
                break;
            }
            case 4: {
                str = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

