/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.BasicRenderer;
import UI.HeaderLabel;
import UI.LibraryTreeRenderer;
import core.Element;
import core.Line;
import core.Main;
import core.Mapping;
import core.Nuclide;
import core.OrderedMapping;
import core.TextWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class MainFrame
extends JFrame {
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Lines");
    DefaultMutableTreeNode alpha = new DefaultMutableTreeNode("Alpha");
    DefaultMutableTreeNode gamma = new DefaultMutableTreeNode("Gamma");
    DefaultMutableTreeNode xray = new DefaultMutableTreeNode("X-Ray");
    Hashtable elements = new Hashtable();
    Hashtable nuclides = new Hashtable();
    Hashtable selectednuclides = new Hashtable();
    Hashtable selectedelements = new Hashtable();
    Hashtable nuclidesNodes = new Hashtable();
    Hashtable nuclidesNodesSel = new Hashtable();
    JLabel dummy = new JLabel();
    Mapping nuclideMapping;
    String header = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?>\n<library xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"D:\\user\\Fortran\\stukprog\\alpha4\\aLibrary.xsd\">\";\n";
    String footer = "</library>\n";
    DefaultMutableTreeNode libRoot = new DefaultMutableTreeNode("Library");
    DefaultMutableTreeNode selRoot = new DefaultMutableTreeNode("Selection");
    Line currentlyEditedLine = null;
    boolean clear = false;
    int selectedLine = 0;
    JTree chainTree = null;
    List currentChain = null;
    JDialog chainDialog = null;
    Color inBack = new Color(217, 217, 180);
    private Nuclide currentlyEdited = null;
    int menuX;
    int menuY;
    JTree invokingTree = null;
    Hashtable invokerNodesNuclides = null;
    Hashtable invokerNuclidesNodes = null;
    Hashtable invokerNuclides = null;
    private JTable aField;
    private JTable aField1;
    private JMenuItem addNuclideLib;
    private JMenuItem addNuclideSel;
    private JPopupMenu chainPopup;
    private JMenuItem chainToSelection;
    private JTextArea codeArea;
    private HeaderLabel currentLabel;
    private JTable daughterField;
    private JMenuItem deleteSubtreeLib;
    private JMenuItem deleteSubtreeSel;
    private JMenuItem editNuclide;
    private JMenuItem exportSelection;
    private HeaderLabel headerLabel1;
    private HeaderLabel headerLabel2;
    private HeaderLabel headerLabel4;
    private HeaderLabel headerLabel5;
    private JTable hlField;
    private JTable hluField;
    private JCheckBoxMenuItem ignoreUncertainties;
    private JMenuItem importFile;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel12;
    private JPanel jPanel14;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JMenuItem libToSelection;
    private JTree libraryNuclidesTree;
    private JPopupMenu libraryPopup;
    private JTable linePropertiesTable;
    private JTree lineTree;
    private JTable nameField;
    private JLabel numLibNuclides;
    private JLabel numSelNuclides;
    private JMenuItem openFile;
    private JTable parentField;
    private JTextArea rawData;
    private JMenuItem rescanSubtreeForYieldLib;
    private JMenuItem rescanSubtreeForYieldSel;
    private JMenuItem saveSelectionAs;
    private JPopupMenu selectionPopup;
    private JTree selectionTree;
    private JMenuItem setToOkLib;
    private JMenuItem setToOkSel;
    private JMenuItem showChainLib;
    private JMenuItem showChainSel;
    private JTextArea statusField;
    private JLabel sumLabel;
    private JMenuItem toSelection;
    private JTable zField;

    public MainFrame() {
        this.initComponents();
        this.initTree();
        this.nuclideMapping = MainFrame.getDefaultMapping();
    }

    public void setLibraryNuclides(List l, String lib) {
        DefaultMutableTreeNode myRoot = new DefaultMutableTreeNode(lib);
        this.libRoot.add(myRoot);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.libRoot);
        this.libraryNuclidesTree.setModel(treeModel);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Nuclide n = (Nuclide)iter.next();
            String sym = Element.determineAbbreviation(n.getZ());
            n.setName(sym + "-" + n.getA().toString());
            String name = n.getName();
            Object o = this.nuclides.get(name);
            if (o != null) {
                List<Nuclide> list;
                if (o instanceof Nuclide) {
                    list = new ArrayList();
                    ((ArrayList)list).add((Nuclide)o);
                    ((ArrayList)list).add(n);
                    this.nuclides.put(name, list);
                } else if (o instanceof List) {
                    list = (List)o;
                    list.add(n);
                }
            } else {
                this.nuclides.put(name, n);
            }
            Element e = new Element();
            e.setZ(n.getZ());
            String key = e.getName() + lib;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.elements.get(key);
            if (parent == null) {
                parent = new DefaultMutableTreeNode(e.getName());
                parent.setUserObject(e.getName());
                this.elements.put(e.getName() + lib, parent);
                myRoot.add(parent);
            }
            int status = n.getStatus();
            String str = "";
            if (status == 1) {
                str = "ok";
            } else if (status == 2) {
                str = "bad data";
            } else if (status == 3) {
                str = "missing data";
            }
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(n.getA().toString() + " (" + str + ")");
            this.nuclidesNodes.put(n, child);
            child.setUserObject(n);
            parent.add(child);
        }
        this.numLibNuclides.setText("Nuclides in library:" + this.nuclides.size());
        treeModel.reload();
    }

    private void initTree() {
        this.root.add(this.alpha);
        this.root.add(this.gamma);
        this.rawData.setBackground(Color.white);
        this.statusField.setBackground(Color.white);
        DefaultTreeModel selmodel = new DefaultTreeModel(this.selRoot);
        this.selectionTree.setModel(selmodel);
        this.selectionTree.setBackground(this.dummy.getBackground());
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.lineTree.setModel(treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.libraryNuclidesTree);
        ToolTipManager.sharedInstance().registerComponent(this.lineTree);
        DefaultTreeModel libmod = new DefaultTreeModel(this.libRoot);
        this.libraryNuclidesTree.setModel(libmod);
        this.libraryNuclidesTree.getSelectionModel().setSelectionMode(1);
        this.libraryNuclidesTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)MainFrame.this.libraryNuclidesTree.getLastSelectedPathComponent();
                MainFrame.this.clearProperties();
                if (node == null) {
                    return;
                }
                Object usr = node.getUserObject();
                if (usr instanceof Nuclide) {
                    Nuclide n = (Nuclide)usr;
                    MainFrame.this.moveNuclideToEditor(n);
                }
            }
        });
        this.lineTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)MainFrame.this.lineTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object usr = node.getUserObject();
                MainFrame.this.clearTable(MainFrame.this.linePropertiesTable);
                int[] rows = MainFrame.this.lineTree.getSelectionRows();
                MainFrame.this.selectedLine = rows[0] - 1;
                if (usr instanceof Line) {
                    Line line = (Line)usr;
                    MainFrame.this.moveLineToEditor(line);
                }
            }
        });
        this.lineTree.setBackground(Color.white);
        this.selectionTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)MainFrame.this.selectionTree.getLastSelectedPathComponent();
                MainFrame.this.clearProperties();
                if (node == null) {
                    return;
                }
                Object usr = node.getUserObject();
                if (usr instanceof Nuclide) {
                    Nuclide n = (Nuclide)usr;
                    MainFrame.this.moveNuclideToEditor(n);
                }
            }
        });
    }

    private void setSelectedRawDataLine() {
        try {
            System.out.println("Selected line:" + this.selectedLine);
            int begin = this.rawData.getLineStartOffset(this.currentlyEdited.getNumberOfLines() + 4 + this.selectedLine);
            int end = this.rawData.getLineEndOffset(this.currentlyEdited.getNumberOfLines() + 4 + this.selectedLine);
            this.rawData.setSelectionColor(Color.yellow);
            this.rawData.setSelectedTextColor(Color.black);
            this.rawData.setSelectionStart(begin);
            this.rawData.setSelectionEnd(end);
            this.rawData.grabFocus();
            this.rawData.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void moveLineToEditor(Line line) {
        Object[] row1 = new Object[]{"Energy", line.getLineEnergy(), "MeV"};
        this.addRow(this.linePropertiesTable, row1);
        Object[] row2 = new Object[]{"Energy uncertainty", line.getEnergyUncertainty(), ""};
        this.addRow(this.linePropertiesTable, row2);
        Object[] row3 = new Object[]{"Yield", line.getLineYield(), "%"};
        this.addRow(this.linePropertiesTable, row3);
        Object[] row4 = new Object[]{"Yield uncertainty", line.getYieldUncertainty(), ""};
        this.addRow(this.linePropertiesTable, row4);
        this.currentlyEditedLine = line;
    }

    private void clearTable(JTable tab) {
        this.clear = true;
        DefaultTableModel model = (DefaultTableModel)tab.getModel();
        int row = tab.getRowCount();
        for (int i = 0; i < row; ++i) {
            model.removeRow(0);
        }
        this.clear = false;
    }

    private void addRow(JTable tab, Object[] row) {
        this.clear = true;
        DefaultTableModel model = (DefaultTableModel)tab.getModel();
        model.addRow(row);
        this.clear = false;
    }

    private void clearProperties() {
        this.clear = true;
        this.currentLabel.setText(" Currently editing: nothing");
        this.aField.setValueAt(null, 0, 0);
        this.zField.setValueAt(null, 0, 0);
        this.alpha.removeAllChildren();
        this.daughterField.setValueAt(null, 0, 0);
        this.parentField.setValueAt(null, 0, 0);
        this.hlField.setValueAt(null, 0, 0);
        this.hluField.setValueAt(null, 0, 0);
        this.nameField.setValueAt(null, 0, 0);
        this.clearTable(this.linePropertiesTable);
        DefaultTreeModel mo = (DefaultTreeModel)this.lineTree.getModel();
        mo.reload();
        this.clear = false;
    }

    private void initTable(JTable table) {
        table.getColumnModel().getColumn(0).setPreferredWidth(105);
        table.getColumnModel().getColumn(1).setPreferredWidth(82);
        table.getColumnModel().getColumn(2).setPreferredWidth(38);
        table.setRowHeight(table.getRowHeight() + 2);
        table.setSelectionMode(0);
    }

    private void moveNuclideToEditor(Nuclide n) {
        this.clear = true;
        this.rawData.setText("");
        this.nameField.setValueAt(n.getName(), 0, 0);
        this.hlField.setValueAt(n.getHalflife(), 0, 0);
        this.hluField.setValueAt(n.getHalflifeUnit(), 0, 0);
        this.zField.setValueAt(n.getZ(), 0, 0);
        this.aField.setValueAt(n.getA(), 0, 0);
        this.aField1.setValueAt(n.getAlphaBranching(), 0, 0);
        this.daughterField.setValueAt(n.getDaughter(), 0, 0);
        this.parentField.setValueAt(n.getParent(), 0, 0);
        List l = n.getLines();
        DefaultTreeModel model = (DefaultTreeModel)this.lineTree.getModel();
        this.alpha.removeAllChildren();
        this.currentLabel.setText(" Currently editing: " + n.getName());
        Iterator iter = l.iterator();
        this.currentlyEdited = n;
        this.rawData.insert("Nuclide:------------------------\n" + n.getRawData() + "\n", 0);
        this.rawData.insert("Alpha lines:------------------------\n", this.rawData.getDocument().getLength());
        this.setSelectedMapping();
        boolean warn = false;
        DefaultMutableTreeNode nod = null;
        float sum = 0.0f;
        while (iter.hasNext()) {
            Line line = (Line)iter.next();
            int ctr = 0;
            if (!line.getLineType().equals("a")) continue;
            try {
                this.rawData.insert(line.getRawData() + "\n", this.rawData.getDocument().getLength());
                DefaultMutableTreeNode lineNode = new DefaultMutableTreeNode(line.getLineEnergy().toString() + " MeV");
                lineNode.setUserObject(line);
                Float Y = line.getLineYield();
                if (Y != null) {
                    sum += Y.floatValue();
                }
                this.alpha.add(lineNode);
                if (ctr++ != 0) continue;
                nod = lineNode;
            }
            catch (Exception ex) {
                DefaultMutableTreeNode lineNode = new DefaultMutableTreeNode("Unknown line");
                lineNode.setUserObject(line);
                this.alpha.add(lineNode);
                ex.printStackTrace();
                if (!warn) {
                    Main.warnUser("Bad data encountered.\nSome lines displayed as 'Unknown line'.", true);
                }
                warn = true;
            }
        }
        this.sumLabel.setText("" + sum);
        model.reload();
        this.statusField.setText(n.getStatusComment() == null ? "Ok" : n.getStatusComment());
        this.statusField.setForeground(n.getStatus() != 1 ? (n.getStatus() == 2 ? LibraryTreeRenderer.badColor : LibraryTreeRenderer.missingColor) : Color.black);
        this.lineTree.expandPath(new TreePath(this.alpha.getPath()));
        this.lineTree.repaint();
        if (nod != null) {
            this.lineTree.setSelectionPath(new TreePath(nod.getPath()));
        }
        this.clear = false;
    }

    private Nuclide[] findNuclide(String name, Hashtable set) {
        Object o = set.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof Nuclide) {
            Nuclide[] ret = new Nuclide[]{(Nuclide)o};
            return ret;
        }
        if (o instanceof List) {
            List list = (List)o;
            return list.toArray(new Nuclide[list.size()]);
        }
        return null;
    }

    private void showChainDialog(Nuclide n, int x, int y, Hashtable set) {
        this.currentChain = new ArrayList();
        JDialog d = null;
        if (this.chainDialog == null) {
            this.chainDialog = d = new JDialog(this);
        } else {
            d = this.chainDialog;
            d.getContentPane().removeAll();
        }
        JTree tree = new JTree();
        tree.setBackground(Color.white);
        this.chainTree = tree;
        tree.setCellRenderer(new LibraryTreeRenderer(false));
        ToolTipManager.sharedInstance().registerComponent(tree);
        Nuclide chainRoot = n;
        String s = chainRoot.getParent();
        while (s != null) {
            Nuclide[] parents = this.findNuclide(s, set);
            if (parents == null) {
                String str = "library";
                if (set == this.selectednuclides) {
                    str = "selection";
                }
                Main.warnUser("Chain could not be fully resolved: \nParent of " + chainRoot.getName() + " not found in " + str + ".\nThe missing nuclide is:" + s);
                s = null;
                continue;
            }
            chainRoot = parents[0];
            s = chainRoot.getParent();
        }
        DefaultMutableTreeNode r = new DefaultMutableTreeNode(chainRoot.getName());
        r.setUserObject(chainRoot);
        DefaultMutableTreeNode next = null;
        DefaultMutableTreeNode prev = null;
        DefaultMutableTreeNode last = r;
        s = chainRoot.getDaughter();
        this.currentChain.add(chainRoot);
        while (s != null) {
            Nuclide[] daughters = this.findNuclide(s, set);
            if (daughters == null) {
                if (prev == null) {
                    next = new DefaultMutableTreeNode(s + " (not found)");
                    r.add(next);
                } else {
                    next = new DefaultMutableTreeNode(s + " (not found)");
                    prev.add(next);
                }
                last = next;
                s = null;
                continue;
            }
            chainRoot = daughters[0];
            if (prev == null) {
                next = new DefaultMutableTreeNode(chainRoot.getName());
                next.setUserObject(chainRoot);
                this.currentChain.add(chainRoot);
                r.add(next);
            } else {
                next = new DefaultMutableTreeNode(chainRoot.getName());
                next.setUserObject(chainRoot);
                this.currentChain.add(chainRoot);
                prev.add(next);
            }
            prev = next;
            last = next;
            s = chainRoot.getDaughter();
        }
        DefaultTreeModel model = new DefaultTreeModel(r);
        tree.setModel(model);
        tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    MainFrame.this.chainPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JScrollPane pane = new JScrollPane(tree);
        d.getContentPane().add(pane);
        d.setSize(300, 180);
        String str = this.invokingTree == this.libraryNuclidesTree ? " (Library)" : " (Selection)";
        d.setTitle("Decay chain for " + n.getName() + str);
        d.setLocation(x, y);
        d.show();
        tree.scrollPathToVisible(new TreePath(last.getPath()));
    }

    private void initComponents() {
        this.libraryPopup = new JPopupMenu();
        this.libToSelection = new JMenuItem();
        this.deleteSubtreeLib = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.showChainLib = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.addNuclideLib = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.setToOkLib = new JMenuItem();
        this.rescanSubtreeForYieldLib = new JMenuItem();
        this.ignoreUncertainties = new JCheckBoxMenuItem();
        this.chainPopup = new JPopupMenu();
        this.editNuclide = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.toSelection = new JMenuItem();
        this.chainToSelection = new JMenuItem();
        this.selectionPopup = new JPopupMenu();
        this.showChainSel = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.addNuclideSel = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.deleteSubtreeSel = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.setToOkSel = new JMenuItem();
        this.rescanSubtreeForYieldSel = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.headerLabel1 = new HeaderLabel();
        this.jScrollPane2 = new JScrollPane();
        this.libraryNuclidesTree = new JTree();
        this.jPanel12 = new JPanel();
        this.numLibNuclides = new JLabel();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.currentLabel = new HeaderLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.nameField = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.zField = new JTable();
        this.aField = new JTable();
        this.jLabel3 = new JLabel();
        this.aField1 = new JTable();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.hlField = new JTable();
        this.jLabel6 = new JLabel();
        this.hluField = new JTable();
        this.jLabel7 = new JLabel();
        this.parentField = new JTable();
        this.jLabel8 = new JLabel();
        this.daughterField = new JTable();
        this.jScrollPane3 = new JScrollPane();
        this.lineTree = new JTree();
        this.headerLabel4 = new HeaderLabel();
        this.linePropertiesTable = new JTable();
        this.statusField = new JTextArea();
        this.headerLabel5 = new HeaderLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jLabel9 = new JLabel();
        this.sumLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.codeArea = new JTextArea();
        this.jPanel8 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.rawData = new JTextArea();
        this.jPanel5 = new JPanel();
        this.headerLabel2 = new HeaderLabel();
        this.jScrollPane1 = new JScrollPane();
        this.selectionTree = new JTree();
        this.jPanel14 = new JPanel();
        this.numSelNuclides = new JLabel();
        this.jPanel9 = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.openFile = new JMenuItem();
        this.importFile = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.saveSelectionAs = new JMenuItem();
        this.exportSelection = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.libToSelection.setText("Move to selection");
        this.libToSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.libToSelectionActionPerformed(evt);
            }
        });
        this.libraryPopup.add(this.libToSelection);
        this.deleteSubtreeLib.setText("Remove");
        this.deleteSubtreeLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.deleteSubtreeLibActionPerformed(evt);
            }
        });
        this.libraryPopup.add(this.deleteSubtreeLib);
        this.libraryPopup.add(this.jSeparator2);
        this.showChainLib.setText("Show decay chain");
        this.showChainLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.showChainLibActionPerformed(evt);
            }
        });
        this.libraryPopup.add(this.showChainLib);
        this.libraryPopup.add(this.jSeparator3);
        this.addNuclideLib.setText("Create nuclide");
        this.addNuclideLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.addNuclideLibActionPerformed(evt);
            }
        });
        this.libraryPopup.add(this.addNuclideLib);
        this.libraryPopup.add(this.jSeparator1);
        this.setToOkLib.setText("Set status to ok");
        this.libraryPopup.add(this.setToOkLib);
        this.rescanSubtreeForYieldLib.setText("Rescan subtree for yield problems");
        this.rescanSubtreeForYieldLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.rescanSubtreeForYieldLibActionPerformed(evt);
            }
        });
        this.libraryPopup.add(this.rescanSubtreeForYieldLib);
        this.ignoreUncertainties.setText("Ignore missing uncertainties");
        this.ignoreUncertainties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.ignoreUncertaintiesActionPerformed(evt);
            }
        });
        this.libraryPopup.add(this.ignoreUncertainties);
        this.editNuclide.setText("Edit nuclide");
        this.editNuclide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.editNuclideActionPerformed(evt);
            }
        });
        this.chainPopup.add(this.editNuclide);
        this.chainPopup.add(this.jSeparator4);
        this.toSelection.setText("Move nuclide to selection");
        this.toSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.toSelectionActionPerformed(evt);
            }
        });
        this.chainPopup.add(this.toSelection);
        this.chainToSelection.setText("Move the decay chain to selection");
        this.chainToSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.chainToSelectionActionPerformed(evt);
            }
        });
        this.chainPopup.add(this.chainToSelection);
        this.showChainSel.setText("Show decay chain");
        this.showChainSel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.showChainSelActionPerformed(evt);
            }
        });
        this.selectionPopup.add(this.showChainSel);
        this.selectionPopup.add(this.jSeparator5);
        this.addNuclideSel.setText("Create nuclide");
        this.selectionPopup.add(this.addNuclideSel);
        this.selectionPopup.add(this.jSeparator6);
        this.deleteSubtreeSel.setText("Delete subtree");
        this.deleteSubtreeSel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.deleteSubtreeSelActionPerformed(evt);
            }
        });
        this.selectionPopup.add(this.deleteSubtreeSel);
        this.selectionPopup.add(this.jSeparator7);
        this.setToOkSel.setText("Set status to ok");
        this.selectionPopup.add(this.setToOkSel);
        this.rescanSubtreeForYieldSel.setText("Rescan subtree for yield problems");
        this.selectionPopup.add(this.rescanSubtreeForYieldSel);
        this.setDefaultCloseOperation(3);
        this.setTitle("Library manager");
        this.setIconImage(new ImageIcon(this.getClass().getResource("images/MainIcon.png")).getImage());
        this.jSplitPane1.setDividerLocation(250);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setPreferredSize(new Dimension(250, 300));
        this.headerLabel1.setText(" Loaded libraries");
        this.jPanel2.add((Component)this.headerLabel1, "North");
        this.jScrollPane2.setPreferredSize(new Dimension(100, 100));
        this.libraryNuclidesTree.setCellRenderer(new LibraryTreeRenderer());
        this.libraryNuclidesTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.libraryNuclidesTreeMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.libraryNuclidesTree);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jPanel12.setLayout(new FlowLayout(0, 5, 0));
        this.jPanel12.setBorder(new SoftBevelBorder(1));
        this.numLibNuclides.setText("Nuclides in library:0");
        this.jPanel12.add(this.numLibNuclides);
        this.jPanel2.add((Component)this.jPanel12, "South");
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jSplitPane2.setDividerLocation(450);
        this.jPanel3.setLayout(new BorderLayout());
        this.currentLabel.setText(" Current nuclide");
        this.jPanel3.add((Component)this.currentLabel, "North");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainFrame.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.jPanel1.setPreferredSize(new Dimension(340, 240));
        this.nameField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.nameField.setRowSelectionAllowed(false);
        this.initListeners(this.nameField);
        this.nameField.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.jPanel1.add((Component)this.nameField, new AbsoluteConstraints(80, 10, 90, -1));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Name:");
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(10, 10, 60, -1));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Z:");
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(10, 30, 60, -1));
        this.zField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.zField.setRowSelectionAllowed(false);
        this.initListeners(this.zField);
        this.zField.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.jPanel1.add((Component)this.zField, new AbsoluteConstraints(80, 30, 50, -1));
        this.aField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.aField.setRowSelectionAllowed(false);
        this.initListeners(this.aField);
        this.aField.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.jPanel1.add((Component)this.aField, new AbsoluteConstraints(80, 50, 50, -1));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("A:");
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(10, 50, 60, -1));
        this.aField1.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.aField1.setRowSelectionAllowed(false);
        this.aField1.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.jPanel1.add((Component)this.aField1, new AbsoluteConstraints(150, 70, 80, -1));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Alpha branching:");
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(20, 70, 120, -1));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Half-life:");
        this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(20, 90, 120, -1));
        this.hlField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.hlField.setRowSelectionAllowed(false);
        this.initListeners(this.hlField);
        this.hlField.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.jPanel1.add((Component)this.hlField, new AbsoluteConstraints(150, 90, 80, -1));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Half-life unit:");
        this.jPanel1.add((Component)this.jLabel6, new AbsoluteConstraints(20, 110, 120, -1));
        this.hluField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.hluField.setRowSelectionAllowed(false);
        this.initListeners(this.hluField);
        this.hluField.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.jPanel1.add((Component)this.hluField, new AbsoluteConstraints(150, 110, 80, -1));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Parent:");
        this.jPanel1.add((Component)this.jLabel7, new AbsoluteConstraints(0, 130, 70, -1));
        this.parentField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.parentField.setRowSelectionAllowed(false);
        this.initListeners(this.parentField);
        this.parentField.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.jPanel1.add((Component)this.parentField, new AbsoluteConstraints(80, 130, 80, -1));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Daughter:");
        this.jPanel1.add((Component)this.jLabel8, new AbsoluteConstraints(0, 150, 70, -1));
        this.daughterField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.daughterField.setRowSelectionAllowed(false);
        this.initListeners(this.daughterField);
        this.daughterField.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.jPanel1.add((Component)this.daughterField, new AbsoluteConstraints(80, 150, 80, -1));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 100));
        this.lineTree.setCellRenderer(new LibraryTreeRenderer());
        this.jScrollPane3.setViewportView(this.lineTree);
        this.jPanel1.add((Component)this.jScrollPane3, new AbsoluteConstraints(10, 180, 200, 160));
        this.headerLabel4.setText(" Line properties");
        this.jPanel1.add((Component)this.headerLabel4, new AbsoluteConstraints(230, 180, 200, -1));
        this.linePropertiesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.linePropertiesTable.setOpaque(false);
        this.linePropertiesTable.setShowHorizontalLines(false);
        this.linePropertiesTable.setShowVerticalLines(false);
        this.initTable(this.linePropertiesTable);
        this.linePropertiesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.linePropertiesTable.getColumnModel().getColumn(1).setCellRenderer(new BasicRenderer(1));
        this.linePropertiesTable.getColumnModel().getColumn(2).setCellRenderer(new BasicRenderer());
        this.initListeners(this.linePropertiesTable);
        this.jPanel1.add((Component)this.linePropertiesTable, new AbsoluteConstraints(230, 200, 200, 80));
        this.statusField.setColumns(10);
        this.statusField.setFont(new Font("SansSerif", 0, 12));
        this.jPanel1.add((Component)this.statusField, new AbsoluteConstraints(10, 370, 420, 40));
        this.headerLabel5.setText(" Status");
        this.jPanel1.add((Component)this.headerLabel5, new AbsoluteConstraints(10, 350, 420, -1));
        this.jButton1.setText("Set status to ok");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton1, new AbsoluteConstraints(270, 10, -1, -1));
        this.jButton2.setText("Delete line");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton2, new AbsoluteConstraints(230, 310, -1, -1));
        this.jButton3.setText("Add line");
        this.jPanel1.add((Component)this.jButton3, new AbsoluteConstraints(320, 310, -1, -1));
        this.jLabel9.setText("Sum of line yields:");
        this.jPanel1.add((Component)this.jLabel9, new AbsoluteConstraints(230, 290, -1, -1));
        this.sumLabel.setText("0");
        this.jPanel1.add((Component)this.sumLabel, new AbsoluteConstraints(320, 290, 110, -1));
        this.jTabbedPane1.addTab("Properties", this.jPanel1);
        this.jPanel4.setLayout(new BorderLayout());
        this.jScrollPane5.setViewportView(this.codeArea);
        this.jPanel4.add((Component)this.jScrollPane5, "Center");
        this.jTabbedPane1.addTab("Code", this.jPanel4);
        this.jPanel8.setLayout(new BorderLayout());
        this.jScrollPane4.setViewportView(this.rawData);
        this.jPanel8.add((Component)this.jScrollPane4, "Center");
        this.jTabbedPane1.addTab("Raw data", this.jPanel8);
        this.jPanel3.add((Component)this.jTabbedPane1, "Center");
        this.jSplitPane2.setLeftComponent(this.jPanel3);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel5.setBackground(new Color(216, 217, 181));
        this.jPanel5.setPreferredSize(new Dimension(250, 115));
        this.headerLabel2.setText(" Selection");
        this.jPanel5.add((Component)this.headerLabel2, "North");
        this.jScrollPane1.setOpaque(false);
        this.jScrollPane1.setPreferredSize(new Dimension(100, 100));
        this.selectionTree.setBackground(new Color(217, 217, 180));
        this.selectionTree.setCellRenderer(new LibraryTreeRenderer());
        this.selectionTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.selectionTreeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.selectionTree);
        this.jPanel5.add((Component)this.jScrollPane1, "Center");
        this.jPanel14.setLayout(new FlowLayout(0, 5, 0));
        this.jPanel14.setBorder(new SoftBevelBorder(1));
        this.numSelNuclides.setText("Nuclides in selection: 0");
        this.jPanel14.add(this.numSelNuclides);
        this.jPanel5.add((Component)this.jPanel14, "South");
        this.jSplitPane2.setRightComponent(this.jPanel5);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jPanel9.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanel9, "South");
        this.jMenu1.setText("File");
        this.openFile.setText("Open library");
        this.openFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.openFileActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.openFile);
        this.importFile.setText("Import library");
        this.importFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.importFileActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.importFile);
        this.jMenu1.add(this.jSeparator8);
        this.saveSelectionAs.setText("Save selection as");
        this.saveSelectionAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveSelectionAsActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveSelectionAs);
        this.exportSelection.setText("Export selection");
        this.jMenu1.add(this.exportSelection);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 980) / 2, (screenSize.height - 518) / 2, 980, 518);
    }

    private void importFileActionPerformed(ActionEvent evt) {
        FileFilter f1 = new FileFilter(){

            public boolean accept(File f) {
                return MainFrame.this.getExtension(f).equals("ens");
            }

            public String getDescription() {
                return "(.ens) ensdef format nuclide data.";
            }
        };
        FileFilter[] filt = new FileFilter[]{f1};
        File f = this.chooseFile(false, filt);
        if (f == null) {
            return;
        }
        Main.importEnsDef(f.getAbsolutePath());
    }

    public String getExtension(File f) {
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private void openFileActionPerformed(ActionEvent evt) {
        FileFilter f1 = new FileFilter(){

            public boolean accept(File f) {
                return MainFrame.this.getExtension(f).equals("xml");
            }

            public String getDescription() {
                return "(.xml) xml format nuclide library.";
            }
        };
        FileFilter[] filt = new FileFilter[]{f1};
        File f = this.chooseFile(false, filt);
        if (f == null) {
            return;
        }
        Main.importXML(f.getAbsolutePath());
    }

    private String getString(Nuclide n, Mapping m) {
        return m.apply(n);
    }

    private void saveSelectionAsActionPerformed(ActionEvent evt) {
        Enumeration<TreeNode> enu = this.selRoot.depthFirstEnumeration();
        ArrayList<Nuclide> list = new ArrayList<Nuclide>();
        String str = "";
        str = str + this.header;
        int i = 0;
        while (enu.hasMoreElements()) {
            DefaultMutableTreeNode node;
            Object o;
            TreeNode n = enu.nextElement();
            if (!n.isLeaf() || !((o = (node = (DefaultMutableTreeNode)n).getUserObject()) instanceof Nuclide)) continue;
            list.add((Nuclide)o);
        }
        Nuclide[] nucs = list.toArray(new Nuclide[list.size()]);
        Arrays.sort(nucs, new Comparator(){

            public int compare(Object o1, Object o2) {
                Nuclide n1 = (Nuclide)o1;
                Nuclide n2 = (Nuclide)o2;
                String name1 = n1.getName();
                String name2 = n2.getName();
                return name1.compareTo(name2);
            }
        });
        for (i = 0; i < nucs.length; ++i) {
            str = str + this.nuclideMapping.apply(nucs[i]);
        }
        str = str + this.footer;
        File f = this.chooseFile(true, null);
        if (f == null) {
            return;
        }
        TextWriter w = new TextWriter();
        w.writeText(f.getAbsolutePath(), str, false);
    }

    private void rescanSubtreeForYieldLibActionPerformed(ActionEvent evt) {
        JPanel p = new JPanel();
        final JDialog d = new JDialog((Frame)this, true);
        d.setUndecorated(true);
        final JTextField f = new JTextField();
        f.setText("0.01");
        f.setColumns(9);
        JLabel lab = new JLabel("Tolerance:");
        p.setLayout(new FlowLayout(0, 0, 0));
        p.add(lab);
        p.add(f);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0, 0, 0));
        final JButton ok = new JButton("Ok");
        final JButton cancel = new JButton("Cancel");
        p2.add(ok);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src == ok) {
                    try {
                        MainFrame.this.checkYields(MainFrame.this.nuclides, Float.parseFloat(f.getText()));
                    }
                    catch (Exception ex) {
                        Main.warnUser("Improper tolerance value!");
                    }
                    d.dispose();
                } else if (src == cancel) {
                    d.dispose();
                }
            }
        };
        ok.addActionListener(al);
        cancel.addActionListener(al);
        p2.add(cancel);
        JPanel p3 = new JPanel();
        p3.setBorder(new SoftBevelBorder(0));
        p3.setLayout(new BorderLayout());
        p3.add((Component)new HeaderLabel(" Rescan line yields"), "North");
        p3.add((Component)p, "Center");
        p3.add((Component)p2, "South");
        d.getContentPane().add(p3);
        Point pt = this.libraryPopup.getLocation();
        SwingUtilities.convertPointToScreen(pt, this.libraryPopup);
        d.setLocation(this.menuX, this.menuY);
        d.pack();
        d.setVisible(true);
    }

    private void ignoreUncertaintiesActionPerformed(ActionEvent evt) {
        Iterator iter = this.nuclides.values().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Nuclide) {
                Nuclide n = (Nuclide)o;
                this.checkLines(n, this.ignoreUncertainties.isSelected());
                continue;
            }
            if (!(o instanceof List)) continue;
            List l = (List)o;
            Iterator l_iter = l.iterator();
            while (l_iter.hasNext()) {
                this.checkLines((Nuclide)l_iter.next(), this.ignoreUncertainties.isSelected());
            }
        }
        this.libraryNuclidesTree.repaint();
    }

    private void checkYield(Nuclide n, float tolerance) {
        if (n.getStatus() == 3) {
            return;
        }
        List l = n.getLines();
        Iterator l_iter = l.iterator();
        float sum = 0.0f;
        boolean err = false;
        while (l_iter.hasNext() && !err) {
            Line line = (Line)l_iter.next();
            Float y = line.getLineYield();
            if (y != null) {
                sum += y.floatValue();
                continue;
            }
            line.setStatus(3);
            n.setStatus(3);
            line.setStatusComment(line.getStatusComment() + " Missing line yield");
            n.setStatusComment(n.getStatusComment() + " Missing line yield");
            err = true;
        }
        if (n.getStatus() != 3 && !err && Math.abs(1.0f - sum) > tolerance) {
            n.setStatus(2);
            n.setStatusComment("Sum of line yields differs from 1 by " + Math.abs(1.0f - sum));
        }
    }

    private void checkLines(Nuclide n, boolean ignoreUnc) {
        boolean err = false;
        List l = n.getLines();
        Iterator l_iter = l.iterator();
        while (l_iter.hasNext() && !err) {
            boolean ok;
            Line line = (Line)l_iter.next();
            boolean bl = ok = line.getLineEnergy() != null && line.getLineYield() != null;
            if (!ignoreUnc) {
                boolean bl2 = ok = ok && line.getEnergyUncertainty() != null && line.getYieldUncertainty() != null;
            }
            if (ok) {
                line.setStatus(1);
                line.setStatusComment(line.getStatusComment() + "(ignored!)");
                continue;
            }
            if (line.getLineEnergy() == null) {
                line.setStatusComment(line.getStatusComment() + " Line energy missing");
            }
            if (line.getLineYield() == null) {
                line.setStatusComment(line.getStatusComment() + " Line Yield missing");
            }
            if (!ignoreUnc) {
                if (line.getEnergyUncertainty() == null) {
                    line.setStatusComment(line.getStatusComment() + " Line energy uncertainty missing");
                }
                if (line.getYieldUncertainty() == null) {
                    line.setStatusComment(line.getStatusComment() + " Line Yield uncertainty missing");
                }
            }
            line.setStatus(3);
            n.setStatus(3);
            err = true;
        }
        if (!err) {
            n.setStatus(1);
        }
        this.checkYield(n, 0.01f);
    }

    private void checkYields(Hashtable set, float tol) {
        Iterator iter = set.values().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Nuclide) {
                Nuclide n = (Nuclide)o;
                this.checkYield(n, tol);
                continue;
            }
            if (!(o instanceof List)) continue;
            List l = (List)o;
            Iterator l_iter = l.iterator();
            while (l_iter.hasNext()) {
                this.checkYield((Nuclide)l_iter.next(), tol);
            }
        }
        this.libraryNuclidesTree.repaint();
    }

    private void libToSelectionActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = this.getSelectedNode(this.libraryNuclidesTree);
        Enumeration<TreeNode> en = node.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode mn;
            Object o;
            TreeNode n = en.nextElement();
            if (!n.isLeaf() || !((o = (mn = (DefaultMutableTreeNode)n).getUserObject()) instanceof Nuclide)) continue;
            this.moveNuclideToSelection((Nuclide)mn.getUserObject());
        }
    }

    private void deleteSubtreeSelActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = this.getSelectedNode(this.selectionTree);
        if (node == null) {
            return;
        }
        if (node.getChildCount() > 0) {
            this.removeElement(node, this.selectionTree, this.selectednuclides, this.nuclidesNodesSel, this.selectedelements);
        } else {
            Nuclide n = (Nuclide)node.getUserObject();
            this.removeNuclide(n, this.selectionTree, this.selectednuclides, this.nuclidesNodesSel, this.selectedelements);
        }
    }

    private void deleteSubtreeLibActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = this.getSelectedNode(this.libraryNuclidesTree);
        System.out.println("Removed node depth:" + node.getLevel());
        if (node == null) {
            return;
        }
        if (node.getChildCount() > 0) {
            if (node.getLevel() > 1) {
                this.removeElement(node, this.libraryNuclidesTree, this.nuclides, this.nuclidesNodes, this.elements);
            } else if (!node.isRoot()) {
                node.removeFromParent();
                int ct = node.getChildCount();
                for (int i = 0; i < ct; ++i) {
                    DefaultMutableTreeNode ch = (DefaultMutableTreeNode)node.getChildAt(0);
                    this.removeElement(ch, this.libraryNuclidesTree, this.nuclides, this.nuclidesNodes, this.elements);
                }
            }
        } else {
            Object o = node.getUserObject();
            if (o instanceof Nuclide) {
                Nuclide n = (Nuclide)node.getUserObject();
                this.removeNuclide(n, this.libraryNuclidesTree, this.nuclides, this.nuclidesNodes, this.elements);
            } else if (!node.isRoot()) {
                node.removeFromParent();
            }
        }
    }

    private void removeNuclide(Nuclide n, JTree tree, Hashtable set, Hashtable map, Hashtable elems) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)map.get(n);
        Object o = set.get(n.getName());
        if (o instanceof List) {
            List l = (List)o;
            l.remove(n);
            if (l.size() == 1) {
                Nuclide nu = (Nuclide)l.get(0);
                set.put(nu.getName(), nu);
            }
        } else {
            set.remove(n.getName());
        }
        map.remove(n);
        int row = tree.getRowForPath(new TreePath(node.getPath()));
        TreePath path = tree.getPathForRow(row - 1);
        TreeNode parent = node.getParent();
        node.removeFromParent();
        if (parent.getChildCount() == 0) {
            this.removeElement((DefaultMutableTreeNode)parent, tree, set, map, elems);
        } else {
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            model.reload();
            tree.scrollPathToVisible(path);
            tree.repaint();
        }
    }

    private void scrollToNextRow(JTree tree) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        model.reload();
    }

    private void removeElement(DefaultMutableTreeNode node, JTree tree, Hashtable set, Hashtable map, Hashtable elems) {
        elems.values().remove(node);
        int ch = node.getChildCount();
        for (int i = 0; i < ch; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(ch - i - 1);
            Nuclide n = (Nuclide)child.getUserObject();
            if (n == null) continue;
            this.removeNuclide(n, tree, set, map, elems);
        }
        int row = tree.getRowForPath(new TreePath(node.getPath()));
        TreePath path = tree.getPathForRow(row - 1);
        node.removeFromParent();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        model.reload();
        tree.scrollPathToVisible(path);
        tree.repaint();
    }

    private void chainToSelectionActionPerformed(ActionEvent evt) {
        if (this.currentChain == null) {
            return;
        }
        Iterator iter = this.currentChain.iterator();
        while (iter.hasNext()) {
            Nuclide n = (Nuclide)iter.next();
            this.moveNuclideToSelection(n);
        }
    }

    private void toSelectionActionPerformed(ActionEvent evt) {
        if (this.currentChain == null) {
            return;
        }
        Iterator iter = this.currentChain.iterator();
        while (iter.hasNext()) {
            Nuclide n = (Nuclide)iter.next();
            this.moveNuclideToSelection(n);
        }
    }

    private void showChainSelActionPerformed(ActionEvent evt) {
        Nuclide n = this.getSelectedNuclide(this.selectionTree);
        if (n == null) {
            return;
        }
        this.invokingTree = this.selectionTree;
        this.invokerNuclidesNodes = this.nuclidesNodesSel;
        this.invokerNuclides = this.selectednuclides;
        this.showChainDialog(n, this.menuX, this.menuY, this.selectednuclides);
    }

    private void selectionTreeMouseClicked(MouseEvent evt) {
        this.inBack = this.dummy.getBackground();
        if (this.selectionTree.getBackground() != Color.white) {
            this.selectionTree.setBackground(Color.white);
            this.libraryNuclidesTree.setBackground(this.inBack);
            this.libraryNuclidesTree.setSelectionRow(-1);
            this.libraryNuclidesTree.repaint();
            this.selectionTree.repaint();
            return;
        }
        Point p = evt.getPoint();
        SwingUtilities.convertPointToScreen(p, this.libraryNuclidesTree);
        this.menuX = p.x;
        this.menuY = p.y;
        if (evt.getButton() != 1) {
            this.selectionPopup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.currentlyEdited.getLines().remove(this.currentlyEditedLine);
        this.moveNuclideToEditor(this.currentlyEdited);
        this.repaint();
    }

    private void moveNuclideToSelection(Nuclide n) {
        if (n == null) {
            return;
        }
        String name = (n = (Nuclide)n.clone()).getName();
        Object o = this.selectednuclides.get(name);
        if (o != null) {
            List<Nuclide> list;
            if (o instanceof Nuclide) {
                list = new ArrayList();
                ((ArrayList)list).add((Nuclide)o);
                ((ArrayList)list).add(n);
                this.selectednuclides.put(name, list);
            } else if (o instanceof List) {
                list = (List)o;
                list.add(n);
            }
        } else {
            this.selectednuclides.put(name, n);
        }
        Element e = new Element();
        e.setZ(n.getZ());
        String key = e.getName();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selectedelements.get(key);
        if (parent == null) {
            parent = new DefaultMutableTreeNode(e.getName());
            parent.setUserObject(e.getName());
            this.selectedelements.put(e.getName(), parent);
            this.selRoot.add(parent);
        }
        int status = n.getStatus();
        String str = "";
        if (status == 1) {
            str = "ok";
        } else if (status == 2) {
            str = "bad data";
        } else if (status == 3) {
            str = "missing data";
        }
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(n.getA().toString() + " (" + str + ")");
        this.nuclidesNodesSel.put(n, child);
        child.setUserObject(n);
        parent.add(child);
        DefaultTreeModel m = (DefaultTreeModel)this.selectionTree.getModel();
        m.reload();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.currentlyEdited.setStatus(1);
        this.currentlyEdited.setStatusComment("Fixed.");
        this.repaint();
    }

    private void editNuclideActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.chainTree.getLastSelectedPathComponent();
        this.clearProperties();
        if (node == null) {
            return;
        }
        Object usr = node.getUserObject();
        if (usr instanceof Nuclide) {
            Nuclide n = (Nuclide)usr;
            this.moveNuclideToEditor(n);
            DefaultMutableTreeNode snode = (DefaultMutableTreeNode)this.invokerNuclidesNodes.get(n);
            this.invokingTree.setSelectionPath(new TreePath(snode.getPath()));
            this.invokingTree.scrollPathToVisible(new TreePath(snode.getPath()));
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        int ind = this.jTabbedPane1.getSelectedIndex();
        if (ind == 2) {
            this.setSelectedRawDataLine();
        }
        if (ind == 1) {
            this.setSelectedMapping();
        }
    }

    private void setSelectedMapping() {
        Nuclide n = this.currentlyEdited;
        String s = this.nuclideMapping.apply(n);
        this.codeArea.setText("");
        this.codeArea.setText(s);
    }

    private void libraryNuclidesTreeMouseClicked(MouseEvent evt) {
        this.inBack = this.dummy.getBackground();
        if (this.libraryNuclidesTree.getBackground() != Color.white) {
            this.selectionTree.setBackground(this.inBack);
            this.libraryNuclidesTree.setBackground(Color.white);
            this.selectionTree.setSelectionRow(-1);
            this.libraryNuclidesTree.repaint();
            this.selectionTree.repaint();
            return;
        }
        Point p = evt.getPoint();
        SwingUtilities.convertPointToScreen(p, this.libraryNuclidesTree);
        this.menuX = p.x;
        this.menuY = p.y;
        if (evt.getButton() != 1) {
            this.libraryPopup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private Nuclide getSelectedNuclide(JTree tree) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object usr = node.getUserObject();
        return (Nuclide)usr;
    }

    private DefaultMutableTreeNode getSelectedNode(JTree tree) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        return node;
    }

    private void showChainLibActionPerformed(ActionEvent evt) {
        Nuclide n = this.getSelectedNuclide(this.libraryNuclidesTree);
        if (n == null) {
            return;
        }
        this.invokingTree = this.libraryNuclidesTree;
        this.invokerNuclidesNodes = this.nuclidesNodes;
        this.invokerNuclides = this.nuclides;
        this.showChainDialog(n, this.menuX, this.menuY, this.nuclides);
    }

    private void addNuclideLibActionPerformed(ActionEvent evt) {
    }

    private void initListeners(JTable tab) {
        tab.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                Object src = e.getSource();
                if (MainFrame.this.clear) {
                    return;
                }
                try {
                    if (src == MainFrame.this.aField.getModel()) {
                        MainFrame.this.currentlyEdited.setA(Integer.parseInt((String)MainFrame.this.aField.getValueAt(0, 0)));
                    } else if (src == MainFrame.this.nameField.getModel()) {
                        MainFrame.this.currentlyEdited.setName((String)MainFrame.this.nameField.getValueAt(0, 0));
                    } else if (src == MainFrame.this.zField.getModel()) {
                        MainFrame.this.currentlyEdited.setZ(Integer.parseInt((String)MainFrame.this.zField.getValueAt(0, 0)));
                    } else if (src == MainFrame.this.hlField.getModel()) {
                        MainFrame.this.currentlyEdited.setHalflife(Float.parseFloat((String)MainFrame.this.hlField.getValueAt(0, 0)));
                    } else if (src == MainFrame.this.hluField.getModel()) {
                        MainFrame.this.currentlyEdited.setHalflifeUnit((String)MainFrame.this.hluField.getValueAt(0, 0));
                    } else if (src == MainFrame.this.linePropertiesTable.getModel()) {
                        int row = e.getFirstRow();
                        String val = (String)MainFrame.this.linePropertiesTable.getValueAt(row, 1);
                        if (row == 0) {
                            MainFrame.this.currentlyEditedLine.setLineEnergy(new Float(Float.parseFloat(val)));
                        }
                        if (row == 1) {
                            MainFrame.this.currentlyEditedLine.setEnergyUncertainty(new Float(Float.parseFloat(val)));
                        }
                        if (row == 2) {
                            MainFrame.this.currentlyEditedLine.setLineYield(new Float(Float.parseFloat(val)));
                        }
                        if (row == 3) {
                            MainFrame.this.currentlyEditedLine.setYieldUncertainty(new Float(Float.parseFloat(val)));
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Main.warnUser("Improper value!");
                }
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }

    private File chooseFile(boolean save, FileFilter[] filters) {
        JFileChooser chooser = new JFileChooser();
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                chooser.addChoosableFileFilter(filters[i]);
            }
        }
        chooser.setCurrentDirectory(new File("."));
        int returnVal = -1;
        returnVal = save ? chooser.showSaveDialog(this) : chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            return f;
        }
        return null;
    }

    private static Mapping getDefaultMapping() {
        Mapping stateMap = new Mapping();
        stateMap.setPrePost("\t\t<state>\n", "\t\t</state>\n");
        stateMap.add("number", "\t\t\t<number>$</number>\n");
        stateMap.add("energy", "\t\t\t<energy>$</energy>\n");
        stateMap.add("spin", "\t\t\t<spin>$</spin>\n");
        stateMap.add("parity", "\t\t\t<parity>$</parity>\n");
        stateMap.add("halfLife", "\t\t\t<halfLife>$</halfLife>\n");
        Mapping lineMap = new Mapping();
        lineMap.setPrePost("\t\t<line>\n", "\t\t</line>\n");
        lineMap.add("lineType", "\t\t\t<lineType>$</lineType>\n");
        lineMap.add("initialState", "\t\t\t<initialState>$</initialState>\n");
        lineMap.add("finalState", "\t\t\t<finalState>$</finalState>\n");
        lineMap.add("lineEnergy", "\t\t\t<lineEnergy>$</lineEnergy>\n");
        lineMap.add("energyUncertainty", "\t\t\t<uncLineEnergy>$</uncLineEnergy>\n");
        lineMap.add("lineYield", "\t\t\t<lineYield>$</lineYield>\n");
        lineMap.add("yieldUncertainty", "\t\t\t<uncLineYield>$</uncLineYield>\n");
        OrderedMapping map = new OrderedMapping();
        map.setPrePost("\t<nuclide>\n", "\t</nuclide>\n");
        ((Mapping)map).add("name", "\t\t<name>$</name>\n");
        ((Mapping)map).add("Z", "\t\t<z>$</z>\n");
        ((Mapping)map).add("A", "\t\t<a>$</a>\n");
        ((Mapping)map).add("halfLife", "\t\t<halflife>$</halflife>\n");
        ((Mapping)map).add("halfLifeUnit", "\t\t<halflifeUnit>$</halflifeUnit>\n");
        ((Mapping)map).add("parent", "\t\t<parent>$</parent>\n");
        ((Mapping)map).add("daughter", "\t\t<daughter>$</daughter>\n");
        ((Mapping)map).add("numberOfLines", "\t\t<numberOfLines>$</numberOfLines>\n");
        ((Mapping)map).add("alphaBranching", "\t\t<alphaBranching>$</alphaBranching>\n");
        ((Mapping)map).add("alphaBranchingUncertainty", "\t\t<uncAlphaBranching>$</uncAlphaBranching>\n");
        ((Mapping)map).add("lines", lineMap);
        ((Mapping)map).add("states", stateMap);
        return map;
    }
}

