/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Element;
import core.Line;
import core.Main;
import core.Nuclide;
import core.State;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import objectify.Objectify;
import objectify.Parameter;

public class NuclideParser {
    static Parameter name = new Parameter("Name", "", "");
    static Parameter decay = new Parameter("Decay marker", "", "");
    static Parameter daughter = new Parameter("Daughter", "", "");
    static Parameter lineEnergy = new Parameter("LineEnergy", "", "");
    static Parameter yield = new Parameter("yield", "", "");
    static Parameter Yunc = new Parameter("yield uncertainty", "", "");
    static Parameter Eunc = new Parameter("Line energy uncertainty", "", "");
    static Parameter alphaMarker = new Parameter("alphaMarker", "", "");
    static Parameter nMarker = new Parameter("nMarker", "", "");
    static Parameter hlu = new Parameter("Half-life unit", "", "");
    static Parameter hlunc = new Parameter("Half-life uncertainty", "", "");
    static Parameter hl = new Parameter("Half-life", "", "");
    static Parameter pMarker = new Parameter("pMarker", "", "");
    static Parameter lMarker = new Parameter("lMarker", "", "");
    static Hashtable parentDaughter = new Hashtable();
    static Hashtable daughterParent = new Hashtable();

    public static List parseNuclides() {
        return NuclideParser.parseNuclides("alphaDecays.ens");
    }

    public static List parseNuclides(String path) {
        ArrayList<Nuclide> nuclides = new ArrayList<Nuclide>();
        try {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            Hashtable<String, Parameter> params = new Hashtable<String, Parameter>();
            params.put("name", name);
            params.put("decay", decay);
            params.put("daughter", daughter);
            params.put("lineEnergy", lineEnergy);
            params.put("yield", yield);
            params.put("Yunc", Yunc);
            params.put("Eunc", Eunc);
            params.put("alphaMarker", alphaMarker);
            params.put("pMarker", pMarker);
            params.put("lMarker", lMarker);
            params.put("nMarker", nMarker);
            params.put("hl", hl);
            params.put("hlu", hlu);
            params.put("hlunc", hlunc);
            File file = new File(path);
            String line = "";
            int ctr = 0;
            boolean phase = false;
            double sum = 0.0;
            boolean modified = false;
            float y = -1.0f;
            int rec = 0;
            int stateNum = 1;
            boolean numLines = false;
            Nuclide n = new Nuclide();
            n.setStatus(1);
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                StringReader reader = new StringReader(line);
                if (Character.isWhitespace(line.charAt(0))) {
                    System.out.println(line);
                    n.setNumberOfLines(n.getLines().size());
                    if (modified) {
                        nuclides.add(n);
                    }
                    if (n.getStatus() == 1 && Math.abs(1.0 - sum) > 0.001) {
                        n.setStatus(2);
                        n.setStatusComment("Sum of line yields differs from 100 by " + Math.abs(100.0 - sum) + ".");
                    }
                    n = new Nuclide();
                    rec = 0;
                    modified = false;
                    stateNum = 1;
                    n.setStatus(1);
                    Main.progressDialog.setMessage("Parsed " + ctr + " nuclides.");
                    if (phase) {
                        System.out.println("Total yield:" + sum + "\n-----------------------");
                    }
                    phase = false;
                    numLines = false;
                    continue;
                }
                if (!phase) {
                    sum = 0.0;
                    boolean isA = NuclideParser.isADecay(line);
                    if (isA) {
                        Objectify.read("daughter,name,a,decay", (Reader)reader, params, true);
                    }
                    if (!isA || !decay.getStringValue().startsWith("DECAY") || name.getStringValue().charAt(0) == 'X') continue;
                    phase = true;
                    sum = 0.0;
                    ++ctr;
                    System.out.println("Name:" + name.getStringValue());
                    modified = true;
                    n.setRawData(line);
                    NuclideParser.determineAttribs(n, name.getStringValue());
                    String daughterSym = NuclideParser.fixSymbol(daughter.getStringValue());
                    n.setDaughter(daughterSym);
                    daughterParent.put(daughterSym, n.getName());
                    parentDaughter.put(n.getName(), daughterSym);
                    continue;
                }
                if (!phase) continue;
                String id = NuclideParser.getRecordId(line);
                if (id.equals("P")) {
                    n.setRawData(n.getRawData() + "\n" + line);
                    line = line.substring(39);
                    StringReader reader2 = new StringReader(line);
                    Objectify.read("hl,hlu,hlunc", (Reader)reader2, params, true);
                    try {
                        n.setHalflife(Float.parseFloat(hl.getStringValue()));
                        n.setHalflifeUnit(hlu.getStringValue());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (++rec > 1) {
                        phase = true;
                    }
                }
                if (id.equals("N")) {
                    n.setRawData(n.getRawData() + "\n" + line);
                    NuclideParser.parseNRecord(line, n);
                    if (++rec > 1) {
                        phase = true;
                    }
                }
                if (id.equals("L")) {
                    State s = NuclideParser.parseState(line);
                    s.setNumber(new Integer(stateNum++));
                    s.setRawData(line);
                    n.setRawData(n.getRawData() + "\n" + line);
                    n.addState(s);
                    phase = true;
                }
                if (!id.equals("A") || line.indexOf("FLAG=") != -1) continue;
                NuclideParser.initParams();
                reader = new StringReader(line);
                Line l = NuclideParser.parseLine(line);
                l.setInitalState(new Integer(-1));
                l.setFinalState(new Integer(stateNum - 1));
                l.setLineType("a");
                l.setRawData(line);
                n.addLine(l);
                if (l.getStatus() != 1) {
                    n.setStatus(l.getStatus());
                    n.setStatusComment(l.getStatusComment());
                }
                if (l.getLineYield() != null) {
                    sum += (double)l.getLineYield().floatValue();
                }
                phase = true;
            }
            System.out.println("Found " + ctr + " nuclides.");
            for (int i = 0; i < nuclides.size(); ++i) {
                String parent;
                Nuclide nucl = (Nuclide)nuclides.get(i);
                if (nucl.getName() == null || (parent = (String)daughterParent.get(nucl.getName())) == null) continue;
                nucl.setParent(parent);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return nuclides;
    }

    private static String getRecordId(String line) {
        String id = NuclideParser.safeSubstring(line, 6, 8);
        id = id.replaceAll("\\s+", "");
        return id;
    }

    private static boolean isADecay(String line) {
        String C = NuclideParser.safeSubstring(line, 6, 7);
        if (C.charAt(0) == 'c' || C.charAt(0) == 'C' || C.charAt(0) == 'T' || C.charAt(0) == 'D') {
            return false;
        }
        String id = NuclideParser.safeSubstring(line, 9, 39);
        return id.indexOf("A DECAY") != -1;
    }

    private static void parseNRecord(String line, Nuclide n) {
        String br = NuclideParser.safeSubstring(line, 31, 39);
        Float Br = NuclideParser.newFloat(br);
        n.setAlphaBranching(Br);
        String ubr = NuclideParser.safeSubstring(line, 39, 41);
        Float uBr = NuclideParser.newFloat(ubr);
        if (Br != null && uBr != null) {
            uBr = new Float(NuclideParser.ensDefErrorToAbsolute(br, uBr.floatValue()));
        }
        n.setAlphaBranchingUncertainty(uBr);
    }

    private static State parseState(String level) {
        State s = new State();
        String e = NuclideParser.safeSubstring(level, 9, 19);
        Float E = NuclideParser.newFloat(e);
        s.setEnergy(E);
        String eunc = NuclideParser.safeSubstring(level, 19, 21);
        Float Eunc = NuclideParser.newFloat(eunc);
        if (Eunc != null && E != null) {
            Eunc = new Float(NuclideParser.ensDefErrorToAbsolute(e, Eunc.floatValue()));
        }
        String spinParity = NuclideParser.safeSubstring(level, 21, 39);
        spinParity = spinParity.replaceAll("\\s+|\\(|\\)", "");
        String[] sps = spinParity.split(",");
        spinParity = sps[0];
        String par = NuclideParser.safeSubstring(spinParity, spinParity.length() - 1, spinParity.length());
        String spin = NuclideParser.safeSubstring(spinParity, 0, spinParity.length() - 1);
        s.setParity(par);
        s.setSpin(spin);
        String hl = NuclideParser.safeSubstring(level, 39, 49);
        String[] hlAndU = hl.split(" ");
        if (hlAndU.length > 0) {
            try {
                hl = hlAndU[0];
                Float Hl = NuclideParser.newFloat(hl);
                s.setHalfLife(Hl);
                String hlUnit = hlAndU[1];
                s.setHalfLifeUnit(hlUnit);
                String hlunc = NuclideParser.safeSubstring(level, 49, 55);
                Float HlUnc = NuclideParser.newFloat(hlunc);
                if (Hl != null && HlUnc != null) {
                    HlUnc = new Float(NuclideParser.ensDefErrorToAbsolute(hl, HlUnc.floatValue()));
                }
                s.setHalfLifeUncertainty(HlUnc);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return s;
    }

    private static Line parseLine(String line) {
        String eunc;
        Float Eunc;
        Line l = new Line();
        String err = "";
        String e = NuclideParser.safeSubstring(line, 9, 19);
        Float E = NuclideParser.newFloat(e);
        l.setLineEnergy(E);
        if (l.getLineEnergy() == null) {
            err = err + "Line energy missing ";
        }
        if ((Eunc = NuclideParser.newFloat(eunc = NuclideParser.safeSubstring(line, 19, 21))) != null && E != null) {
            Eunc = new Float(NuclideParser.ensDefErrorToAbsolute(e, Eunc.floatValue()));
        }
        l.setEnergyUncertainty(Eunc);
        if (l.getEnergyUncertainty() == null) {
            err = err + "Energy uncertainty missing ";
        }
        String y = NuclideParser.safeSubstring(line, 21, 29);
        Float Yield = NuclideParser.newFloat(y);
        l.setLineYield(Yield);
        if (Yield == null) {
            err = err + "Line yield missing ";
        }
        String yunc = NuclideParser.safeSubstring(line, 29, 31);
        Float Yunc = NuclideParser.newFloat(yunc);
        if (Yield != null && Yunc != null) {
            Yunc = new Float(NuclideParser.ensDefErrorToAbsolute(y, Yunc.floatValue()));
        }
        l.setYieldUncertainty(Yunc);
        if (Yield != null) {
            Yield = new Float(Yield.floatValue() / 100.0f);
        }
        if (Yunc != null) {
            Yunc = new Float(Yunc.floatValue() / 100.0f);
        }
        l.setLineYield(Yield);
        l.setYieldUncertainty(Yunc);
        if (l.getYieldUncertainty() == null) {
            err = err + "Yield uncertainty missing ";
        }
        if (err.length() > 0) {
            l.setStatus(3);
            l.setStatusComment(err);
        } else {
            l.setStatus(1);
        }
        return l;
    }

    private static float ensDefErrorToAbsolute(String valStr, float error) {
        int dot = (valStr = valStr.replaceAll("\\s+", "")).indexOf(46);
        if (dot == -1) {
            return error;
        }
        int decimals = valStr.length() - dot - 1;
        return error / (float)Math.pow(10.0, decimals);
    }

    private static String safeSubstring(String from, int begin, int end) {
        try {
            String ret = from.substring(begin, end);
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void determineAttribs(Nuclide n, String name) {
        int a = Integer.parseInt(name.substring(0, 3));
        String symbol = name.substring(3, name.length());
        String symbolCase = "" + symbol.charAt(0);
        if (symbol.length() > 1) {
            symbolCase = symbolCase + Character.toLowerCase(symbol.charAt(1));
        }
        symbol = symbolCase;
        int z = Element.determineZ(symbol);
        Element e = new Element();
        e.setZ(new Integer(z));
        n.setZ(z);
        n.setA(a);
        n.setName(symbolCase + "-" + a);
        String key = e.getName();
    }

    private static String fixSymbol(String s) {
        int a = Integer.parseInt(s.substring(0, 3));
        String symbol = s.substring(3, s.length());
        String symbolCase = "" + symbol.charAt(0);
        if (symbol.length() > 1) {
            symbolCase = symbolCase + Character.toLowerCase(symbol.charAt(1));
        }
        symbol = symbolCase;
        int z = Element.determineZ(symbol);
        symbol = symbol + "-" + a;
        return symbol;
    }

    private static int getZ(String symbol) {
        return Integer.parseInt(symbol.substring(symbol.length() - 3, symbol.length()));
    }

    private static int getA(String symbol) {
        return Integer.parseInt(symbol.substring(0, 3));
    }

    private static void initParams() {
        lineEnergy.setValue("n/a");
        yield.setValue("n/a");
        Yunc.setValue("n/a");
        Eunc.setValue("n/a");
    }

    private static Float newFloat(String s) {
        try {
            Float f = null;
            f = new Float(s);
            return f;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void fixLine(String line, Line read) {
        Float eunc = read.getEnergyUncertainty();
        if (eunc != null) {
            float feunc = read.getEnergyUncertainty().floatValue();
            if (feunc - (float)((int)feunc) != 0.0f || feunc < 1.0f) {
                read.setYieldUncertainty(read.getLineYield());
                read.setLineYield(read.getEnergyUncertainty());
                read.setEnergyUncertainty(null);
            }
            if (feunc > 1000.0f) {
                float fix = feunc / 1000.0f;
                read.setEnergyUncertainty(new Float((int)fix));
                read.setYieldUncertainty(read.getLineYield());
                read.setLineYield(new Float((fix - (float)((int)fix)) * 1000.0f));
            }
        }
    }

    public static void main(String[] args) {
        NuclideParser.parseNuclides();
    }
}

