/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphics2d.PixelGraphics2D;
import org.freehep.graphicsio.ImageParamConverter;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;

public class ImageGraphics2D
extends PixelGraphics2D {
    private static final String[] alwaysCompressedFormats = new String[]{"jpg", "jpeg", "gif"};
    private static final String[] nonTransparentFormats = new String[]{"jpg", "jpeg", "ppm"};
    public static final String rootKey = "org.freehep.graphicsio";
    public static final String TRANSPARENT = ".Transparent";
    public static final String BACKGROUND = ".Background";
    public static final String BACKGROUND_COLOR = ".BackgroundColor";
    public static final String ANTIALIAS = ".Antialias";
    public static final String ANTIALIAS_TEXT = ".AntialiasText";
    public static final String PROGRESSIVE = ".Progressive";
    public static final String COMPRESS = ".Compress";
    public static final String COMPRESS_MODE = ".CompressMode";
    public static final String COMPRESS_DESCRIPTION = ".CompressDescription";
    public static final String COMPRESS_QUALITY = ".CompressQuality";
    private static final Map defaultProperties = new HashMap();
    protected OutputStream os;
    protected BufferedImage image;
    protected String format;
    protected Component component;

    public static Properties getDefaultProperties(String format) {
        UserProperties properties = (UserProperties)defaultProperties.get(format);
        if (properties == null) {
            properties = new UserProperties();
            defaultProperties.put(format, properties);
            String formatKey = "org.freehep.graphicsio." + format;
            if (ImageGraphics2D.canWriteTransparent(format)) {
                properties.setProperty(formatKey + TRANSPARENT, true);
                properties.setProperty(formatKey + BACKGROUND, false);
                properties.setProperty(formatKey + BACKGROUND_COLOR, Color.GRAY);
            } else {
                properties.setProperty(formatKey + BACKGROUND, false);
                properties.setProperty(formatKey + BACKGROUND_COLOR, Color.GRAY);
            }
            properties.setProperty(formatKey + ANTIALIAS, true);
            properties.setProperty(formatKey + ANTIALIAS_TEXT, true);
            ImageWriter writer = ImageGraphics2D.getPreferredImageWriter(format);
            if (writer != null) {
                ImageWriteParam param = writer.getDefaultWriteParam();
                if (param.canWriteCompressed()) {
                    param.setCompressionMode(2);
                    properties.setProperty(formatKey + COMPRESS, true);
                    String[] compressionTypes = param.getCompressionTypes();
                    String compressionType = param.getCompressionType();
                    properties.setProperty(formatKey + COMPRESS_MODE, compressionType != null ? compressionType : compressionTypes[0]);
                    properties.setProperty(formatKey + COMPRESS_DESCRIPTION, "Custom");
                    float compressionQuality = 0.0f;
                    try {
                        compressionQuality = param.getCompressionQuality();
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    properties.setProperty(formatKey + COMPRESS_QUALITY, compressionQuality);
                } else {
                    properties.setProperty(formatKey + COMPRESS, false);
                    properties.setProperty(formatKey + COMPRESS_MODE, "");
                    properties.setProperty(formatKey + COMPRESS_DESCRIPTION, "Custom");
                    properties.setProperty(formatKey + COMPRESS_QUALITY, 0.0f);
                }
                if (param.canWriteProgressive()) {
                    properties.setProperty(formatKey + PROGRESSIVE, param.getProgressiveMode() != 0);
                } else {
                    properties.setProperty(formatKey + PROGRESSIVE, false);
                }
            } else {
                System.err.println(ImageGraphics2D.class + ": No writer for format '" + format + "'.");
            }
        }
        return properties;
    }

    public void setProperties(Properties newProperties) {
        if (newProperties == null) {
            return;
        }
        String formatKey = "org.freehep.graphicsio." + this.format;
        Properties formatProperties = new Properties();
        Enumeration<?> e = newProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = newProperties.getProperty(key);
            if (key.indexOf("." + this.format) < 0) {
                key = formatKey + key;
            }
            formatProperties.setProperty(key, value);
        }
        super.setProperties(formatProperties);
        this.setPropertiesOnGraphics();
    }

    private void setPropertiesOnGraphics() {
        String formatKey = "org.freehep.graphicsio." + this.format;
        if (this.isProperty(formatKey + ANTIALIAS)) {
            this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isProperty(formatKey + ANTIALIAS_TEXT)) {
            this.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            this.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.isProperty(formatKey + TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(formatKey + BACKGROUND)) {
            this.setBackground(this.getPropertyColor(formatKey + BACKGROUND_COLOR));
        } else {
            this.setBackground(this.component != null ? this.component.getBackground() : Color.WHITE);
        }
    }

    private void setHintsOnGraphics() {
        if (this.format.equalsIgnoreCase("JPG")) {
            this.setRenderingHint(KEY_SYMBOL_BLIT, VALUE_SYMBOL_BLIT_OFF);
        } else {
            this.setRenderingHint(KEY_SYMBOL_BLIT, VALUE_SYMBOL_BLIT_ON);
        }
    }

    public ImageGraphics2D(File file, Dimension size, String format) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size, format);
    }

    public ImageGraphics2D(File file, Component component, String format) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component, format);
    }

    public ImageGraphics2D(OutputStream os, Dimension size, String format) {
        this.init(os, size, format);
        this.component = null;
    }

    public ImageGraphics2D(OutputStream os, Component component, String format) {
        this.component = component;
        this.init(os, component.getSize(), format);
        this.setColor(component.getForeground());
        GraphicsConfiguration gc = component.getGraphicsConfiguration();
        if (gc != null) {
            this.setTransform(gc.getDefaultTransform());
        }
    }

    private void init(OutputStream os, Dimension size, String format) {
        this.os = os;
        this.format = format;
        this.initProperties(ImageGraphics2D.getDefaultProperties(format));
        this.image = ImageGraphics2D.createBufferedImage(format, size.width, size.height);
        this.setHostGraphics(this.image.getGraphics());
        this.setPropertiesOnGraphics();
        this.setHintsOnGraphics();
        this.hostGraphics.clipRect(0, 0, size.width, size.height);
    }

    protected ImageGraphics2D(ImageGraphics2D graphics) {
        super((PixelGraphics2D)graphics);
        this.image = graphics.image;
        this.os = graphics.os;
        this.format = graphics.format;
        this.setHintsOnGraphics();
    }

    public Graphics create() {
        return new ImageGraphics2D(this);
    }

    public Graphics create(double x, double y, double width, double height) {
        ImageGraphics2D imageGraphics = new ImageGraphics2D(this);
        imageGraphics.translate(x, y);
        imageGraphics.clipRect(0.0, 0.0, width, height);
        return imageGraphics;
    }

    public void startExport() {
        if (this.getBackground() != null) {
            this.clearRect(0.0, 0.0, this.image.getWidth(), this.image.getHeight());
        }
    }

    public void endExport() {
        try {
            this.write();
            this.closeStream();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    protected void write() throws IOException {
        ImageGraphics2D.writeImage(this.image, this.format, this.getProperties(), this.os);
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    protected void handleException(Exception exception) {
        System.err.println(exception);
    }

    public static BufferedImage createBufferedImage(String format, int width, int height) {
        int imageType = format.equalsIgnoreCase("jpg") || format.equalsIgnoreCase("jpeg") ? 1 : 2;
        BufferedImage image = new BufferedImage(width, height, imageType);
        return image;
    }

    public static BufferedImage generateThumbnail(Component component, Dimension size) {
        int longSide = Math.max(size.width, size.height);
        if (longSide < 0) {
            return null;
        }
        int componentWidth = component.getBounds().width;
        int componentHeight = component.getBounds().height;
        BufferedImage image = new BufferedImage(componentWidth, componentHeight, 2);
        Graphics imageGraphics = image.getGraphics();
        component.print(imageGraphics);
        int width = longSide;
        int height = longSide;
        if (componentWidth < componentHeight) {
            width = componentWidth * size.height / componentHeight;
        } else {
            height = componentHeight * size.width / componentWidth;
        }
        BufferedImage scaled = new BufferedImage(width, height, 2);
        Graphics scaledGraphics = scaled.getGraphics();
        scaledGraphics.drawImage(image, 0, 0, width, height, null);
        return scaled;
    }

    public static void writeImage(Image image, String format, Properties properties, OutputStream os) throws IOException {
        ImageGraphics2D.writeImage(ImageUtilities.createRenderedImage((Image)image, null, (Color)Color.black), format, properties, os);
    }

    public static void writeImage(RenderedImage image, String format, Properties properties, OutputStream os) throws IOException {
        ImageWriter writer = ImageGraphics2D.getPreferredImageWriter(format);
        if (writer == null) {
            throw new IOException(ImageGraphics2D.class + ": No writer for format '" + format + "'.");
        }
        UserProperties user = new UserProperties(properties);
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (param instanceof ImageParamConverter) {
            param = ((ImageParamConverter)((Object)param)).getWriteParam((Properties)user);
        }
        String formatKey = "org.freehep.graphicsio." + format;
        if (param.canWriteCompressed()) {
            if (user.isProperty(formatKey + COMPRESS)) {
                if (user.getProperty(formatKey + COMPRESS_MODE).equals("")) {
                    param.setCompressionMode(1);
                } else {
                    param.setCompressionMode(2);
                    param.setCompressionType(user.getProperty(formatKey + COMPRESS_MODE));
                    param.setCompressionQuality(user.getPropertyFloat(formatKey + COMPRESS_QUALITY));
                }
            } else if (ImageGraphics2D.canWriteUncompressed(format)) {
                param.setCompressionMode(0);
            }
        }
        if (param.canWriteProgressive()) {
            if (user.isProperty(formatKey + PROGRESSIVE)) {
                param.setProgressiveMode(1);
            } else {
                param.setProgressiveMode(0);
            }
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(image, null, null), param);
        writer.dispose();
        ios.close();
    }

    public static ImageWriter getPreferredImageWriter(String format) {
        return (ImageWriter)ImageGraphics2D.getImageWriters(ImageIO.getImageWritersByFormatName(format)).first();
    }

    public static ImageWriter getPreferredImageWriterForMIMEType(String mimeType) {
        return (ImageWriter)ImageGraphics2D.getImageWriters(ImageIO.getImageWritersByMIMEType(mimeType)).first();
    }

    public static SortedSet getImageWriters(Iterator iterator) {
        TreeSet<ImageWriter> imageWriters = new TreeSet<ImageWriter>(new Comparator(){

            private int order(Object o) {
                String className = o.getClass().getName();
                if (className.startsWith("org.freehep.")) {
                    return 0;
                }
                if (className.startsWith("com.sun.imageio.")) {
                    return 1;
                }
                if (className.startsWith("com.sun.media.")) {
                    return 2;
                }
                return 3;
            }

            public int compare(Object arg0, Object arg1) {
                int order1;
                int order0 = this.order(arg0);
                return order0 < (order1 = this.order(arg1)) ? -1 : (order0 > order1 ? 1 : 0);
            }
        });
        while (iterator.hasNext()) {
            imageWriters.add((ImageWriter)iterator.next());
        }
        return imageWriters;
    }

    public static BufferedImage readImage(String format, InputStream is) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(format);
        if (!iterator.hasNext()) {
            throw new IOException(ImageGraphics2D.class + ": No reader for format '" + format + "'.");
        }
        ImageReader reader = iterator.next();
        ImageInputStream iis = ImageIO.createImageInputStream(is);
        reader.setInput(iis, true);
        BufferedImage image = reader.read(0);
        reader.dispose();
        iis.close();
        return image;
    }

    public static boolean canWriteUncompressed(String format) {
        return !Arrays.asList(alwaysCompressedFormats).contains(format.toLowerCase());
    }

    public static boolean canWriteTransparent(String format) {
        return !Arrays.asList(nonTransparentFormats).contains(format.toLowerCase());
    }
}

