/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class TextW
implements EMFConstants {
    private Point pos;
    private String string;
    private int options;
    private int[] widths;
    private Rectangle bounds;

    public TextW(Point pos, String string, int options, Rectangle bounds, int[] widths) {
        this.pos = pos;
        this.string = string;
        this.options = options;
        this.bounds = bounds;
        this.widths = widths;
    }

    public TextW(EMFInputStream emf) throws IOException {
        int i;
        this.pos = emf.readPOINTL();
        int sLen = emf.readDWORD();
        emf.readDWORD();
        this.options = emf.readDWORD();
        this.bounds = emf.readRECTL();
        emf.readDWORD();
        this.string = new String(emf.readBYTE(2 * sLen), "UTF-16LE");
        if (2 * sLen % 4 != 0) {
            for (i = 0; i < 4 - 2 * sLen % 4; ++i) {
                emf.readBYTE();
            }
        }
        this.widths = new int[sLen];
        for (i = 0; i < sLen; ++i) {
            this.widths[i] = emf.readDWORD();
        }
    }

    public void write(EMFOutputStream emf) throws IOException {
        int i;
        emf.writePOINTL(this.pos);
        emf.writeDWORD(this.string.length());
        emf.writeDWORD(76);
        emf.writeDWORD(this.options);
        emf.writeRECTL(this.bounds);
        int pad = 2 * this.string.length() % 4;
        if (pad > 0) {
            pad = 4 - pad;
        }
        emf.writeDWORD(76 + 2 * this.string.length() + pad);
        emf.writeBYTE(this.string.getBytes("UTF-16LE"));
        for (i = 0; i < pad; ++i) {
            emf.writeBYTE(0);
        }
        for (i = 0; i < this.string.length(); ++i) {
            emf.writeDWORD(this.widths[i]);
        }
    }

    public String toString() {
        StringBuffer widthsS = new StringBuffer();
        for (int i = 0; i < this.string.length(); ++i) {
            widthsS.append("," + this.widths[i]);
        }
        widthsS.append(']');
        widthsS.setCharAt(0, '[');
        return "  Text\n    pos: " + this.pos + "\n" + "    options: " + this.options + "\n" + "    bounds: " + this.bounds + "\n" + "    string: " + this.string + "\n" + "    widths: " + widthsS;
    }
}

