/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import widgets.Drawer;

public class Shelf
extends JPanel
implements Scrollable {
    Hashtable minPositions;
    Hashtable maxPositions;
    Vector drawers = new Vector();
    boolean exclusive = true;
    int totalW = 0;
    int totalH = 0;
    int oldW = 0;
    int oldH = 0;
    int yMargin = 10;
    private boolean adjusting = false;
    int numDrawers = 0;

    public Shelf() {
        this.minPositions = new Hashtable();
    }

    public void setExclusive(boolean enabled) {
        this.exclusive = enabled;
    }

    private void maximizeExclusive(Drawer drawer) {
        int offs = 0;
        Iterator iter = this.drawers.iterator();
        while (iter.hasNext()) {
            Drawer d = (Drawer)iter.next();
            Point p = (Point)this.minPositions.get(d);
            d.minimize(true);
            d.moveTo(p.x, p.y + offs);
            if (d != drawer) continue;
            int h = drawer.getHeight();
            drawer.maximize(true);
            offs += drawer.getHeight() - h;
        }
        this.repaint();
    }

    private void maximizeInclusive(Drawer drawer) {
        int offs = 0;
        Iterator iter = this.drawers.iterator();
        int ind = 0;
        int xpos = 0;
        int ypos = 0;
        int w = 0;
        int maxW = 0;
        this.oldH = this.getHeight();
        this.oldW = this.getWidth();
        this.totalH = 0;
        while (iter.hasNext()) {
            Drawer d = (Drawer)iter.next();
            Point p = d.getLocation();
            if (ind == 0) {
                xpos = p.x;
                ypos = p.y;
            }
            d.moveTo(xpos, ypos + offs);
            if (d == drawer) {
                int h = drawer.getHeight();
                drawer.maximize(false);
            }
            offs = d.isMinimized() ? (offs += (int)d.getMinimumSize().getHeight() + 5) : (offs += (int)d.getMaximumSize().getHeight() + 5);
            ++ind;
            w = d.getWidth();
            if (w < maxW) continue;
            maxW = w;
        }
        this.totalH = offs + this.yMargin + this.getInsets().top + this.getInsets().bottom;
        this.totalW = maxW + 2;
    }

    public void maximize(Drawer drawer) {
        this.adjusting = true;
        if (this.exclusive) {
            this.maximizeExclusive(drawer);
        } else {
            this.maximizeInclusive(drawer);
            this.redoSize();
        }
        this.adjusting = false;
    }

    public void setYMargin(int yMargin) {
        this.yMargin = yMargin;
    }

    private void redoSize() {
        this.setPreferredSize(new Dimension(this.getWidth(), this.totalH));
        int w = this.getParent().getWidth();
        int h = this.getParent().getHeight();
        Container parent = this.getParent();
        parent.validate();
        if (parent instanceof JComponent) {
            parent.doLayout();
            JComponent jparent = (JComponent)this.getParent();
            int n = jparent.getComponentCount();
            this.totalH = 0;
            this.totalW = 0;
            for (int i = 0; i < n; ++i) {
                Component c = jparent.getComponent(i);
                if (c.getY() + c.getHeight() <= h) continue;
                this.totalH = c.getHeight() + c.getY();
            }
        }
    }

    private void minimizeExclusive(Drawer drawer) {
        Iterator iter = this.drawers.iterator();
        while (iter.hasNext()) {
            Drawer d = (Drawer)iter.next();
            Point p = (Point)this.minPositions.get(d);
            d.moveTo(p.x, p.y);
            if (d != drawer) continue;
            d.minimize(true);
        }
        this.repaint();
    }

    private void minimizeInclusive(Drawer drawer) {
        int offs = 0;
        Iterator iter = this.drawers.iterator();
        int ind = 0;
        int xpos = 0;
        int ypos = 0;
        int w = 0;
        int maxW = 0;
        this.oldH = this.getHeight();
        this.oldW = this.getWidth();
        while (iter.hasNext()) {
            Drawer d = (Drawer)iter.next();
            Point p = d.getLocation();
            if (ind == 0) {
                xpos = p.x;
                ypos = p.y;
            }
            d.moveTo(xpos, ypos + offs);
            if (d == drawer) {
                int h = drawer.getHeight();
                drawer.minimize(false);
            }
            offs = d.isMinimized() ? (offs += (int)d.getMinimumSize().getHeight() + 5) : (offs += (int)d.getMaximumSize().getHeight() + 5);
            ++ind;
            w = d.getWidth();
            if (w <= maxW) continue;
            maxW = w;
        }
        this.totalH = offs + this.yMargin;
        this.totalW = maxW + 2;
    }

    public void minimize(Drawer drawer) {
        this.adjusting = true;
        if (this.exclusive) {
            this.minimizeExclusive(drawer);
        } else {
            this.minimizeInclusive(drawer);
            this.redoSize();
        }
        this.adjusting = false;
    }

    public Component add(Component c) {
        if (c instanceof Drawer) {
            this.drawers.add(c);
            this.minPositions.put(c, new Point(10, 10 + this.numDrawers * 20 + this.numDrawers++ * 10));
        }
        return super.add(c);
    }

    public void add(Component c, Object constraints) {
        if (c instanceof Drawer) {
            this.minPositions.put(c, new Point(c.getX(), c.getY()));
            this.drawers.add(c);
        }
        super.add(c);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getMaximumSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int param, int param2) {
        return 1;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int param, int param2) {
        return 1;
    }

    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
    }
}

