/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Lookup;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.font.FontUtilities;
import org.freehep.graphicsio.pdf.PDFCatalog;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFDocInfo;
import org.freehep.graphicsio.pdf.PDFFontTable;
import org.freehep.graphicsio.pdf.PDFImageDelayQueue;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFOutline;
import org.freehep.graphicsio.pdf.PDFOutlineList;
import org.freehep.graphicsio.pdf.PDFPage;
import org.freehep.graphicsio.pdf.PDFPageTree;
import org.freehep.graphicsio.pdf.PDFPaintDelayQueue;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFViewerPreferences;
import org.freehep.graphicsio.pdf.PDFWriter;
import org.freehep.util.UserProperties;

public class PDFGraphics2D
extends AbstractVectorGraphicsIO
implements MultiPageDocument,
FontUtilities.ShowString {
    private static final String rootKey = PDFGraphics2D.class.getName();
    public static final String VERSION6 = "Acrobat Reader 6.x";
    public static final String VERSION5 = "Acrobat Reader 5.x";
    public static final String VERSION4 = "Acrobat Reader 4.x";
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String PAGE_SIZE = rootKey + "." + "PageSize";
    public static final String PAGE_MARGINS = rootKey + "." + "PageMargins";
    public static final String ORIENTATION = rootKey + "." + "Orientation";
    public static final String FIT_TO_PAGE = rootKey + "." + "FitToPage";
    public static final String EMBED_FONTS = rootKey + "." + "EmbedFonts";
    public static final String EMBED_FONTS_AS = rootKey + "." + "EmbedFontsAs";
    public static final String THUMBNAILS = rootKey + ".Thumbnails";
    public static final String THUMBNAIL_SIZE = rootKey + ".ThumbnailSize";
    public static final String COMPRESS = rootKey + ".Compress";
    public static final String VERSION = rootKey + ".Version";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    public static final String AUTHOR = rootKey + "." + "Author";
    public static final String TITLE = rootKey + "." + "Title";
    public static final String SUBJECT = rootKey + "." + "Subject";
    public static final String KEYWORDS = rootKey + "." + "Keywords";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 9312 $";
    private static final String PDF_VERSION = "1.4";
    private static final String[] COMPRESS_FILTERS;
    private static final String[] NO_FILTERS;
    private static final double FONTSIZE_CORRECTION = 1.0;
    private OutputStream ros;
    private PDFWriter os;
    private PDFStream pageStream;
    private PDFFontTable fontTable;
    private PDFImageDelayQueue delayImageQueue;
    private PDFPaintDelayQueue delayPaintQueue;
    private int currentPage;
    private boolean multiPage;
    private TagString[] headerText;
    private int headerUnderline;
    private Font headerFont;
    private TagString[] footerText;
    private int footerUnderline;
    private Font footerFont;
    private List titles;
    int alphaIndex;
    Map extGStates;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public PDFGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public PDFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public PDFGraphics2D(OutputStream ros, Dimension size) {
        super(size, false);
        this.init(ros);
    }

    public PDFGraphics2D(OutputStream ros, Component component) {
        super(component, false);
        this.init(ros);
    }

    private void init(OutputStream ros) {
        this.ros = new BufferedOutputStream(ros);
        this.currentPage = 0;
        this.multiPage = false;
        this.titles = new ArrayList();
        this.initProperties((Properties)defaultProperties);
    }

    protected PDFGraphics2D(PDFGraphics2D graphics, boolean doRestoreOnDispose) {
        super((AbstractVectorGraphicsIO)graphics, doRestoreOnDispose);
        this.os = graphics.os;
        this.pageStream = graphics.pageStream;
        this.delayImageQueue = graphics.delayImageQueue;
        this.delayPaintQueue = graphics.delayPaintQueue;
        this.fontTable = graphics.fontTable;
        this.currentPage = graphics.currentPage;
        this.multiPage = graphics.multiPage;
        this.titles = graphics.titles;
        this.alphaIndex = graphics.alphaIndex;
        this.extGStates = graphics.extGStates;
    }

    public void setMultiPage(boolean multiPage) {
        this.multiPage = multiPage;
    }

    public boolean isMultiPage() {
        return this.multiPage;
    }

    public static void setClipEnabled(boolean enabled) {
        defaultProperties.setProperty(CLIP, enabled);
    }

    public void writeHeader() throws IOException {
        this.os = new PDFWriter(new BufferedOutputStream(this.ros), PDF_VERSION);
        this.delayImageQueue = new PDFImageDelayQueue(this.os);
        this.delayPaintQueue = new PDFPaintDelayQueue(this.os, this.delayImageQueue);
        this.fontTable = new PDFFontTable(this.os);
        String producer = ((Object)((Object)this)).getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        PDFDocInfo info = this.os.openDocInfo("DocInfo");
        info.setTitle(this.getProperty(TITLE));
        info.setAuthor(this.getProperty(AUTHOR));
        info.setSubject(this.getProperty(SUBJECT));
        info.setKeywords(this.getProperty(KEYWORDS));
        info.setCreator(this.getCreator());
        info.setProducer(producer);
        if (!this.isDeviceIndependent()) {
            Calendar now = Calendar.getInstance();
            info.setCreationDate(now);
            info.setModificationDate(now);
        }
        info.setTrapped("False");
        this.os.close(info);
        PDFCatalog catalog = this.os.openCatalog("Catalog", "RootPage");
        catalog.setOutlines("Outlines");
        catalog.setPageMode("UseOutlines");
        catalog.setViewerPreferences("Preferences");
        catalog.setOpenAction(new Object[]{this.os.ref("Page1"), this.os.name("Fit")});
        this.os.close(catalog);
        PDFViewerPreferences prefs = this.os.openViewerPreferences("Preferences");
        prefs.setFitWindow(true);
        prefs.setCenterWindow(false);
        this.os.close(prefs);
        this.alphaIndex = 1;
        this.extGStates = new HashMap();
        if (!this.isMultiPage()) {
            this.openPage(this.getSize(), null, this.getComponent());
        }
    }

    public void writeBackground() {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        if (!this.isMultiPage()) {
            this.closePage();
        }
        PDFPageTree pages = this.os.openPageTree("RootPage", null);
        for (int i = 1; i <= this.currentPage; ++i) {
            pages.addPage("Page" + i);
        }
        Dimension pageSize = PageConstants.getSize((String)this.getProperty(PAGE_SIZE), (String)this.getProperty(ORIENTATION));
        pages.setMediaBox(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight());
        pages.setResources("Resources");
        this.os.close(pages);
        this.os.object("PageProcSet", new Object[]{this.os.name("PDF"), this.os.name("Text"), this.os.name("ImageC")});
        int nFonts = this.fontTable.addFontDictionary();
        int nXObjects = this.delayImageQueue.addXObjects();
        int nPatterns = this.delayPaintQueue.addPatterns();
        if (this.extGStates.size() > 0) {
            PDFDictionary extGState = this.os.openDictionary("ExtGState");
            Iterator i = this.extGStates.keySet().iterator();
            while (i.hasNext()) {
                Float alpha = (Float)i.next();
                String alphaName = (String)this.extGStates.get(alpha);
                PDFDictionary alphaDictionary = extGState.openDictionary(alphaName);
                alphaDictionary.entry("ca", alpha.floatValue());
                alphaDictionary.entry("CA", alpha.floatValue());
                alphaDictionary.entry("BM", this.os.name("Normal"));
                alphaDictionary.entry("AIS", false);
                extGState.close(alphaDictionary);
            }
            this.os.close(extGState);
        }
        PDFDictionary resources = this.os.openDictionary("Resources");
        resources.entry("ProcSet", this.os.ref("PageProcSet"));
        if (nFonts > 0) {
            resources.entry("Font", this.os.ref("FontList"));
        }
        if (nXObjects > 0) {
            resources.entry("XObject", this.os.ref("XObjects"));
        }
        if (nPatterns > 0) {
            resources.entry("Pattern", this.os.ref("Pattern"));
        }
        if (this.extGStates.size() > 0) {
            resources.entry("ExtGState", this.os.ref("ExtGState"));
        }
        this.os.close(resources);
        PDFOutlineList outlines = this.os.openOutlineList("Outlines", "Outline1", "Outline" + this.currentPage);
        this.os.close(outlines);
        for (int i = 1; i <= this.currentPage; ++i) {
            String prev = i > 1 ? "Outline" + (i - 1) : null;
            String next = i < this.currentPage ? "Outline" + (i + 1) : null;
            PDFOutline outline = this.os.openOutline("Outline" + i, (String)this.titles.get(i - 1), "Outlines", prev, next);
            outline.setDest(new Object[]{this.os.ref("Page" + i), this.os.name("Fit")});
            this.os.close(outline);
        }
        this.processDelayed();
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    private void processDelayed() throws IOException {
        this.delayImageQueue.processAll();
        this.delayPaintQueue.processAll();
        this.fontTable.embedAll(this.getFontRenderContext(), this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
    }

    public void openPage(Component component) throws IOException {
        this.openPage(component.getSize(), component.getName(), component);
    }

    public void openPage(Dimension size, String title) throws IOException {
        this.openPage(size, title, null);
    }

    private void openPage(Dimension size, String title, Component component) throws IOException {
        if (size == null) {
            size = component.getSize();
        }
        this.resetClip(new Rectangle(0, 0, size.width, size.height));
        if (this.pageStream != null) {
            this.writeWarning("Page " + this.currentPage + " already open. " + "Call closePage() before starting a new one.");
            return;
        }
        BufferedImage thumbnail = null;
        if (component != null && this.isProperty(THUMBNAILS)) {
            thumbnail = ImageGraphics2D.generateThumbnail((Component)component, (Dimension)this.getPropertyDimension(THUMBNAIL_SIZE));
        }
        ++this.currentPage;
        if (title == null) {
            title = "Page " + this.currentPage + " (untitled)";
        }
        this.titles.add(title);
        PDFPage page = this.os.openPage("Page" + this.currentPage, "RootPage");
        page.setContents("PageContents" + this.currentPage);
        if (thumbnail != null) {
            page.setThumb("Thumb" + this.currentPage);
        }
        this.os.close(page);
        if (thumbnail != null) {
            PDFStream thumbnailStream = this.os.openStream("Thumb" + this.currentPage);
            thumbnailStream.image(thumbnail, Color.black, COMPRESS_FILTERS);
            this.os.close(thumbnailStream);
        }
        this.pageStream = this.os.openStream("PageContents" + this.currentPage, this.isProperty(COMPRESS) ? COMPRESS_FILTERS : NO_FILTERS);
        AffineTransform pageTrafo = new AffineTransform();
        pageTrafo.scale(1.0, -1.0);
        Dimension pageSize = PageConstants.getSize((String)this.getProperty(PAGE_SIZE), (String)this.getProperty(ORIENTATION));
        Insets margins = PageConstants.getMargins((Insets)this.getPropertyInsets(PAGE_MARGINS), (String)this.getProperty(ORIENTATION));
        pageTrafo.translate(margins.left, -(pageSize.getHeight() - (double)margins.top));
        this.writeHeadline(pageTrafo);
        this.writeFootline(pageTrafo);
        double scaleFactor = Math.min(this.getWidth() / (double)size.width, this.getHeight() / (double)size.height);
        if (scaleFactor < 1.0 || this.isProperty(FIT_TO_PAGE)) {
            pageTrafo.scale(scaleFactor, scaleFactor);
        } else {
            scaleFactor = 1.0;
        }
        double dx = (this.getWidth() - (double)size.width * scaleFactor) / 2.0 / scaleFactor;
        double dy = (this.getHeight() - (double)size.height * scaleFactor) / 2.0 / scaleFactor;
        pageTrafo.translate(dx, dy);
        this.writeTransform(pageTrafo);
        this.writeGraphicsSave();
        this.clipRect(0, 0, size.width, size.height);
        this.writeGraphicsSave();
        this.delayPaintQueue.setPageMatrix(pageTrafo);
        this.writeGraphicsState();
        this.writeBackground();
    }

    public void closePage() throws IOException {
        if (this.pageStream == null) {
            this.writeWarning("Page " + this.currentPage + " already closed. " + "Call openPage() to start a new one.");
            return;
        }
        this.os.close(this.pageStream);
        this.pageStream = null;
        this.processDelayed();
    }

    public void setHeader(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
        this.headerFont = font;
        this.headerText = new TagString[3];
        this.headerText[0] = left;
        this.headerText[1] = center;
        this.headerText[2] = right;
        this.headerUnderline = underlineThickness;
    }

    public void setFooter(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
        this.footerFont = font;
        this.footerText = new TagString[3];
        this.footerText[0] = left;
        this.footerText[1] = center;
        this.footerText[2] = right;
        this.footerUnderline = underlineThickness;
    }

    private void writeHeadline(AffineTransform pageTrafo) throws IOException {
        if (this.headerText != null) {
            LineMetrics metrics = this.headerFont.getLineMetrics("mM", this.getFontRenderContext());
            this.writeLine(pageTrafo, this.headerFont, this.headerText, -metrics.getLeading() - this.headerFont.getSize2D() / 2.0f, 3, -this.headerFont.getSize2D() / 2.0f, this.headerUnderline);
        }
    }

    private void writeFootline(AffineTransform pageTrafo) throws IOException {
        if (this.footerText != null) {
            LineMetrics metrics = this.footerFont.getLineMetrics("mM", this.getFontRenderContext());
            double y = this.getHeight() + (double)(this.footerFont.getSize2D() / 2.0f);
            this.writeLine(pageTrafo, this.footerFont, this.footerText, y + (double)metrics.getLeading(), 1, y, this.footerUnderline);
        }
    }

    private void writeLine(AffineTransform trafo, Font font, TagString[] text, double ty, int yAlign, double ly, int underline) throws IOException {
        this.writeGraphicsSave();
        this.setColor(Color.black);
        this.setFont(font);
        this.writeTransform(trafo);
        if (text[0] != null) {
            this.drawString(text[0], 0.0, ty, 1, yAlign);
        }
        if (text[1] != null) {
            this.drawString(text[1], this.getWidth() / 2.0, ty, 2, yAlign);
        }
        if (text[2] != null) {
            this.drawString(text[2], this.getWidth(), ty, 3, yAlign);
        }
        if (underline >= 0) {
            this.setLineWidth(underline);
            this.drawLine(0.0, ly, this.getWidth(), ly);
        }
        this.writeGraphicsRestore();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new PDFGraphics2D(this, true);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        PDFGraphics2D graphics = new PDFGraphics2D(this, true);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
        this.pageStream.save();
    }

    protected void writeGraphicsRestore() throws IOException {
        this.pageStream.restore();
    }

    public void draw(Shape s) {
        try {
            if (this.getStroke() instanceof BasicStroke) {
                this.pageStream.drawPath(s);
                this.pageStream.stroke();
            } else {
                this.pageStream.drawPath(this.getStroke().createStrokedShape(s));
                this.pageStream.fill();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fill(Shape s) {
        try {
            boolean eofill = this.pageStream.drawPath(s);
            if (eofill) {
                this.pageStream.fillEvenOdd();
            } else {
                this.pageStream.fill();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillAndDraw(Shape s, Color fillColor) {
        try {
            this.writeGraphicsSave();
            this.setNonStrokeColor(fillColor);
            boolean eofill = this.pageStream.drawPath(s);
            if (eofill) {
                this.pageStream.fillEvenOddAndStroke();
            } else {
                this.pageStream.fillAndStroke();
            }
            this.writeGraphicsRestore();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        PDFName ref = this.delayImageQueue.delayImage(image, bkg, this.getProperty(WRITE_IMAGES_AS));
        AffineTransform imageTransform = new AffineTransform((double)image.getWidth(), 0.0, 0.0, (double)(-image.getHeight()), 0.0, (double)image.getHeight());
        xform.concatenate(imageTransform);
        this.writeGraphicsSave();
        this.pageStream.matrix(xform);
        this.pageStream.xObject(ref);
        this.writeGraphicsRestore();
    }

    protected void writeString(String str, double x, double y) throws IOException {
        this.writeGraphicsSave();
        AffineTransform at = new AffineTransform(1.0, 0.0, 0.0, 1.0, x, y);
        at.concatenate(this.getFont().getTransform());
        at.scale(1.0, -1.0);
        this.writeTransform(at);
        this.pageStream.beginText();
        this.pageStream.text(0.0, 0.0);
        this.showCharacterCodes(str);
        this.pageStream.endText();
        this.writeGraphicsRestore();
    }

    protected void writeTransform(AffineTransform t) throws IOException {
        this.pageStream.matrix(t);
    }

    protected void writeSetClip(Shape s) throws IOException {
        try {
            AffineTransform at = this.getTransform();
            Stroke stroke = this.getStroke();
            this.writeGraphicsRestore();
            this.writeGraphicsSave();
            this.writeStroke(stroke);
            this.writeTransform(at);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        this.writeClip(s);
    }

    protected void writeClip(Shape s) throws IOException {
        if (s == null || !this.isProperty(CLIP)) {
            return;
        }
        if (s instanceof Rectangle2D) {
            this.pageStream.move(((Rectangle2D)s).getMinX(), ((Rectangle2D)s).getMinY());
            this.pageStream.line(((Rectangle2D)s).getMaxX(), ((Rectangle2D)s).getMinY());
            this.pageStream.line(((Rectangle2D)s).getMaxX(), ((Rectangle2D)s).getMaxY());
            this.pageStream.line(((Rectangle2D)s).getMinX(), ((Rectangle2D)s).getMaxY());
            this.pageStream.closePath();
            this.pageStream.clip();
            this.pageStream.endPath();
        } else {
            boolean eoclip = this.pageStream.drawPath(s);
            if (eoclip) {
                this.pageStream.clipEvenOdd();
            } else {
                this.pageStream.clip();
            }
            this.pageStream.endPath();
        }
    }

    protected void writeWidth(float width) throws IOException {
        this.pageStream.width(width);
    }

    protected void writeCap(int cap) throws IOException {
        switch (cap) {
            default: {
                this.pageStream.cap(0);
                break;
            }
            case 1: {
                this.pageStream.cap(1);
                break;
            }
            case 2: {
                this.pageStream.cap(2);
            }
        }
    }

    protected void writeJoin(int join) throws IOException {
        switch (join) {
            default: {
                this.pageStream.join(0);
                break;
            }
            case 1: {
                this.pageStream.join(1);
                break;
            }
            case 2: {
                this.pageStream.join(2);
            }
        }
    }

    protected void writeMiterLimit(float limit) throws IOException {
        this.pageStream.mitterLimit(limit);
    }

    protected void writeDash(float[] dash, float phase) throws IOException {
        this.pageStream.dash(dash, (double)phase);
    }

    public void setPaintMode() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color c) throws IOException {
        float[] cc = c.getRGBComponents(null);
        Float alpha = new Float(cc[3]);
        String alphaName = (String)this.extGStates.get(alpha);
        if (alphaName == null) {
            alphaName = "Alpha" + this.alphaIndex;
            ++this.alphaIndex;
            this.extGStates.put(alpha, alphaName);
        }
        this.pageStream.state(this.os.name(alphaName));
        this.pageStream.colorSpace(cc[0], cc[1], cc[2]);
        this.pageStream.colorSpaceStroke(cc[0], cc[1], cc[2]);
    }

    protected void writePaint(GradientPaint c) throws IOException {
        this.writePaint((Paint)c);
    }

    protected void writePaint(TexturePaint c) throws IOException {
        this.writePaint((Paint)c);
    }

    protected void writePaint(Paint paint) throws IOException {
        this.pageStream.colorSpace(this.os.name("Pattern"));
        this.pageStream.colorSpaceStroke(this.os.name("Pattern"));
        PDFName shadingName = this.delayPaintQueue.delayPaint(paint, this.getTransform(), this.getProperty(WRITE_IMAGES_AS));
        this.pageStream.colorSpace(null, shadingName);
        this.pageStream.colorSpaceStroke(new double[0], shadingName);
    }

    protected void setNonStrokeColor(Color c) throws IOException {
        float[] cc = c.getRGBColorComponents(null);
        this.pageStream.colorSpace(cc[0], cc[1], cc[2]);
    }

    protected void setStrokeColor(Color c) throws IOException {
        float[] cc = c.getRGBColorComponents(null);
        this.pageStream.colorSpaceStroke(cc[0], cc[1], cc[2]);
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String comment) throws IOException {
    }

    public String toString() {
        return "PDFGraphics2D";
    }

    public void showString(Font font, String str) throws IOException {
        String fontRef = this.fontTable.fontReference(font, this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
        this.pageStream.font(this.os.name(fontRef), (double)font.getSize() * 1.0);
        this.pageStream.show(str);
    }

    private void showCharacterCodes(String str) throws IOException {
        FontUtilities.showString((Font)this.getFont(), (String)str, (CharTable)Lookup.getInstance().getTable("PDFLatin"), (FontUtilities.ShowString)this);
    }

    private double getWidth() {
        Dimension pageSize = PageConstants.getSize((String)this.getProperty(PAGE_SIZE), (String)this.getProperty(ORIENTATION));
        Insets margins = PageConstants.getMargins((Insets)this.getPropertyInsets(PAGE_MARGINS), (String)this.getProperty(ORIENTATION));
        return pageSize.getWidth() - (double)margins.left - (double)margins.right;
    }

    private double getHeight() {
        Dimension pageSize = PageConstants.getSize((String)this.getProperty(PAGE_SIZE), (String)this.getProperty(ORIENTATION));
        Insets margins = PageConstants.getMargins((Insets)this.getPropertyInsets(PAGE_MARGINS), (String)this.getProperty(ORIENTATION));
        return pageSize.getHeight() - (double)margins.top - (double)margins.bottom;
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(VERSION, VERSION5);
        defaultProperties.setProperty(COMPRESS, true);
        defaultProperties.setProperty(PAGE_SIZE, "International");
        defaultProperties.setProperty(PAGE_MARGINS, PageConstants.getMargins((String)"Small"));
        defaultProperties.setProperty(ORIENTATION, "Portrait");
        defaultProperties.setProperty(FIT_TO_PAGE, true);
        defaultProperties.setProperty(EMBED_FONTS, false);
        defaultProperties.setProperty(EMBED_FONTS_AS, "Type3");
        defaultProperties.setProperty(THUMBNAILS, defaultProperties.getProperty(VERSION).equals(VERSION4));
        defaultProperties.setProperty(THUMBNAIL_SIZE, new Dimension(128, 128));
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(AUTHOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(SUBJECT, "");
        defaultProperties.setProperty(KEYWORDS, "");
        defaultProperties.setProperty(CLIP, true);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
        COMPRESS_FILTERS = new String[]{"Flate", "ASCII85"};
        NO_FILTERS = new String[0];
    }
}

