/*
 * Decompiled with CFR 0.152.
 */
package jas.plot.java2;

import jas.plot.SetablePlotGraphics;
import jas.plot.Transformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class PlotGraphics12
implements SetablePlotGraphics {
    private static final boolean[] isFilled = new boolean[]{true, true, true, true, false, false, false, false, false, false};
    private GeneralPath path = new GeneralPath();
    private Graphics2D g;
    private Line2D.Double line = new Line2D.Double();
    private Arc2D.Double arc = new Arc2D.Double();
    private Rectangle2D.Double rect = new Rectangle2D.Double();
    private RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private Shape oldClip;
    private Stroke oldStroke;
    private Transformation xt;
    private Transformation yt;
    private static final Transformation defaultTransformation = new Transformation(){

        public double convert(double d) {
            return d;
        }
    };

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            this.g.setStroke(this.oldStroke);
        } else {
            this.g.setStroke(stroke);
        }
    }

    public void setGraphics(Graphics graphics) {
        this.g = (Graphics2D)graphics;
        if (this.g == null) {
            this.oldClip = null;
            this.oldStroke = null;
        } else {
            this.oldClip = this.g.getClip();
            this.oldStroke = this.g.getStroke();
            this.g.setRenderingHints(this.rh);
        }
        this.clearTransformation();
    }

    public void setTransformation(Transformation transformation, Transformation transformation2) {
        this.xt = transformation == null ? defaultTransformation : transformation;
        this.yt = transformation2 == null ? defaultTransformation : transformation2;
    }

    public void clearTransformation() {
        this.xt = defaultTransformation;
        this.yt = defaultTransformation;
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.line.setLine(this.xt.convert(d), this.yt.convert(d2), this.xt.convert(d3), this.yt.convert(d4));
        this.g.draw(this.line);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = this.xt.convert(d);
        double d8 = this.yt.convert(d2);
        double d9 = this.xt.convert(d3);
        double d10 = this.yt.convert(d4);
        if (d9 < d7) {
            d6 = d7;
            d7 = d9;
            d9 = d6;
        }
        if (d10 < d8) {
            d6 = d8;
            d8 = d10;
            d10 = d6;
        }
        if ((d6 = d9 - d7) < 1.0) {
            d6 = 1.0;
        }
        if ((d5 = d10 - d8) < 1.0) {
            d5 = 1.0;
        }
        this.rect.setRect(d7, d8, d6, d5);
        this.g.fill(this.rect);
    }

    public void drawOval(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = this.xt.convert(d);
        double d8 = this.yt.convert(d2);
        double d9 = this.xt.convert(d3);
        double d10 = this.yt.convert(d4);
        if (d9 < d7) {
            d6 = d7;
            d7 = d9;
            d9 = d6;
        }
        if (d10 < d8) {
            d6 = d8;
            d8 = d10;
            d10 = d6;
        }
        if ((d6 = d9 - d7) < 1.0) {
            d6 = 1.0;
        }
        if ((d5 = d10 - d8) < 1.0) {
            d5 = 1.0;
        }
        this.arc.setArc(d7, d8, d6, d5, 0.0, 360.0, 1);
        this.g.draw(this.arc);
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = this.xt.convert(d);
        double d8 = this.yt.convert(d2);
        double d9 = this.xt.convert(d3);
        double d10 = this.yt.convert(d4);
        if (d9 < d7) {
            d6 = d7;
            d7 = d9;
            d9 = d6;
        }
        if (d10 < d8) {
            d6 = d8;
            d8 = d10;
            d10 = d6;
        }
        if ((d6 = d9 - d7) < 1.0) {
            d6 = 1.0;
        }
        if ((d5 = d10 - d8) < 1.0) {
            d5 = 1.0;
        }
        this.rect.setRect(d7, d8, d6, d5);
        this.g.draw(this.rect);
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void drawString(String string, double d, double d2) {
        this.g.drawString(string, (float)this.xt.convert(d), (float)this.yt.convert(d2));
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public void drawSymbol(double d, double d2, double d3, int n) {
        Shape shape = this.getShapeForSymbol(d, d2, d3, n);
        if (isFilled[n]) {
            this.g.fill(shape);
        } else {
            this.g.draw(shape);
        }
    }

    private Shape getShapeForSymbol(double d, double d2, double d3, int n) {
        float f = (float)this.xt.convert(d);
        float f2 = (float)this.yt.convert(d2);
        float f3 = (float)d3 / 2.0f;
        switch (n) {
            case 0: 
            case 8: {
                this.arc.setArc(f - f3, f2 - f3, d3, d3, 0.0, 360.0, 2);
                return this.arc;
            }
            case 1: 
            case 9: {
                this.rect.setRect(f - f3, f2 - f3, d3, d3);
                return this.rect;
            }
            case 2: {
                this.path.reset();
                this.path.moveTo(f - f3, f2 + f3);
                this.path.lineTo(f + f3, f2 + f3);
                this.path.lineTo(f, f2 - f3);
                this.path.closePath();
                return this.path;
            }
            case 3: {
                this.path.reset();
                this.path.moveTo(f - f3, f2);
                this.path.lineTo(f, f2 + f3);
                this.path.lineTo(f + f3, f2);
                this.path.lineTo(f, f2 - f3);
                this.path.closePath();
                return this.path;
            }
            case 4: {
                this.path.reset();
                this.path.moveTo(f, f2 + f3);
                this.path.lineTo(f, f2 - f3);
                this.path.moveTo(f - f3, f2);
                this.path.lineTo(f + f3, f2);
                this.path.moveTo(f - f3, f2 - f3);
                this.path.lineTo(f + f3, f2 + f3);
                this.path.moveTo(f + f3, f2 - f3);
                this.path.lineTo(f - f3, f2 + f3);
                return this.path;
            }
            case 5: {
                this.line.setLine(f, f2 + f3, f, f2 - f3);
                return this.line;
            }
            case 6: {
                this.line.setLine(f - f3, f2, f + f3, f2);
                return this.line;
            }
            case 7: {
                this.path.reset();
                this.path.moveTo(f, f2 + f3);
                this.path.lineTo(f, f2 - f3);
                this.path.moveTo(f - f3, f2);
                this.path.lineTo(f + f3, f2);
                return this.path;
            }
        }
        throw new RuntimeException("Unknown symbol " + n);
    }

    public void drawPolyLine(double[] dArray, double[] dArray2, int n) {
        if (n <= 0) {
            return;
        }
        this.path.reset();
        this.path.moveTo((float)this.xt.convert(dArray[0]), (float)this.yt.convert(dArray2[0]));
        for (int i = 1; i < n; ++i) {
            this.path.lineTo((float)this.xt.convert(dArray[i]), (float)this.yt.convert(dArray2[i]));
        }
        this.g.draw(this.path);
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public void drawPolySymbol(double[] dArray, double[] dArray2, double d, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.drawSymbol(dArray[i], dArray2[i], d, n);
        }
    }

    public void drawImage(Image image, double d, double d2, ImageObserver imageObserver) {
        this.g.drawImage(image, (int)this.xt.convert(d), (int)this.yt.convert(d2), imageObserver);
    }

    public void drawImage(Image image, double d, double d2, int n, int n2, ImageObserver imageObserver) {
        this.g.drawImage(image, (int)this.xt.convert(d), (int)this.yt.convert(d2), n, n2, imageObserver);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n4, n2 - n, n3 - n4);
    }

    public void clearClip() {
        this.g.setClip(this.oldClip);
    }

    public Rectangle getClipBounds() {
        if (this.g == null) {
            return null;
        }
        return this.g.getClipBounds();
    }

    public BufferedImage createImage(int n, int n2) {
        BufferedImage bufferedImage = null;
        bufferedImage = this.g != null ? this.g.getDeviceConfiguration().createCompatibleImage(n, n2) : new BufferedImage(n, n2, 2);
        return bufferedImage;
    }
}

