/*
 * Decompiled with CFR 0.152.
 */
package tablelayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Vector;
import tablelayout.TableCol;
import tablelayout.TableLoc;
import tablelayout.TableLocRec;
import tablelayout.TableRow;

public class TableLayout
implements LayoutManager {
    private static final String version_id = "@(#)$Id: TableLayout.java,v 1.2 2002/03/26 18:21:02 tonyj Exp $ Copyright West Consulting bv";
    boolean force_shrink = true;
    int col_spacing = 1;
    int row_spacing = 1;
    TableLoc layout = new TableLoc();
    Vector same_width = new Vector();
    Vector same_height = new Vector();
    int margin_width = 0;
    int margin_height = 0;
    TableCol cols = null;
    TableRow rows = null;

    public void addLayoutComponent(String string, Component component) {
        try {
            TableLocRec tableLocRec = new TableLocRec(string);
            this.layout.addElement(tableLocRec, component);
        }
        catch (Exception exception) {
            System.out.println("TableLayout: Syntax error in component: " + string);
            return;
        }
    }

    public void removeLayoutComponent(Component component) {
        this.layout.removeElement(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Object object;
        int n;
        int n2 = container.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = container.getComponent(n);
            if (!component.isVisible() || (object = this.layout.element(component)) == null) continue;
            ((TableLocRec)object).orig_width = component.getPreferredSize().width;
            ((TableLocRec)object).orig_height = component.getPreferredSize().height;
            ((TableLocRec)object).same_width = 0;
            ((TableLocRec)object).same_height = 0;
        }
        this.considerSameWidth();
        this.considerSameHeight();
        this.cols = new TableCol(this);
        this.rows = new TableRow(this);
        n = this.cols.getPreferredSize();
        int n3 = this.rows.getPreferredSize();
        object = container.getInsets();
        return new Dimension(n += ((Insets)object).left + ((Insets)object).right, n3 += ((Insets)object).top + ((Insets)object).bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n;
        int n2 = container.getComponentCount();
        for (n = 0; n < n2; ++n) {
            TableLocRec tableLocRec;
            Component component = container.getComponent(n);
            if (!component.isVisible() || (tableLocRec = this.layout.element(component)) == null) continue;
            tableLocRec.orig_width = component.getPreferredSize().width;
            tableLocRec.orig_height = component.getPreferredSize().height;
            tableLocRec.same_width = 0;
            tableLocRec.same_height = 0;
        }
        this.considerSameWidth();
        this.considerSameHeight();
        this.cols = new TableCol(this);
        this.rows = new TableRow(this);
        n = this.cols.totalSize();
        int n3 = this.rows.totalSize();
        return new Dimension(n, n3);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            TableLocRec tableLocRec;
            Component component = container.getComponent(i);
            if (!component.isVisible() || (tableLocRec = this.layout.element(component)) == null) continue;
            component.doLayout();
            tableLocRec.orig_width = component.getPreferredSize().width;
            tableLocRec.orig_height = component.getPreferredSize().height;
            tableLocRec.same_width = 0;
            tableLocRec.same_height = 0;
        }
        this.considerSameWidth();
        this.considerSameHeight();
        this.cols = new TableCol(this);
        this.rows = new TableRow(this);
        this.cols.minimize();
        this.rows.minimize();
        this.tableMakeColsFitWidth(dimension.width - insets.left - insets.right);
        this.tableMakeRowsFitHeight(dimension.height - insets.top - insets.bottom);
        this.tableSetGeometryOfChildren(insets);
    }

    public void sameWidth(Vector vector) {
        this.same_width.addElement(vector);
    }

    public void sameHeight(Vector vector) {
        this.same_height.addElement(vector);
    }

    public void marginWidth(int n) {
        this.margin_width = n;
    }

    public void marginHeight(int n) {
        this.margin_height = n;
    }

    public void forceShrink(boolean bl) {
        this.force_shrink = bl;
    }

    public void columnSpacing(int n) {
        this.col_spacing = n;
    }

    public void rowSpacing(int n) {
        this.row_spacing = n;
    }

    private void considerSameWidth() {
        int n = this.same_width.size();
        for (int i = 0; i < n; ++i) {
            Component component;
            TableLocRec tableLocRec;
            int n2;
            Vector vector = (Vector)this.same_width.elementAt(i);
            int n3 = 0;
            int n4 = vector.size();
            for (n2 = 0; n2 < n4 && (tableLocRec = this.layout.element(component = (Component)vector.elementAt(n2))) != null; ++n2) {
                if (tableLocRec.orig_width <= n3) continue;
                n3 = tableLocRec.orig_width;
            }
            for (n2 = 0; n2 < n4 && (tableLocRec = this.layout.element(component = (Component)vector.elementAt(n2))) != null; ++n2) {
                tableLocRec.same_width = n3;
            }
        }
    }

    private void considerSameHeight() {
        int n = this.same_height.size();
        for (int i = 0; i < n; ++i) {
            Component component;
            TableLocRec tableLocRec;
            int n2;
            Vector vector = (Vector)this.same_height.elementAt(i);
            int n3 = 0;
            int n4 = vector.size();
            for (n2 = 0; n2 < n4 && (tableLocRec = this.layout.element(component = (Component)vector.elementAt(n2))) != null; ++n2) {
                if (tableLocRec.orig_height <= n3) continue;
                n3 = tableLocRec.orig_height;
            }
            for (n2 = 0; n2 < n4 && (tableLocRec = this.layout.element(component = (Component)vector.elementAt(n2))) != null; ++n2) {
                tableLocRec.same_height = n3;
            }
        }
    }

    private void tableMakeColsFitWidth(int n) {
        int n2 = this.cols.totalSize();
        int n3 = this.cols.getPreferredSize();
        int n4 = n < n3 && !this.force_shrink ? n3 - n2 : n - n2;
        if (n4 != 0) {
            this.cols.adjust(n4);
        }
    }

    private void tableMakeRowsFitHeight(int n) {
        int n2 = this.rows.totalSize();
        int n3 = this.rows.getPreferredSize();
        int n4 = n < n3 && !this.force_shrink ? n3 - n2 : n - n2;
        if (n4 != 0) {
            this.rows.adjust(n4);
        }
    }

    private void tableSetGeometryOfChildren(Insets insets) {
        if (this.layout == (TableLoc)null || this.cols == (TableCol)null || this.rows == (TableRow)null) {
            return;
        }
        this.cols.computeOffsets(insets.left, this.col_spacing);
        this.rows.computeOffsets(insets.top, this.row_spacing);
        int n = this.layout.size();
        for (int i = 0; i < n; ++i) {
            TableLocRec tableLocRec = this.layout.recElementAt(i);
            Component component = this.layout.compElementAt(i);
            this.TableComputeChildPosition(tableLocRec, component);
        }
    }

    private void TableComputeChildPosition(TableLocRec tableLocRec, Component component) {
        int n;
        int n2 = this.col_spacing;
        int n3 = -n2;
        for (n = 0; n < tableLocRec.col_span; ++n) {
            n3 += this.cols.elementAt((int)(tableLocRec.col + n)).value + n2;
        }
        int n4 = tableLocRec.preferredWidth();
        int n5 = tableLocRec.options.W && n3 > n4 ? n4 : n3;
        if (n5 <= 0) {
            n5 = 1;
        }
        n2 = this.row_spacing;
        int n6 = -n2;
        for (n = 0; n < tableLocRec.row_span; ++n) {
            n6 += this.rows.elementAt((int)(tableLocRec.row + n)).value + n2;
        }
        n4 = tableLocRec.preferredHeight();
        int n7 = tableLocRec.options.H && n6 > n4 ? n4 : n6;
        if (n7 <= 0) {
            n7 = 1;
        }
        int n8 = this.cols.elementAt((int)tableLocRec.col).offset;
        int n9 = tableLocRec.options.l ? n8 : (tableLocRec.options.r ? n8 + n3 - n5 : n8 + (n3 - n5) / 2);
        int n10 = this.rows.elementAt((int)tableLocRec.row).offset;
        int n11 = tableLocRec.options.t ? n10 : (tableLocRec.options.b ? n10 + n6 - n7 : n10 + (n6 - n7) / 2);
        component.setSize(n5, n7);
        Point point = component.getLocation();
        if (n9 != point.x || n11 != point.y) {
            component.setLocation(n9, n11);
        }
    }

    public String toString() {
        return "TableLayout [\nlayout: " + this.layout.toString() + "\ncols: " + this.cols.toString() + "\nrows: " + this.rows.toString() + "\nsame_width: " + this.same_width.toString() + "\nsame_height: " + this.same_height.toString() + "\ncol_spacing: " + this.col_spacing + "\nrow_spacing: " + this.row_spacing + "\nforce_shrink: " + this.force_shrink + "\nmargin_width: " + this.margin_width + "\nmargin_height: " + this.margin_height + " ]";
    }

    public Object clone() {
        TableLayout tableLayout = new TableLayout();
        tableLayout.force_shrink = this.force_shrink;
        tableLayout.col_spacing = this.col_spacing;
        tableLayout.row_spacing = this.row_spacing;
        tableLayout.layout = (TableLoc)this.layout.clone();
        tableLayout.same_width = (Vector)this.same_width.clone();
        tableLayout.same_height = (Vector)this.same_height.clone();
        tableLayout.margin_width = this.margin_width;
        tableLayout.margin_height = this.margin_height;
        tableLayout.considerSameWidth();
        tableLayout.considerSameHeight();
        tableLayout.cols = new TableCol(this);
        tableLayout.rows = new TableRow(this);
        return tableLayout;
    }
}

