/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Lookup;
import org.freehep.graphicsio.font.FontEmbedderType1;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.graphicsio.ps.PSFontEmbedder;

public class PSFontTable
extends FontTable {
    private OutputStream out;
    private FontRenderContext context;
    private static final Properties replaceFonts = new Properties();
    private static final HashSet ignoreAtributes;

    public PSFontTable(OutputStream out, FontRenderContext context) {
        this.out = out;
        this.context = context;
    }

    public CharTable getEncodingTable() {
        return Lookup.getInstance().getTable("STDLatin");
    }

    protected void firstRequest(FontTable.Entry e, boolean embed, String embedAs) throws IOException {
        PSFontEmbedder fontIncluder = null;
        e.setWritten(true);
        this.out.flush();
        if (embed) {
            if (embedAs.equals("Type3")) {
                fontIncluder = new PSFontEmbedder(this.context, new PrintStream(this.out));
            } else if (embedAs.equals("Type1")) {
                fontIncluder = new FontEmbedderType1(this.context, this.out, true);
            } else {
                System.err.println("PSFontTable: not a valid value for embedAs: " + embedAs);
            }
        } else {
            return;
        }
        fontIncluder.includeFont(e.getFont(), e.getEncoding(), e.getReference());
        this.out.flush();
    }

    protected Font substituteFont(Font font) {
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.remove(TextAttribute.TRANSFORM);
        attributes.remove(TextAttribute.SUPERSCRIPT);
        return new Font(attributes);
    }

    protected String createFontReference(Font font) {
        Object posture;
        Object weight;
        Map<TextAttribute, ?> attributes = font.getAttributes();
        PSFontTable.normalize(attributes);
        StringBuffer result = new StringBuffer();
        String family = (String)attributes.get(TextAttribute.FAMILY);
        Object v0 = weight = ignoreAtributes.contains(family) ? null : attributes.get(TextAttribute.WEIGHT);
        if (TextAttribute.WEIGHT_BOLD.equals(weight)) {
            result.append("Bold");
        } else if (TextAttribute.WEIGHT_DEMIBOLD.equals(weight)) {
            result.append("DemiBold");
        } else if (TextAttribute.WEIGHT_DEMILIGHT.equals(weight)) {
            result.append("DemiLight");
        } else if (TextAttribute.WEIGHT_EXTRA_LIGHT.equals(weight)) {
            result.append("ExtraLight");
        } else if (TextAttribute.WEIGHT_EXTRABOLD.equals(weight)) {
            result.append("ExtraBold");
        } else if (TextAttribute.WEIGHT_HEAVY.equals(weight)) {
            result.append("Heavy");
        } else if (TextAttribute.WEIGHT_LIGHT.equals(weight)) {
            result.append("Light");
        } else if (TextAttribute.WEIGHT_MEDIUM.equals(weight)) {
            result.append("Medium");
        } else if (!TextAttribute.WEIGHT_REGULAR.equals(weight)) {
            if (TextAttribute.WEIGHT_SEMIBOLD.equals(weight)) {
                result.append("SemiBold");
            } else if (TextAttribute.WEIGHT_ULTRABOLD.equals(weight)) {
                result.append("UltraBold");
            }
        }
        Object v1 = posture = ignoreAtributes.contains(family) ? null : attributes.get(TextAttribute.POSTURE);
        if (TextAttribute.POSTURE_OBLIQUE.equals(posture)) {
            if (family.equals("Times")) {
                result.append("Italic");
            } else {
                result.append("Oblique");
            }
        } else if (TextAttribute.POSTURE_REGULAR.equals(posture)) {
            // empty if block
        }
        if (family.equals("Times") && result.length() == 0) {
            result.append("Roman");
        }
        if (result.length() > 0) {
            result.insert(0, "-");
            result.insert(0, attributes.get(TextAttribute.FAMILY));
        } else {
            result.append(attributes.get(TextAttribute.FAMILY));
        }
        return result.toString();
    }

    public static void normalize(Map attributes) {
        FontTable.normalize((Map)attributes);
        String family = replaceFonts.getProperty(((String)attributes.get(TextAttribute.FAMILY)).toLowerCase());
        if (family == null) {
            family = (String)attributes.get(TextAttribute.FAMILY);
        }
        family = family.replaceAll(" ", "");
        attributes.put(TextAttribute.FAMILY, family);
    }

    static {
        replaceFonts.setProperty("timesroman", "Times");
        replaceFonts.setProperty("dialog", "Helvetica");
        replaceFonts.setProperty("dialoginput", "Courier-New");
        replaceFonts.setProperty("serif", "Times");
        replaceFonts.setProperty("sansserif", "Helvetica");
        replaceFonts.setProperty("monospaced", "Courier-New");
        replaceFonts.setProperty("typewriter", "Courier-New");
        ignoreAtributes = new HashSet();
        ignoreAtributes.add("Symbol");
        ignoreAtributes.add("ZapfDingbats");
    }
}

