/*
 * Decompiled with CFR 0.152.
 */
package UI;

import core.Line;
import core.Nuclide;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class LibraryTreeRenderer
extends DefaultTreeCellRenderer {
    Icon addedIcon;
    Icon notAddedIcon;
    JLabel lab = null;
    JLabel ret = null;
    public static Color okColor;
    public static Color badColor;
    public static Color missingColor;
    public static Color back;
    boolean icons = true;

    public LibraryTreeRenderer() {
        okColor = Color.green.darker();
        missingColor = Color.red.darker();
        badColor = Color.yellow.darker();
        back = new Color(217, 217, 180);
        this.ret = new JLabel();
    }

    public LibraryTreeRenderer(boolean icons) {
        this();
        this.icons = icons;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object usr = node.getUserObject();
        if (sel) {
            this.lab = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        } else {
            this.lab = this.ret;
            this.lab.setText(" ");
            this.lab.setIcon(((JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus)).getIcon());
            this.lab.setForeground(Color.black);
        }
        if (node != null) {
            this.lab.setText(node.toString());
        }
        if (usr instanceof Nuclide) {
            this.handleNuclide(usr);
        }
        if (usr instanceof Line) {
            this.handleLine(usr);
        }
        if (!this.icons) {
            this.lab.setIcon(null);
        }
        return this.lab;
    }

    private void handleNuclide(Object o) {
        Nuclide n = (Nuclide)o;
        String str = n.getName();
        this.lab.setForeground(Color.black);
        if (n.getStatus() == 1) {
            str = str + " (ok)";
            this.lab.setForeground(okColor);
        }
        if (n.getStatus() == 3) {
            str = str + " (missing data)";
            this.lab.setForeground(missingColor);
        }
        if (n.getStatus() == 2) {
            str = str + " (bad data)";
            this.lab.setForeground(badColor);
        }
        this.lab.setToolTipText(n.getStatusComment());
        this.lab.setText(str);
    }

    private void handleLine(Object o) {
        Line l = (Line)o;
        String str = "Unknown line";
        if (l.getLineEnergy() != null) {
            str = l.getLineEnergy() + " KeV";
        }
        this.lab.setForeground(Color.black);
        if (l.getStatus() == 1) {
            str = str + " (ok)";
            this.lab.setForeground(okColor);
        }
        if (l.getStatus() == 3) {
            str = str + " (missing data)";
            this.lab.setForeground(missingColor);
        }
        if (l.getStatus() == 2) {
            str = str + " (bad data)";
            this.lab.setForeground(badColor);
        }
        this.lab.setToolTipText(l.getStatusComment());
        this.lab.setText(str);
    }
}

