/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Nuclide;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class Mapping {
    DecimalFormat frmt;
    Hashtable map;
    Class mappedClass = Nuclide.class;
    protected String pre = "";
    protected String post = "";

    public Mapping() {
        this.frmt = new DecimalFormat();
        this.frmt.setMaximumFractionDigits(10);
        DecimalFormatSymbols sym = this.frmt.getDecimalFormatSymbols();
        sym.setDecimalSeparator('.');
        this.frmt.setGroupingUsed(false);
        this.frmt.setDecimalFormatSymbols(sym);
        this.map = new Hashtable();
    }

    public void setPrePost(String pre, String post) {
        this.pre = pre;
        this.post = post;
    }

    public void add(String from, String to) {
        this.map.put(from, to);
    }

    public void add(String from, Mapping to) {
        this.map.put(from, to);
    }

    protected Object getMapFor(String name) {
        return this.map.get(name);
    }

    public String apply(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Collection) {
            return this.handleCollection((Collection)o);
        }
        Field[] fields = o.getClass().getDeclaredFields();
        String ret = "";
        if (this.pre != null) {
            ret = ret + this.pre;
        }
        for (int i = 0; i < fields.length; ++i) {
            System.out.println("Considering field:" + fields[i].toString() + " " + fields[i].getType());
            Object to = this.getMapFor(fields[i].getName());
            if (to != null && to instanceof String) {
                ret = ret + this.handleString((String)to, fields[i], o);
                continue;
            }
            if (to == null || !(to instanceof Mapping)) continue;
            try {
                Mapping toMap = (Mapping)to;
                ret = ret + toMap.apply(fields[i].get(o));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.post != null) {
            ret = ret + this.post;
        }
        return ret;
    }

    protected String handleString(String s, Field f, Object o) {
        ArrayList templ = this.parseMapping(s);
        String pre = (String)templ.get(0);
        String post = (String)templ.get(1);
        String string = null;
        try {
            Object obj = f.get(o);
            if (obj != null) {
                if (obj instanceof Float) {
                    Float fl = (Float)obj;
                    string = this.frmt.format(fl.floatValue());
                } else {
                    string = obj.toString();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (string != null) {
            return pre + string + post;
        }
        return "";
    }

    protected String handleCollection(Collection c) {
        Iterator iter = c.iterator();
        String res = "";
        while (iter.hasNext()) {
            res = res + this.apply(iter.next());
        }
        return res;
    }

    private ArrayList parseMapping(String map) {
        int ind1 = map.indexOf(36);
        String pre = map.substring(0, ind1);
        String post = map.substring(ind1 + 1, map.length());
        ArrayList<String> templ = new ArrayList<String>();
        templ.add(pre);
        templ.add(post);
        return templ;
    }
}

