/*
 * Decompiled with CFR 0.152.
 */
package fi.stuk.visualization.graphs;

import fi.stuk.visualization.graphs.Axis;
import fi.stuk.visualization.graphs.Graph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GraphCanvas
extends JPanel
implements Printable {
    List graphs;
    List shapes;
    List annotations;
    Axis axis;
    AffineTransform mirror;
    AffineTransform t;
    AffineTransform xt;
    AffineTransform yt;
    Graph selected;
    int xInset = 30;
    int yInset = 30;
    BufferedImage im;
    boolean isUpToDate = false;
    boolean clearToBack = true;
    RenderingHints hints;
    public static Font FONT_SERIF12 = new Font("Serif", 0, 12);
    public static Font FONT_SERIF10 = new Font("Serif", 0, 10);
    public static Font FONT_SERIF8 = new Font("Serif", 0, 8);
    boolean started = false;
    public static Object ANNOTATION_XOR = new Integer(1);
    public static Object ANNOTATION_FILL = new Integer(2);
    public static Object ANNOTATION_STOP_FILL = new Integer(3);
    private Vector annotBelow;
    boolean xInsetSet = false;
    boolean yInsetSet = false;
    boolean paintAxis = true;
    boolean forceRender = false;
    private Rectangle2D temp = new Rectangle2D.Double();
    int oldW = -1;
    int oldH = -1;
    int offsx = 0;
    int offsy = 0;
    double scalex = 1.0;
    double scaley = 1.0;
    Color alphaColor = new Color(0, 0, 0, 0);

    public GraphCanvas() {
        this.graphs = new Vector();
        this.annotations = new Vector();
        this.annotBelow = new Vector();
        this.mirror = AffineTransform.getScaleInstance(1.0, -1.0);
        this.t = AffineTransform.getScaleInstance(1.0, -1.0);
        this.xt = AffineTransform.getRotateInstance(-1.5707963267948966);
        this.axis = new Axis();
        this.axis.setMinMax(0.0, 0.0, 1.0, 1.0);
        this.hints = new RenderingHints(null);
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void setAntialiasingEnabled(boolean enabled) {
        if (!enabled) {
            this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else {
            this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public void addGraph(Graph g) {
        if (g == null) {
            return;
        }
        this.graphs.add(g);
    }

    public List getGraphs() {
        return this.graphs;
    }

    public void addAnnotation(Object o) {
        this.annotations.add(o);
    }

    public void addAnnotation(Object o, boolean below) {
        if (!below) {
            this.annotations.add(o);
        } else {
            this.annotBelow.add(o);
        }
    }

    public void setPaintAxis(boolean paint) {
        this.paintAxis = paint;
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public List getAnnotations(boolean below) {
        if (!below) {
            return this.annotations;
        }
        return this.annotBelow;
    }

    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getXInset() {
        return this.xInset;
    }

    public int getYInset() {
        return this.yInset;
    }

    public void setDrawAxis(boolean paint) {
        this.paintAxis = paint;
    }

    public void start() {
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setSelected(Graph g) {
        this.selected = g;
    }

    public Graph getSelected() {
        return this.selected;
    }

    private void newImage(int x, int y) {
        if (x <= 0) {
            x = 1;
        }
        if (y <= 0) {
            y = 1;
        }
        this.im = new BufferedImage(x, y, 2);
    }

    public void refresh() {
        if (!this.started) {
            return;
        }
        if (this.im == null || this.im.getHeight() != this.getHeight() || this.im.getWidth() != this.getWidth()) {
            this.newImage(this.getWidth(), this.getHeight());
        }
        this.render(this.im.getGraphics());
        this.isUpToDate = true;
    }

    public BufferedImage getImage() {
        return this.im;
    }

    public void setXInset(int xInset) {
        this.xInset = xInset;
        this.xInsetSet = true;
    }

    public void setYInset(int yInset) {
        this.yInset = yInset;
        this.yInsetSet = true;
    }

    public void setClearToBackground(boolean enabled) {
        this.clearToBack = enabled;
    }

    public void setRenderOnPaint(boolean enabled) {
        this.forceRender = enabled;
    }

    public void render(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Graphics2D g2d2 = (Graphics2D)g.create();
        Graphics2D g2d3 = (Graphics2D)g.create();
        g2d.setRenderingHints(this.hints);
        g2d2.setRenderingHints(this.hints);
        g2d3.setRenderingHints(this.hints);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.clearToBack) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, w, h);
        } else {
            g2d.setColor(Color.black);
            g2d.fillRect(0, 0, w, h);
        }
        Rectangle clipR = new Rectangle(this.xInset - 1, this.yInset - 1, this.axis.getSize(0) + 3, this.axis.getSize(1) + 3);
        if (!this.xInsetSet) {
            this.xInset = (int)((double)w / 6.5);
        }
        if (!this.yInsetSet) {
            this.yInset = (int)((double)h / 6.5);
        }
        if (this.axis == null) {
            return;
        }
        this.axis.setSize(w - 2 * this.xInset, h - 2 * this.yInset);
        this.axis.setLocation(new Point(0 + this.xInset, h - this.yInset));
        Iterator iter = this.graphs.iterator();
        g2d2.setClip(this.xInset - 1, this.yInset - 1, this.axis.getSize(0) + 3, this.axis.getSize(1) + 3);
        g2d2.translate(this.axis.getLocation().getX(), this.axis.getLocation().getY());
        g2d2.transform(this.mirror);
        g2d3.translate(this.axis.getLocation().getX(), this.axis.getLocation().getY());
        g2d3.transform(this.mirror);
        this.renderAnnotations(g2d2, this.annotBelow);
        g2d.setColor(Color.black);
        Shape clip = g2d.getClip();
        AffineTransform transf = g2d.getTransform();
        g2d.translate(this.axis.getLocation().getX(), this.axis.getLocation().getY());
        g2d.transform(this.mirror);
        if (this.paintAxis) {
            this.axis.renderGrid(this, g2d);
        }
        while (iter.hasNext()) {
            Graph gr = (Graph)iter.next();
            if (gr == null || gr == this.selected) continue;
            gr.render(this, g2d2, this.axis);
        }
        if (this.paintAxis) {
            this.axis.render(this, g2d);
        }
        if (this.selected != null) {
            boolean old = this.selected.isFilled();
            this.selected.setFilled(true);
            Color oldC = this.selected.getColor();
            this.selected.setColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
            this.selected.render(this, g2d2, this.axis);
            this.selected.setColor(oldC);
            this.selected.setFilled(old);
        }
        g2d2.dispose();
        this.renderAnnotations(g2d3, this.annotations);
    }

    public void renderAnnotations(Graphics g, List annot) {
        boolean fill = false;
        Graphics2D g2d = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        Shape clip = g2d.getClip();
        boolean screencs = false;
        for (int s = 0; s < 2; ++s) {
            Iterator iter = annot.iterator();
            boolean bl = screencs = !screencs;
            while (iter.hasNext()) {
                Object[] loc;
                int[] loc2;
                AffineTransform temp;
                Object location;
                int x2;
                int y1;
                int y2;
                Rectangle2D r;
                Object ann = iter.next();
                if (ann == ANNOTATION_XOR) {
                    g2d.setXORMode((Color)iter.next());
                }
                if (ann == ANNOTATION_FILL) {
                    fill = true;
                }
                if (ann == ANNOTATION_STOP_FILL) {
                    fill = false;
                }
                if (ann instanceof Rectangle && screencs) {
                    r = (Rectangle)ann;
                    Dimension d = ((Rectangle)r).getSize();
                    if (fill) {
                        g2d.fillRect(((Rectangle)r).x, ((Rectangle)r).y, d.width, d.height);
                    } else {
                        g2d.drawRect(((Rectangle)r).x, ((Rectangle)r).y, d.width, d.height);
                    }
                }
                if (ann instanceof Rectangle2D && !screencs) {
                    r = (Rectangle2D)ann;
                    int x1 = (int)this.axis.getAxisCoordinateForValue(r.getX(), 0);
                    int x22 = (int)this.axis.getAxisCoordinateForValue(r.getX() + r.getWidth(), 0);
                    int y12 = (int)this.axis.getAxisCoordinateForValue(r.getY(), 1);
                    y2 = (int)this.axis.getAxisCoordinateForValue(r.getY() + r.getHeight(), 1);
                    this.temp.setRect(Math.min(x1, x22), Math.min(y12, y2), Math.min(Math.abs(x22 - x1), Math.abs(w - x1)), Math.min(Math.abs(y2 - y12), Math.abs(h - y12)));
                    if (fill) {
                        g2d.fill(this.temp);
                    } else {
                        g2d.draw(this.temp);
                    }
                }
                if (ann instanceof Font) {
                    Font font = (Font)ann;
                    g2d.setFont(font);
                    continue;
                }
                if (ann instanceof double[] && !screencs) {
                    double[] l = (double[])ann;
                    g2d.setClip(0, 0, this.axis.getSize(0), this.axis.getSize(1));
                    int x1 = (int)this.axis.getAxisCoordinateForValue(l[0], 0);
                    y1 = (int)this.axis.getAxisCoordinateForValue(l[1], 1);
                    x2 = (int)this.axis.getAxisCoordinateForValue(l[2], 0);
                    y2 = (int)this.axis.getAxisCoordinateForValue(l[3], 1);
                    g2d.drawLine(x1, y1, x2, y2);
                    continue;
                }
                if (ann instanceof Image) {
                    location = iter.next();
                    if (location instanceof double[] && !screencs) {
                        g2d.setClip(0, 0, this.axis.getSize(0), this.axis.getSize(1));
                        temp = g2d.getTransform();
                        g2d.transform(this.t);
                        double[] loc3 = (double[])location;
                        int x1 = (int)this.axis.getAxisCoordinateForValue(loc3[0], 0);
                        int y13 = (int)this.axis.getAxisCoordinateForValue(loc3[1], 1);
                        Image img = (Image)ann;
                        g2d.drawImage(img, x1, -y13, null);
                        g2d.setTransform(temp);
                        continue;
                    }
                    if (!(location instanceof int[]) || !screencs) continue;
                    g2d.setClip(clip);
                    loc2 = (int[])location;
                    AffineTransform temp2 = g2d.getTransform();
                    g2d.setTransform(AffineTransform.getScaleInstance(1.0, 1.0));
                    Image img = (Image)ann;
                    g2d.drawImage(img, loc2[0], loc2[1], null);
                    g2d.setTransform(temp2);
                    continue;
                }
                if (ann instanceof Color) {
                    g2d.setColor((Color)ann);
                    continue;
                }
                if (ann instanceof String) {
                    String[] lines;
                    location = iter.next();
                    if (location instanceof double[] && !screencs) {
                        g2d.setClip(0, 0, this.axis.getSize(0), this.axis.getSize(1));
                        temp = g2d.getTransform();
                        g2d.transform(this.t);
                        String str = (String)ann;
                        double[] loc4 = (double[])location;
                        int x = (int)this.axis.getAxisCoordinateForValue(loc4[0], 0);
                        int y = (int)this.axis.getAxisCoordinateForValue(loc4[1], 1);
                        lines = str.split("\\n");
                        int fh = g2d.getFontMetrics().getHeight();
                        for (int i = 0; i < lines.length; ++i) {
                            g2d.drawString(lines[i], x, -y + i * fh);
                        }
                        g2d.setTransform(temp);
                        continue;
                    }
                    if (!(location instanceof int[]) || !screencs) continue;
                    loc2 = (int[])location;
                    AffineTransform temp3 = (AffineTransform)g2d.getTransform().clone();
                    g2d.transform(AffineTransform.getScaleInstance(1.0, -1.0));
                    String str = (String)ann;
                    int y = loc2[1] - this.yInset - this.axis.getSize(1);
                    int fh = g2d.getFontMetrics().getHeight();
                    lines = str.split("\\n");
                    for (int i = 0; i < lines.length; ++i) {
                        g2d.drawString(lines[i], loc2[0] - this.xInset, y + i * fh);
                    }
                    g2d.setTransform(temp3);
                    continue;
                }
                if (ann instanceof double[] && !screencs) {
                    g2d.setClip(0, 0, this.axis.getSize(0), this.axis.getSize(1));
                    loc = (double[])ann;
                    int x1 = (int)this.axis.getAxisCoordinateForValue((double)loc[0], 0);
                    y1 = (int)this.axis.getAxisCoordinateForValue((double)loc[1], 1);
                    x2 = (int)this.axis.getAxisCoordinateForValue((double)loc[2], 0);
                    y2 = (int)this.axis.getAxisCoordinateForValue((double)loc[3], 1);
                    g2d.drawLine(x1, y1, x2, y2);
                    continue;
                }
                if (!(ann instanceof int[]) || !screencs) continue;
                g2d.setClip(clip);
                loc = (int[])ann;
                temp = g2d.getTransform();
                g2d.setTransform(AffineTransform.getScaleInstance(1.0, 1.0));
                g2d.drawLine(loc[0], loc[1], loc[2], loc[3]);
                g2d.setTransform(temp);
            }
        }
    }

    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.newImage(x, y);
        this.render(this.im.getGraphics());
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setPaintBackground(boolean enabled) {
        this.clearToBack = enabled;
    }

    public void setBounds(int x, int y, int w, int h) {
        if (w != this.oldW || h != this.oldH) {
            this.isUpToDate = false;
        }
        super.setBounds(x, y, w, h);
        this.oldW = w;
        this.oldH = h;
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void paint(Graphics g) {
        if (!this.started) {
            super.paint(g);
            return;
        }
        if (this.forceRender) {
            this.render(g);
            return;
        }
        if (!this.isUpToDate) {
            this.newImage(this.getWidth(), this.getHeight());
            this.render(this.im.getGraphics());
            this.isUpToDate = true;
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage(this.im, null, 0, 0);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage(this.im, null, 0, 0);
        }
    }

    public void setPrintOffsetScale(int x, int y, double sx, double sy) {
        this.offsx = x;
        this.offsy = y;
        this.scalex = sx;
        this.scaley = sy;
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.scale((float)this.scalex, (float)this.scaley);
        g2d.translate(this.offsx, this.offsy);
        g2d.setFont(this.axis.getTitleFont(1));
        int xoffs = SwingUtilities.computeStringWidth(g2d.getFontMetrics(), this.axis.getTitle(1));
        g2d.setFont(this.axis.getTitleFont(0));
        int yoffs = SwingUtilities.computeStringWidth(g2d.getFontMetrics(), this.axis.getTitle(0));
        double sx = pageFormat.getImageableWidth() / (double)(this.getWidth() + xoffs);
        double sy = pageFormat.getImageableHeight() / (double)(this.getHeight() + yoffs);
        this.renderFHG(g2d);
        return 0;
    }

    public void renderFHG(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Graphics2D g2d2 = (Graphics2D)g.create();
        g2d.setRenderingHints(this.hints);
        g2d2.setRenderingHints(this.hints);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.clearToBack) {
            g2d.setColor(this.getBackground());
        } else {
            g2d.setColor(this.alphaColor);
        }
        g2d.fillRect(0, 0, w, h);
        Rectangle clipR = new Rectangle(this.xInset - 1, this.yInset - 1, this.axis.getSize(0) + 3, this.axis.getSize(1) + 3);
        if (!this.xInsetSet) {
            this.xInset = (int)((double)w / 6.5);
        }
        if (!this.yInsetSet) {
            this.yInset = (int)((double)h / 6.5);
        }
        if (this.axis == null) {
            return;
        }
        this.axis.setSize(w - 2 * this.xInset, h - 2 * this.yInset);
        this.axis.setLocation(new Point(0 + this.xInset, h - this.yInset));
        Iterator iter = this.graphs.iterator();
        g2d2.setClip(this.xInset - 1, this.yInset - 1, this.axis.getSize(0) + 3, this.axis.getSize(1) + 3);
        g2d2.translate(this.axis.getLocation().getX(), this.axis.getLocation().getY());
        g2d2.transform(this.mirror);
        while (iter.hasNext()) {
            Graph gr = (Graph)iter.next();
            gr.render(this, g2d2, this.axis);
        }
        g2d2.dispose();
        g2d.setColor(Color.black);
        Shape clip = g2d.getClip();
        AffineTransform transf = g2d.getTransform();
        g2d.translate(this.axis.getLocation().getX(), this.axis.getLocation().getY());
        g2d.transform(this.mirror);
        if (this.paintAxis) {
            this.axis.render(this, g2d);
        }
        this.renderAnnotationsFHG(g);
    }

    public void renderAnnotationsFHG(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        Shape clip = g2d.getClip();
        boolean screencs = false;
        for (int s = 0; s < 2; ++s) {
            Iterator iter = this.annotations.iterator();
            boolean bl = screencs = !screencs;
            while (iter.hasNext()) {
                Object[] loc;
                Object location;
                int y2;
                int x2;
                int y1;
                Object ann = iter.next();
                if (ann instanceof Font) {
                    Font font = (Font)ann;
                    g2d.setFont(font);
                    continue;
                }
                if (ann instanceof double[] && !screencs) {
                    double[] l = (double[])ann;
                    g2d.setClip(0, 0, this.axis.getSize(0), this.axis.getSize(1));
                    int x1 = (int)this.axis.getAxisCoordinateForValue(l[0], 0);
                    y1 = (int)this.axis.getAxisCoordinateForValue(l[1], 1);
                    x2 = (int)this.axis.getAxisCoordinateForValue(l[2], 0);
                    y2 = (int)this.axis.getAxisCoordinateForValue(l[3], 1);
                    g2d.drawLine(x1, y1, x2, y2);
                    continue;
                }
                if (ann instanceof Image) {
                    location = iter.next();
                    if (location instanceof double[] && !screencs) {
                        g2d.setClip(0, 0, this.axis.getSize(0), this.axis.getSize(1));
                        AffineTransform temp = g2d.getTransform();
                        g2d.transform(this.t);
                        double[] loc2 = (double[])location;
                        int x1 = (int)this.axis.getAxisCoordinateForValue(loc2[0], 0);
                        int y12 = (int)this.axis.getAxisCoordinateForValue(loc2[1], 1);
                        Image img = (Image)ann;
                        g2d.drawImage(img, x1, -y12, null);
                        g2d.setTransform(temp);
                        continue;
                    }
                    if (!(location instanceof int[]) || !screencs) continue;
                    g2d.setClip(clip);
                    int[] loc3 = (int[])location;
                    AffineTransform temp = g2d.getTransform();
                    g2d.setTransform(AffineTransform.getScaleInstance(1.0, 1.0));
                    Image img = (Image)ann;
                    g2d.drawImage(img, loc3[0], loc3[1], null);
                    g2d.setTransform(temp);
                    continue;
                }
                if (ann instanceof Color) {
                    g2d.setColor((Color)ann);
                    continue;
                }
                if (ann instanceof String) {
                    String[] lines;
                    location = iter.next();
                    if (location instanceof double[] && !screencs) {
                        g2d.setClip(0, 0, this.axis.getSize(0), this.axis.getSize(1));
                        AffineTransform temp = g2d.getTransform();
                        g2d.transform(this.t);
                        String str = (String)ann;
                        double[] loc4 = (double[])location;
                        int x = (int)this.axis.getAxisCoordinateForValue(loc4[0], 0);
                        int y = (int)this.axis.getAxisCoordinateForValue(loc4[1], 1);
                        lines = str.split("\\n");
                        int fh = g2d.getFontMetrics().getHeight();
                        for (int i = 0; i < lines.length; ++i) {
                            g2d.drawString(lines[i], x, -y + i * fh);
                        }
                        g2d.setTransform(temp);
                        continue;
                    }
                    if (!(location instanceof int[]) || !screencs) continue;
                    int[] loc5 = (int[])location;
                    AffineTransform temp = (AffineTransform)g2d.getTransform().clone();
                    g2d.transform(AffineTransform.getScaleInstance(1.0, -1.0));
                    String str = (String)ann;
                    int y = loc5[1] - this.yInset - this.axis.getSize(1);
                    int fh = g2d.getFontMetrics().getHeight();
                    lines = str.split("\\n");
                    for (int i = 0; i < lines.length; ++i) {
                        g2d.drawString(lines[i], loc5[0] - this.xInset, y + i * fh);
                    }
                    g2d.setTransform(temp);
                    continue;
                }
                if (ann instanceof double[] && !screencs) {
                    g2d.setClip(0, 0, this.axis.getSize(0), this.axis.getSize(1));
                    loc = (double[])ann;
                    int x1 = (int)this.axis.getAxisCoordinateForValue((double)loc[0], 0);
                    y1 = (int)this.axis.getAxisCoordinateForValue((double)loc[1], 1);
                    x2 = (int)this.axis.getAxisCoordinateForValue((double)loc[2], 0);
                    y2 = (int)this.axis.getAxisCoordinateForValue((double)loc[3], 1);
                    g2d.drawLine(x1, y1, x2, y2);
                    continue;
                }
                if (!(ann instanceof int[]) || !screencs) continue;
                g2d.setClip(clip);
                loc = (int[])ann;
                AffineTransform temp = g2d.getTransform();
                g2d.setTransform(AffineTransform.getScaleInstance(1.0, 1.0));
                g2d.drawLine(loc[0], loc[1], loc[2], loc[3]);
                g2d.setTransform(temp);
            }
        }
    }
}

