/*
 * Decompiled with CFR 0.152.
 */
package fi.stuk.visualization.polygonal;

import fi.stuk.visualization.polygonal.FrameBuffer;
import fi.stuk.visualization.polygonal.ScanConverter;
import fi.stuk.visualization.polygonal.Shader;
import fi.stuk.visualization.polygonal.util.PolyUtils;
import java.util.List;
import java.util.Vector;

public class RenderingPipeline {
    double[][] Tm = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    double[][] Tv = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    double[][] Tp = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    double[][] C = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    double[][] Td = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    double[][] tmp = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    double[] eye = new double[]{0.0, 0.0, 0.0, 0.0};
    double[][] tVerts;
    int NVERTS = 400;
    List lights;
    List globalData = new Vector();
    ScanConverter sc;
    Shader sh;
    List perVertexData;
    List vertices;
    List tvertices = new Vector();
    int numVerts;
    FrameBuffer fb;
    boolean stateIsDetermined = true;

    public RenderingPipeline() {
        this.Td = PolyUtils.getDeviceTransform(0, 0, 300, 300);
        this.tVerts = new double[this.NVERTS][4];
        for (int i = 0; i < this.NVERTS; ++i) {
            this.tVerts[i] = new double[4];
        }
    }

    public void setModelingTransform(double[][] Tm) {
        this.Tm = Tm;
    }

    public void setViewingTransform(double[][] Tv) {
        this.Tv = Tv;
        this.stateIsDetermined = false;
    }

    public void setProjectionTransform(double[][] Tp) {
        this.Tp = Tp;
        this.stateIsDetermined = false;
    }

    public void getProjectionTransform(double[][] trg) {
        PolyUtils.set(trg, this.Tp);
    }

    public void getViewingTransform(double[][] trg) {
        PolyUtils.set(trg, this.Tv);
    }

    public double[][] getProjectionTransform() {
        return this.Tp;
    }

    public double[][] getViewingTransform() {
        return this.Tv;
    }

    public List getGlobalData() {
        return this.globalData;
    }

    public void setLights(List lights) {
        this.lights = lights;
    }

    public void setVertices(List vertices) {
        this.vertices = vertices;
        this.numVerts = vertices.size();
    }

    public void setVertexData(List vertexdata) {
        this.perVertexData = vertexdata;
    }

    public void setScanConverter(ScanConverter sc) {
        this.sc = sc;
    }

    public ScanConverter getShaderBuffer() {
        return this.sc;
    }

    public void setShader(Shader shader) {
        this.sh = shader;
    }

    public Shader getShader() {
        return this.sh;
    }

    public void setFrameBuffer(FrameBuffer fb) {
        this.fb = fb;
    }

    public FrameBuffer getFrameBuffer() {
        return this.fb;
    }

    private void calculateCompositeTransform() {
        PolyUtils.matMult4(this.Tp, this.Tv, this.C);
    }

    public List getLights() {
        return this.lights;
    }

    public void render() {
        int i = 0;
        this.tvertices.clear();
        if (!this.stateIsDetermined) {
            this.calculateCompositeTransform();
            this.stateIsDetermined = true;
        }
        while (i < this.numVerts) {
            double[] vertex = (double[])this.vertices.get(i);
            double[] tVertex = this.tVerts[i];
            PolyUtils.matMult4(vertex, this.C, tVertex);
            tVertex[0] = tVertex[0] * (double)this.fb.w;
            tVertex[1] = tVertex[1] * (double)this.fb.h;
            tVertex[0] = tVertex[0] / tVertex[3];
            tVertex[1] = tVertex[1] / tVertex[3];
            this.tvertices.add(tVertex);
            if (tVertex[3] < 0.0) {
                return;
            }
            ++i;
        }
        this.sh.setFrameBuffer(this.fb);
        this.sc.setShader(this.sh);
        this.sc.scanConvert(this.tvertices, this.perVertexData);
    }
}

