/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.util.border.ShadowBorder;
import jas.util.xml.XMLNodeTraverser;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

class BorderNodeTraverser
extends XMLNodeTraverser {
    private Color color;
    private String type;

    BorderNodeTraverser() {
    }

    void traverse(Node node, JComponent jComponent) throws XMLNodeTraverser.BadXMLException {
        super.traverse(node);
        if (this.type.equals("Bevel In")) {
            jComponent.setBorder(BorderFactory.createLoweredBevelBorder());
        } else if (this.type.equals("Bevel Out")) {
            jComponent.setBorder(BorderFactory.createRaisedBevelBorder());
        } else if (this.type.equals("Etched")) {
            jComponent.setBorder(BorderFactory.createEtchedBorder());
        } else if (this.type.equals("Shadow")) {
            jComponent.setBorder(ShadowBorder.createShadowBorder());
        } else if (this.type.equals("Line")) {
            jComponent.setBorder(BorderFactory.createLineBorder(this.color));
        }
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("type")) {
            this.type = string2;
        } else if (string.equals("color")) {
            this.color = this.toColor(string2);
        } else {
            super.handleAttributeNode(attr, string, string2);
        }
    }
}

