/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.ExtendedStatistics;
import jas.hist.Fitter;
import jas.hist.FunctionValueUndefined;
import jas.hist.InvalidFunctionParameter;
import jas.util.DoubleWithError;
import java.text.NumberFormat;

public abstract class Fittable1DFunction
extends Basic1DFunction
implements ExtendedStatistics {
    private static final String chi2 = "\u03c7\u00b2";
    private Fitter m_fit;
    private boolean[] m_fitParms;
    private NumberFormat format = NumberFormat.getInstance();

    public abstract double valueAt(double var1, double[] var3) throws FunctionValueUndefined;

    public abstract void setFit(Fitter var1, double[] var2) throws InvalidFunctionParameter;

    public boolean[] getIncludeParametersInFit() {
        this.initIncludeParametersInFit(this.getParameterNames().length);
        return this.m_fitParms;
    }

    public void clearFitParams() {
        this.m_fitParms = null;
    }

    public void setIncludeParameterInFit(int n, boolean bl) {
        this.initIncludeParametersInFit(this.getParameterNames().length);
        this.m_fitParms[n] = bl;
        this.clearFit();
        this.setChanged();
    }

    protected void initIncludeParametersInFit(int n) {
        if (this.m_fitParms == null || this.m_fitParms.length != n) {
            this.m_fitParms = new boolean[n];
            for (int i = 0; i < this.m_fitParms.length; ++i) {
                this.m_fitParms[i] = true;
            }
        }
    }

    public double[] getDerivatives(double d, double[] dArray) throws FunctionValueUndefined {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = this.getParameterDeltas();
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i];
            double d3 = dArray3[i];
            dArray[i] = d2 + d3;
            double d4 = this.valueAt(d, dArray);
            dArray[i] = d2 - d3;
            dArray2[i] = (d4 - this.valueAt(d, dArray)) / (2.0 * d3);
            dArray[i] = d2;
        }
        return dArray2;
    }

    private double[] getParameterDeltas() {
        double[] dArray = (double[])this.getParameterValues().clone();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 1.0E-7;
        }
        return dArray;
    }

    public Fitter getFit() {
        return this.m_fit;
    }

    protected void setFit(Fitter fitter) {
        this.m_fit = fitter;
    }

    public void clearFit() {
        Fitter fitter = this.m_fit;
        if (fitter != null) {
            this.m_fit = null;
            fitter.dispose();
        }
    }

    protected void destroy() {
        this.clearFit();
        super.destroy();
    }

    public String[] getStatisticNames() {
        String[] stringArray = null;
        if (this.m_fit != null) {
            if (this.getParameterNames() != null) {
                stringArray = new String[this.getParameterNames().length + 1];
                for (int i = 0; i < this.getParameterNames().length; ++i) {
                    stringArray[i] = this.getParameterNames()[i];
                }
            } else {
                stringArray = new String[1];
            }
            stringArray[stringArray.length - 1] = chi2;
            return stringArray;
        }
        stringArray = super.getStatisticNames();
        return stringArray;
    }

    public double getStatistic(String string) {
        if (string.equals(chi2)) {
            return this.m_fit.getChiSquared();
        }
        return super.getStatistic(string);
    }

    public Object getExtendedStatistic(String string) {
        if (this.m_fit != null) {
            boolean[] blArray = this.getIncludeParametersInFit();
            int n = 0;
            for (int i = 0; i < blArray.length; ++i) {
                if (string.equals(this.getParameterNames()[i])) {
                    if (blArray[i]) {
                        return new DoubleWithError(this.getParameterValues()[i], this.m_fit.getParameterSigmas()[n]);
                    }
                    return this.format.format(this.getParameterValues()[i]) + " Fixed";
                }
                if (!blArray[i]) continue;
                ++n;
            }
        }
        return null;
    }
}

