/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.JASHist1DFunctionStyle;
import jas.hist.JASHistData;
import jas.hist.JASHistFunctionOverlay;
import jas.hist.JASHistStyle;
import jas.hist.SupportsFunctions;
import jas.hist.XMLPrintWriter;
import jas.plot.Overlay;
import jas.util.ColorConverter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Observable;

class JASHist1DFunctionData
extends JASHistData
implements Serializable {
    private double lowerBound = Double.NaN;
    private double upperBound = Double.NaN;
    private Basic1DFunction dataSource;
    private double xLow;
    private double xHigh;
    private double xIncrement;
    private transient Double hole;
    private JASHist1DFunctionStyle style;
    static final long serialVersionUID = -3529869583896718619L;

    JASHist1DFunctionData(DataManager dataManager, Basic1DFunction basic1DFunction) {
        super(dataManager);
        this.dataSource = basic1DFunction;
        this.style = new JASHist1DFunctionStyle();
        this.style.addObserver(this);
    }

    public void setStyle(JASHistStyle jASHistStyle) {
        if (!(jASHistStyle instanceof JASHist1DFunctionStyle)) {
            throw new IllegalArgumentException("Style is not subclass of JASHist1DFunctionStyle");
        }
        if (this.style != null) {
            this.style.deleteObserver(this);
        }
        this.style = (JASHist1DFunctionStyle)jASHistStyle;
        jASHistStyle.addObserver(this);
    }

    public void update(Observable observable, Object object) {
        if (observable == this.dataSource) {
            ((SupportsFunctions)((Object)this.parent)).update(this);
        } else if (observable == this.style) {
            ((SupportsFunctions)((Object)this.parent)).update(this);
        }
    }

    public void axisChanged() {
        ((SupportsFunctions)((Object)this.parent)).update(this);
    }

    public void setXBounds(double d, double d2) {
        this.lowerBound = d;
        this.upperBound = d2;
    }

    void setXRange(double d, double d2) {
        if (!Double.isNaN(this.lowerBound)) {
            double d3 = d = d < this.lowerBound ? this.lowerBound : d;
        }
        if (!Double.isNaN(this.upperBound)) {
            double d4 = d2 = d2 > this.upperBound ? this.upperBound : d2;
        }
        if (d > d2) {
            d = d2;
        }
        if (this.overlay instanceof JASHistFunctionOverlay) {
            ((JASHistFunctionOverlay)this.overlay).setXRange(d, d2);
        }
    }

    public String getTitle() {
        return this.dataSource.getTitle();
    }

    Overlay createOverlay() {
        return new JASHistFunctionOverlay(this, this.style);
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    void normalizationChanged(boolean bl) {
    }

    public void writeAsXML(XMLPrintWriter xMLPrintWriter, boolean bl) {
        xMLPrintWriter.setAttribute("axis", "y" + this.getYAxis());
        xMLPrintWriter.setAttribute("type", this.dataSource.getTitle());
        xMLPrintWriter.openTag("function1d");
        String[] stringArray = this.dataSource.getParameterNames();
        double[] dArray = this.dataSource.getParameterValues();
        for (int i = 0; i < stringArray.length; ++i) {
            xMLPrintWriter.setAttribute("name", stringArray[i]);
            xMLPrintWriter.setAttribute("value", dArray[i]);
            xMLPrintWriter.printTag("functionParam");
        }
        xMLPrintWriter.setAttribute("lineColor", ColorConverter.colorToString(this.style.getLineColor()));
        xMLPrintWriter.printTag("functionStyle1d");
        xMLPrintWriter.closeTag();
    }

    Basic1DFunction getFunction() {
        return this.dataSource;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.parent);
        objectOutputStream.writeInt(this.yAxisIndex);
        objectOutputStream.writeBoolean(this.isVisible);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.isVisible = false;
        this.parent = (DataManager)objectInputStream.readObject();
        this.yAxisIndex = objectInputStream.readInt();
        this.style.addObserver(this);
        if (objectInputStream.readBoolean()) {
            if (this.dataSource instanceof Observable) {
                this.dataSource.addObserver(this);
            }
            this.show(true);
        }
    }

    public void delete() {
        ((SupportsFunctions)((Object)this.parent)).removeFunction(this);
    }

    void destroy() {
        this.dataSource.destroy();
        this.dataSource.deleteObserver(this);
        this.style.deleteObserver(this);
        super.deleteNormalizationObserver();
    }
}

