/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.DataSource;
import jas.hist.HasSlices;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.ScatterPlotSource;
import jas.hist.test.TestScatterPlotSource;
import jas.hist.util.ScatterSliceAdapter;
import jas.hist.util.ScatterTwoDAdapter;
import jas.hist.util.SliceAdapter;
import jas.hist.util.SliceEvent;
import jas.hist.util.SliceListener;
import jas.hist.util.TwoDSliceAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SliceTest
extends JPanel
implements SliceListener {
    private final ScatterPlotSource source = new TestScatterPlotSource();
    private JASHist hist2;
    private JASHist hist1;
    private Hashtable hash = new Hashtable();

    SliceTest() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.hist1 = new JASHist();
        this.hist2 = new JASHist();
        jPanel.add(this.hist1);
        jPanel.add(this.hist2);
        this.add((Component)jPanel, "Center");
        this.add((Component)new ButtonPanel(), "South");
    }

    void setSliceData(Rebinnable1DHistogramData rebinnable1DHistogramData) {
        this.hist2.removeAllData();
        if (rebinnable1DHistogramData != null) {
            this.hist2.addData(rebinnable1DHistogramData).show(true);
        }
    }

    void setData(DataSource dataSource) {
        this.hist1.removeAllData();
        this.hist2.removeAllData();
        this.hash.clear();
        this.hist1.addData(dataSource).show(true);
        if (dataSource instanceof SliceAdapter) {
            ((SliceAdapter)((Object)dataSource)).addSliceListener(this);
        }
    }

    public void sliceAdded(SliceEvent sliceEvent) {
        HasSlices hasSlices = (HasSlices)sliceEvent.getSource();
        Rebinnable1DHistogramData rebinnable1DHistogramData = hasSlices.getSlice(sliceEvent.getIndex());
        JASHistData jASHistData = this.hist2.addData(rebinnable1DHistogramData);
        jASHistData.show(true);
        this.hash.put(rebinnable1DHistogramData, jASHistData);
    }

    public void sliceRemoved(SliceEvent sliceEvent) {
        HasSlices hasSlices = (HasSlices)sliceEvent.getSource();
        Rebinnable1DHistogramData rebinnable1DHistogramData = hasSlices.getSlice(sliceEvent.getIndex());
        JASHistData jASHistData = (JASHistData)this.hash.get(rebinnable1DHistogramData);
        jASHistData.show(false);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setContentPane(new SliceTest());
        jFrame.pack();
        jFrame.show();
    }

    class ButtonPanel
    extends JPanel
    implements ActionListener {
        private ButtonGroup g = new ButtonGroup();
        private JRadioButton b1 = new JRadioButton("Scatter Plot");
        private JRadioButton b2;
        private JRadioButton b3;

        ButtonPanel() {
            super(new FlowLayout());
            this.addButton(this.b1);
            this.b2 = new JRadioButton("Rebinnable 2D Plot");
            this.addButton(this.b2);
            this.b3 = new JRadioButton("NonRebinnable 2D Plot");
            this.addButton(this.b3);
        }

        private void addButton(JRadioButton jRadioButton) {
            this.add(jRadioButton);
            this.g.add(jRadioButton);
            jRadioButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.b1) {
                SliceTest.this.setData(new ScatterSliceAdapter(SliceTest.this.source));
            } else if (object == this.b2) {
                SliceTest.this.setData(new TwoDSliceAdapter(new ScatterTwoDAdapter(SliceTest.this.source)));
            } else if (object == this.b3) {
                SliceTest.this.setData(new TwoDSliceAdapter(new ScatterTwoDAdapter(this, SliceTest.this.source){
                    private final /* synthetic */ ButtonPanel this$1;
                    {
                        this.this$1 = buttonPanel;
                    }

                    public boolean isRebinnable() {
                        return false;
                    }
                }));
            }
        }
    }
}

