/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.util;

import jas.hist.Rebinnable2DHistogramData;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.hist.util.AbstractSlice;
import jas.hist.util.DefaultSliceParameters;
import jas.hist.util.ScatterTwoDAdapter;
import jas.hist.util.TwoDSliceAdapter;
import javax.swing.event.EventListenerList;

public class ScatterSliceAdapter
extends TwoDSliceAdapter {
    private EventListenerList listenerList = new EventListenerList();

    public ScatterSliceAdapter(Rebinnable2DHistogramData rebinnable2DHistogramData) {
        super(rebinnable2DHistogramData);
    }

    public ScatterSliceAdapter(ScatterPlotSource scatterPlotSource) {
        super(new ScatterTwoDAdapter(scatterPlotSource));
    }

    public int addSlice(double d, double d2, double d3, double d4, double d5) {
        if (this.scatter != null && this.scatter.hasScatterPlotData()) {
            int n = this.slices.size();
            String string = (d3 == Double.POSITIVE_INFINITY ? "Projection " : "Slice ") + n;
            this.slices.addElement(new Slice(string, d, d2, d3, d4, d5));
            this.fireSliceAdded(n);
            return n;
        }
        return super.addSlice(d, d2, d3, d4, d5);
    }

    private class Slice
    extends AbstractSlice {
        private double m_min;
        private double m_max;
        private boolean minMaxValid = false;

        Slice(String string, double d, double d2, double d3, double d4, double d5) {
            super(string, d3 == Double.POSITIVE_INFINITY);
            this.parm = new DefaultSliceParameters(this, d, d2, d3, d4, d5){
                private final /* synthetic */ Slice this$1;
                {
                    this.this$1 = slice;
                }

                protected void changed() {
                    this.this$1.sendUpdate();
                }
            };
        }

        public void sendUpdate() {
            this.minMaxValid = false;
            super.sendUpdate();
        }

        public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
            double[] dArray = new double[n];
            ScatterEnumeration scatterEnumeration = ScatterSliceAdapter.this.scatter.startEnumeration();
            double d3 = Math.sin(this.parm.phi);
            double d4 = Math.cos(this.parm.phi);
            double d5 = -this.parm.x * d3 + this.parm.y * d4;
            double d6 = this.parm.x * d4 + this.parm.y * d3;
            double[] dArray2 = new double[2];
            while (scatterEnumeration.getNextPoint(dArray2)) {
                int n2;
                double d7;
                double d8 = dArray2[0] * d4 + dArray2[1] * d3;
                if (!this.projection && (Math.abs(d8 - d6) > this.parm.width || Math.abs((d7 = -dArray2[0] * d3 + dArray2[1] * d4) - d5) > this.parm.height) || d8 < d || (n2 = (int)((d8 - d) * (double)n / (d2 - d))) >= n) continue;
                int n3 = n2;
                dArray[n3] = dArray[n3] + 1.0;
            }
            double[][] dArrayArray = new double[][]{dArray};
            return dArrayArray;
        }

        private void calcMinMax() {
            this.minMaxValid = true;
            if (this.projection) {
                ScatterEnumeration scatterEnumeration = ScatterSliceAdapter.this.scatter.startEnumeration();
                double d = Math.sin(this.parm.phi);
                double d2 = Math.cos(this.parm.phi);
                double[] dArray = new double[2];
                double d3 = 0.0;
                double d4 = 0.0;
                boolean bl = true;
                while (scatterEnumeration.getNextPoint(dArray)) {
                    double d5 = dArray[0] * d2 + dArray[1] * d;
                    if (bl) {
                        d3 = d4 = d5;
                    } else {
                        d3 = Math.min(d3, d5);
                        d4 = Math.max(d4, d5);
                    }
                    bl = false;
                }
                this.m_min = d3;
                this.m_max = d4;
            } else {
                double d = Math.sin(this.parm.phi);
                double d6 = Math.cos(this.parm.phi);
                double d7 = this.parm.x * d6 + this.parm.y * d;
                this.m_min = d7 - this.parm.width;
                this.m_max = d7 + this.parm.width;
            }
        }

        public double getMin() {
            if (!this.minMaxValid) {
                this.calcMinMax();
            }
            return this.m_min;
        }

        public double getMax() {
            if (!this.minMaxValid) {
                this.calcMinMax();
            }
            return this.m_max;
        }

        public int getBins() {
            return 40;
        }

        public boolean isRebinnable() {
            return true;
        }
    }
}

