/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentPrintWriter
extends PrintWriter {
    private int indent = 0;
    private boolean indented = false;
    private String indentString;

    public IndentPrintWriter(Writer writer) {
        super(writer);
    }

    public void println(String string) {
        if (!this.indented) {
            this.doIndent();
        }
        super.println(string);
        this.indented = false;
    }

    public void print(String string) {
        if (!this.indented) {
            this.doIndent();
        }
        super.print(string);
    }

    public void println() {
        super.println();
        this.indented = false;
    }

    private void doIndent() {
        for (int i = 0; i < this.indent; ++i) {
            super.print(this.indentString);
        }
        this.indented = true;
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        --this.indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String string) {
        this.indentString = string;
    }
}

