/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Application;
import jas.util.Finishable;
import jas.util.HasHelpPage;
import jas.util.HasNextPages;
import jas.util.JASWizardPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.EtchedBorder;

public class JASWizard
extends JDialog
implements ActionListener {
    private final JFrame m_frame;
    private final Cursor m_default = Cursor.getDefaultCursor();
    private final Cursor m_wait = new Cursor(3);
    private boolean m_currentPageHasAmbiguousDefault;
    private final JRootPane m_rootPane;
    private final Container m_contentPane;
    private final JPanel m_wizardPagePanel;
    private final JASWizardPage m_firstPage;
    private JASWizardPage m_currentPage;
    private final JButton m_cancel;
    private final JButton m_help;
    private final JButton m_prev;
    private final JButton m_next;
    private final JButton m_finish;
    private final CardLayout m_layout;

    public JASWizard(JFrame jFrame, String string, JASWizardPage jASWizardPage) {
        super(jFrame, string, true);
        this.m_frame = jFrame;
        this.m_contentPane = this.getContentPane();
        this.m_contentPane.setLayout(new BorderLayout());
        this.m_rootPane = this.getRootPane();
        this.m_layout = new CardLayout();
        this.m_wizardPagePanel = new JPanel(this.m_layout);
        jASWizardPage.addTo(this.m_wizardPagePanel, this, null);
        JPanel jPanel = new JPanel(new FlowLayout());
        this.m_cancel = new JButton("Cancel");
        jPanel.add(this.m_cancel);
        this.m_cancel.setMnemonic('C');
        this.m_help = new JButton("Help");
        jPanel.add(this.m_help);
        this.m_help.setMnemonic('H');
        this.m_prev = new JButton("<< Previous");
        jPanel.add(this.m_prev);
        this.m_prev.setMnemonic('P');
        this.m_next = new JButton("Next >>");
        jPanel.add(this.m_next);
        this.m_next.setMnemonic('N');
        this.m_finish = new JButton("Finish");
        jPanel.add(this.m_finish);
        this.m_finish.setMnemonic('F');
        this.m_wizardPagePanel.setBorder(new EtchedBorder());
        this.m_contentPane.add("Center", this.m_wizardPagePanel);
        this.m_contentPane.add("South", jPanel);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = jFrame.getSize();
        Point point = jFrame.getLocation();
        point.translate((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setLocation(point);
        this.m_layout.first(this.m_wizardPagePanel);
        this.m_currentPage = this.m_firstPage = jASWizardPage;
        this.m_firstPage.doEnable();
        this.m_cancel.addActionListener(this);
        this.m_help.addActionListener(this);
        this.m_prev.addActionListener(this);
        this.m_next.addActionListener(this);
        this.m_finish.addActionListener(this);
        this.m_currentPageHasAmbiguousDefault = this.m_currentPage.isFinishable() && this.m_currentPage.hasNextPages();
        this.m_help.setEnabled(jASWizardPage instanceof HasHelpPage);
        this.setResizable(false);
        this.enableEvents(64L);
        jASWizardPage.beforeShowing();
        Application application = Application.getApplication();
        if (application != null) {
            application.modalDialogOpening(this);
        }
        this.show();
        if (application != null) {
            application.modalDialogClosing(this);
        }
    }

    void setNextEnabled(boolean bl) {
        this.m_next.setEnabled(bl && this.m_currentPage.hasNextPages());
    }

    void setFinishEnabled(boolean bl) {
        this.m_finish.setEnabled(bl && this.m_currentPage.isFinishable());
    }

    void doPrevEnabled() {
        this.m_prev.setEnabled(this.m_currentPage.getPrev() != null);
    }

    private void onHelp() {
        this.setToWaitCursor();
        HasHelpPage hasHelpPage = (HasHelpPage)((Object)this.m_currentPage);
        Application.getApplication().showHelpTopic(hasHelpPage.getHelpTopic(), this);
        this.setToDefaultCursor();
    }

    private void setToCurrentPage(JASWizardPage jASWizardPage) {
        this.m_currentPage = jASWizardPage;
        this.m_currentPageHasAmbiguousDefault = this.m_currentPage.isFinishable() && this.m_currentPage.hasNextPages();
        jASWizardPage.doEnable();
        if (!this.m_currentPageHasAmbiguousDefault) {
            this.setDefaultButton();
        }
        this.m_help.setEnabled(jASWizardPage instanceof HasHelpPage);
        jASWizardPage.beforeShowing();
        this.m_layout.show(this.m_wizardPagePanel, jASWizardPage.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPrev() {
        this.setToWaitCursor();
        try {
            this.setToCurrentPage(this.m_currentPage.getPrev());
        }
        catch (Throwable throwable) {
            this.handleError("Error during wizard processing", throwable);
        }
        finally {
            this.setToDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNext() {
        this.setToWaitCursor();
        try {
            JASWizardPage jASWizardPage = ((HasNextPages)((Object)this.m_currentPage)).getNext();
            if (jASWizardPage != null) {
                if (!this.m_wizardPagePanel.isAncestorOf(jASWizardPage)) {
                    jASWizardPage.addTo(this.m_wizardPagePanel, this, this.m_currentPage);
                    jASWizardPage.invalidate();
                    this.validate();
                }
                this.setToCurrentPage(jASWizardPage);
            }
        }
        catch (Throwable throwable) {
            this.handleError("Error during wizard processing", throwable);
        }
        finally {
            this.setToDefaultCursor();
        }
    }

    void setDefaultButton() {
        if (this.m_currentPageHasAmbiguousDefault && this.m_next.isEnabled()) {
            this.m_rootPane.setDefaultButton(this.m_next);
        } else if (this.m_currentPageHasAmbiguousDefault && this.m_finish.isEnabled()) {
            this.m_rootPane.setDefaultButton(this.m_finish);
        } else {
            this.m_rootPane.setDefaultButton(this.m_currentPage.hasNextPages() ? this.m_next : this.m_finish);
        }
    }

    public void dispose() {
        this.m_firstPage.clear();
        JASWizardPage.pageNumber = 0;
        if (this.getCursor() == this.m_wait) {
            this.m_frame.setCursor(this.m_wait);
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinish() {
        this.setToWaitCursor();
        try {
            ((Finishable)((Object)this.m_currentPage)).onFinish();
        }
        catch (Throwable throwable) {
            this.handleError("Error during wizard processing", throwable);
        }
        finally {
            this.setToDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCancel() {
        this.setToWaitCursor();
        try {
            this.m_firstPage.doCancel();
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleError("Error during wizard processing", throwable);
        }
        finally {
            this.setToDefaultCursor();
        }
    }

    void setToWaitCursor() {
        this.setCursor(this.m_wait);
    }

    void setToDefaultCursor() {
        this.setCursor(this.m_default);
        this.m_frame.setCursor(this.m_default);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_cancel) {
            this.onCancel();
        } else if (object == this.m_help) {
            this.onHelp();
        } else if (object == this.m_prev) {
            this.onPrev();
        } else if (object == this.m_next) {
            this.onNext();
        } else if (object == this.m_finish) {
            this.onFinish();
        }
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 201) {
            this.onCancel();
        } else if (n == 205) {
            this.setDefaultButton();
        }
    }

    protected void handleError(String string, Throwable throwable) {
        Application application = Application.getApplication();
        if (application != null) {
            application.error("Error during wizard processing", throwable);
        } else {
            throwable.printStackTrace();
        }
    }
}

