/*
 * Decompiled with CFR 0.152.
 */
package jas.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PnutsLayout
implements LayoutManager2,
Serializable {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int V_FIT = 16;
    public static final int H_FIT = 32;
    static final int V_FILL = 3;
    static final int H_FILL = 12;
    static Integer[] integer;
    static int[] zero;
    Hashtable alignmentTable = new Hashtable();
    Hashtable spanTable = new Hashtable();
    Hashtable padTable = new Hashtable();
    Hashtable iPadTable = new Hashtable();
    private int[] widths;
    private int[] heights;
    private int[] hfit;
    private int[] vfit;
    private int hfits;
    private int vfits;
    int[] grid_x;
    int[] grid_y;
    int[] pos_x = new int[8];
    int[] pos_y = new int[8];
    private Dimension psize;
    private boolean valid = false;
    protected int align = 0;
    protected int padx;
    protected int pady;
    protected int ipadx;
    protected int ipady;
    protected int cols;
    protected int rows;
    protected boolean xfix;
    protected boolean yfix;

    static Integer getInteger(int n) {
        if (n < 32) {
            return integer[n];
        }
        return new Integer(n);
    }

    public PnutsLayout() {
        this(1);
    }

    public PnutsLayout(int n) {
        this(n, 0, 0);
    }

    public PnutsLayout(int n, int n2, int n3) {
        this.cols = n;
        this.padx = n2;
        this.pady = n3;
    }

    public PnutsLayout(String string) {
        Hashtable hashtable = PnutsLayout.str2table(string);
        this.cols = PnutsLayout.getInt(hashtable.get("cols"), 1);
        this.padx = PnutsLayout.getInt(hashtable.get("padx"), 0);
        this.pady = PnutsLayout.getInt(hashtable.get("pady"), 0);
        this.ipadx = PnutsLayout.getInt(hashtable.get("ipadx"), 0);
        this.ipady = PnutsLayout.getInt(hashtable.get("ipady"), 0);
        int n = 0;
        int n2 = 0;
        String string2 = (String)hashtable.get("halign");
        if (string2 != null) {
            if ("left".equalsIgnoreCase(string2)) {
                n |= 4;
            } else if ("right".equalsIgnoreCase(string2)) {
                n |= 8;
            } else if ("center".equalsIgnoreCase(string2)) {
                n |= 0;
            } else if ("fill".equalsIgnoreCase(string2)) {
                n |= 8;
                n |= 4;
            }
        } else {
            n = this.align & 0x2C;
        }
        String string3 = (String)hashtable.get("valign");
        if (string3 != null) {
            if ("top".equalsIgnoreCase(string3)) {
                n2 |= 1;
            } else if ("bottom".equalsIgnoreCase(string3)) {
                n2 |= 2;
            } else if ("center".equalsIgnoreCase(string3)) {
                n2 |= 0;
            } else if ("fill".equalsIgnoreCase(string3)) {
                n2 |= 1;
                n2 |= 2;
            }
        } else {
            n2 = this.align & 0x13;
        }
        String string4 = (String)hashtable.get("expand");
        if (string4 instanceof String) {
            if ("x".equalsIgnoreCase(string4)) {
                n |= 0x20;
            } else if ("y".equalsIgnoreCase(string4)) {
                n2 |= 0x10;
            } else if ("xy".equalsIgnoreCase(string4)) {
                n |= 0x20;
                n2 |= 0x10;
            }
        }
        this.align = n | n2;
        String string5 = (String)hashtable.get("uniform");
        if ("x".equals(string5)) {
            this.xfix = true;
        } else if ("y".equals(string5)) {
            this.yfix = true;
        } else if ("xy".equals(string5)) {
            this.xfix = true;
            this.yfix = true;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof Hashtable) {
            this.setConstraints(component, (Hashtable)object);
        } else if (object instanceof String) {
            this.setConstraints(component, (String)object);
        }
    }

    public void setConstraints(Component component, String string) {
        Object object;
        String string2;
        int n = this.align & 0x2C;
        int n2 = this.align & 0x13;
        Hashtable hashtable = PnutsLayout.str2table(string);
        Object v = hashtable.get("expand");
        if (v instanceof String) {
            string2 = (String)v;
            if ("x".equalsIgnoreCase(string2)) {
                n |= 0x20;
            } else if ("y".equalsIgnoreCase(string2)) {
                n2 |= 0x10;
            } else if ("xy".equalsIgnoreCase(string2)) {
                n |= 0x20;
                n2 |= 0x10;
            }
        }
        if ((string2 = hashtable.get("halign")) instanceof String) {
            n &= 0xFFFFFFF3;
            object = string2;
            if ("left".equalsIgnoreCase((String)object)) {
                n |= 4;
            } else if ("right".equalsIgnoreCase((String)object)) {
                n |= 8;
            } else if ("center".equalsIgnoreCase((String)object)) {
                n |= 0;
            } else if ("fill".equalsIgnoreCase((String)object)) {
                n |= 8;
                n |= 4;
            }
        }
        if ((object = hashtable.get("valign")) instanceof String) {
            n2 &= 0xFFFFFFFC;
            String string3 = (String)object;
            if ("top".equalsIgnoreCase(string3)) {
                n2 |= 1;
            } else if ("bottom".equalsIgnoreCase(string3)) {
                n2 |= 2;
            } else if ("center".equalsIgnoreCase(string3)) {
                n2 |= 0;
            } else if ("fill".equalsIgnoreCase(string3)) {
                n2 |= 1;
                n2 |= 2;
            }
        }
        hashtable.put("valign", PnutsLayout.getInteger(n2));
        hashtable.put("halign", PnutsLayout.getInteger(n));
        this.setConstraints(component, hashtable);
    }

    static int getInt(Object object, int n) {
        if (object == null) {
            return n;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return Integer.parseInt((String)object);
    }

    public void setConstraints(Component component, Hashtable hashtable) {
        int n = PnutsLayout.getInt(hashtable.get("halign"), this.align & 0xC);
        int n2 = PnutsLayout.getInt(hashtable.get("valign"), this.align & 3);
        this.alignmentTable.put(component, PnutsLayout.getInteger(n | n2));
        int n3 = PnutsLayout.getInt(hashtable.get("colspan"), 1);
        if (n3 <= this.cols) {
            this.spanTable.put(component, new Object[]{PnutsLayout.getInteger(n3), PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("rowspan"), 1))});
        }
        this.padTable.put(component, new Object[]{PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("padx"), this.padx)), PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("pady"), this.pady))});
        this.iPadTable.put(component, new Object[]{PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("ipadx"), this.ipadx)), PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("ipady"), this.ipady))});
    }

    public String getConstraintString(Component component) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string;
        String string2;
        Hashtable hashtable = this.getConstraints(component);
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = (String)hashtable.get("halign");
        if (string3 != null) {
            stringBuffer.append("halign = " + string3);
        }
        if ((string2 = (String)hashtable.get("valign")) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("valign = " + string2);
        }
        if ((string = (String)hashtable.get("expand")) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("expand = " + string);
        }
        if ((n6 = ((Integer)hashtable.get("padx")).intValue()) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("padx = " + n6);
        }
        if ((n5 = ((Integer)hashtable.get("pady")).intValue()) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("pady = " + n5);
        }
        if ((n4 = ((Integer)hashtable.get("ipadx")).intValue()) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("ipadx = " + n4);
        }
        if ((n3 = ((Integer)hashtable.get("ipady")).intValue()) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("ipady = " + n3);
        }
        if ((n2 = ((Integer)hashtable.get("colspan")).intValue()) > 1) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("colspan = " + n2);
        }
        if ((n = ((Integer)hashtable.get("rowspan")).intValue()) > 1) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("rowspan = " + n);
        }
        return stringBuffer.toString();
    }

    public Hashtable getConstraints(Component component) {
        Object object;
        Object object2;
        Object object3;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Object v = this.alignmentTable.get(component);
        int n = this.align;
        if (v != null) {
            n = (Integer)v;
            object3 = "center";
            object2 = "center";
            switch (n & 0xC) {
                case 4: {
                    object3 = "left";
                    break;
                }
                case 8: {
                    object3 = "right";
                    break;
                }
                case 12: {
                    object3 = "fill";
                }
            }
            switch (n & 3) {
                case 1: {
                    object2 = "top";
                    break;
                }
                case 2: {
                    object2 = "bottom";
                    break;
                }
                case 3: {
                    object2 = "fill";
                }
            }
            if (!"center".equals(object3)) {
                hashtable.put("halign", object3);
            }
            if (!"center".equals(object2)) {
                hashtable.put("valign", object2);
            }
            object = "";
            if ((n & 0x20) == 32) {
                object = (String)object + "x";
            }
            if ((n & 0x10) == 16) {
                object = (String)object + "y";
            }
            if (((String)object).length() > 0) {
                hashtable.put("expand", object);
            }
        }
        if ((object3 = (Object[])this.padTable.get(component)) != null) {
            hashtable.put("padx", object3[0]);
            hashtable.put("pady", object3[1]);
        }
        if ((object2 = (Object[])this.iPadTable.get(component)) != null) {
            hashtable.put("ipadx", object2[0]);
            hashtable.put("ipady", object2[1]);
        }
        if ((object = (Object[])this.spanTable.get(component)) != null) {
            hashtable.put("colspan", object[0]);
            hashtable.put("rowspan", object[1]);
        }
        return hashtable;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension maximumLayoutSize(Container container) {
        return container.getMaximumSize();
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
        this.valid = false;
    }

    public void setCols(int n) {
        Enumeration enumeration = this.spanTable.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            int n2 = (Integer)objectArray[0];
            if (n2 <= n) continue;
            return;
        }
        this.cols = n;
        this.valid = false;
    }

    public void setUniform(boolean bl, boolean bl2) {
        this.xfix = bl;
        this.yfix = bl2;
        this.valid = false;
    }

    public boolean[] getUniform() {
        return new boolean[]{this.xfix, this.yfix};
    }

    public void setColspan(Component component, int n) {
        Object[] objectArray = (Object[])this.spanTable.get(component);
        if (objectArray != null) {
            objectArray[0] = PnutsLayout.getInteger(n);
            this.spanTable.put(component, objectArray);
        } else {
            this.spanTable.put(component, new Object[]{PnutsLayout.getInteger(n), PnutsLayout.getInteger(1)});
        }
        this.invalidateLayout(component.getParent());
    }

    public int getColspan(Component component) {
        Object[] objectArray = (Object[])this.spanTable.get(component);
        if (objectArray == null || objectArray.length < 2) {
            return 1;
        }
        return (Integer)objectArray[0];
    }

    public void setRowspan(Component component, int n) {
        Object[] objectArray = (Object[])this.spanTable.get(component);
        if (objectArray != null) {
            objectArray[1] = PnutsLayout.getInteger(n);
            this.spanTable.put(component, objectArray);
        } else {
            this.spanTable.put(component, new Object[]{PnutsLayout.getInteger(1), PnutsLayout.getInteger(n)});
        }
        this.invalidateLayout(component.getParent());
    }

    public int getRowspan(Component component) {
        Object[] objectArray = (Object[])this.spanTable.get(component);
        if (objectArray == null || objectArray.length < 2) {
            return 1;
        }
        return (Integer)objectArray[1];
    }

    public void setHAlign(Component component, String string) {
        int n = 0;
        n = "left".equalsIgnoreCase(string) ? 4 : ("right".equalsIgnoreCase(string) ? 8 : ("fill".equalsIgnoreCase(string) ? 12 : 0));
        this.alignmentTable.put(component, PnutsLayout.getInteger(n));
        this.invalidateLayout(component.getParent());
    }

    public void setVAlign(Component component, String string) {
        int n = 0;
        n = "left".equalsIgnoreCase(string) ? 1 : ("bottom".equalsIgnoreCase(string) ? 2 : ("fill".equalsIgnoreCase(string) ? 3 : 0));
        this.alignmentTable.put(component, PnutsLayout.getInteger(n));
        this.invalidateLayout(component.getParent());
    }

    public String getHAlign(Component component) {
        Integer n = (Integer)this.alignmentTable.get(component);
        int n2 = this.align;
        if (n != null) {
            n2 = n;
        }
        if ((n2 & 0xC) == 12) {
            return "fill";
        }
        if ((n2 & 4) == 4) {
            return "left";
        }
        if ((n2 & 8) == 8) {
            return "right";
        }
        return "center";
    }

    public String getVAlign(Component component) {
        Integer n = (Integer)this.alignmentTable.get(component);
        int n2 = this.align;
        if (n != null) {
            n2 = n;
        }
        if ((n2 & 3) == 3) {
            return "fill";
        }
        if ((n2 & 1) == 1) {
            return "top";
        }
        if ((n2 & 2) == 2) {
            return "bottom";
        }
        return "center";
    }

    public void setExpand(Component component, String string) {
        Integer n = (Integer)this.alignmentTable.get(component);
        int n2 = this.align;
        if (n != null) {
            n2 = n;
        }
        if ("x".equalsIgnoreCase(string)) {
            n2 |= 0x20;
        } else if ("y".equalsIgnoreCase(string)) {
            n2 |= 0x10;
        } else if ("xy".equalsIgnoreCase(string)) {
            n2 |= 0x20;
            n2 |= 0x10;
        }
        this.alignmentTable.put(component, PnutsLayout.getInteger(n2));
        this.invalidateLayout(component.getParent());
    }

    public String getExpand(Component component) {
        Integer n = (Integer)this.alignmentTable.get(component);
        int n2 = this.align;
        if (n != null) {
            n2 = n;
        }
        if ((n2 & 0x30) == 48) {
            return "xy";
        }
        if ((n2 & 0x20) == 32) {
            return "x";
        }
        if ((n2 & 0x10) == 16) {
            return "y";
        }
        return "";
    }

    public void setPadding(Component component, int n, int n2) {
        this.padTable.put(component, new Object[]{PnutsLayout.getInteger(n), PnutsLayout.getInteger(n2)});
        this.invalidateLayout(component.getParent());
    }

    public int getPadX(Component component) {
        Object[] objectArray = (Object[])this.padTable.get(component);
        if (objectArray != null) {
            return (Integer)objectArray[0];
        }
        return 0;
    }

    public int getPadY(Component component) {
        Object[] objectArray = (Object[])this.padTable.get(component);
        if (objectArray != null) {
            return (Integer)objectArray[1];
        }
        return 0;
    }

    public void setIPadding(Component component, int n, int n2) {
        this.iPadTable.put(component, new Object[]{PnutsLayout.getInteger(n), PnutsLayout.getInteger(n2)});
        this.invalidateLayout(component.getParent());
    }

    public int getIPadX(Component component) {
        Object[] objectArray = (Object[])this.iPadTable.get(component);
        if (objectArray != null) {
            return (Integer)objectArray[0];
        }
        return 0;
    }

    public int getIPadY(Component component) {
        Object[] objectArray = (Object[])this.iPadTable.get(component);
        if (objectArray != null) {
            return (Integer)objectArray[1];
        }
        return 0;
    }

    void clear(int[] nArray, int n) {
        int n2;
        for (n2 = 0; n2 <= n - zero.length; n2 += zero.length) {
            System.arraycopy(zero, 0, nArray, n2, zero.length);
        }
        System.arraycopy(zero, 0, nArray, n2, n - n2);
    }

    void bindContainer(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.valid) {
            return;
        }
        BitSet[] bitSetArray = new BitSet[this.cols];
        for (n5 = 0; n5 < this.cols; ++n5) {
            bitSetArray[n5] = new BitSet();
        }
        n5 = container.getComponentCount();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.pos_x.length < n5) {
            this.pos_x = new int[n5 * 2];
        }
        if (this.pos_y.length < n5) {
            this.pos_y = new int[n5 * 2];
        }
        this.clear(this.pos_x, n5);
        this.clear(this.pos_y, n5);
        for (n4 = 0; n4 < n5; ++n4) {
            Component component = container.getComponent(n4);
            Object[] objectArray = (Object[])this.spanTable.get(component);
            n3 = 1;
            n2 = 1;
            if (objectArray != null) {
                n3 = (Integer)objectArray[0];
                n2 = (Integer)objectArray[1];
            }
            while (!this.fit(n7, n6, n3, n2, bitSetArray)) {
                if (++n7 < this.cols) continue;
                n7 = 0;
                ++n6;
            }
            this.pos_y[n4] = n6;
            this.pos_x[n4] = n7;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    bitSetArray[n7 + i].set(n6 + j);
                }
            }
            if (n8 < n6 + n2) {
                n8 = n6 + n2;
            }
            if (++n7 < this.cols) continue;
            n7 = 0;
            ++n6;
        }
        this.rows = n8;
        this.grid_x = new int[this.cols + 1];
        this.grid_y = new int[this.rows + 1];
        this.widths = new int[this.cols];
        this.heights = new int[this.rows];
        this.vfit = new int[this.rows];
        this.hfit = new int[this.cols];
        n4 = 0;
        int n9 = 0;
        n3 = 0;
        n2 = 0;
        for (n = 0; n < n5; ++n) {
            int n10;
            int n11;
            Component component = container.getComponent(n);
            Dimension dimension = component.getPreferredSize();
            int n12 = dimension.width;
            int n13 = dimension.height;
            Object[] objectArray = (Object[])this.iPadTable.get(component);
            if (objectArray != null) {
                n12 = dimension.width + (Integer)objectArray[0];
                n13 = dimension.height + (Integer)objectArray[1];
            }
            Object[] objectArray2 = (Object[])this.padTable.get(component);
            int n14 = this.padx;
            int n15 = this.pady;
            if (objectArray2 != null) {
                n14 = (Integer)objectArray2[0];
                n15 = (Integer)objectArray2[1];
            }
            n2 = this.pos_y[n];
            n3 = this.pos_x[n];
            int n16 = 1;
            int n17 = 1;
            Object[] objectArray3 = (Object[])this.spanTable.get(component);
            if (objectArray3 != null) {
                n16 = (Integer)objectArray3[0];
                n17 = (Integer)objectArray3[1];
            }
            int n18 = 0;
            for (n11 = 0; n11 < n16; ++n11) {
                n18 += this.widths[n3 + n11];
            }
            if (n18 < n12 + n14 * 2) {
                for (n11 = 0; n11 < n16; ++n11) {
                    int n19 = n3 + n11;
                    this.widths[n19] = this.widths[n19] + (n12 + n14 * 2 - n18) / n16;
                    if (!this.xfix || n4 >= this.widths[n3 + n11]) continue;
                    n4 = this.widths[n3 + n11];
                }
            }
            if (this.heights[n2] < (n13 + n15 * 2) / n17) {
                this.heights[n2] = (n13 + n15 * 2) / n17;
                if (this.yfix && n9 < this.heights[n2]) {
                    n9 = this.heights[n2];
                }
            }
            Object v = this.alignmentTable.get(component);
            int n20 = this.align;
            if (v != null && v instanceof Integer) {
                n20 = (Integer)v;
            }
            if ((n20 & 0x20) != 0) {
                for (n10 = 0; n10 < n16; ++n10) {
                    int n21 = n3 + n10;
                    this.hfit[n21] = this.hfit[n21] | 1;
                }
            }
            if ((n20 & 0x10) != 0) {
                for (n10 = 0; n10 < n17; ++n10) {
                    int n22 = n2 + n10;
                    this.vfit[n22] = this.vfit[n22] | 1;
                }
            }
            if ((n3 += n16) < this.cols) continue;
            n3 = 0;
            ++n2;
        }
        if (this.xfix) {
            for (n = 0; n < this.cols; ++n) {
                this.widths[n] = n4;
            }
        }
        if (this.yfix) {
            for (n = 0; n < this.rows; ++n) {
                this.heights[n] = n9;
            }
        }
        n = 0;
        n3 = 0;
        for (n2 = 0; n2 < this.cols; ++n2) {
            n += this.widths[n2];
        }
        for (n2 = 0; n2 < this.rows; ++n2) {
            n3 += this.heights[n2];
        }
        this.hfits = 0;
        for (n2 = 0; n2 < this.hfit.length; ++n2) {
            if ((this.hfit[n2] & 1) == 0) continue;
            ++this.hfits;
        }
        this.vfits = 0;
        for (n2 = 0; n2 < this.vfit.length; ++n2) {
            if ((this.vfit[n2] & 1) == 0) continue;
            ++this.vfits;
        }
        Insets insets = container.getInsets();
        this.psize = new Dimension(n += insets.left + insets.right + this.padx * this.cols, n3 += insets.top + insets.bottom + this.pady * this.rows);
        this.valid = true;
    }

    public Dimension preferredLayoutSize(Container container) {
        this.bindContainer(container);
        return this.psize;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        Insets insets = container.getInsets();
        int n3 = container.getComponentCount();
        this.bindContainer(container);
        int n4 = container.getSize().width;
        int n5 = container.getSize().height;
        int n6 = this.psize.width;
        int n7 = this.psize.height;
        int n8 = 0;
        int n9 = 0;
        if (this.hfits > 0) {
            n8 = (n4 - n6) / this.hfits;
        }
        if (this.vfits > 0) {
            n9 = (n5 - n7) / this.vfits;
        }
        int n10 = insets.top;
        this.grid_x[0] = n2 = insets.left;
        for (n = 1; n <= this.cols; ++n) {
            this.grid_x[n] = this.grid_x[n - 1] + this.widths[n - 1] + this.padx;
            if ((this.hfit[n - 1] & 1) == 0) continue;
            int n11 = n;
            this.grid_x[n11] = this.grid_x[n11] + n8;
        }
        this.grid_y[0] = n10;
        for (n = 1; n <= this.rows; ++n) {
            this.grid_y[n] = this.grid_y[n - 1] + this.heights[n - 1] + this.pady;
            if ((this.vfit[n - 1] & 1) == 0) continue;
            int n12 = n;
            this.grid_y[n12] = this.grid_y[n12] + n9;
        }
        int n13 = 0;
        int n14 = 0;
        for (n = 0; n < n3; ++n) {
            int n15;
            int n16;
            Component component = container.getComponent(n);
            Dimension dimension = component.getPreferredSize();
            int n17 = dimension.width;
            int n18 = dimension.height;
            Object[] objectArray = (Object[])this.iPadTable.get(component);
            if (objectArray != null) {
                n17 = dimension.width + (Integer)objectArray[0];
                n18 = dimension.height + (Integer)objectArray[1];
            }
            n14 = this.pos_y[n];
            n13 = this.pos_x[n];
            int n19 = 1;
            int n20 = 1;
            Object[] objectArray2 = (Object[])this.spanTable.get(component);
            if (objectArray2 != null) {
                n19 = (Integer)objectArray2[0];
                n20 = (Integer)objectArray2[1];
            }
            int n21 = this.align;
            Object v = this.alignmentTable.get(component);
            if (v != null && v instanceof Integer) {
                n21 = (Integer)v;
            }
            int n22 = n17;
            int n23 = n18;
            Object[] objectArray3 = (Object[])this.padTable.get(component);
            int n24 = this.padx;
            int n25 = this.pady;
            if (objectArray3 != null) {
                n24 = (Integer)objectArray3[0];
                n25 = (Integer)objectArray3[1];
            }
            if ((n21 & 4) != 0) {
                n16 = this.grid_x[n13] + n24;
                if ((n21 & 8) != 0) {
                    n22 = this.grid_x[n13 + n19] - this.grid_x[n13] - n24 * 2;
                }
            } else {
                n16 = (n21 & 8) != 0 ? this.grid_x[n13 + n19] - n22 - n24 : (this.grid_x[n13] + this.grid_x[n13 + n19] - n22) / 2;
            }
            if ((n21 & 1) != 0) {
                n15 = this.grid_y[n14] + n25;
                if ((n21 & 2) != 0) {
                    n23 = this.grid_y[n14 + n20] - this.grid_y[n14] - n25 * 2;
                }
            } else {
                n15 = (n21 & 2) != 0 ? this.grid_y[n14 + n20] - n23 - n25 : (this.grid_y[n14] + this.grid_y[n14 + n20] - n23) / 2;
            }
            component.setBounds(n16, n15, n22, n23);
        }
    }

    boolean fit(int n, int n2, int n3, int n4, BitSet[] bitSetArray) {
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (n + i >= this.cols) {
                    return false;
                }
                if (!bitSetArray[n + i].get(n2 + j)) continue;
                return false;
            }
        }
        return true;
    }

    static Hashtable str2table(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "= ");
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        if (!this.valid) {
            throw new RuntimeException("PnutsLayout not valid");
        }
        return this.rows;
    }

    public Point getGridPoint(Container container, int n, int n2) {
        if (!this.valid) {
            return null;
        }
        return new Point(this.grid_x[n], this.grid_y[n2]);
    }

    public Rectangle getGridRectangle(Container container, int n) {
        if (!this.valid) {
            return null;
        }
        int n2 = this.pos_x[n];
        int n3 = this.pos_y[n];
        int n4 = this.grid_x[n2];
        int n5 = this.grid_y[n3];
        Object[] objectArray = (Object[])this.spanTable.get(container.getComponent(n));
        int n6 = 1;
        int n7 = 1;
        if (objectArray != null) {
            n6 = (Integer)objectArray[0];
            n7 = (Integer)objectArray[1];
        }
        return new Rectangle(n4, n5, this.grid_x[n2 + n6] - n4, this.grid_y[n3 + n7] - n5);
    }

    public String toString() {
        return this.getClass().getName() + "[cols=" + this.cols + ",padx=" + this.padx + ",pady=" + this.pady + ",ipadx=" + this.ipadx + ",ipady=" + this.ipady + "]";
    }

    static {
        int n;
        integer = new Integer[33];
        for (n = 0; n < integer.length; ++n) {
            PnutsLayout.integer[n] = new Integer(n);
        }
        zero = new int[16];
        for (n = 0; n < zero.length; ++n) {
            PnutsLayout.zero[n] = 0;
        }
    }
}

