/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.WireShader;
import core.Main;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.stuk.visualization.graphs.GraphCanvas;
import org.stuk.visualization.polygonal.FrameBuffer;
import org.stuk.visualization.polygonal.RenderingPipeline;
import org.stuk.visualization.polygonal.ScanConverter;
import org.stuk.visualization.polygonal.Shader;
import org.stuk.visualization.polygonal.util.PolyUtils;

public class AboutDialog
extends JDialog {
    Thread t;
    Thread cons;
    int w = 200;
    int h = 200;
    int ox = 150;
    int oy = 150;
    RenderingPipeline p;
    FrameBuffer fb;
    List bin = new ArrayList();
    List annotations = new ArrayList();
    Font font = new Font("Dialog", 0, 9);
    int currentView = 0;
    double[] vrp = new double[]{40.0, 0.0, 20.0};
    double[] fp = new double[]{0.0, 0.0, 20.0};
    double[] up = new double[]{0.0, 0.0, 1.0};
    double[][] Tv = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    double[][] Tp = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    static double[] light = new double[]{1.0, 0.0, 0.0};
    double a = 0.0;
    boolean stop = false;
    private GraphCanvas graphCanvas;
    private JLabel versionLabel;

    public AboutDialog(JFrame owner) {
        super(owner);
        this.initComponents();
        Image img = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/UI/images/AboutImage.png"));
        AboutDialog.waitForImage(img, this.graphCanvas);
        int[] loc = new int[]{0, 0};
        int h = img.getHeight(null);
        int w = img.getWidth(null);
        String vers = "Frontend version: " + Main.getVersionString();
        String bvers = "Backend version: " + Main.getBackendVersionString();
        int[] locVers = new int[]{220, 105};
        int[] locBvers = new int[]{220, 155};
        String auth = "Programming:  T.Karhunen";
        int[] locAuth = new int[]{220, 125};
        String auth2 = "Design:             T.Karhunen, R.P\u00f6ll\u00e4nen";
        int[] locAuth2 = new int[]{220, 135};
        String auth3 = "Authors:            T.Siiskonen, R.P\u00f6ll\u00e4nen";
        int[] locAuth3 = new int[]{220, 175};
        String jvm = Main.getJVMVersion();
        this.setUpRenderer();
        this.setUpView();
        this.render();
        int[] locIm = new int[]{0, 0};
        this.graphCanvas.setPaintAxis(false);
        this.graphCanvas.setPaintBackground(false);
        this.graphCanvas.setDoubleBuffered(false);
        this.graphCanvas.setAntialiasingEnabled(true);
        this.graphCanvas.addAnnotation(img);
        this.graphCanvas.addAnnotation(loc);
        this.graphCanvas.addAnnotation(Color.white);
        this.graphCanvas.addAnnotation(new Font("Arial", 1, 10));
        this.graphCanvas.addAnnotation(vers);
        this.graphCanvas.addAnnotation(locVers);
        this.graphCanvas.addAnnotation(bvers);
        this.graphCanvas.addAnnotation(locBvers);
        this.graphCanvas.addAnnotation(auth3);
        this.graphCanvas.addAnnotation(locAuth3);
        this.graphCanvas.addAnnotation(auth);
        this.graphCanvas.addAnnotation(locAuth);
        this.graphCanvas.addAnnotation(auth2);
        this.graphCanvas.addAnnotation(locAuth2);
        this.graphCanvas.addAnnotation(this.fb.getImage());
        this.graphCanvas.addAnnotation(locIm);
        this.graphCanvas.addAnnotation(Color.darkGray);
        this.graphCanvas.addAnnotation(jvm);
        int[] locV = new int[]{350, 197};
        this.graphCanvas.addAnnotation(locV);
        this.graphCanvas.setPreferredSize(new Dimension(w, h));
        this.graphCanvas.setSize(w, h);
        this.graphCanvas.start();
        this.pack();
        this.graphCanvas.refresh();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AboutDialog.this.stop = true;
                AboutDialog.this.dispose();
            }
        });
        this.setVisible(true);
        this.graphCanvas.repaint();
        this.start();
    }

    public void start() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                while (!AboutDialog.this.stop) {
                    AboutDialog.this.vrp[0] = Math.sin(AboutDialog.this.a) * 300.0;
                    AboutDialog.this.vrp[1] = Math.cos(AboutDialog.this.a) * 300.0;
                    AboutDialog.this.a += 0.01;
                    AboutDialog.this.render();
                    AboutDialog.this.graphCanvas.refresh();
                    AboutDialog.this.graphCanvas.repaint();
                    Thread.yield();
                }
            }
        });
        t.start();
    }

    public static boolean waitForImage(Image image, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }

    private void setUpRenderer() {
        int numdatas = 2;
        this.p = new RenderingPipeline();
        this.fb = new FrameBuffer(this.w, this.h);
        this.fb.setAlphaEnabled(true);
        ScanConverter sc = new ScanConverter(this.w, this.h, numdatas);
        double[] pl = new double[]{50.0, 50.0, -100.0};
        Vector<double[]> light = new Vector<double[]>();
        light.add(pl);
        this.p.setLights(light);
        WireShader s = new WireShader();
        this.p.setFrameBuffer(this.fb);
        this.p.setShader(s);
        this.p.setScanConverter(sc);
        double[][] prj = PolyUtils.getProjectionTransform(4.0, 1000.0, Math.toRadians(90.0), 1.0);
        this.p.setProjectionTransform(prj);
        PolyUtils.getViewingTransform(this.vrp, this.fp, this.up, this.Tv);
        this.p.setViewingTransform(this.Tv);
    }

    private void setUpView() {
        double scale = 1000.0;
        double rx = 0.1 * scale;
        double ry = 0.2 * scale;
        double rz = 0.1194 * scale;
        this.fp[2] = 0.0;
        this.vrp[2] = 0.0;
        this.vrp[0] = 300.0;
        this.createEllipsoid(0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 30, this.bin);
    }

    public void render() {
        PolyUtils.getViewingTransform(this.vrp, this.fp, this.up, this.Tv);
        this.p.setViewingTransform(this.Tv);
        this.fb.clear();
        int i = 0;
        while (i < this.bin.size()) {
            Object o;
            if ((o = this.bin.get(i++)) instanceof Shader) {
                this.p.setShader((Shader)o);
                continue;
            }
            List v = (List)o;
            List d = (List)this.bin.get(i++);
            this.p.setVertices(v);
            this.p.setVertexData(d);
            this.p.render();
        }
    }

    private void createEllipsoid(double x, double y, double z, double rX, double rY, double rZ, int numSeg, List target) {
        double full = Math.PI * 2;
        double half = Math.PI;
        double quart = 1.5707963267948966;
        int N = numSeg;
        double[] u = new double[4];
        double[] v = new double[4];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                u[0] = (double)i * full / (double)N;
                v[0] = quart - (double)j * half / (double)N;
                u[1] = (double)((i + 1) % N) * full / (double)N;
                v[1] = quart - (double)j * half / (double)N;
                u[2] = (double)((i + 1) % N) * full / (double)N;
                v[2] = quart - (double)((j + 1) % N) * half / (double)N;
                u[3] = (double)i * full / (double)N;
                v[3] = quart - (double)((j + 1) % N) * half / (double)N;
                ArrayList<double[]> poly = new ArrayList<double[]>();
                poly.add(this.eVertex(u[0], v[0], rX, rY, rZ));
                poly.add(this.eVertex(u[1], v[1], rX, rY, rZ));
                poly.add(this.eVertex(u[2], v[2], rX, rY, rZ));
                poly.add(this.eVertex(u[3], v[3], rX, rY, rZ));
                target.add(poly);
                ArrayList<double[]> data = new ArrayList<double[]>();
                data.add(this.eData(u[0], v[0], rX, rY, rZ));
                data.add(this.eData(u[1], v[1], rX, rY, rZ));
                data.add(this.eData(u[2], v[2], rX, rY, rZ));
                data.add(this.eData(u[3], v[3], rX, rY, rZ));
                target.add(data);
            }
        }
    }

    private double[] eVertex(double u, double v, double rx, double ry, double rz) {
        double[] v1 = new double[]{Math.round(rx * Math.cos(u) * Math.cos(v)), Math.round(ry * Math.cos(u) * Math.sin(v)), Math.round(rz * Math.sin(u)), 1.0};
        return v1;
    }

    private double[] eData(double u, double v, double rx, double ry, double rz) {
        double[] v1 = new double[]{Math.round(rx * Math.cos(u) * Math.cos(v)), Math.round(ry * Math.cos(u) * Math.sin(v)), Math.round(rz * Math.sin(u))};
        PolyUtils.normalize(v1);
        double[] d = new double[]{0.0, PolyUtils.dot(v1, light)};
        return d;
    }

    private void initComponents() {
        this.graphCanvas = new GraphCanvas();
        this.versionLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("About AASI Frontend");
        this.setResizable(false);
        this.graphCanvas.setLayout(new AbsoluteLayout());
        this.graphCanvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AboutDialog.this.graphCanvasMousePressed(evt);
            }
        });
        this.versionLabel.setForeground(new Color(255, 255, 255));
        this.versionLabel.setText("jLabel1");
        this.graphCanvas.add((Component)this.versionLabel, new AbsoluteConstraints(130, 90, 190, -1));
        this.getContentPane().add((Component)this.graphCanvas, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 445) / 2, (screenSize.height - 187) / 2, 445, 187);
    }

    private void graphCanvasMousePressed(MouseEvent evt) {
        if (evt.getX() < 30 && evt.getY() < 30) {
            if (!Main.debug) {
                this.graphCanvas.addAnnotation(Color.white);
                this.graphCanvas.addAnnotation(new Font("Serif", 1, 26));
                this.graphCanvas.addAnnotation("Debug mode enabled!");
                int[] pos = new int[]{3, 24};
                this.graphCanvas.addAnnotation(pos);
                Main.debug = true;
                Main.retainFiles = true;
                Main.mainFrame.addDebugMenu();
            }
        } else {
            this.stop = true;
            this.dispose();
        }
    }

    private void graphCanvasMouseMoved(MouseEvent evt) {
        if (evt.getX() < 30 && evt.getY() < 30) {
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

