/*
 * Decompiled with CFR 0.152.
 */
package UI;

import java.awt.image.BufferedImage;
import org.stuk.visualization.polygonal.RenderingPipeline;
import org.stuk.visualization.polygonal.Shader;
import org.stuk.visualization.polygonal.util.PolyUtils;

public class MetalShader
extends Shader {
    double[] darray = new double[]{0.0, 0.0, 0.0, 255.0};
    BufferedImage envMap;
    double[] n = new double[]{1.0, 0.0, 0.0};
    double[] r = new double[]{0.0, 0.0, 0.0};
    double[] e = new double[]{0.0, 0.0, 0.0};
    double[] p = new double[]{0.0, 0.0, 0.0};
    RenderingPipeline rp;
    int ctr = 0;
    double ang = 0.0;

    public MetalShader(BufferedImage envMap, RenderingPipeline rp) {
        this.envMap = envMap;
        this.rp = rp;
    }

    public void shade(int x, int y, double[] data, boolean isEdge) {
        double z = data[0];
        this.e[0] = x;
        this.e[1] = y;
        this.e[2] = z;
        PolyUtils.normalize(this.e);
        this.n[0] = data[2];
        this.n[1] = data[3];
        this.n[2] = data[4];
        double i = this.readEnvMap();
        if (i < 0.0) {
            i = 0.0;
        }
        if (i > 1.0) {
            i = 1.0;
        }
        this.darray[0] = i * 255.0;
        this.darray[1] = i * 255.0;
        this.darray[2] = i * 255.0;
        this.fb.set(x, y, z, this.darray);
    }

    private double readEnvMap() {
        this.ang += 0.001;
        ++this.ctr;
        this.reflect(this.e, this.n);
        double theta = Math.atan(this.r[1] / this.r[0]);
        double rho = Math.acos(this.r[2]);
        double cx = Math.cos(rho) * Math.sin(theta);
        double cy = Math.sin(rho) * Math.sin(theta);
        int w = this.envMap.getWidth() - 1;
        int h = this.envMap.getHeight() - 1;
        int x = (int)(Math.abs(cx) * (double)w) % w;
        int y = (int)(Math.abs(cy) * (double)h) % h;
        if (x > w) {
            x = w;
        }
        if (y > h) {
            y = h;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        double ret = this.envMap.getRaster().getSampleDouble(x, y, 0);
        ret += this.envMap.getRaster().getSampleDouble(x, y, 1);
        ret += this.envMap.getRaster().getSampleDouble(x, y, 2);
        ret /= 3.0;
        return ret /= 255.0;
    }

    private void reflect(double[] v, double[] n) {
        this.r[0] = v[1] * n[2] - n[1] * v[2];
        this.r[1] = v[2] * n[0] - n[2] * v[0];
        this.r[2] = v[0] * n[1] - n[0] * v[1];
    }
}

