/*
 * Decompiled with CFR 0.152.
 */
package UI;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.stuk.visualization.graphs.Axis;
import org.stuk.visualization.graphs.Graph;
import org.stuk.visualization.graphs.GraphCanvas;

public class MiniControlWidgets
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int TOOL_NONE = 0;
    public static final int TOOL_ZOOM = 1;
    public static final int TOOL_PAN = 2;
    private boolean isDragging;
    private ArrayList listeners = new ArrayList();
    private double zoomf = 1.15;
    private int tool = 0;
    private boolean xConstrainToPositive = false;
    private boolean yConstrainToPositive = false;
    private boolean xConstrainToNegative = false;
    private boolean yConstrainToNegative = false;
    private boolean home = false;
    private double mix = 0.0;
    private double miy = 0.0;
    private double max = 0.0;
    private double may = 0.0;
    GraphCanvas graphCanvas;
    Point start;
    Point end;
    Point prev;
    private ArrayList canvases = new ArrayList();
    double logMax = -1.0;
    private JLabel autoRegion;
    private JToggleButton panToolButton;
    private JToggleButton zoomToolButton;

    public MiniControlWidgets() {
        this.initComponents();
    }

    public void setCanvas(GraphCanvas c) {
        this.graphCanvas = c;
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
    }

    public void addSecondaryCanvas(GraphCanvas c) {
        this.canvases.add(c);
    }

    public void setHome(double mix, double miy, double max, double may) {
        this.miy = miy;
        this.may = may;
        this.mix = mix;
        this.max = max;
        this.home = true;
    }

    public void constrainToPositive(boolean x, boolean y) {
        this.xConstrainToPositive = x;
        this.xConstrainToNegative = !x;
        this.yConstrainToPositive = y;
        this.yConstrainToNegative = !y;
    }

    public void constrainToNegative(boolean x, boolean y) {
        this.xConstrainToPositive = !x;
        this.xConstrainToNegative = x;
        this.yConstrainToPositive = !y;
        this.yConstrainToNegative = y;
    }

    public void mousePressed(MouseEvent evt) {
        this.isDragging = false;
        if (this.tool == 1) {
            this.start = evt.getPoint();
            this.end = null;
        }
    }

    private boolean insideAxis(Point p) {
        int xi = this.graphCanvas.getXInset();
        int yi = this.graphCanvas.getYInset();
        int wa = this.graphCanvas.getAxis().getSize(0);
        int ha = this.graphCanvas.getAxis().getSize(1);
        return p.x > xi && p.x < xi + wa && p.y > yi && p.y < yi + ha;
    }

    public void showAll() {
        this.autoRegionMousePressed(null);
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        if (this.tool == 0) {
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
        } else if (p.x < this.graphCanvas.getXInset()) {
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(8));
        } else if (p.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(10));
        } else if (this.tool == 1) {
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(6));
        } else if (this.tool == 2) {
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void setSelectedTool(int tool) {
        this.tool = tool;
        if (tool == 0) {
            Color c = this.autoRegion.getBackground();
            this.panToolButton.setSelected(false);
            this.panToolButton.repaint();
            this.zoomToolButton.setSelected(false);
            this.zoomToolButton.repaint();
        }
    }

    public void mouseReleased(MouseEvent evt) {
        this.end = evt.getPoint();
        if (this.tool == 1) {
            int xi = this.graphCanvas.getXInset();
            int yi = this.graphCanvas.getYInset();
            int wi = xi + this.graphCanvas.getAxis().getSize(0);
            int hi = yi + this.graphCanvas.getAxis().getSize(1);
            int x = evt.getX();
            int y = evt.getY();
            if (evt.getButton() != 3 && this.isDragging) {
                if (this.start.equals(this.end)) {
                    return;
                }
                if (y < hi && Math.abs(this.start.x - this.end.x) < 10) {
                    return;
                }
                this.zoom();
            } else if (evt.getButton() == 3 || x < xi || y > hi) {
                this.end = evt.getPoint();
                this.zoom(evt.getPoint(), evt.getButton() == 1 ? 1 : 3);
            }
        }
        if (this.tool == 2) {
            this.prev = null;
        }
    }

    public void setEnabled(boolean enabled) {
        this.zoomToolButton.setEnabled(enabled);
        this.panToolButton.setEnabled(enabled);
        this.autoRegion.setEnabled(enabled);
    }

    public void mouseDragged(MouseEvent evt) {
        this.isDragging = true;
        if (this.tool == 2) {
            Point p = evt.getPoint();
            if (this.prev != null) {
                int dx = p.x - this.prev.x;
                int dy = p.y - this.prev.y;
                this.pan(-dx, dy);
            }
            this.prev = p;
        }
        if (this.tool == 1) {
            if (this.end != null) {
                this.fillRectXor();
            }
            this.end = evt.getPoint();
            this.fillRectXor();
        }
    }

    private void pan(int dx, int dy) {
        Axis a = this.graphCanvas.getAxis();
        double mix = a.getMin(0);
        double miy = a.getMin(1);
        double max = a.getMax(0);
        double may = a.getMax(1);
        int one = 1;
        int two = 2;
        double donex = a.getValueForAxisCoordinate(two, 0) - a.getValueForAxisCoordinate(one, 0);
        double doney = a.getValueForAxisCoordinate(two, 1) - a.getValueForAxisCoordinate(one, 1);
        double ddx = (double)dx * donex;
        double ddy = (double)dy * doney;
        mix = a.getMin(0);
        max = a.getMax(0);
        miy = a.getMin(1);
        may = a.getMax(1);
        if (this.xConstrainToPositive && mix + ddx < 0.0) {
            ddx = -mix;
        }
        if (this.xConstrainToNegative && max + ddx > 0.0) {
            ddx = -max;
        }
        if (this.yConstrainToPositive && miy + ddy < 0.0) {
            ddy = -miy;
        }
        if (this.yConstrainToNegative && may + ddy > 0.0) {
            ddy = -may;
        }
        a.setMinMax(mix + ddx, miy + ddy, max + ddx, may + ddy);
        for (int i = 0; i < this.canvases.size(); ++i) {
            GraphCanvas cnv = (GraphCanvas)this.canvases.get(i);
            cnv.getAxis().setMinMax(mix + ddx, max + ddx, 0);
            cnv.getAxis().setTics();
            cnv.refresh();
            cnv.repaint();
        }
        a.setTics();
        this.setLogTics(1);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void zoom(Point p, int button) {
        Axis a = this.graphCanvas.getAxis();
        double mix = a.getMin(0);
        double miy = a.getMin(1);
        double max = a.getMax(0);
        double may = a.getMax(1);
        double lenx = (max - mix) / 2.0;
        double leny = (may - miy) / 2.0;
        int px = p.x - this.graphCanvas.getXInset();
        int py = this.graphCanvas.getHeight() - p.y - this.graphCanvas.getYInset();
        double cx = a.getValueForAxisCoordinate(px, 0);
        double cy = a.getValueForAxisCoordinate(py, 1);
        double f = 0.0;
        double len1x = cx - mix;
        double len2x = max - cx;
        double len1y = cy - miy;
        double len2y = may - cy;
        f = button == 1 ? this.zoomf : 2.0 - this.zoomf;
        len1x /= f;
        len2x /= f;
        len1y /= f;
        len2y /= f;
        if (p.x < this.graphCanvas.getXInset()) {
            double my = cy - len1y;
            double My = cy + len2y;
            if (this.yConstrainToPositive) {
                my = Math.max(my, 0.0);
            }
            if (this.yConstrainToNegative) {
                My = Math.min(My, 0.0);
            }
            a.setMinMax(mix, my, max, My);
            a.setTics();
            this.setLogTics(1);
        } else if (p.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            double mx = cx - len1x;
            double Mx = cx + len2x;
            if (this.xConstrainToPositive) {
                mx = Math.max(mx, 0.0);
            }
            if (this.xConstrainToNegative) {
                Mx = Math.min(Mx, 0.0);
            }
            a.setMinMax(mx, miy, Mx, may);
            for (int i = 0; i < this.canvases.size(); ++i) {
                GraphCanvas cnv = (GraphCanvas)this.canvases.get(i);
                cnv.getAxis().setMinMax(mx, Mx, 0);
                cnv.getAxis().setTics();
                cnv.refresh();
                cnv.repaint();
            }
            a.setTics();
            this.setLogTics(1);
        } else {
            double my = cy - len1y;
            double mx = cx - len1x;
            double Mx = cx + len2x;
            double My = cx + len2y;
            if (this.xConstrainToPositive) {
                mx = Math.max(mx, 0.0);
            }
            if (this.xConstrainToNegative) {
                Mx = Math.min(Mx, 0.0);
            }
            if (this.yConstrainToPositive) {
                my = Math.max(my, 0.0);
            }
            if (this.yConstrainToNegative) {
                My = Math.min(My, 0.0);
            }
            a.setMinMax(mx, my, Mx, My);
            for (int i = 0; i < this.canvases.size(); ++i) {
                GraphCanvas cnv = (GraphCanvas)this.canvases.get(i);
                cnv.getAxis().setMinMax(mx, Mx, 0);
                cnv.getAxis().setTics();
                cnv.refresh();
                cnv.repaint();
            }
            a.setTics();
            this.setLogTics(1);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private int getScreenX(double dx) {
        int xi = this.graphCanvas.getXInset();
        int x = xi + (int)this.graphCanvas.getAxis().getAxisCoordinateForValue(dx, 0);
        return x;
    }

    private int getScreenY(double vy) {
        int yi = this.graphCanvas.getYInset();
        int h = this.graphCanvas.getHeight();
        int y = h - yi - (int)this.graphCanvas.getAxis().getAxisCoordinateForValue(vy, 1);
        return y;
    }

    public void setLogTics(int iaxis) {
        int td;
        int y2;
        int y1;
        int i;
        int d;
        int j;
        int i2;
        int ind;
        double incr;
        double tic;
        double[] tics;
        Axis axis = this.graphCanvas.getAxis();
        axis.setTics();
        if (axis.isLogarithmic(1)) {
            tics = new double[55];
            tic = 10.0;
            incr = 10.0;
            ind = 0;
            i2 = 0;
            while (ind < tics.length - 1) {
                for (j = 1; j < 10; ++j) {
                    tics[ind + 1] = (double)j * incr;
                    ++ind;
                }
                incr *= 10.0;
                ++i2;
            }
            tics[0] = 1.0;
            d = 100000000;
            for (i = 0; i < tics.length - 1; ++i) {
                y1 = this.getScreenY(tics[i]);
                y2 = this.getScreenY(tics[i + 1]);
                td = Math.abs(y1 - y2);
                if (Math.abs(y1 - y2) >= d) continue;
                d = Math.abs(y1 - y2);
            }
            if (d <= axis.getTicFont(1).getSize() - 3) {
                tics = new double[10];
                tic = 10.0;
                for (i = 1; i < tics.length; ++i) {
                    tics[i] = tic;
                    tic *= 10.0;
                }
                tics[0] = 1.0;
            }
            axis.setMin(1.0, 1);
            axis.setTics(tics, 1);
        }
        if (axis.isLogarithmic(0)) {
            tics = new double[55];
            tic = 10.0;
            incr = 10.0;
            ind = 0;
            i2 = 0;
            while (ind < tics.length - 1) {
                for (j = 1; j < 10; ++j) {
                    tics[ind + 1] = (double)j * incr;
                    ++ind;
                }
                incr *= 10.0;
                ++i2;
            }
            tics[0] = 1.0;
            d = 100000000;
            for (i = 0; i < tics.length - 1; ++i) {
                y1 = this.getScreenX(tics[i]);
                y2 = this.getScreenX(tics[i + 1]);
                td = Math.abs(y1 - y2);
                if (Math.abs(y1 - y2) >= d) continue;
                d = Math.abs(y1 - y2);
            }
            if (d <= axis.getTicFont(0).getSize() * 3) {
                tics = new double[10];
                tic = 10.0;
                for (i = 1; i < tics.length; ++i) {
                    tics[i] = tic;
                    tic *= 10.0;
                }
                tics[0] = 1.0;
            }
            axis.setMin(1.0, 0);
            axis.setTics(tics, 0);
        }
    }

    private void zoom() {
        Axis a = this.graphCanvas.getAxis();
        double mix = a.getMin(0);
        double miy = a.getMin(1);
        double max = a.getMax(0);
        double may = a.getMax(1);
        double lenx = (max - mix) / 2.0;
        double leny = (may - miy) / 2.0;
        int ex = Math.max(this.start.x, this.end.x);
        int ey = Math.max(this.start.y, this.end.y);
        int sx = Math.min(this.start.x, this.end.x);
        int sy = Math.min(this.start.y, this.end.y);
        int px1 = sx - this.graphCanvas.getXInset();
        int py1 = this.graphCanvas.getHeight() - sy - this.graphCanvas.getYInset();
        int px2 = ex - this.graphCanvas.getXInset();
        int py2 = this.graphCanvas.getHeight() - ey - this.graphCanvas.getYInset();
        double cx1 = a.getValueForAxisCoordinate(px1, 0);
        double cy1 = a.getValueForAxisCoordinate(py1, 1);
        double cx2 = a.getValueForAxisCoordinate(px2, 0);
        double cy2 = a.getValueForAxisCoordinate(py2, 1);
        double f = 0.0;
        double len1x = cx1 - mix;
        double len2x = max - cx1;
        double len1y = cy1 - miy;
        double len2y = may - cy1;
        len1x /= f;
        len2x /= f;
        len1y /= f;
        len2y /= f;
        if (this.start.x < this.graphCanvas.getXInset()) {
            double m = Math.min(cy1, cy2);
            double M = Math.max(cy1, cy2);
            if (this.yConstrainToPositive) {
                m = Math.max(0.0, m);
            }
            if (this.yConstrainToNegative) {
                M = Math.min(0.0, M);
            }
            a.setMinMax(mix, m, max, M);
            a.setTics();
            this.setLogTics(1);
        } else if (this.start.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            double m = Math.min(cx1, cx2);
            double M = Math.max(cx1, cx2);
            if (this.xConstrainToPositive) {
                m = Math.max(0.0, m);
            }
            if (this.xConstrainToNegative) {
                M = Math.min(0.0, M);
            }
            a.setMinMax(m, miy, M, may);
            for (int i = 0; i < this.canvases.size(); ++i) {
                GraphCanvas cnv = (GraphCanvas)this.canvases.get(i);
                cnv.getAxis().setMinMax(m, M, 0);
                cnv.getAxis().setTics();
                cnv.refresh();
                cnv.repaint();
            }
            a.setTics();
            this.setLogTics(1);
        } else {
            double my = Math.min(cy1, cy2);
            double My = Math.max(cy1, cy2);
            double mx = Math.min(cx1, cx2);
            double Mx = Math.max(cx1, cx2);
            if (this.yConstrainToPositive) {
                my = Math.max(0.0, my);
            }
            if (this.yConstrainToNegative) {
                My = Math.min(0.0, My);
            }
            if (this.xConstrainToPositive) {
                mx = Math.max(0.0, mx);
            }
            if (this.xConstrainToNegative) {
                Mx = Math.min(0.0, Mx);
            }
            a.setMinMax(mx, my, Mx, My);
            for (int i = 0; i < this.canvases.size(); ++i) {
                GraphCanvas cnv = (GraphCanvas)this.canvases.get(i);
                cnv.getAxis().setMinMax(mx, Mx, 0);
                cnv.getAxis().setTics();
                cnv.refresh();
                cnv.repaint();
            }
            a.setTics();
            this.setLogTics(1);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void fillRectXor() {
        Axis a = this.graphCanvas.getAxis();
        int lenx = Math.abs(this.end.x - this.start.x);
        int leny = Math.abs(this.end.y - this.start.y);
        int sx = Math.min(this.start.x, this.end.x);
        int sy = Math.min(this.start.y, this.end.y);
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.red);
        if (this.start.x < this.graphCanvas.getXInset()) {
            g.fillRect(this.graphCanvas.getXInset(), sy, this.graphCanvas.getAxis().getSize(0), leny);
        } else if (this.start.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            g.fillRect(sx, this.graphCanvas.getYInset(), lenx, this.graphCanvas.getAxis().getSize(1));
        } else {
            g.fillRect(sx, sy, lenx, leny);
        }
    }

    private void initComponents() {
        this.zoomToolButton = new JToggleButton();
        this.panToolButton = new JToggleButton();
        this.autoRegion = new JLabel();
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        this.zoomToolButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/ZoomSmall.png")));
        this.zoomToolButton.setToolTipText("Zoom tool. Click & drag on the display area to zoom in. Rigth click to zoom out.");
        this.zoomToolButton.setFocusPainted(false);
        this.zoomToolButton.setFocusable(false);
        this.zoomToolButton.setPreferredSize(new Dimension(22, 18));
        this.zoomToolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MiniControlWidgets.this.zoomToolButtonActionPerformed(evt);
            }
        });
        this.add(this.zoomToolButton);
        this.panToolButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/PanSmall.png")));
        this.panToolButton.setToolTipText("Pan tool. Click and drag on the display area to pan.");
        this.panToolButton.setFocusPainted(false);
        this.panToolButton.setFocusable(false);
        this.panToolButton.setPreferredSize(new Dimension(22, 18));
        this.panToolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MiniControlWidgets.this.panToolButtonActionPerformed(evt);
            }
        });
        this.add(this.panToolButton);
        this.autoRegion.setForeground(new Color(255, 255, 255));
        this.autoRegion.setHorizontalAlignment(0);
        this.autoRegion.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/ShowAllSmall.png")));
        this.autoRegion.setToolTipText("Reset view to show whole spectrum range.");
        this.autoRegion.setOpaque(true);
        this.autoRegion.setPreferredSize(new Dimension(22, 16));
        this.autoRegion.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MiniControlWidgets.this.autoRegionMousePressed(evt);
            }
        });
        this.add(this.autoRegion);
    }

    private void panToolButtonActionPerformed(ActionEvent evt) {
        if (this.tool == 2) {
            this.tool = 0;
            return;
        }
        this.tool = 2;
        Color c = this.autoRegion.getBackground();
        this.zoomToolButton.setSelected(false);
        this.zoomToolButton.repaint();
        ActionEvent e = new ActionEvent(this.panToolButton, 2, "Pan activated");
        this.fireActionPerformed(e);
    }

    private void zoomToolButtonActionPerformed(ActionEvent evt) {
        if (this.tool == 1) {
            this.tool = 0;
            return;
        }
        this.tool = 1;
        Color c = this.autoRegion.getBackground();
        this.panToolButton.setSelected(false);
        this.panToolButton.repaint();
        ActionEvent e = new ActionEvent(this.zoomToolButton, 2, "Zoom activated");
        this.fireActionPerformed(e);
    }

    private void autoRegionMousePressed(MouseEvent evt) {
        if (this.home) {
            this.graphCanvas.getAxis().setMinMax(this.mix, this.miy, this.max, this.may);
        } else {
            List l = this.graphCanvas.getGraphs();
            Iterator iter = l.iterator();
            this.mix = 100000.0;
            this.miy = 100000.0;
            this.max = -100000.0;
            this.may = -100000.0;
            while (iter.hasNext()) {
                Graph g = (Graph)iter.next();
                if (g.getXmin() < this.mix) {
                    this.mix = g.getXmin();
                }
                if (g.getXmax() > this.max) {
                    this.max = g.getXmax();
                }
                if (g.getYmin() < this.miy) {
                    this.miy = g.getYmin();
                }
                if (!(g.getYmax() > this.may)) continue;
                this.may = g.getYmax();
            }
            this.graphCanvas.getAxis().setMinMax(this.mix, this.miy, this.max, this.may);
            for (int i = 0; i < this.canvases.size(); ++i) {
                GraphCanvas cnv = (GraphCanvas)this.canvases.get(i);
                cnv.getAxis().setMinMax(this.mix, this.max, 0);
                cnv.getAxis().setTics();
                cnv.refresh();
                cnv.repaint();
            }
        }
        this.graphCanvas.getAxis().setTics();
        if (this.graphCanvas.getAxis().isLogarithmic(1)) {
            this.setLogTics(1);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
        ActionEvent e = new ActionEvent(this.autoRegion, 2, "AutoRegion activated");
        this.fireActionPerformed(e);
    }

    public void addActionListener(ActionListener act) {
        this.listeners.add(act);
    }

    public void fireActionPerformed(ActionEvent e) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ActionListener al = (ActionListener)iter.next();
            al.actionPerformed(e);
        }
    }
}

