/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.ColorComboboxRenderer;
import UI.Drawer;
import UI.HeaderLabel;
import UI.MiniControlWidgets;
import UI.Shelf;
import UI.TileLayout;
import core.Fitter;
import core.IECReader;
import core.Main;
import core.PhdReader;
import core.PhdWriter;
import core.ResultsReader;
import core.ResultsWriter;
import core.SPEReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.stuk.visualization.graphs.Axis;
import org.stuk.visualization.graphs.Graph;
import org.stuk.visualization.graphs.GraphCanvas;
import org.stuk.visualization.graphs.XYGraph;
import say.swing.JFontChooser;

public class PlotPanel
extends JPanel {
    private DecimalFormat format;
    private DecimalFormat format2;
    public static final int TOOL_NONE = 0;
    public static final int TOOL_ZOOM = 1;
    public static final int TOOL_PAN = 2;
    public static final int TOOL_TEXT = 3;
    public static final int TOOL_EVAL = 4;
    public static final int TOOL_SELECT = 5;
    public static final int TOOL_LINE = 6;
    public static final int TOOL_ERASER = 7;
    public static final int TOOL_FIT_RANGE = 8;
    public static final int MODE_XY = 1;
    public static final int MODE_X = 2;
    public static final int MODE_Y = 3;
    public static final int CS_VIEW = 1;
    public static final int CS_MODEL = 2;
    String rangeTarget = "shape";
    public static final int PT_START = 1;
    public static final int PT_END = 2;
    Color[] colors = new Color[]{Color.black, Color.blue, Color.red.darker(), Color.green.darker(), Color.gray, Color.cyan.darker(), Color.orange, Color.yellow.darker()};
    int curColor = 0;
    private int toolCoordinates = 2;
    private int tool = 0;
    private int selectedPt = 0;
    private int panMode = 0;
    private double zoomf = 1.15;
    private int prevZoomType = 0;
    private RenderingHints hints;
    boolean toolDisabled = false;
    Point current = null;
    Hashtable graphs = new Hashtable();
    DropTarget dropTarget;
    private double defaultWidth = 2.0;
    private boolean started = false;
    private Font lastUserFont = new Font("Arial", 0, 10);
    private boolean openXShelf = false;
    private boolean openYShelf = false;
    private boolean openGraphShelf = false;
    private boolean hideProperties = false;
    private boolean pendingSettings = false;
    static double[] coeffs = new double[10];
    Properties settings = new Properties();
    boolean first = true;
    JDialog tdialog = new JDialog();
    Font anfont;
    boolean isEditing = false;
    boolean isCreating = false;
    JTextArea field = new JTextArea();
    int ox;
    int oy;
    double ax;
    double ay;
    boolean loading = false;
    double panAmnt = 0.4;
    double zoomAmnt = 0.5;
    int zoomLevel = 1;
    boolean userSetSize = false;
    ArrayList shapes = new ArrayList();
    Fitter fitter = new Fitter();
    PageFormat currentFormat = null;
    int offsx = 0;
    int offsy = 0;
    double scalex = 1.0;
    double scaley = 1.0;
    Point start;
    Point end;
    boolean isClick = true;
    FileFilter phdFormat;
    FileFilter graphFormat;
    FileFilter iecFormat;
    FileFilter pdfFormat;
    FileFilter emfFormat;
    FileFilter gifFormat;
    FileFilter epsFormat;
    FileFilter figFormat;
    FileFilter pngFormat;
    FileFilter svgFormat;
    FileFilter lastFormat;
    String chooserOpenHome = Main.workingDir;
    String chooserSaveHome = Main.workingDir;
    double logMax = -1.0;
    Hashtable widths = new Hashtable();
    JColorChooser jcc;
    JDialog dialog;
    boolean isDragging = false;
    String prevCs;
    String cs;
    Point p;
    double ovy = Double.POSITIVE_INFINITY;
    double ovx = 0.0;
    Object selectedObj;
    String type;
    String ptype;
    Font selectedFont;
    Object psel = null;
    int prevTool = 5;
    Point prev;
    private JToggleButton addLineButton;
    private JMenuItem addLineMenuItem;
    private JToggleButton addLineTagButton;
    private JMenuItem addLineTagMenuItem;
    private JToggleButton addTextButton;
    private JMenuItem addTextMenuItem;
    private JToggleButton addTextTagButton;
    private JMenuItem addTextTagMenuItem;
    private JCheckBox antialiasingCheckbox;
    private JMenuItem batchConvertMenuItem;
    private JPanel colorPanel;
    private JMenuItem copyExcel;
    private JMenuItem copyMatlab;
    private JLabel correction;
    private JLabel correction2;
    private JTextField correctionField;
    private ButtonGroup csButtonGroup;
    private JMenuItem deleteAllGraphs;
    private JButton deleteGraphButton;
    private JMenuItem deleteGraphMenuItem;
    private Drawer drawer1;
    private Drawer drawer2;
    private Drawer drawer3;
    private JMenu editMenu;
    private JToggleButton evalButton;
    private JPanel expandGraphPanel;
    private JPanel expandXPanel;
    private JPanel expandYPanel;
    private GraphCanvas graphCanvas;
    private JTextField graphTitleField;
    private JComboBox graphsCombobox;
    private JComboBox graphsCombobox1;
    private widgets.HeaderLabel headerLabel1;
    private widgets.HeaderLabel headerLabel4;
    private widgets.HeaderLabel headerLabel6;
    private JToggleButton infoToolButton;
    private JCheckBox jCheckBox1;
    private JDesktopPane jDesktopPane1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JSeparator jSeparator15;
    private JSeparator jSeparator16;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;
    private JLabel navigationLabel;
    private JPanel northPanel;
    private JButton openBtn;
    private JMenuItem openGraphMenuItem;
    private widgets.HeaderLabel openGraphPropertiesLabel;
    private widgets.HeaderLabel openXPropertiesLabel;
    private widgets.HeaderLabel openYPropertiesLabel;
    private JButton pageSetupBtn;
    private JMenuItem pageSetupMenuItem;
    private JToggleButton panButton;
    private JMenuItem panLeftItem;
    private JMenuItem panRightItem;
    private JMenu plotAnnotationsMenu;
    private JPanel plotColorPanel;
    private MiniControlWidgets plotControlWidgets;
    private JMenu plotFileMenu;
    private JPanel plotFillPanel;
    private JMenu plotGraphsMenu;
    private JMenu plotViewMenu;
    private JLabel plotWidthMinusBtn;
    private JLabel plotWidthPlusBtn;
    private JMenu plotZoomMenu;
    private JButton printBtn;
    private JMenuItem printFigMenuItem;
    private ButtonGroup rangeGroup;
    private ButtonGroup rangeGroup1;
    private JButton redoTicsX;
    private JButton redoTicsX1;
    private JButton redoTicsY;
    private JButton redoTicsY1;
    private JMenuItem removeAllAnnotationsMenuItem;
    private JLabel removeObjectBtn;
    private JMenuItem removeSelectedAnnotationMenuItem;
    private JPanel rightPanel;
    private JButton saveBtn;
    private JMenuItem saveFigMenuItem;
    private JMenuItem saveSelectedMenuItem;
    private JToggleButton selectButton;
    private JToggleButton selectButton1;
    private JMenuItem selectNextItem;
    private JMenuItem selectPrevItem;
    private JToggleButton selectToolButton;
    private JLabel selectedObjectLabel;
    private JLabel selectionLabel;
    private Shelf shelf;
    private JInternalFrame simulationPlotFrame;
    private JMenuItem toBackItem;
    private JToggleButton toFitBtn;
    private JButton toFitBtn2;
    private JButton toFrontBtn;
    private JButton toFrontBtn1;
    private JMenuItem toFrontItem;
    private ButtonGroup toolsGroup;
    private ButtonGroup typeGroup;
    private ButtonGroup typeGroup1;
    private JCheckBoxMenuItem viewNavigationMenuItem;
    private JCheckBoxMenuItem viewPropertiesPaneItem;
    private JLabel width;
    private JLabel width2;
    private JTextField widthField;
    private JRadioButton xAxisLinear;
    private JRadioButton xAxisLog;
    private JTextField xAxisTitleField;
    private JTextField xMaxField;
    private JTextField xMinField;
    private JRadioButton xRangeAutoButton;
    private JRadioButton xRangeButton;
    private HeaderLabel xRangeLabel;
    private JCheckBox xTicsCheckbox;
    private JButton xTitleFontBtn;
    private JRadioButton yAxisLinear;
    private JRadioButton yAxisLog;
    private JTextField yAxisTitleField;
    private JTextField yMaxField;
    private JTextField yMinField;
    private JRadioButton yRangeAutoButton;
    private JRadioButton yRangeButton;
    private HeaderLabel yRangeLabel;
    private HeaderLabel yRangeLabel1;
    private JCheckBox yTicsCheckbox;
    private JButton yTitleFontBtn;
    private JMenuItem zoomAllMenuItem;
    private JToggleButton zoomButton;
    private JMenuItem zoomInMenuItem;
    private JMenuItem zoomOutMenuItem;

    public PlotPanel() {
        this.initComponents();
        this.setupComponents();
        this.loadSettings();
        this.antialiasingCheckbox.setSelected(true);
        this.graphCanvas.setAntialiasingEnabled(true);
        this.northPanel.remove(this.antialiasingCheckbox);
        this.currentFormat = PrinterJob.getPrinterJob().defaultPage();
        this.currentFormat.setOrientation(0);
        this.format = new DecimalFormat();
        this.format2 = new DecimalFormat();
        this.initDnd();
        DecimalFormatSymbols fs = this.format.getDecimalFormatSymbols();
        fs.setDecimalSeparator('.');
        this.format.setDecimalFormatSymbols(fs);
        this.format.setMaximumFractionDigits(3);
        this.format2.setDecimalFormatSymbols(fs);
        this.format2.setMaximumFractionDigits(0);
        this.xRangeLabel.setText(" " + this.graphCanvas.getAxis().getTitle(0) + " plot range");
        this.yRangeLabel.setText(" " + this.graphCanvas.getAxis().getTitle(1) + " plot range");
        this.graphCanvas.refresh();
        this.simulationPlotFrame.setJMenuBar(this.jMenuBar1);
    }

    private void setupComponents() {
        if (!Main.aasi_fit) {
            this.jPanel6.remove(this.toFitBtn2);
        }
        this.zoomAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(36, 2));
        this.zoomInMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, 2));
        this.zoomOutMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, 2));
        this.panRightItem.setAccelerator(KeyStroke.getKeyStroke(39, 2));
        this.panLeftItem.setAccelerator(KeyStroke.getKeyStroke(37, 2));
        this.selectNextItem.setAccelerator(KeyStroke.getKeyStroke(34, 2));
        this.selectPrevItem.setAccelerator(KeyStroke.getKeyStroke(33, 2));
        this.deleteGraphMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        this.plotControlWidgets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JPanel) {
                    return;
                }
                PlotPanel.this.infoToolButton.setSelected(false);
                PlotPanel.this.selectToolButton.setSelected(false);
                PlotPanel.this.tool = 0;
                if (PlotPanel.this.graphCanvas.getSelected() != null) {
                    PlotPanel.this.graphCanvas.setSelected(null);
                    PlotPanel.this.graphCanvas.refresh();
                    PlotPanel.this.graphCanvas.repaint();
                }
            }
        });
    }

    public JInternalFrame getPlotFrame() {
        return this.simulationPlotFrame;
    }

    private String encodeFont(Font f) {
        String str = f.getFamily();
        int style = f.getStyle();
        if (style == 1) {
            str = str + "-BOLD";
        }
        if (style == 0) {
            str = str + "-PLAIN";
        }
        if (style == 2) {
            str = str + "-ITALIC";
        }
        if (style == 3) {
            str = str + "-BOLDITALIC";
        }
        str = str + "-" + f.getSize();
        return str;
    }

    public void saveSettings() {
        try {
            File f = new File("./lib/plot.prs");
            this.settings.setProperty("x_axis_properties_open", this.drawer1.isMinimized() ? "false" : "true");
            this.settings.setProperty("y_axis_properties_open", this.drawer2.isMinimized() ? "false" : "true");
            this.settings.setProperty("graph_properties_open", this.drawer3.isMinimized() ? "false" : "true");
            this.settings.setProperty("x_axis_linear", this.graphCanvas.getAxis().isLogarithmic(0) ? "false" : "true");
            this.settings.setProperty("y_axis_linear", this.graphCanvas.getAxis().isLogarithmic(1) ? "false" : "true");
            this.settings.setProperty("default_graph_width", this.defaultWidth + "");
            Axis a = this.graphCanvas.getAxis();
            this.settings.setProperty("x_tic_font", this.encodeFont(a.getTicFont(0)));
            this.settings.setProperty("y_tic_font", this.encodeFont(a.getTicFont(1)));
            this.settings.setProperty("x_title_font", this.encodeFont(a.getTitleFont(0)));
            this.settings.setProperty("y_title_font", this.encodeFont(a.getTitleFont(1)));
            this.settings.setProperty("last_user_font", this.encodeFont(this.lastUserFont));
            this.settings.setProperty("properties_pane_visible", this.viewPropertiesPaneItem.isSelected() ? "true" : "false");
            this.settings.setProperty("toolbar_visible", this.viewNavigationMenuItem.isSelected() ? "true" : "false");
            FileOutputStream fos = new FileOutputStream(f);
            this.settings.store(fos, "Plot settings");
            fos.close();
            System.out.println("Saved plot settings!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadSettings() {
        try {
            File f = new File("./lib/plot.prs");
            FileInputStream fis = new FileInputStream(f);
            this.settings.load(fis);
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String s = this.settings.getProperty("x_axis_properties_open", "false");
        if (s.equals("true")) {
            this.openXShelf = true;
        }
        if ((s = this.settings.getProperty("y_axis_properties_open", "false")).equals("true")) {
            this.openYShelf = true;
        }
        if ((s = this.settings.getProperty("graph_properties_open", "false")).equals("true")) {
            this.openGraphShelf = true;
        }
        if ((s = this.settings.getProperty("properties_pane_visible", "true")).equals("false")) {
            this.hideProperties = true;
            this.viewPropertiesPaneItem.setSelected(false);
            this.viewPropertiesPaneItemActionPerformed(null);
        }
        if ((s = this.settings.getProperty("toolbar_visible", "true")).equals("false")) {
            this.viewNavigationMenuItem.setSelected(false);
            this.viewNavigationMenuItemActionPerformed(null);
        }
        s = this.settings.getProperty("x_axis_linear", "true");
        s = this.settings.getProperty("y_axis_linear", "true");
        if (s.equals("false")) {
            this.yAxisLogActionPerformed(null);
        }
        Axis a = this.graphCanvas.getAxis();
        s = this.settings.getProperty("x_tic_font", "Arial-PLAIN-10");
        Font f = Font.decode(s);
        a.setTicFont(f, 0);
        s = this.settings.getProperty("y_tic_font", "Arial-PLAIN-10");
        Font f1 = Font.decode(s);
        a.setTicFont(f1, 1);
        s = this.settings.getProperty("x_title_font", "Arial-BOLD-18");
        Font f2 = Font.decode(s);
        a.setTitleFont(f2, 0);
        s = this.settings.getProperty("y_title_font", "Arial-BOLD-18");
        Font f3 = Font.decode(s);
        a.setTitleFont(f3, 1);
        s = this.settings.getProperty("last_user_font", "Arial-PLAIN-10");
        this.lastUserFont = Font.decode(s);
        s = this.settings.getProperty("default_graph_width", "1.0");
        try {
            double d;
            this.defaultWidth = d = Double.parseDouble(s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initDnd() {
        this.dropTarget = new DropTarget(){

            public void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(1);
                Transferable tr = dtde.getTransferable();
                PlotPanel.this.handlePaste(tr);
                dtde.dropComplete(true);
            }
        };
        this.graphCanvas.setDropTarget(this.dropTarget);
    }

    public void start() {
        this.graphCanvas.start();
        this.loadSettings();
        this.started = true;
    }

    public void setAxisTitles(String titleX, String titleY) {
        this.xAxisTitleField.setText(titleX);
        this.yAxisTitleField.setText(titleY);
        this.xAxisTitleFieldActionPerformed(null);
        this.yAxisTitleFieldActionPerformed(null);
    }

    private void activateTool(int atool) {
        if (atool == 5) {
            this.selectButton.setSelected(true);
            this.tool = 5;
        } else if (atool == 3) {
            this.addTextButton.setSelected(true);
            this.tool = 3;
        } else if (atool == 6) {
            this.addLineButton.setSelected(true);
            this.tool = 6;
        }
    }

    public synchronized void addGraph(Graph graph, boolean genColor) {
        this.enablePlotToolbar(true);
        this.simulationPlotFrame.toFront();
        if (this.first) {
            this.simulationPlotFrame.setResizable(true);
            this.jScrollPane1.setVerticalScrollBarPolicy(20);
            this.jScrollPane1.setHorizontalScrollBarPolicy(30);
        }
        if (!this.userSetSize) {
            this.simulationPlotFrame.reshape(20, 20, this.getWidth() - 20, this.getHeight() - 20);
        }
        if (this.first) {
            Axis a = this.graphCanvas.getAxis();
            a.setTitle("Energy (MeV)", 0);
            this.xAxisTitleField.setText("Energy (MeV)");
            a.setTitle("Counts", 1);
            this.yAxisTitleField.setText("Counts");
            this.graphCanvas.getAxis().setMinMax(graph.getXmin(), graph.getYmin(), graph.getXmax(), graph.getYmax());
            this.xMinField.setText(this.format.format(graph.getXmin()));
            this.xMaxField.setText(this.format.format(graph.getXmax()));
            this.yMinField.setText(this.format.format(graph.getYmin()));
            this.yMaxField.setText(this.format.format(graph.getYmax()));
        }
        if (genColor) {
            graph.setColor(this.colors[this.curColor++ % this.colors.length]);
        }
        graph.setStrokeWidth((float)this.defaultWidth);
        this.graphCanvas.addGraph(graph);
        HeaderLabel l = new HeaderLabel();
        l.setFore(graph.getColor());
        l.setBack(Color.white);
        l.setBackground(Color.white);
        l.setOpaque(true);
        l.setText(graph.toString());
        this.graphs.put(l, graph);
        this.loading = true;
        this.graphsCombobox.addItem(l);
        this.graphsCombobox1.addItem(l);
        if (!this.graphCanvas.isStarted()) {
            this.graphCanvas.start();
        }
        this.graphsCombobox.setSelectedItem(l);
        this.widthField.setText(graph.getStrokeWidth() + "");
        if (this.first) {
            this.graphCanvas.getAxis().setTics(10);
        }
        if (this.xRangeAutoButton.isSelected()) {
            this.xRangeAutoButtonActionPerformed(null);
        }
        if (this.yRangeAutoButton.isSelected()) {
            this.yRangeAutoButtonActionPerformed(null);
        }
        this.graphCanvas.refresh();
        this.loading = false;
        if (this.first) {
            if (!this.hideProperties) {
                if (this.openXShelf) {
                    this.openXPropertiesLabelMouseClicked(null);
                }
                if (this.openYShelf) {
                    this.openYPropertiesLabelMouseClicked(null);
                }
                if (this.openGraphShelf) {
                    this.openGraphPropertiesLabelMouseClicked(null);
                }
                this.pendingSettings = false;
            } else {
                this.pendingSettings = true;
            }
        }
        this.first = false;
    }

    private double getMax() {
        double max = 1.0;
        Iterator iter = this.graphCanvas.getGraphs().iterator();
        while (iter.hasNext()) {
            Graph g = (Graph)iter.next();
            double ymax = g.getYmax();
            if (!(ymax > max)) continue;
            max = ymax;
        }
        return max;
    }

    public void addGraph(Graph graph) {
        this.addGraph(graph, true);
    }

    public void enablePlotToolbar(boolean enabled) {
        this.plotControlWidgets.setEnabled(enabled);
        this.selectToolButton.setEnabled(enabled);
        this.infoToolButton.setEnabled(enabled);
        this.graphsCombobox.setEnabled(enabled);
        this.navigationLabel.setEnabled(enabled);
        this.selectionLabel.setEnabled(enabled);
        this.selectedObjectLabel.setEnabled(enabled);
        this.plotWidthPlusBtn.setEnabled(enabled);
        this.plotWidthMinusBtn.setEnabled(enabled);
        this.removeObjectBtn.setEnabled(enabled);
        this.plotZoomMenu.setEnabled(enabled);
        if (!enabled) {
            if (this.graphCanvas.getAnnotations().size() == 0) {
                this.plotAnnotationsMenu.setEnabled(enabled);
            }
        } else {
            this.plotAnnotationsMenu.setEnabled(enabled);
        }
        this.plotGraphsMenu.setEnabled(enabled);
        this.plotFillPanel.setEnabled(enabled);
        this.editMenu.setEnabled(enabled);
        this.saveSelectedMenuItem.setEnabled(enabled);
        this.saveFigMenuItem.setEnabled(enabled);
        this.printFigMenuItem.setEnabled(enabled);
        this.pageSetupMenuItem.setEnabled(enabled);
        this.toFitBtn.setEnabled(enabled);
    }

    private void addTextDialog(int x, int y) {
        this.addTextDialog(x, y, null, null, null);
    }

    private void addTextAnnotation() {
        if (!this.field.getText().equals("")) {
            this.graphCanvas.addAnnotation(this.field.getForeground());
            this.graphCanvas.addAnnotation(this.field.getFont());
            this.lastUserFont = this.field.getFont();
            String text = this.field.getText();
            this.graphCanvas.addAnnotation(text);
            if (this.toolCoordinates == 2) {
                double[] loc = new double[]{this.ax, this.ay};
                this.graphCanvas.addAnnotation(loc);
            } else {
                int[] loc = new int[]{this.ox, this.oy};
                this.graphCanvas.addAnnotation(loc);
            }
            this.isEditing = false;
            this.tdialog.dispose();
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        } else {
            this.isEditing = false;
            this.tdialog.dispose();
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        }
    }

    private void addTextDialog(int x, int y, String msg, Font f, Color c) {
        this.toolDisabled = true;
        this.disableAllTools();
        if (this.tdialog != null && this.tdialog.isShowing()) {
            return;
        }
        this.anfont = null;
        this.ox = x;
        this.oy = y;
        String orig = msg;
        this.tdialog = new JDialog(JOptionPane.getFrameForComponent(this));
        this.field = new JTextArea();
        this.field.setLineWrap(false);
        if (f != null) {
            this.field.setFont(f);
        } else if (this.lastUserFont != null) {
            this.field.setFont(this.lastUserFont);
        }
        try {
            if (msg != null) {
                this.field.getDocument().insertString(0, msg, null);
            } else {
                this.field.setText("");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (c != null) {
            this.field.setForeground(c);
        }
        this.field.setBackground(Color.lightGray);
        this.ax = this.graphCanvas.getAxis().getValueForAxisCoordinate(x - this.graphCanvas.getXInset(), 0);
        int al = this.graphCanvas.getAxis().getLocation().y;
        this.ay = this.graphCanvas.getAxis().getValueForAxisCoordinate(al - y, 1);
        this.tdialog.getContentPane().setLayout(new FlowLayout(0, 0, 0));
        this.tdialog.getContentPane().setBackground(Color.white);
        final JButton font = new JButton();
        final JButton color = new JButton();
        font.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/FontIcon.png")));
        color.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/FontColorIcon.png")));
        int offs = 0;
        int maxlen = 1;
        try {
            for (int i = 0; i < this.field.getLineCount(); ++i) {
                int coffs = this.field.getLineStartOffset(i);
                int len = coffs - offs;
                if (len > maxlen) {
                    maxlen = len;
                }
                offs = coffs;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.field.setColumns(maxlen + 1);
        this.field.setMaximumSize(new Dimension(100000, 100000));
        this.field.setSize(this.field.getWidth(), font.getHeight());
        this.field.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                PlotPanel.this.tdialog.invalidate();
                int offs = 0;
                int maxlen = -1;
                try {
                    for (int i = 0; i < PlotPanel.this.field.getLineCount(); ++i) {
                        int coffs = PlotPanel.this.field.getLineStartOffset(i);
                        int len = PlotPanel.this.field.getLineEndOffset(i) - PlotPanel.this.field.getLineStartOffset(i);
                        if (len > maxlen) {
                            maxlen = len;
                        }
                        offs = coffs;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (maxlen > 0) {
                    PlotPanel.this.field.setColumns(maxlen);
                }
                PlotPanel.this.tdialog.pack();
                PlotPanel.this.tdialog.validate();
                if (e.getKeyCode() == 27) {
                    if (!PlotPanel.this.isEditing) {
                        PlotPanel.this.tdialog.dispose();
                        PlotPanel.this.isEditing = false;
                    } else {
                        if (PlotPanel.this.field.getText().equals("")) {
                            PlotPanel.this.graphCanvas.refresh();
                            PlotPanel.this.graphCanvas.repaint();
                            PlotPanel.this.toolDisabled = true;
                            PlotPanel.this.prev = null;
                            PlotPanel.this.activateTool(PlotPanel.this.prevTool);
                            PlotPanel.this.isEditing = false;
                            return;
                        }
                        PlotPanel.this.addTextAnnotation();
                        PlotPanel.this.toolDisabled = true;
                        PlotPanel.this.prev = null;
                        PlotPanel.this.isEditing = false;
                        PlotPanel.this.activateTool(PlotPanel.this.prevTool);
                        PlotPanel.this.tdialog.dispose();
                    }
                    PlotPanel.this.graphCanvas.refresh();
                    PlotPanel.this.graphCanvas.repaint();
                }
            }
        });
        font.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotPanel.this.toolDisabled = true;
                JFontChooser chooser = new JFontChooser();
                chooser.setSelectedFont(PlotPanel.this.field.getFont());
                int retval = chooser.showDialog(PlotPanel.this.graphCanvas);
                if (retval == 0) {
                    PlotPanel.this.anfont = chooser.getSelectedFont();
                    PlotPanel.this.field.setFont(PlotPanel.this.anfont);
                    PlotPanel.this.lastUserFont = chooser.getSelectedFont();
                }
                PlotPanel.this.field.grabFocus();
            }
        });
        color.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotPanel.this.toolDisabled = true;
                if (PlotPanel.this.jcc == null) {
                    PlotPanel.this.jcc = new JColorChooser();
                }
                PlotPanel.this.dialog = JColorChooser.createDialog(PlotPanel.this.colorPanel, "Graph color", true, PlotPanel.this.jcc, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        (this).PlotPanel.this.field.setForeground((this).PlotPanel.this.jcc.getColor());
                        (this).PlotPanel.this.field.grabFocus();
                    }
                }, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        (this).PlotPanel.this.field.grabFocus();
                    }
                });
                PlotPanel.this.dialog.show();
            }
        });
        this.field.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent evnt) {
                Component c = evnt.getOppositeComponent();
                if (c == font || c == color) {
                    return;
                }
                PlotPanel.this.enableAllTools();
                PlotPanel.this.isClick = false;
                PlotPanel.this.addTextAnnotation();
                PlotPanel.this.activateTool(PlotPanel.this.prevTool);
                PlotPanel.this.toolDisabled = true;
                PlotPanel.this.prev = null;
                PlotPanel.this.isEditing = false;
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.tdialog.setTitle("Add text");
        this.tdialog.getContentPane().add((Component)this.field, "West");
        this.tdialog.getContentPane().add((Component)font, "Center");
        this.tdialog.getContentPane().add((Component)color, "East");
        Point pt = new Point(x, y);
        SwingUtilities.convertPointToScreen(pt, this.graphCanvas);
        this.field.setOpaque(true);
        this.tdialog.setUndecorated(true);
        this.tdialog.pack();
        this.tdialog.setLocation(pt.x, pt.y - this.tdialog.getHeight() / 2);
        this.tdialog.show();
    }

    private void disableAllTools() {
        this.selectButton.setEnabled(false);
        this.selectButton1.setEnabled(false);
        this.addLineButton.setEnabled(false);
        this.addTextButton.setEnabled(false);
        this.addLineTagButton.setEnabled(false);
        this.addTextTagButton.setEnabled(false);
        this.zoomButton.setEnabled(false);
        this.panButton.setEnabled(false);
        this.evalButton.setEnabled(false);
    }

    private void enableAllTools() {
        this.selectButton.setEnabled(true);
        this.selectButton1.setEnabled(true);
        this.addLineButton.setEnabled(true);
        this.addTextButton.setEnabled(true);
        this.addLineTagButton.setEnabled(true);
        this.addTextTagButton.setEnabled(true);
        this.zoomButton.setEnabled(true);
        this.panButton.setEnabled(true);
        this.evalButton.setEnabled(true);
    }

    private void deleteSelectedObject() {
        if (this.selectedObj == null) {
            return;
        }
        List l = this.graphCanvas.getAnnotations();
        int index = l.indexOf(this.selectedObj);
        if (this.selectedObj instanceof String) {
            l.remove(index - 2);
            l.remove(index - 2);
            l.remove(index - 2);
            l.remove(index - 2);
        } else if (this.selectedObj instanceof Image) {
            l.remove(index);
            l.remove(index);
        } else if (this.selectedObj instanceof double[] || this.selectedObj instanceof int[]) {
            l.remove(index);
        }
        this.toolDisabled = true;
        this.prev = null;
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
        this.selectedObj = null;
    }

    private int getScreenX(double dx) {
        int xi = this.graphCanvas.getXInset();
        int x = xi + (int)this.graphCanvas.getAxis().getAxisCoordinateForValue(dx, 0);
        return x;
    }

    private int getScreenY(double vy) {
        int yi = this.graphCanvas.getYInset();
        int h = this.graphCanvas.getHeight();
        int y = h - yi - (int)this.graphCanvas.getAxis().getAxisCoordinateForValue(vy, 1);
        return y;
    }

    private double getValue(int y) {
        Axis a = this.graphCanvas.getAxis();
        int ay = this.graphCanvas.getHeight() - this.graphCanvas.getYInset() - y;
        return a.getValueForAxisCoordinate(ay, 1);
    }

    public Graph getSelectedGraph() {
        Object key = this.graphsCombobox.getSelectedItem();
        if (key == null) {
            return null;
        }
        return (Graph)this.graphs.get(key);
    }

    private double getDomain(int x) {
        Axis a = this.graphCanvas.getAxis();
        return a.getValueForAxisCoordinate(x - this.graphCanvas.getXInset(), 0);
    }

    private void initComponents() {
        this.rangeGroup = new ButtonGroup();
        this.typeGroup = new ButtonGroup();
        this.rangeGroup1 = new ButtonGroup();
        this.typeGroup1 = new ButtonGroup();
        this.toolsGroup = new ButtonGroup();
        this.csButtonGroup = new ButtonGroup();
        this.jDesktopPane1 = new JDesktopPane();
        this.simulationPlotFrame = new JInternalFrame();
        this.jMenuBar1 = new JMenuBar();
        this.plotFileMenu = new JMenu();
        this.openGraphMenuItem = new JMenuItem();
        this.jSeparator12 = new JSeparator();
        this.saveSelectedMenuItem = new JMenuItem();
        this.jSeparator16 = new JSeparator();
        this.saveFigMenuItem = new JMenuItem();
        this.batchConvertMenuItem = new JMenuItem();
        this.jSeparator11 = new JSeparator();
        this.printFigMenuItem = new JMenuItem();
        this.pageSetupMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.copyExcel = new JMenuItem();
        this.copyMatlab = new JMenuItem();
        this.plotViewMenu = new JMenu();
        this.viewPropertiesPaneItem = new JCheckBoxMenuItem();
        this.viewNavigationMenuItem = new JCheckBoxMenuItem();
        this.plotZoomMenu = new JMenu();
        this.zoomAllMenuItem = new JMenuItem();
        this.jSeparator13 = new JSeparator();
        this.zoomInMenuItem = new JMenuItem();
        this.zoomOutMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.panRightItem = new JMenuItem();
        this.panLeftItem = new JMenuItem();
        this.plotGraphsMenu = new JMenu();
        this.deleteAllGraphs = new JMenuItem();
        this.deleteGraphMenuItem = new JMenuItem();
        this.jSeparator14 = new JSeparator();
        this.toFrontItem = new JMenuItem();
        this.toBackItem = new JMenuItem();
        this.jSeparator15 = new JSeparator();
        this.selectNextItem = new JMenuItem();
        this.selectPrevItem = new JMenuItem();
        this.plotAnnotationsMenu = new JMenu();
        this.addTextMenuItem = new JMenuItem();
        this.addLineMenuItem = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.addTextTagMenuItem = new JMenuItem();
        this.addLineTagMenuItem = new JMenuItem();
        this.jSeparator10 = new JSeparator();
        this.removeSelectedAnnotationMenuItem = new JMenuItem();
        this.removeAllAnnotationsMenuItem = new JMenuItem();
        this.jPanel7 = new JPanel();
        this.jPanel4 = new JPanel();
        this.selectionLabel = new JLabel();
        this.selectToolButton = new JToggleButton();
        this.infoToolButton = new JToggleButton();
        this.jSeparator8 = new JSeparator();
        this.navigationLabel = new JLabel();
        this.plotControlWidgets = new MiniControlWidgets();
        this.jSeparator1 = new JSeparator();
        this.selectedObjectLabel = new JLabel();
        this.graphsCombobox = new JComboBox();
        this.plotColorPanel = new JPanel();
        this.plotFillPanel = new JPanel();
        this.plotWidthPlusBtn = new JLabel();
        this.plotWidthMinusBtn = new JLabel();
        this.removeObjectBtn = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.toFitBtn = new JToggleButton();
        this.graphCanvas = new GraphCanvas();
        this.northPanel = new JPanel();
        this.jToolBar3 = new JToolBar();
        this.openBtn = new JButton();
        this.saveBtn = new JButton();
        this.printBtn = new JButton();
        this.pageSetupBtn = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jToolBar2 = new JToolBar();
        this.zoomButton = new JToggleButton();
        this.panButton = new JToggleButton();
        this.evalButton = new JToggleButton();
        this.jSeparator5 = new JSeparator();
        this.jToolBar1 = new JToolBar();
        this.addTextButton = new JToggleButton();
        this.addLineButton = new JToggleButton();
        this.addTextTagButton = new JToggleButton();
        this.addLineTagButton = new JToggleButton();
        this.jSeparator7 = new JSeparator();
        this.selectButton = new JToggleButton();
        this.selectButton1 = new JToggleButton();
        this.jSeparator6 = new JSeparator();
        this.antialiasingCheckbox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.rightPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.xRangeButton = new JRadioButton();
        this.xRangeAutoButton = new JRadioButton();
        this.xMinField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.xMaxField = new JTextField();
        this.jLabel3 = new JLabel();
        this.xRangeLabel = new HeaderLabel();
        this.yRangeButton = new JRadioButton();
        this.yRangeAutoButton = new JRadioButton();
        this.jLabel9 = new JLabel();
        this.yMinField = new JTextField();
        this.jLabel8 = new JLabel();
        this.yMaxField = new JTextField();
        this.jLabel7 = new JLabel();
        this.yRangeLabel = new HeaderLabel();
        this.yRangeLabel1 = new HeaderLabel();
        this.graphsCombobox1 = new JComboBox();
        this.shelf = new Shelf();
        this.drawer1 = new Drawer();
        this.jPanel1 = new JPanel();
        this.xAxisTitleField = new JTextField();
        this.xTicsCheckbox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.xAxisLinear = new JRadioButton();
        this.xAxisLog = new JRadioButton();
        this.redoTicsX = new JButton();
        this.xTitleFontBtn = new JButton();
        this.redoTicsX1 = new JButton();
        this.jLabel10 = new JLabel();
        this.expandXPanel = new JPanel();
        this.openXPropertiesLabel = new widgets.HeaderLabel();
        this.headerLabel1 = new widgets.HeaderLabel();
        this.drawer2 = new Drawer();
        this.jPanel5 = new JPanel();
        this.yAxisTitleField = new JTextField();
        this.yTicsCheckbox = new JCheckBox();
        this.jLabel11 = new JLabel();
        this.yAxisLinear = new JRadioButton();
        this.yAxisLog = new JRadioButton();
        this.redoTicsY = new JButton();
        this.yTitleFontBtn = new JButton();
        this.redoTicsY1 = new JButton();
        this.jLabel5 = new JLabel();
        this.expandYPanel = new JPanel();
        this.openYPropertiesLabel = new widgets.HeaderLabel();
        this.headerLabel4 = new widgets.HeaderLabel();
        this.drawer3 = new Drawer();
        this.jPanel6 = new JPanel();
        this.colorPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.deleteGraphButton = new JButton();
        this.graphTitleField = new JTextField();
        this.jLabel12 = new JLabel();
        this.toFrontBtn = new JButton();
        this.widthField = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.correction = new JLabel();
        this.correctionField = new JTextField();
        this.width = new JLabel();
        this.width2 = new JLabel();
        this.correction2 = new JLabel();
        this.toFrontBtn1 = new JButton();
        this.toFitBtn2 = new JButton();
        this.expandGraphPanel = new JPanel();
        this.openGraphPropertiesLabel = new widgets.HeaderLabel();
        this.headerLabel6 = new widgets.HeaderLabel();
        this.setLayout(new BorderLayout());
        this.simulationPlotFrame.setIconifiable(true);
        this.simulationPlotFrame.setMaximizable(true);
        this.simulationPlotFrame.setResizable(true);
        this.simulationPlotFrame.setTitle("Simulation plot");
        this.simulationPlotFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/SpectrumIcon.png")));
        this.simulationPlotFrame.setVisible(true);
        this.plotFileMenu.setText("File");
        this.openGraphMenuItem.setText("Open...");
        this.openGraphMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.openGraphMenuItemActionPerformed(evt);
            }
        });
        this.plotFileMenu.add(this.openGraphMenuItem);
        this.plotFileMenu.add(this.jSeparator12);
        this.saveSelectedMenuItem.setText("Save selected spectrum...");
        this.saveSelectedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.saveSelectedMenuItemActionPerformed(evt);
            }
        });
        this.plotFileMenu.add(this.saveSelectedMenuItem);
        this.plotFileMenu.add(this.jSeparator16);
        this.saveFigMenuItem.setText("Save plot as figure...");
        this.saveFigMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.saveFigMenuItemActionPerformed(evt);
            }
        });
        this.plotFileMenu.add(this.saveFigMenuItem);
        this.batchConvertMenuItem.setText("Batch convert...");
        this.batchConvertMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.batchConvertMenuItemActionPerformed(evt);
            }
        });
        this.plotFileMenu.add(this.batchConvertMenuItem);
        this.plotFileMenu.add(this.jSeparator11);
        this.printFigMenuItem.setText("Print...");
        this.printFigMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.printFigMenuItemActionPerformed(evt);
            }
        });
        this.plotFileMenu.add(this.printFigMenuItem);
        this.pageSetupMenuItem.setText("Page setup & preview...");
        this.pageSetupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.pageSetupMenuItemActionPerformed(evt);
            }
        });
        this.plotFileMenu.add(this.pageSetupMenuItem);
        this.jMenuBar1.add(this.plotFileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.setEnabled(false);
        this.editMenu.setMnemonic('E');
        this.copyExcel.setText("Copy selected graph in Excel format");
        this.copyExcel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.copyExcelActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyExcel);
        this.copyMatlab.setText("Copy selected graph in Matlab format");
        this.copyMatlab.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.copyMatlabActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyMatlab);
        this.jMenuBar1.add(this.editMenu);
        this.plotViewMenu.setText("View");
        this.viewPropertiesPaneItem.setSelected(true);
        this.viewPropertiesPaneItem.setText("Show properties pane");
        this.viewPropertiesPaneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.viewPropertiesPaneItemActionPerformed(evt);
            }
        });
        this.plotViewMenu.add(this.viewPropertiesPaneItem);
        this.viewNavigationMenuItem.setSelected(true);
        this.viewNavigationMenuItem.setText("Show toolbar");
        this.viewNavigationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.viewNavigationMenuItemActionPerformed(evt);
            }
        });
        this.plotViewMenu.add(this.viewNavigationMenuItem);
        this.jMenuBar1.add(this.plotViewMenu);
        this.plotZoomMenu.setText("Zoom");
        this.plotZoomMenu.setEnabled(false);
        this.zoomAllMenuItem.setText("Zoom all");
        this.zoomAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.zoomAllMenuItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.zoomAllMenuItem);
        this.plotZoomMenu.add(this.jSeparator13);
        this.zoomInMenuItem.setText("Zoom in");
        this.zoomInMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.zoomInMenuItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.zoomInMenuItem);
        this.zoomOutMenuItem.setText("Zoom out");
        this.zoomOutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.zoomOutMenuItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.zoomOutMenuItem);
        this.plotZoomMenu.add(this.jSeparator2);
        this.panRightItem.setText("Pan right");
        this.panRightItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.panRightItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.panRightItem);
        this.panLeftItem.setText("Pan left");
        this.panLeftItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.panLeftItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.panLeftItem);
        this.jMenuBar1.add(this.plotZoomMenu);
        this.plotGraphsMenu.setText("Graphs");
        this.plotGraphsMenu.setEnabled(false);
        this.deleteAllGraphs.setText("Remove all graphs");
        this.deleteAllGraphs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.deleteAllGraphsActionPerformed(evt);
            }
        });
        this.plotGraphsMenu.add(this.deleteAllGraphs);
        this.deleteGraphMenuItem.setText("Remove selected graph");
        this.deleteGraphMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.deleteGraphMenuItemActionPerformed(evt);
            }
        });
        this.plotGraphsMenu.add(this.deleteGraphMenuItem);
        this.plotGraphsMenu.add(this.jSeparator14);
        this.toFrontItem.setText("Bring to front");
        this.toFrontItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.toFrontItemActionPerformed(evt);
            }
        });
        this.plotGraphsMenu.add(this.toFrontItem);
        this.toBackItem.setText("Send to back");
        this.toBackItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.toBackItemActionPerformed(evt);
            }
        });
        this.plotGraphsMenu.add(this.toBackItem);
        this.plotGraphsMenu.add(this.jSeparator15);
        this.selectNextItem.setText("Select next graph");
        this.selectNextItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.selectNextItemActionPerformed(evt);
            }
        });
        this.plotGraphsMenu.add(this.selectNextItem);
        this.selectPrevItem.setText("Select previous graph");
        this.selectPrevItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.selectPrevItemActionPerformed(evt);
            }
        });
        this.plotGraphsMenu.add(this.selectPrevItem);
        this.jMenuBar1.add(this.plotGraphsMenu);
        this.plotAnnotationsMenu.setText("Annotations");
        this.plotAnnotationsMenu.setEnabled(false);
        this.addTextMenuItem.setText("Add text");
        this.addTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.addTextMenuItemActionPerformed(evt);
            }
        });
        this.plotAnnotationsMenu.add(this.addTextMenuItem);
        this.addLineMenuItem.setText("Add line");
        this.addLineMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.addLineMenuItemActionPerformed(evt);
            }
        });
        this.plotAnnotationsMenu.add(this.addLineMenuItem);
        this.plotAnnotationsMenu.add(this.jSeparator9);
        this.addTextTagMenuItem.setText("Add text tag");
        this.addTextTagMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.addTextTagMenuItemActionPerformed(evt);
            }
        });
        this.plotAnnotationsMenu.add(this.addTextTagMenuItem);
        this.addLineTagMenuItem.setText("Add line tag");
        this.addLineTagMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.addLineTagMenuItemActionPerformed(evt);
            }
        });
        this.plotAnnotationsMenu.add(this.addLineTagMenuItem);
        this.plotAnnotationsMenu.add(this.jSeparator10);
        this.removeSelectedAnnotationMenuItem.setText("Remove selected annotation");
        this.removeSelectedAnnotationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.removeSelectedAnnotationMenuItemActionPerformed(evt);
            }
        });
        this.plotAnnotationsMenu.add(this.removeSelectedAnnotationMenuItem);
        this.removeAllAnnotationsMenuItem.setText("Remove all annotations");
        this.removeAllAnnotationsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.removeAllAnnotationsMenuItemActionPerformed(evt);
            }
        });
        this.plotAnnotationsMenu.add(this.removeAllAnnotationsMenuItem);
        this.jMenuBar1.add(this.plotAnnotationsMenu);
        this.simulationPlotFrame.getContentPane().add((Component)this.jMenuBar1, "Center");
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setLayout(new FlowLayout(0, 2, 0));
        this.selectionLabel.setText("Selection:");
        this.selectionLabel.setEnabled(false);
        this.selectionLabel.setOpaque(true);
        this.jPanel4.add(this.selectionLabel);
        this.selectToolButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SelectSmall.png")));
        this.selectToolButton.setToolTipText("Selection tool, use to select annotations or graphs.");
        this.selectToolButton.setEnabled(false);
        this.selectToolButton.setFocusPainted(false);
        this.selectToolButton.setFocusable(false);
        this.selectToolButton.setPreferredSize(new Dimension(22, 18));
        this.selectToolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.selectToolButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.selectToolButton);
        this.infoToolButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/CursorSmall.png")));
        this.infoToolButton.setToolTipText("Info tool. Display counts and energy at mouse cursor.");
        this.infoToolButton.setEnabled(false);
        this.infoToolButton.setFocusPainted(false);
        this.infoToolButton.setFocusable(false);
        this.infoToolButton.setPreferredSize(new Dimension(22, 18));
        this.infoToolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.infoToolButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.infoToolButton);
        this.jSeparator8.setOrientation(1);
        this.jSeparator8.setPreferredSize(new Dimension(4, 16));
        this.jPanel4.add(this.jSeparator8);
        this.navigationLabel.setText("Navigation:");
        this.navigationLabel.setEnabled(false);
        this.jPanel4.add(this.navigationLabel);
        this.plotControlWidgets.setEnabled(false);
        this.plotControlWidgets.setCanvas(this.graphCanvas);
        this.plotControlWidgets.constrainToPositive(true, true);
        this.plotControlWidgets.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.plotControlWidgetsMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.plotControlWidgets);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setPreferredSize(new Dimension(4, 16));
        this.jPanel4.add(this.jSeparator1);
        this.selectedObjectLabel.setText("Selected spectrum:");
        this.selectedObjectLabel.setEnabled(false);
        this.jPanel4.add(this.selectedObjectLabel);
        this.graphsCombobox.setToolTipText("Select a spectrum to edit");
        this.graphsCombobox.setEnabled(false);
        this.graphsCombobox.setPreferredSize(new Dimension(125, 19));
        this.graphsCombobox.setRenderer(new ColorComboboxRenderer());
        this.graphsCombobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.graphsComboboxActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.graphsCombobox);
        this.plotColorPanel.setBackground(new Color(207, 204, 189));
        this.plotColorPanel.setToolTipText("Choose the color of the selected spectrum");
        this.plotColorPanel.setPreferredSize(new Dimension(12, 12));
        this.plotColorPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.plotColorPanelMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.plotColorPanel);
        this.plotFillPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.plotFillPanel.setToolTipText("Fill the spectrum");
        this.plotFillPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.plotFillPanelMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.plotFillPanel);
        this.plotWidthPlusBtn.setBackground(new Color(102, 102, 102));
        this.plotWidthPlusBtn.setForeground(new Color(255, 255, 255));
        this.plotWidthPlusBtn.setHorizontalAlignment(0);
        this.plotWidthPlusBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/PlusSmall.png")));
        this.plotWidthPlusBtn.setToolTipText("Increase line width");
        this.plotWidthPlusBtn.setEnabled(false);
        this.plotWidthPlusBtn.setPreferredSize(new Dimension(12, 16));
        this.plotWidthPlusBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.plotWidthPlusBtnMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.plotWidthPlusBtn);
        this.plotWidthMinusBtn.setBackground(new Color(102, 102, 102));
        this.plotWidthMinusBtn.setForeground(new Color(255, 255, 255));
        this.plotWidthMinusBtn.setHorizontalAlignment(0);
        this.plotWidthMinusBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/MinusSmall.png")));
        this.plotWidthMinusBtn.setToolTipText("Decrease line width");
        this.plotWidthMinusBtn.setEnabled(false);
        this.plotWidthMinusBtn.setPreferredSize(new Dimension(12, 16));
        this.plotWidthMinusBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.plotWidthMinusBtnMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.plotWidthMinusBtn);
        this.removeObjectBtn.setBackground(new Color(102, 102, 102));
        this.removeObjectBtn.setForeground(new Color(255, 255, 255));
        this.removeObjectBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/DeleteSmall2.png")));
        this.removeObjectBtn.setToolTipText("Remove the currently selected graph");
        this.removeObjectBtn.setEnabled(false);
        this.removeObjectBtn.setPreferredSize(new Dimension(18, 16));
        this.removeObjectBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.removeObjectBtnMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.removeObjectBtn);
        this.jSeparator4.setOrientation(1);
        this.jSeparator4.setPreferredSize(new Dimension(4, 16));
        this.jPanel4.add(this.jSeparator4);
        this.toFitBtn.setText("To fitting as target");
        this.toFitBtn.setContentAreaFilled(false);
        this.toFitBtn.setEnabled(false);
        this.toFitBtn.setOpaque(true);
        this.toFitBtn.setPreferredSize(new Dimension(0, 20));
        this.toFitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.toFitBtnActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.toFitBtn);
        this.jPanel7.add((Component)this.jPanel4, "South");
        this.graphCanvas.setBackground(new Color(255, 255, 255));
        Axis a = new Axis();
        a.setSize(this.graphCanvas.getWidth(), this.graphCanvas.getHeight());
        this.graphCanvas.setAxis(a);
        this.graphCanvas.setAntialiasingEnabled(false);
        this.graphCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                PlotPanel.this.graphCanvas_handleMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                PlotPanel.this.graphCanvasMouseMoved(evt);
            }
        });
        this.graphCanvas.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                PlotPanel.this.graphCanvasKeyPressed(evt);
            }
        });
        this.graphCanvas.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.graphCanvas_handleMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                PlotPanel.this.graphCanvasMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                PlotPanel.this.graphCanvas_handleMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                PlotPanel.this.graphCanvas_handleMouseReleased(evt);
            }
        });
        this.jPanel7.add((Component)this.graphCanvas, "Center");
        this.northPanel.setPreferredSize(new Dimension(1178, 1));
        this.northPanel.setLayout(new FlowLayout(0));
        this.jToolBar3.setFloatable(false);
        this.openBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/OpenIcon.png")));
        this.openBtn.setText("Open");
        this.openBtn.setToolTipText("Open a graph file and add the graph to the spectrums list.");
        this.openBtn.setBorderPainted(false);
        this.openBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.openBtnActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.openBtn);
        this.saveBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SaveIcon.png")));
        this.saveBtn.setText("Save");
        this.saveBtn.setToolTipText("Save the selected graph into a file.");
        this.saveBtn.setBorderPainted(false);
        this.saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.saveBtnActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.saveBtn);
        this.printBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/PrintIcon.png")));
        this.printBtn.setText("Print");
        this.printBtn.setToolTipText("Save the selected graph into a file.");
        this.printBtn.setBorderPainted(false);
        this.printBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.printBtnActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.printBtn);
        this.pageSetupBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/PageSetupIcon.png")));
        this.pageSetupBtn.setText("Page setup");
        this.pageSetupBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.pageSetupBtnActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.pageSetupBtn);
        this.northPanel.add(this.jToolBar3);
        this.jSeparator3.setOrientation(1);
        this.jSeparator3.setPreferredSize(new Dimension(6, 20));
        this.northPanel.add(this.jSeparator3);
        this.jToolBar2.setFloatable(false);
        this.toolsGroup.add(this.zoomButton);
        this.zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/ZoomIcon.png")));
        this.zoomButton.setText("Zoom");
        this.zoomButton.setToolTipText("Zoom tool. Zooms the view of the graph in and out. (left / right mouse button)");
        this.zoomButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.zoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.zoomButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.zoomButton);
        this.toolsGroup.add(this.panButton);
        this.panButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/HandIcon.png")));
        this.panButton.setText("Pan");
        this.panButton.setToolTipText("Pan tool. Pans the view of the graph.");
        this.panButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.panButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.panButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.panButton);
        this.toolsGroup.add(this.evalButton);
        this.evalButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/CursorIcon.png")));
        this.evalButton.setText("Cursor");
        this.evalButton.setToolTipText("Cursor tool. Displays values in the graph.");
        this.evalButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.evalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.evalButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.evalButton);
        this.northPanel.add(this.jToolBar2);
        this.jSeparator5.setOrientation(1);
        this.jSeparator5.setPreferredSize(new Dimension(6, 20));
        this.northPanel.add(this.jSeparator5);
        this.jToolBar1.setFloatable(false);
        this.toolsGroup.add(this.addTextButton);
        this.addTextButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/TextIcon.png")));
        this.addTextButton.setText("Add text object");
        this.addTextButton.setToolTipText("Text tool. Adds text.");
        this.addTextButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addTextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.addTextButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addTextButton);
        this.toolsGroup.add(this.addLineButton);
        this.addLineButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/LineIcon.png")));
        this.addLineButton.setText("Add line object ");
        this.addLineButton.setToolTipText("Line tool. Adds lines.");
        this.addLineButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addLineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.addLineButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addLineButton);
        this.toolsGroup.add(this.addTextTagButton);
        this.addTextTagButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/TextTagIcon.png")));
        this.addTextTagButton.setText("Add text tag object ");
        this.addTextTagButton.setToolTipText("Adds a text tag into the plot range.");
        this.addTextTagButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addTextTagButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.addTextTagButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addTextTagButton);
        this.toolsGroup.add(this.addLineTagButton);
        this.addLineTagButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/LineTagIcon.png")));
        this.addLineTagButton.setText("Add line tag object ");
        this.addLineTagButton.setToolTipText("Adds a line tag into the plot range.");
        this.addLineTagButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addLineTagButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.addLineTagButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addLineTagButton);
        this.jSeparator7.setOrientation(1);
        this.jSeparator7.setPreferredSize(new Dimension(6, 20));
        this.jToolBar1.add(this.jSeparator7);
        this.toolsGroup.add(this.selectButton);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SelectIcon.png")));
        this.selectButton.setText("Edit object");
        this.selectButton.setToolTipText("Select and edit objects such as lines, text and tags.");
        this.selectButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.selectButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.selectButton);
        this.toolsGroup.add(this.selectButton1);
        this.selectButton1.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/EraseIcon.png")));
        this.selectButton1.setText("Erase object");
        this.selectButton1.setToolTipText("Erase objects, such as lines, text and tags.");
        this.selectButton1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.selectButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.selectButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.selectButton1);
        this.northPanel.add(this.jToolBar1);
        this.jSeparator6.setOrientation(1);
        this.jSeparator6.setPreferredSize(new Dimension(6, 20));
        this.northPanel.add(this.jSeparator6);
        this.antialiasingCheckbox.setText("Antialiasing");
        this.antialiasingCheckbox.setToolTipText("Toggles antialiasing.");
        this.antialiasingCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.antialiasingCheckboxActionPerformed(evt);
            }
        });
        this.northPanel.add(this.antialiasingCheckbox);
        this.jPanel7.add((Component)this.northPanel, "North");
        this.jScrollPane1.setMinimumSize(new Dimension(225, 23));
        this.jScrollPane1.setPreferredSize(new Dimension(225, 852));
        this.rightPanel.setAutoscrolls(true);
        this.rightPanel.setMinimumSize(new Dimension(220, 650));
        this.rightPanel.setPreferredSize(new Dimension(220, 750));
        this.rightPanel.setLayout(new TileLayout());
        this.rightPanel.setLayout(new fi.stuk.ui.TileLayout());
        this.jPanel3.setMinimumSize(new Dimension(200, 190));
        this.jPanel3.setPreferredSize(new Dimension(200, 190));
        this.jPanel3.setLayout(new AbsoluteLayout());
        this.rangeGroup.add(this.xRangeButton);
        this.xRangeButton.setText("Range");
        this.xRangeButton.setToolTipText("Specify the range of x-axis to display");
        this.xRangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.xRangeButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.xRangeButton, new AbsoluteConstraints(10, 30, -1, 20));
        this.rangeGroup.add(this.xRangeAutoButton);
        this.xRangeAutoButton.setSelected(true);
        this.xRangeAutoButton.setText("Auto");
        this.xRangeAutoButton.setToolTipText("Automatically determine the range to display.");
        this.xRangeAutoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.xRangeAutoButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.xRangeAutoButton, new AbsoluteConstraints(10, 50, -1, 20));
        this.xMinField.setBackground(new Color(255, 255, 254));
        this.xMinField.setHorizontalAlignment(0);
        this.xMinField.setText("min");
        this.xMinField.setToolTipText("The lower bound of the display range");
        this.xMinField.setEnabled(false);
        this.xMinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.xMinFieldActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.xMinField, new AbsoluteConstraints(70, 30, 50, -1));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("[");
        this.jPanel3.add((Component)this.jLabel2, new AbsoluteConstraints(60, 30, 10, 20));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(",");
        this.jPanel3.add((Component)this.jLabel4, new AbsoluteConstraints(120, 30, 10, 20));
        this.xMaxField.setBackground(new Color(255, 255, 254));
        this.xMaxField.setHorizontalAlignment(0);
        this.xMaxField.setText("max");
        this.xMaxField.setToolTipText("The upper bound of the display range");
        this.xMaxField.setEnabled(false);
        this.xMaxField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.xMaxFieldActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.xMaxField, new AbsoluteConstraints(130, 30, 50, -1));
        this.jLabel3.setHorizontalAlignment(2);
        this.jLabel3.setText("]");
        this.jPanel3.add((Component)this.jLabel3, new AbsoluteConstraints(180, 30, 10, 20));
        this.xRangeLabel.setText(" X-Axis plot range");
        this.jPanel3.add((Component)this.xRangeLabel, new AbsoluteConstraints(10, 10, 180, -1));
        this.rangeGroup1.add(this.yRangeButton);
        this.yRangeButton.setText("Range");
        this.yRangeButton.setToolTipText("Specify the range of y-axis to display");
        this.yRangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.yRangeButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.yRangeButton, new AbsoluteConstraints(10, 90, -1, 20));
        this.rangeGroup1.add(this.yRangeAutoButton);
        this.yRangeAutoButton.setSelected(true);
        this.yRangeAutoButton.setText("Auto");
        this.yRangeAutoButton.setToolTipText("Automatically determine the range to display.");
        this.yRangeAutoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.yRangeAutoButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.yRangeAutoButton, new AbsoluteConstraints(10, 110, -1, 20));
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("[");
        this.jPanel3.add((Component)this.jLabel9, new AbsoluteConstraints(60, 90, 10, 20));
        this.yMinField.setBackground(new Color(255, 255, 254));
        this.yMinField.setHorizontalAlignment(0);
        this.yMinField.setText("min");
        this.yMinField.setToolTipText("The lower bound of the display range");
        this.yMinField.setEnabled(false);
        this.yMinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.yMinFieldActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.yMinField, new AbsoluteConstraints(70, 90, 50, 20));
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText(",");
        this.jPanel3.add((Component)this.jLabel8, new AbsoluteConstraints(120, 90, 10, 20));
        this.yMaxField.setBackground(new Color(255, 255, 254));
        this.yMaxField.setHorizontalAlignment(0);
        this.yMaxField.setText("max");
        this.yMaxField.setToolTipText("The upper bound of the display range");
        this.yMaxField.setEnabled(false);
        this.yMaxField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.yMaxFieldActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.yMaxField, new AbsoluteConstraints(130, 90, 50, 20));
        this.jLabel7.setHorizontalAlignment(2);
        this.jLabel7.setText("]");
        this.jPanel3.add((Component)this.jLabel7, new AbsoluteConstraints(180, 90, 10, 20));
        this.yRangeLabel.setText(" Y-Axis plot range");
        this.jPanel3.add((Component)this.yRangeLabel, new AbsoluteConstraints(10, 70, 180, -1));
        this.yRangeLabel1.setText(" Currently selected spectrum");
        this.jPanel3.add((Component)this.yRangeLabel1, new AbsoluteConstraints(10, 140, 180, -1));
        this.graphsCombobox1.setToolTipText("Select a spectrum to edit");
        this.graphsCombobox1.setPreferredSize(new Dimension(125, 16));
        this.graphsCombobox1.setRenderer(new ColorComboboxRenderer());
        this.graphsCombobox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.graphsCombobox1ActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.graphsCombobox1, new AbsoluteConstraints(10, 160, 180, 20));
        this.rightPanel.add(this.jPanel3);
        this.shelf.setMaximumSize(new Dimension(200, 700));
        this.shelf.setMinimumSize(new Dimension(200, 200));
        this.shelf.setPreferredSize(new Dimension(200, 200));
        this.shelf.setExclusive(false);
        this.shelf.setLayout(null);
        this.drawer1.setBorder(new SoftBevelBorder(1));
        this.drawer1.setMaximizeComponent(this.expandXPanel);
        this.drawer1.setMaximumSize(new Dimension(180, 170));
        this.drawer1.setMinimumSize(new Dimension(180, 20));
        this.drawer1.setLayout(new AbsoluteLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.xAxisTitleField.setBackground(new Color(255, 255, 254));
        this.xAxisTitleField.setText("X-Axis");
        this.xAxisTitleField.setToolTipText("The title of the x-axis");
        this.xAxisTitleField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.xAxisTitleFieldActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xAxisTitleField, new AbsoluteConstraints(40, 10, 80, 20));
        this.xTicsCheckbox.setSelected(true);
        this.xTicsCheckbox.setText("Tics");
        this.xTicsCheckbox.setToolTipText("Display tics on the x-axis.");
        this.xTicsCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.xTicsCheckboxActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xTicsCheckbox, new AbsoluteConstraints(10, 90, -1, -1));
        this.jLabel6.setText("Title");
        this.jPanel1.add((Component)this.jLabel6, new AbsoluteConstraints(10, 10, -1, 20));
        this.typeGroup.add(this.xAxisLinear);
        this.xAxisLinear.setSelected(true);
        this.xAxisLinear.setText("Linear");
        this.xAxisLinear.setToolTipText("Use linear x-axis");
        this.xAxisLinear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.xAxisLinearActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xAxisLinear, new AbsoluteConstraints(10, 40, -1, 20));
        this.typeGroup.add(this.xAxisLog);
        this.xAxisLog.setText("Logarithmic");
        this.xAxisLog.setToolTipText("Use logarithmic x-axis");
        this.xAxisLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.xAxisLogActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xAxisLog, new AbsoluteConstraints(10, 60, -1, 20));
        this.redoTicsX.setText("+");
        this.redoTicsX.setToolTipText("Redraw the axis tics");
        this.redoTicsX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.redoTicsXActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.redoTicsX, new AbsoluteConstraints(60, 110, -1, -1));
        this.xTitleFontBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/FontIcon.png")));
        this.xTitleFontBtn.setToolTipText("Choose the font of the x-axis title.");
        this.xTitleFontBtn.setAlignmentX(1.0f);
        this.xTitleFontBtn.setAlignmentY(1.0f);
        this.xTitleFontBtn.setIconTextGap(0);
        this.xTitleFontBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.xTitleFontBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xTitleFontBtn, new AbsoluteConstraints(120, 10, 24, 22));
        this.redoTicsX1.setText("-");
        this.redoTicsX1.setToolTipText("Redraw the axis tics");
        this.redoTicsX1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.redoTicsX1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.redoTicsX1, new AbsoluteConstraints(110, 110, -1, -1));
        this.jLabel10.setText("Tic size:");
        this.jPanel1.add((Component)this.jLabel10, new AbsoluteConstraints(10, 113, -1, -1));
        this.drawer1.add((Component)this.jPanel1, new AbsoluteConstraints(10, 20, 150, 150));
        this.expandXPanel.setLayout(new AbsoluteLayout());
        this.openXPropertiesLabel.setText(" +");
        this.openXPropertiesLabel.setFore(new Color(153, 255, 153));
        this.openXPropertiesLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.openXPropertiesLabelMouseClicked(evt);
            }
        });
        this.expandXPanel.add((Component)this.openXPropertiesLabel, new AbsoluteConstraints(0, 0, 20, -1));
        this.headerLabel1.setText(" X-Axis properties");
        this.headerLabel1.setDark(false);
        this.expandXPanel.add((Component)this.headerLabel1, new AbsoluteConstraints(20, 0, 150, -1));
        this.drawer1.add((Component)this.expandXPanel, new AbsoluteConstraints(3, 3, 170, 16));
        this.shelf.add(this.drawer1);
        this.drawer1.setBounds(10, 10, 180, 20);
        this.drawer2.setBorder(new SoftBevelBorder(1));
        this.drawer2.setMaximizeComponent(this.expandYPanel);
        this.drawer2.setMaximumSize(new Dimension(180, 170));
        this.drawer2.setMinimumSize(new Dimension(180, 20));
        this.drawer2.setLayout(new AbsoluteLayout());
        this.jPanel5.setOpaque(false);
        this.jPanel5.setLayout(new AbsoluteLayout());
        this.yAxisTitleField.setBackground(new Color(255, 255, 254));
        this.yAxisTitleField.setText("Y-Axis");
        this.yAxisTitleField.setToolTipText("The title of the y-axis");
        this.yAxisTitleField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.yAxisTitleFieldActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yAxisTitleField, new AbsoluteConstraints(40, 10, 80, 20));
        this.yTicsCheckbox.setSelected(true);
        this.yTicsCheckbox.setText("Tics");
        this.yTicsCheckbox.setToolTipText("toolTipText\tDisplay tics on the y-axis.");
        this.yTicsCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.yTicsCheckboxActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yTicsCheckbox, new AbsoluteConstraints(10, 90, -1, -1));
        this.jLabel11.setText("Title");
        this.jPanel5.add((Component)this.jLabel11, new AbsoluteConstraints(10, 10, -1, 20));
        this.typeGroup1.add(this.yAxisLinear);
        this.yAxisLinear.setSelected(true);
        this.yAxisLinear.setText("Linear");
        this.yAxisLinear.setToolTipText("Use linear y-axis");
        this.yAxisLinear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.yAxisLinearActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yAxisLinear, new AbsoluteConstraints(10, 40, -1, 20));
        this.typeGroup1.add(this.yAxisLog);
        this.yAxisLog.setText("Logarithmic");
        this.yAxisLog.setToolTipText("Use logarithmic y-axis");
        this.yAxisLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.yAxisLogActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yAxisLog, new AbsoluteConstraints(10, 60, -1, 20));
        this.redoTicsY.setText("+");
        this.redoTicsY.setToolTipText("Redraw the axis tics");
        this.redoTicsY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.redoTicsYActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.redoTicsY, new AbsoluteConstraints(60, 110, -1, -1));
        this.yTitleFontBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/FontIcon.png")));
        this.yTitleFontBtn.setToolTipText("Choose the font of the y-axis title.");
        this.yTitleFontBtn.setAlignmentX(1.0f);
        this.yTitleFontBtn.setAlignmentY(1.0f);
        this.yTitleFontBtn.setIconTextGap(0);
        this.yTitleFontBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.yTitleFontBtnActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yTitleFontBtn, new AbsoluteConstraints(120, 10, 24, 22));
        this.redoTicsY1.setText("-");
        this.redoTicsY1.setToolTipText("Redraw the axis tics");
        this.redoTicsY1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.redoTicsY1ActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.redoTicsY1, new AbsoluteConstraints(110, 110, -1, -1));
        this.jLabel5.setText("Tic size:");
        this.jPanel5.add((Component)this.jLabel5, new AbsoluteConstraints(10, 113, -1, -1));
        this.drawer2.add((Component)this.jPanel5, new AbsoluteConstraints(0, 20, 160, 150));
        this.expandYPanel.setLayout(new AbsoluteLayout());
        this.openYPropertiesLabel.setText(" +");
        this.openYPropertiesLabel.setFore(new Color(153, 255, 153));
        this.openYPropertiesLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.openYPropertiesLabelMouseClicked(evt);
            }
        });
        this.expandYPanel.add((Component)this.openYPropertiesLabel, new AbsoluteConstraints(0, 0, 20, -1));
        this.headerLabel4.setText(" Y-Axis properties");
        this.headerLabel4.setDark(false);
        this.expandYPanel.add((Component)this.headerLabel4, new AbsoluteConstraints(20, 0, 150, -1));
        this.drawer2.add((Component)this.expandYPanel, new AbsoluteConstraints(3, 3, 175, 16));
        this.shelf.add(this.drawer2);
        this.drawer2.setBounds(10, 35, 180, 20);
        this.drawer3.setBorder(new SoftBevelBorder(1));
        this.drawer3.setMaximizeComponent(this.expandGraphPanel);
        this.drawer3.setMaximumSize(new Dimension(180, 310));
        this.drawer3.setMinimumSize(new Dimension(180, 20));
        this.drawer3.setLayout(new AbsoluteLayout());
        this.jPanel6.setOpaque(false);
        this.jPanel6.setLayout(new AbsoluteLayout());
        this.colorPanel.setBackground(new Color(0, 0, 0));
        this.colorPanel.setToolTipText("Choose the color of the selected spectrum");
        this.colorPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.colorPanelMouseClicked(evt);
            }
        });
        this.jPanel6.add((Component)this.colorPanel, new AbsoluteConstraints(40, 40, 20, 20));
        this.jLabel1.setText("Color");
        this.jPanel6.add((Component)this.jLabel1, new AbsoluteConstraints(10, 40, -1, 20));
        this.deleteGraphButton.setText("Delete");
        this.deleteGraphButton.setToolTipText("Delete the selected spectrum");
        this.deleteGraphButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.deleteGraphButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.deleteGraphButton, new AbsoluteConstraints(10, 200, 130, -1));
        this.graphTitleField.setBackground(new Color(255, 255, 254));
        this.graphTitleField.setToolTipText("The title of the selected spectrum");
        this.graphTitleField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.graphTitleFieldActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.graphTitleField, new AbsoluteConstraints(40, 10, 100, -1));
        this.jLabel12.setText("Title");
        this.jPanel6.add((Component)this.jLabel12, new AbsoluteConstraints(10, 10, -1, 20));
        this.toFrontBtn.setText("Bring to front");
        this.toFrontBtn.setToolTipText("Bring the selected spectrum to front. Superimposing it on all the other spectrums.");
        this.toFrontBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.toFrontBtnActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.toFrontBtn, new AbsoluteConstraints(10, 230, 130, -1));
        this.widthField.setToolTipText("Set the stroke width of the selected spectrum");
        this.widthField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.widthFieldActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.widthField, new AbsoluteConstraints(40, 70, 40, -1));
        this.jLabel13.setText("Width");
        this.jPanel6.add((Component)this.jLabel13, new AbsoluteConstraints(10, 70, -1, 20));
        this.jLabel14.setText("Fill");
        this.jPanel6.add((Component)this.jLabel14, new AbsoluteConstraints(10, 100, -1, 20));
        this.jCheckBox1.setToolTipText("Display the spectrum as filled or outline");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.jCheckBox1, new AbsoluteConstraints(30, 100, 20, -1));
        this.correction.setText("Energy shift:");
        this.jPanel6.add((Component)this.correction, new AbsoluteConstraints(10, 140, -1, 20));
        this.correctionField.setBackground(new Color(255, 255, 254));
        this.correctionField.setToolTipText("The title of the selected spectrum");
        this.correctionField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.correctionFieldActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.correctionField, new AbsoluteConstraints(80, 140, 40, -1));
        this.width.setText("Channel width:");
        this.jPanel6.add((Component)this.width, new AbsoluteConstraints(10, 120, -1, 20));
        this.width2.setText("10.667 keV");
        this.jPanel6.add((Component)this.width2, new AbsoluteConstraints(90, 120, 60, 20));
        this.correction2.setHorizontalAlignment(0);
        this.correction2.setText("MeV");
        this.jPanel6.add((Component)this.correction2, new AbsoluteConstraints(120, 140, 30, 20));
        this.toFrontBtn1.setText("Send to back");
        this.toFrontBtn1.setToolTipText("Bring the selected spectrum to front. Superimposing it on all the other spectrums.");
        this.toFrontBtn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.toFrontBtn1ActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.toFrontBtn1, new AbsoluteConstraints(10, 260, 130, -1));
        this.toFitBtn2.setText("To fitting as target");
        this.toFitBtn2.setToolTipText("Move the currently selected specttum to fitting");
        this.toFitBtn2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotPanel.this.toFitBtn2ActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.toFitBtn2, new AbsoluteConstraints(10, 170, 130, -1));
        this.drawer3.add((Component)this.jPanel6, new AbsoluteConstraints(10, 20, 160, 290));
        this.expandGraphPanel.setLayout(new AbsoluteLayout());
        this.openGraphPropertiesLabel.setText(" +");
        this.openGraphPropertiesLabel.setFore(new Color(153, 255, 153));
        this.openGraphPropertiesLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PlotPanel.this.openGraphPropertiesLabelMouseClicked(evt);
            }
        });
        this.expandGraphPanel.add((Component)this.openGraphPropertiesLabel, new AbsoluteConstraints(0, 0, 20, -1));
        this.headerLabel6.setText(" Spectrum properties");
        this.headerLabel6.setDark(false);
        this.expandGraphPanel.add((Component)this.headerLabel6, new AbsoluteConstraints(20, 0, 150, -1));
        this.drawer3.add((Component)this.expandGraphPanel, new AbsoluteConstraints(3, 3, 175, 16));
        this.shelf.add(this.drawer3);
        this.drawer3.setBounds(10, 60, 180, 20);
        this.rightPanel.add(this.shelf);
        this.jScrollPane1.setViewportView(this.rightPanel);
        this.jPanel7.add((Component)this.jScrollPane1, "East");
        this.simulationPlotFrame.getContentPane().add((Component)this.jPanel7, "Center");
        this.simulationPlotFrame.setBounds(30, 20, 680, 280);
        this.jDesktopPane1.add((Component)this.simulationPlotFrame, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.jDesktopPane1, "Center");
    }

    private void batchConvertMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.toolDisabled = true;
            JFileChooser chooser = new JFileChooser();
            FileFilter f1 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("fig");
                }

                public String getDescription() {
                    return "(.fig) Complete figure with graphs and annotations (binary).";
                }
            };
            FileFilter f2 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("graph");
                }

                public String getDescription() {
                    return "(.graph) Graph only (text)";
                }
            };
            FileFilter f3 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("phd");
                }

                public String getDescription() {
                    return "(.phd) IMS2.0 format";
                }
            };
            chooser.addChoosableFileFilter(f1);
            chooser.addChoosableFileFilter(f2);
            chooser.addChoosableFileFilter(f3);
            chooser.setCurrentDirectory(new File(this.chooserOpenHome));
            chooser.setMultiSelectionEnabled(true);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.chooserOpenHome = chooser.getSelectedFile().getPath();
                File[] inFiles = chooser.getSelectedFiles();
                this.handleOpenFile(inFiles[0]);
                this.saveBtnActionPerformed(null);
                this.deleteGraphMenuItemActionPerformed(null);
                String ext = ".graph";
                if (this.lastFormat == this.phdFormat) {
                    ext = ".phd";
                }
                for (int i = 1; i < inFiles.length; ++i) {
                    try {
                        this.handleOpenFile(inFiles[i]);
                        this.saveFile(new File(inFiles[i].getCanonicalPath() + ext), this.lastFormat);
                        this.deleteGraphMenuItemActionPerformed(null);
                        continue;
                    }
                    catch (Exception ex) {
                        Main.warnUser("Can't load " + inFiles[i].getName() + "\nPossibly wrong format.");
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            Main.warnUser("Loading failed. Possibly wrong format encountered.");
            ex.printStackTrace();
        }
    }

    private void copyMatlabActionPerformed(ActionEvent evt) {
        XYGraph g = (XYGraph)this.getSelectedGraph();
        double[] x = g.getX();
        double[] y = g.getY();
        StringBuffer b = new StringBuffer();
        String str = "";
        boolean seq = false;
        boolean seq2 = false;
        b.append("EnCn = [");
        b.append(x[0]);
        b.append(' ');
        b.append(y[0]);
        b.append(';');
        for (int i = 1; i < x.length; ++i) {
            if (!seq) {
                if (y[i] == y[i - 1]) {
                    seq = true;
                } else if (y[i] == y[i - 1]) {
                    seq2 = true;
                }
            }
            if (y[i] != y[i - 1]) {
                if (seq2) {
                    b.append(x[i - 1]);
                    b.append(' ');
                    b.append(y[i - 1]);
                    b.append(';');
                }
                seq = false;
                seq2 = false;
            } else if (seq) {
                seq2 = true;
            } else {
                seq = true;
            }
            if (seq2) continue;
            b.append(x[i]);
            b.append(' ');
            b.append(y[i]);
            b.append(';');
        }
        b.append("];");
        final String excelStr = b.toString();
        b.delete(0, b.length());
        System.gc();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Transferable tr = new Transferable(){

            public Object getTransferData(DataFlavor flavor) {
                return excelStr;
            }

            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] f = new DataFlavor[]{DataFlavor.stringFlavor};
                return f;
            }

            public boolean isDataFlavorSupported(DataFlavor f) {
                return f == DataFlavor.stringFlavor;
            }
        };
        tk.getSystemClipboard().setContents(tr, null);
    }

    private void copyExcelActionPerformed(ActionEvent evt) {
        XYGraph g = (XYGraph)this.getSelectedGraph();
        double[] x = g.getX();
        double[] y = g.getY();
        StringBuffer b = new StringBuffer();
        String str = "";
        boolean seq = false;
        boolean seq2 = false;
        b.append("Energy");
        b.append('\t');
        b.append("Counts");
        b.append('\n');
        b.append(x[0]);
        b.append('\t');
        b.append(y[0]);
        b.append('\n');
        for (int i = 1; i < x.length; ++i) {
            if (!seq) {
                if (y[i] == y[i - 1]) {
                    seq = true;
                } else if (y[i] == y[i - 1]) {
                    seq2 = true;
                }
            }
            if (y[i] != y[i - 1]) {
                if (seq2) {
                    b.append(x[i - 1]);
                    b.append('\t');
                    b.append(y[i - 1]);
                    b.append('\n');
                }
                seq = false;
                seq2 = false;
            } else if (seq) {
                seq2 = true;
            } else {
                seq = true;
            }
            if (seq2) continue;
            b.append(x[i]);
            b.append('\t');
            b.append(y[i]);
            b.append('\n');
        }
        final String excelStr = b.toString();
        b.delete(0, b.length());
        System.gc();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Transferable tr = new Transferable(){

            public Object getTransferData(DataFlavor flavor) {
                return excelStr;
            }

            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] f = new DataFlavor[]{DataFlavor.stringFlavor};
                return f;
            }

            public boolean isDataFlavorSupported(DataFlavor f) {
                return f == DataFlavor.stringFlavor;
            }
        };
        tk.getSystemClipboard().setContents(tr, null);
    }

    private void toFitBtn2ActionPerformed(ActionEvent evt) {
        this.toFitBtnActionPerformed(null);
    }

    private void removeSelectedAnnotationMenuItemActionPerformed(ActionEvent evt) {
        this.deleteSelectedObject();
        this.tool = 0;
        this.selectToolButton.setSelected(false);
        this.graphCanvas.setSelected(null);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void toFitBtnActionPerformed(ActionEvent evt) {
        XYGraph g = (XYGraph)this.getSelectedGraph();
        XYGraph ng = new XYGraph(true);
        if (g != null) {
            ng.setX(g.getX());
            ng.setY(g.getY());
            ng.setTitle("Fitting target");
            Main.mainFrame.getFitPanel().addTarget(ng, false);
        }
        this.toFitBtn.setSelected(false);
        Main.mainFrame.setPage(8);
    }

    private void removeAllAnnotationsMenuItemActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAnnotations().clear();
        this.graphCanvas.getAnnotations(true).clear();
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void selectPrevItemActionPerformed(ActionEvent evt) {
        int n = this.graphsCombobox.getItemCount();
        if (n < 2) {
            return;
        }
        int ind = this.graphsCombobox.getSelectedIndex();
        if (--ind == -1) {
            ind = n - 1;
        }
        this.graphsCombobox.setSelectedIndex(ind);
    }

    private void selectNextItemActionPerformed(ActionEvent evt) {
        int n = this.graphsCombobox.getItemCount();
        if (n < 2) {
            return;
        }
        int ind = this.graphsCombobox.getSelectedIndex();
        ind = (ind + 1) % n;
        this.graphsCombobox.setSelectedIndex(ind);
    }

    private void graphsCombobox1ActionPerformed(ActionEvent evt) {
        if (this.loading) {
            return;
        }
        this.graphsCombobox.setSelectedItem(this.graphsCombobox1.getSelectedItem());
    }

    private void panLeftItemActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double m = a.getMin(0);
        double M = a.getMax(0);
        if (m < 0.4) {
            return;
        }
        this.panAmnt = (M - m) / 8.0;
        a.setMinMax(m - this.panAmnt, M - this.panAmnt, 0);
        this.plotControlWidgets.setLogTics(1);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void panRightItemActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double m = a.getMin(0);
        double M = a.getMax(0);
        this.panAmnt = (M - m) / 8.0;
        a.setMinMax(m + this.panAmnt, M + this.panAmnt, 0);
        this.plotControlWidgets.setLogTics(1);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void viewNavigationMenuItemActionPerformed(ActionEvent evt) {
        if (this.viewNavigationMenuItem.isSelected()) {
            this.jPanel4.setPreferredSize(new Dimension(this.jPanel4.getWidth(), 20));
            this.jPanel7.doLayout();
            this.jPanel7.repaint();
            this.simulationPlotFrame.setLocation(this.simulationPlotFrame.getX(), this.simulationPlotFrame.getY());
        } else {
            this.jPanel4.setPreferredSize(new Dimension(this.jPanel4.getWidth(), 1));
            this.jPanel7.doLayout();
            this.jPanel7.repaint();
            this.simulationPlotFrame.setLocation(this.simulationPlotFrame.getX(), this.simulationPlotFrame.getY());
        }
    }

    private void viewPropertiesPaneItemActionPerformed(ActionEvent evt) {
        if (this.viewPropertiesPaneItem.isSelected()) {
            this.jScrollPane1.setPreferredSize(new Dimension(225, this.rightPanel.getHeight()));
            this.jPanel7.doLayout();
            this.rightPanel.doLayout();
            this.rightPanel.repaint();
            this.simulationPlotFrame.setLocation(this.simulationPlotFrame.getX(), this.simulationPlotFrame.getY());
            if (this.pendingSettings) {
                if (this.openXShelf) {
                    this.openXPropertiesLabelMouseClicked(null);
                }
                if (this.openYShelf) {
                    this.openYPropertiesLabelMouseClicked(null);
                }
                if (this.openGraphShelf) {
                    this.openGraphPropertiesLabelMouseClicked(null);
                }
                this.jPanel7.doLayout();
                this.rightPanel.doLayout();
                this.rightPanel.repaint();
                this.pendingSettings = false;
            }
        } else {
            this.jScrollPane1.setPreferredSize(new Dimension(1, this.rightPanel.getHeight()));
            this.jPanel7.doLayout();
            this.rightPanel.doLayout();
            this.rightPanel.repaint();
            this.simulationPlotFrame.setLocation(this.simulationPlotFrame.getX(), this.simulationPlotFrame.getY());
        }
    }

    private void deleteAllGraphsActionPerformed(ActionEvent evt) {
        this.graphCanvas.getGraphs().clear();
        this.graphsCombobox.removeAllItems();
        this.graphsCombobox1.removeAllItems();
        this.enablePlotToolbar(false);
        this.graphCanvas.setSelected(null);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void deleteGraphMenuItemActionPerformed(ActionEvent evt) {
        this.graphCanvas.setSelected(null);
        this.deleteGraphButtonActionPerformed(null);
        if (this.graphsCombobox.getItemCount() == 0) {
            this.enablePlotToolbar(false);
        }
    }

    private void toBackItemActionPerformed(ActionEvent evt) {
        this.toFrontBtn1ActionPerformed(null);
    }

    private void toFrontItemActionPerformed(ActionEvent evt) {
        this.toFrontBtnActionPerformed(null);
    }

    private void zoomOutMenuItemActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double xmin = a.getMin(0);
        double xmax = a.getMax(0);
        double ymin = a.getMin(1);
        double ymax = a.getMax(1);
        this.zoomAmnt = (xmax - xmin) / 5.0;
        a.setMinMax(xmin - this.zoomAmnt, 0.0, xmax + this.zoomAmnt, ymax + this.zoomAmnt);
        a.setTics();
        if (a.isLogarithmic(1)) {
            this.setLogTics(a);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void zoomInMenuItemActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double xmin = a.getMin(0);
        double xmax = a.getMax(0);
        double ymin = a.getMin(1);
        double ymax = a.getMax(1);
        this.zoomAmnt = (xmax - xmin) / 5.0;
        a.setMinMax(xmin + this.zoomAmnt, 0.0, xmax - this.zoomAmnt, ymax - this.zoomAmnt);
        a.setTics();
        if (a.isLogarithmic(1)) {
            this.setLogTics(a);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void addLineMenuItemActionPerformed(ActionEvent evt) {
        this.toolCoordinates = 1;
        this.tool = 6;
        this.plotControlWidgets.setSelectedTool(0);
        this.prev = null;
        this.start = null;
    }

    private void addLineTagMenuItemActionPerformed(ActionEvent evt) {
        this.toolCoordinates = 2;
        this.tool = 6;
        this.plotControlWidgets.setSelectedTool(0);
        this.prev = null;
        this.start = null;
    }

    private void addTextTagMenuItemActionPerformed(ActionEvent evt) {
        this.toolCoordinates = 2;
        this.tool = 3;
        this.plotControlWidgets.setSelectedTool(0);
    }

    private void addTextMenuItemActionPerformed(ActionEvent evt) {
        this.toolCoordinates = 1;
        this.tool = 3;
        this.plotControlWidgets.setSelectedTool(0);
    }

    private void pageSetupMenuItemActionPerformed(ActionEvent evt) {
        this.pageSetupBtnActionPerformed(null);
    }

    private void printFigMenuItemActionPerformed(ActionEvent evt) {
        this.printBtnActionPerformed(null);
    }

    private void zoomAllMenuItemActionPerformed(ActionEvent evt) {
        this.xRangeAutoButtonActionPerformed(null);
        this.yRangeAutoButtonActionPerformed(null);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void removeObjectBtnMouseClicked(MouseEvent evt) {
        this.deleteGraphButtonActionPerformed(null);
        if (this.graphCanvas.getGraphs().size() == 0) {
            this.enablePlotToolbar(false);
        }
    }

    private void plotWidthMinusBtnMouseClicked(MouseEvent evt) {
        Graph g = this.getSelectedGraph();
        if (g == null) {
            return;
        }
        float w = g.getStrokeWidth();
        if (w <= 1.0f) {
            return;
        }
        g.setStrokeWidth(w -= 1.0f);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void plotWidthPlusBtnMouseClicked(MouseEvent evt) {
        Graph g = this.getSelectedGraph();
        if (g == null) {
            return;
        }
        float w = g.getStrokeWidth();
        g.setStrokeWidth(w + 1.0f);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void plotColorPanelMouseClicked(MouseEvent evt) {
        this.colorPanelMouseClicked(evt);
    }

    private void plotFillPanelMouseClicked(MouseEvent evt) {
        Graph g;
        g.setFilled(!(g = this.getSelectedGraph()).isFilled());
        this.jCheckBox1.setSelected(g.isFilled());
        this.plotFillPanel.setBackground(g.isFilled() ? Color.gray : this.selectionLabel.getBackground());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void selectToolButtonActionPerformed(ActionEvent evt) {
        if (this.tool == 5) {
            this.tool = 0;
            this.graphCanvas.setSelected(null);
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
            return;
        }
        this.infoToolButton.setSelected(false);
        this.tool = 5;
        this.prev = null;
        this.plotControlWidgets.setSelectedTool(0);
        this.graphCanvas.setSelected(this.getSelectedGraph());
        this.graphsComboboxActionPerformed(null);
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlotPanel.this.drawAnchors();
            }
        });
    }

    private void infoToolButtonActionPerformed(ActionEvent evt) {
        if (this.tool == 4) {
            this.tool = 0;
            this.graphCanvas.repaint();
            return;
        }
        this.selectToolButton.setSelected(false);
        this.tool = 4;
        this.prev = null;
        this.plotControlWidgets.setSelectedTool(0);
        this.plotControlWidgets.repaint();
        if (this.graphCanvas.getSelected() != null) {
            this.graphCanvas.setSelected(null);
            this.graphCanvas.refresh();
        }
        this.graphCanvas.repaint();
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    private void plotControlWidgetsMouseClicked(MouseEvent evt) {
        this.tool = 0;
        this.infoToolButton.setSelected(false);
        this.selectToolButton.setSelected(false);
    }

    private void saveFigMenuItemActionPerformed(ActionEvent evt) {
        this.saveBtnActionPerformed(new ActionEvent(this, 0, "save fig"));
    }

    private void saveSelectedMenuItemActionPerformed(ActionEvent evt) {
        this.saveBtnActionPerformed(null);
    }

    private void openGraphMenuItemActionPerformed(ActionEvent evt) {
        this.openBtnActionPerformed(null);
    }

    private void redoTicsX1ActionPerformed(ActionEvent evt) {
        Font f = this.graphCanvas.getAxis().getTicFont(0);
        this.graphCanvas.getAxis().setTicFont(f.deriveFont((float)f.getSize() - 1.0f), 0);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void redoTicsY1ActionPerformed(ActionEvent evt) {
        Font f = this.graphCanvas.getAxis().getTicFont(1);
        this.graphCanvas.getAxis().setTicFont(f.deriveFont((float)f.getSize() - 1.0f), 1);
        if (this.graphCanvas.getAxis().isLogarithmic(1)) {
            this.setLogTics(this.graphCanvas.getAxis());
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void redoTicsXActionPerformed(ActionEvent evt) {
        Font f = this.graphCanvas.getAxis().getTicFont(0);
        this.graphCanvas.getAxis().setTicFont(f.deriveFont((float)f.getSize() + 1.0f), 0);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void toFrontBtn1ActionPerformed(ActionEvent evt) {
        List l = this.graphCanvas.getGraphs();
        Object key = this.graphsCombobox.getSelectedItem();
        Graph g = (Graph)this.graphs.get(key);
        l.remove(g);
        l.add(0, g);
        this.graphsCombobox.removeItem(key);
        this.graphsCombobox1.removeItem(key);
        this.graphsCombobox.addItem(key);
        this.graphsCombobox1.addItem(key);
        this.graphsCombobox1.setSelectedItem(key);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void openGraphPropertiesLabelMouseClicked(MouseEvent evt) {
        if (this.drawer3.isMinimized()) {
            this.shelf.maximize(this.drawer3);
            this.openGraphPropertiesLabel.setText(" -");
        } else {
            this.shelf.minimize(this.drawer3);
            this.openGraphPropertiesLabel.setText(" +");
        }
    }

    private void openYPropertiesLabelMouseClicked(MouseEvent evt) {
        if (this.drawer2.isMinimized()) {
            this.shelf.maximize(this.drawer2);
            this.openYPropertiesLabel.setText(" -");
        } else {
            this.shelf.minimize(this.drawer2);
            this.openYPropertiesLabel.setText(" +");
        }
    }

    private void openXPropertiesLabelMouseClicked(MouseEvent evt) {
        if (this.drawer1.isMinimized()) {
            this.shelf.maximize(this.drawer1);
            this.openXPropertiesLabel.setText(" -");
        } else {
            this.shelf.minimize(this.drawer1);
            this.openXPropertiesLabel.setText(" +");
        }
    }

    private void addLineTagButtonActionPerformed(ActionEvent evt) {
        this.tool = 6;
        this.toolCoordinates = 2;
        this.graphCanvas.repaint();
        this.prev = null;
        this.start = null;
        this.p = null;
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    private void addTextTagButtonActionPerformed(ActionEvent evt) {
        this.tool = 3;
        this.toolCoordinates = 2;
        this.graphCanvas.repaint();
        try {
            this.graphCanvas.setCursor(Cursor.getSystemCustomCursor("Invalid.16x16"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void correctionFieldActionPerformed(ActionEvent evt) {
        this.getSelectedGraph().setOffset(Double.parseDouble(this.correctionField.getText()));
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void selectButton1ActionPerformed(ActionEvent evt) {
        this.tool = 7;
        this.graphCanvas.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlotPanel.this.drawAnchors();
            }
        });
        this.prev = null;
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void pageSetupBtnActionPerformed(ActionEvent evt) {
        final JDialog diag = new JDialog(JOptionPane.getFrameForComponent(this));
        diag.setTitle("Print preview");
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (this.currentFormat == null) {
            this.currentFormat = printJob.defaultPage();
        }
        this.currentFormat = printJob.pageDialog(this.currentFormat);
        final JPanel panel = new JPanel(){

            public void paint(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g.setColor(Color.gray);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.white);
                g.fillRect(0, 0, (int)PlotPanel.this.currentFormat.getWidth(), (int)PlotPanel.this.currentFormat.getHeight());
                g.setColor(Color.red);
                g.drawRect((int)PlotPanel.this.currentFormat.getImageableX(), (int)PlotPanel.this.currentFormat.getImageableY(), (int)PlotPanel.this.currentFormat.getImageableWidth(), (int)PlotPanel.this.currentFormat.getImageableHeight());
                PlotPanel.this.graphCanvas.setClearToBackground(false);
                g2d.scale(PlotPanel.this.scalex, PlotPanel.this.scaley);
                g.translate(PlotPanel.this.offsx, PlotPanel.this.offsy);
                PlotPanel.this.graphCanvas.print(g, PlotPanel.this.currentFormat, 0);
                PlotPanel.this.graphCanvas.setClearToBackground(true);
            }
        };
        diag.getContentPane().add((Component)panel, "Center");
        JButton but = new JButton("Close");
        final JButton left = new JButton("Left");
        final JButton right = new JButton("Right");
        final JButton up = new JButton("Up");
        final JButton down = new JButton("Down");
        final JButton widthPlus = new JButton("+");
        final JButton widthMinus = new JButton("-");
        final JButton heightPlus = new JButton("+");
        final JButton heightMinus = new JButton("-");
        ActionListener ac = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src == left) {
                    PlotPanel.this.offsx -= 5;
                } else if (src == right) {
                    PlotPanel.this.offsx += 5;
                } else if (src == up) {
                    PlotPanel.this.offsy -= 5;
                } else if (src == down) {
                    PlotPanel.this.offsy += 5;
                } else if (src == widthPlus) {
                    PlotPanel.this.scalex += 0.05;
                } else if (src == widthMinus) {
                    PlotPanel.this.scalex -= 0.05;
                } else if (src == heightPlus) {
                    PlotPanel.this.scaley += 0.05;
                } else if (src == heightMinus) {
                    PlotPanel.this.scaley -= 0.05;
                }
                panel.repaint();
            }
        };
        left.addActionListener(ac);
        up.addActionListener(ac);
        down.addActionListener(ac);
        right.addActionListener(ac);
        widthPlus.addActionListener(ac);
        widthMinus.addActionListener(ac);
        heightPlus.addActionListener(ac);
        heightMinus.addActionListener(ac);
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                diag.dispose();
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(but);
        buttons.add(new JLabel("Position:"));
        buttons.add(left);
        buttons.add(right);
        buttons.add(up);
        buttons.add(down);
        buttons.add(new JLabel("Width:"));
        buttons.add(widthPlus);
        buttons.add(widthMinus);
        buttons.add(new JLabel("Height:"));
        buttons.add(heightPlus);
        buttons.add(heightMinus);
        diag.getContentPane().add((Component)buttons, "South");
        panel.setSize((int)this.currentFormat.getWidth(), (int)this.currentFormat.getHeight());
        diag.setSize((int)this.currentFormat.getWidth() + 50, (int)this.currentFormat.getHeight() + 50);
        diag.setVisible(true);
    }

    private void printBtnActionPerformed(ActionEvent evt) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
        if (this.currentFormat != null) {
            printJob.setPrintable(this.graphCanvas, this.currentFormat);
        } else {
            printJob.setPrintable(this.graphCanvas);
        }
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        Graph g = this.getSelectedGraph();
        if (g == null) {
            return;
        }
        g.setFilled(this.jCheckBox1.isSelected());
        this.plotFillPanel.setBackground(g.isFilled() ? Color.gray : this.selectionLabel.getBackground());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void widthFieldActionPerformed(ActionEvent evt) {
        Graph g = this.getSelectedGraph();
        if (g == null) {
            return;
        }
        float w = Float.parseFloat(this.widthField.getText());
        this.defaultWidth = w;
        g.setStrokeWidth(w);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void addLineButtonActionPerformed(ActionEvent evt) {
        this.tool = 6;
        this.toolCoordinates = 1;
        this.graphCanvas.repaint();
        this.prev = null;
        this.start = null;
        this.p = null;
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    private int isSupported(DataFlavor[] f) {
        for (int i = 0; i < f.length; ++i) {
            if (f[i].getDefaultRepresentationClass() == null) continue;
            return i;
        }
        return -1;
    }

    private void graphCanvasKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.deleteSelectedObject();
        }
        if (evt.getKeyCode() == 86) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                Transferable data = tk.getSystemClipboard().getContents(this);
                this.handlePaste(data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (evt.getKeyCode() == 67) {
            this.graphCanvas.refresh();
            final BufferedImage img = this.graphCanvas.getImage();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Transferable tr = new Transferable(){

                public Object getTransferData(DataFlavor flavor) {
                    return img;
                }

                public DataFlavor[] getTransferDataFlavors() {
                    DataFlavor[] f = new DataFlavor[]{DataFlavor.imageFlavor};
                    return f;
                }

                public boolean isDataFlavorSupported(DataFlavor f) {
                    return f == DataFlavor.imageFlavor;
                }
            };
            tk.getSystemClipboard().setContents(tr, null);
        }
    }

    public void handleOpenFile(File f) throws Exception {
        if (f.getName().indexOf(".fig") != -1) {
            FileInputStream fis = new FileInputStream(f);
            ObjectInputStream ois = new ObjectInputStream(fis);
            List annotations = (List)ois.readObject();
            int numGraphs = ois.readInt();
            this.removeAllAnnotationsMenuItemActionPerformed(null);
            this.deleteAllGraphsActionPerformed(null);
            List l = this.graphCanvas.getAnnotations();
            l.addAll(annotations);
            for (int j = 0; j < numGraphs; ++j) {
                XYGraph g = (XYGraph)ois.readObject();
                g.setOffset(0.0);
                this.addGraph(g, false);
            }
        } else if (f.getName().indexOf(".phd") != -1) {
            PhdReader reader = new PhdReader();
            File file = f;
            List l = reader.read(file.getCanonicalPath());
            if (l.get(0) == null) {
                return;
            }
            if (((float[])l.get(0)).length == 0) {
                throw new RuntimeException("Not a valid PHD file.");
            }
            XYGraph g = new XYGraph(true);
            g.setX((float[])l.get(0));
            g.setY((float[])l.get(1));
            g.setOffset(0.0);
            g.setTitle(file.getName());
            this.setWidth(g, reader.getChannelWidth());
            this.addGraph(g);
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        } else if (f.getName().indexOf(".iec") != -1) {
            IECReader reader = new IECReader();
            File file = f;
            List l = reader.read(file.getCanonicalPath());
            if (l.get(0) == null) {
                return;
            }
            XYGraph g = new XYGraph(true);
            g.setX((float[])l.get(0));
            g.setY((float[])l.get(1));
            g.setOffset(0.0);
            g.setTitle(file.getName());
            this.setWidth(g, reader.getChannelWidth());
            this.addGraph(g);
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        } else if (f.getName().indexOf(".spe") != -1) {
            SPEReader reader = new SPEReader();
            File file = f;
            List l = reader.read(file.getCanonicalPath());
            if (l.get(0) == null) {
                return;
            }
            XYGraph g = new XYGraph(true);
            g.setX((float[])l.get(0));
            g.setY((float[])l.get(1));
            g.setOffset(0.0);
            g.setTitle(file.getName());
            this.setWidth(g, reader.getChannelWidth());
            this.addGraph(g);
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        } else if (f.getName().indexOf(".png") != -1 || f.getName().indexOf(".jpg") != -1 || f.getName().indexOf(".gif") != -1) {
            BufferedImage im = null;
            try {
                im = ImageIO.read(f);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (im != null) {
                this.graphCanvas.addAnnotation(im);
                int[] loc = new int[]{10, 10};
                this.graphCanvas.addAnnotation(loc);
                this.graphCanvas.refresh();
                this.graphCanvas.repaint();
            }
        } else {
            ResultsReader reader = new ResultsReader();
            File file = f;
            List l = reader.loadResults(file.getCanonicalPath());
            if (l.get(0) == null) {
                return;
            }
            XYGraph g = new XYGraph(true);
            g.setX((float[])l.get(0));
            g.setY((float[])l.get(1));
            g.setOffset(0.0);
            g.setTitle(file.getName());
            this.addGraph(g);
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        }
    }

    public void handlePaste(Transferable data) {
        try {
            if (data.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image i = (Image)data.getTransferData(DataFlavor.imageFlavor);
                if (this.current != null) {
                    this.graphCanvas.addAnnotation(i);
                    if (this.toolCoordinates == 2) {
                        double ax = this.graphCanvas.getAxis().getValueForAxisCoordinate(this.current.x - this.graphCanvas.getXInset(), 0);
                        int al = this.graphCanvas.getAxis().getLocation().y;
                        double ay = this.graphCanvas.getAxis().getValueForAxisCoordinate(al - this.current.y, 1);
                        double[] loc = new double[]{ax, ay};
                        this.graphCanvas.addAnnotation(loc);
                    } else {
                        int[] loc = new int[]{this.current.x, this.current.y};
                        this.graphCanvas.addAnnotation(loc);
                    }
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                }
            } else if (data.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List flist = (List)data.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iter = flist.iterator();
                while (iter.hasNext()) {
                    File f = (File)iter.next();
                    this.handleOpenFile(f);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void graphCanvas_handleMouseReleased(MouseEvent evt) {
        if (this.tool == 1) {
            int xi = this.graphCanvas.getXInset();
            int yi = this.graphCanvas.getYInset();
            int wi = xi + this.graphCanvas.getAxis().getSize(0);
            int hi = yi + this.graphCanvas.getAxis().getSize(1);
            int x = evt.getX();
            int y = evt.getY();
            if (evt.getButton() != 3 && this.isDragging) {
                if (this.start.equals(this.end)) {
                    return;
                }
                if (y < hi && Math.abs(this.start.x - this.end.x) < 10) {
                    return;
                }
                this.zoom();
                this.graphCanvas.repaint();
            } else if (evt.getButton() == 3 || x < xi || y > hi) {
                this.p = evt.getPoint();
                this.zoom(evt.getPoint(), evt.getButton() == 1 ? 1 : 3);
            }
        }
        if (this.tool == 5) {
            if (this.selectedObj == null) {
                return;
            }
            this.start = null;
            this.end = null;
            this.prev = null;
            this.p = null;
            if (this.selectedObj == null) {
                return;
            }
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
            this.toolDisabled = true;
            this.prev = null;
            this.ovy = Double.NEGATIVE_INFINITY;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PlotPanel.this.drawAnchors();
                }
            });
        }
        if (this.tool == 6) {
            if (this.start == null) {
                return;
            }
            this.p = evt.getPoint();
            if (this.toolCoordinates == 2) {
                double x1 = this.getDomain(this.start.x);
                double y1 = this.getValue(this.start.y);
                double x2 = this.getDomain(this.p.x);
                double y2 = this.getValue(this.p.y);
                double[] loc = new double[]{x1, y1, x2, y2};
                this.graphCanvas.addAnnotation(loc);
            } else {
                int[] loc = new int[]{this.start.x, this.start.y, this.p.x, this.p.y};
                this.graphCanvas.addAnnotation(loc);
            }
            this.prev = null;
            this.start = null;
            this.end = null;
            this.p = null;
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        }
        if (this.tool == 2) {
            Axis a = this.graphCanvas.getAxis();
            a.setTics(10);
            this.prev = null;
            if (a.isLogarithmic(1)) {
                this.setLogTics(a);
            }
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        }
    }

    private void graphCanvas_handleMousePressed(MouseEvent evt) {
        this.isDragging = false;
        if (this.tool == 5) {
            // empty if block
        }
        if (this.tool == 6) {
            if (!(this.toolCoordinates == 1 || this.toolCoordinates == 2 && this.insideAxis(evt.getPoint()))) {
                return;
            }
            this.drawLineXor(this.prev, this.prevCs);
            this.start = evt.getPoint();
            this.end = null;
            this.prev = null;
        }
        if (this.tool == 3 && this.tdialog != null && this.tdialog.isVisible()) {
            this.enableAllTools();
            this.isClick = false;
            this.addTextAnnotation();
            this.activateTool(this.prevTool);
            this.toolDisabled = true;
            this.prev = null;
        }
        if (this.tool == 1) {
            this.start = evt.getPoint();
            this.end = null;
        }
        if (this.tool == 8) {
            this.drawEvalXor(this.prev, this.ovx, this.ovy);
            this.start = evt.getPoint();
            this.end = null;
        }
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        this.tool = 5;
        this.prev = null;
        this.graphCanvas.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlotPanel.this.drawAnchors();
            }
        });
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void yTitleFontBtnActionPerformed(ActionEvent evt) {
        this.toolDisabled = true;
        JFontChooser chooser = new JFontChooser();
        chooser.setSelectedFont(this.graphCanvas.getAxis().getTitleFont(1));
        int returnVal = chooser.showDialog(this);
        if (returnVal == 0) {
            this.graphCanvas.getAxis().setTitleFont(chooser.getSelectedFont(), 1);
            this.lastUserFont = chooser.getSelectedFont();
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xTitleFontBtnActionPerformed(ActionEvent evt) {
        this.toolDisabled = true;
        JFontChooser chooser = new JFontChooser();
        chooser.setSelectedFont(this.graphCanvas.getAxis().getTitleFont(0));
        int returnVal = chooser.showDialog(this);
        if (returnVal == 0) {
            this.graphCanvas.getAxis().setTitleFont(chooser.getSelectedFont(), 0);
            this.lastUserFont = chooser.getSelectedFont();
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void addTextButtonActionPerformed(ActionEvent evt) {
        this.tool = 3;
        this.toolCoordinates = 1;
        this.graphCanvas.repaint();
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void evalButtonActionPerformed(ActionEvent evt) {
        this.tool = 4;
        this.graphCanvas.repaint();
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    private void antialiasingCheckboxActionPerformed(ActionEvent evt) {
        if (this.antialiasingCheckbox.isSelected()) {
            this.graphCanvas.setAntialiasingEnabled(true);
        } else {
            this.graphCanvas.setAntialiasingEnabled(false);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void saveFile(File file, FileFilter format) {
        try {
            this.lastFormat = format;
            this.toolDisabled = true;
            if (file != null) {
                if (format == this.epsFormat) {
                    File f = file;
                    if (f.getName().indexOf(".eps") == -1) {
                        File nFile;
                        f = nFile = new File(f.getPath() + ".eps");
                    }
                    Properties p = new Properties();
                    p.setProperty("PageSize", "A4");
                    p.setProperty("Orientation", "Portrait");
                    if (this.currentFormat.getOrientation() == 1) {
                        p.setProperty("Orientation", "Portrait");
                    } else {
                        p.setProperty("Orientation", "Landscape");
                    }
                    this.graphCanvas.setRenderOnPaint(true);
                    this.graphCanvas.setClearToBackground(false);
                    this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
                    PSGraphics2D g = new PSGraphics2D(f, new Dimension(this.graphCanvas.getSize()));
                    ((VectorGraphics)g).setProperties(p);
                    ((VectorGraphics)g).startExport();
                    this.graphCanvas.print(g, this.currentFormat, 0);
                    ((VectorGraphics)g).endExport();
                    this.graphCanvas.setClearToBackground(true);
                    this.graphCanvas.setRenderOnPaint(false);
                    this.graphCanvas.setAntialiasingEnabled(true);
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                } else if (format == this.figFormat) {
                    File f = file;
                    if (f.getName().indexOf(".fig") == -1) {
                        File nFile;
                        f = nFile = new File(f.getPath() + ".fig");
                    }
                    List l = this.graphCanvas.getAnnotations();
                    FileOutputStream fos = new FileOutputStream(f);
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(l);
                    List l2 = this.graphCanvas.getGraphs();
                    oos.writeInt(l2.size());
                    Iterator iter = l2.iterator();
                    while (iter.hasNext()) {
                        Object o = iter.next();
                        oos.writeObject(o);
                    }
                    oos.close();
                } else if (format == this.pdfFormat) {
                    File f = file;
                    if (f.getName().indexOf(".pdf") == -1) {
                        File nFile;
                        f = nFile = new File(f.getPath() + ".pdf");
                    }
                    Properties p = new Properties();
                    p.setProperty("PageSize", "A4");
                    p.setProperty("Orientation", "Portrait");
                    if (this.currentFormat.getOrientation() == 1) {
                        p.setProperty("Orientation", "Portrait");
                    } else {
                        p.setProperty("Orientation", "Landscape");
                    }
                    this.graphCanvas.setRenderOnPaint(true);
                    this.graphCanvas.setClearToBackground(false);
                    this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
                    PDFGraphics2D g = new PDFGraphics2D(f, new Dimension(this.graphCanvas.getSize()));
                    ((VectorGraphics)g).setProperties(p);
                    ((VectorGraphics)g).startExport();
                    this.graphCanvas.print(g, this.currentFormat, 0);
                    ((VectorGraphics)g).endExport();
                    this.graphCanvas.setClearToBackground(true);
                    this.graphCanvas.setRenderOnPaint(false);
                    this.graphCanvas.setAntialiasingEnabled(true);
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                } else if (format == this.svgFormat) {
                    File f = file;
                    Properties p = new Properties();
                    p.setProperty("PageSize", "A4");
                    p.setProperty("Orientation", "Portrait");
                    if (this.currentFormat.getOrientation() == 1) {
                        p.setProperty("Orientation", "Portrait");
                    } else {
                        p.setProperty("Orientation", "Landscape");
                    }
                    this.graphCanvas.setRenderOnPaint(true);
                    this.graphCanvas.setClearToBackground(false);
                    this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
                    SVGGraphics2D g = new SVGGraphics2D(f, new Dimension(this.graphCanvas.getSize()));
                    ((VectorGraphics)g).setProperties(p);
                    ((VectorGraphics)g).startExport();
                    this.graphCanvas.print(g, this.currentFormat, 0);
                    ((VectorGraphics)g).endExport();
                    this.graphCanvas.setClearToBackground(true);
                    this.graphCanvas.setRenderOnPaint(false);
                    this.graphCanvas.setAntialiasingEnabled(true);
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                } else if (format == this.pngFormat) {
                    File f = file;
                    if (f.getName().indexOf(".png") == -1) {
                        File nFile;
                        f = nFile = new File(f.getPath() + ".png");
                    }
                    this.graphCanvas.refresh();
                    ImageIO.write((RenderedImage)this.graphCanvas.getImage(), "png", f);
                } else if (format == this.emfFormat) {
                    File f = file;
                    if (f.getName().indexOf(".emf") == -1) {
                        File nFile;
                        f = nFile = new File(f.getPath() + ".emf");
                    }
                    Properties p = new Properties();
                    p.setProperty("PageSize", "A4");
                    this.graphCanvas.setRenderOnPaint(true);
                    this.graphCanvas.setClearToBackground(false);
                    this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
                    EMFGraphics2D g = new EMFGraphics2D(f, new Dimension(this.graphCanvas.getSize()));
                    ((VectorGraphics)g).setProperties(p);
                    ((VectorGraphics)g).startExport();
                    this.graphCanvas.print(g, this.currentFormat, 0);
                    ((VectorGraphics)g).endExport();
                    this.graphCanvas.setClearToBackground(true);
                    this.graphCanvas.setRenderOnPaint(false);
                    this.graphCanvas.setAntialiasingEnabled(true);
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                } else if (format == this.graphFormat) {
                    File f = file;
                    if (f.getName().indexOf(".graph") == -1) {
                        File nFile;
                        f = nFile = new File(f.getPath() + ".graph");
                    }
                    ResultsWriter writer = new ResultsWriter();
                    XYGraph g = (XYGraph)this.graphs.get(this.graphsCombobox.getSelectedItem());
                    ArrayList<double[]> l = new ArrayList<double[]>();
                    l.add(g.getX());
                    l.add(g.getY());
                    writer.writeResults(f.getCanonicalPath(), l);
                } else if (format == this.phdFormat) {
                    File f = file;
                    if (f.getName().indexOf(".phd") == -1) {
                        File nFile;
                        f = nFile = new File(f.getPath() + ".phd");
                    }
                    PhdWriter writer = new PhdWriter();
                    XYGraph g = (XYGraph)this.graphs.get(this.graphsCombobox.getSelectedItem());
                    ArrayList<double[]> l = new ArrayList<double[]>();
                    l.add(g.getX());
                    l.add(g.getY());
                    writer.writeResults(f.getCanonicalPath(), l);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        try {
            this.toolDisabled = true;
            JFileChooser chooser = new JFileChooser();
            this.phdFormat = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("phd");
                }

                public String getDescription() {
                    return "(.phd) IMS2.0 format (ASCII).";
                }
            };
            this.pdfFormat = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("pdf");
                }

                public String getDescription() {
                    return "(.pdf) Portable document format (vector).";
                }
            };
            this.pngFormat = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("png");
                }

                public String getDescription() {
                    return "(.png) Portable network graphics (bitmap).";
                }
            };
            this.emfFormat = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("emf");
                }

                public String getDescription() {
                    return "(.emf) Enhanced metafile (vector).";
                }
            };
            this.figFormat = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("fig");
                }

                public String getDescription() {
                    return "(.fig) Complete figure with graphs and annotations (binary).";
                }
            };
            this.graphFormat = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("graph");
                }

                public String getDescription() {
                    return "(.graph) Currently selected graph only (ASCII).";
                }
            };
            this.epsFormat = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equals("eps");
                }

                public String getDescription() {
                    return "(.eps) Encapsulated postscript. (vector)";
                }
            };
            if (evt == null) {
                chooser.addChoosableFileFilter(this.graphFormat);
                chooser.addChoosableFileFilter(this.phdFormat);
            } else {
                chooser.addChoosableFileFilter(this.epsFormat);
                chooser.addChoosableFileFilter(this.figFormat);
                chooser.addChoosableFileFilter(this.emfFormat);
                chooser.addChoosableFileFilter(this.pdfFormat);
                chooser.addChoosableFileFilter(this.pngFormat);
            }
            chooser.setCurrentDirectory(new File(this.chooserSaveHome));
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.chooserSaveHome = chooser.getSelectedFile().getParent();
                this.saveFile(chooser.getSelectedFile(), chooser.getFileFilter());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getExtension(File f) {
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private void openBtnActionPerformed(ActionEvent evt) {
        try {
            this.toolDisabled = true;
            JFileChooser chooser = new JFileChooser();
            FileFilter f1 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equalsIgnoreCase("fig");
                }

                public String getDescription() {
                    return "(.fig) Complete figure with graphs and annotations (binary).";
                }
            };
            FileFilter f2 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equalsIgnoreCase("graph");
                }

                public String getDescription() {
                    return "(.graph) Graph only (text)";
                }
            };
            FileFilter f3 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return PlotPanel.this.getExtension(f).equalsIgnoreCase("phd");
                }

                public String getDescription() {
                    return "(.phd) IMS2.0 format";
                }
            };
            chooser.addChoosableFileFilter(f1);
            chooser.addChoosableFileFilter(f2);
            chooser.addChoosableFileFilter(f3);
            chooser.setCurrentDirectory(new File(this.chooserOpenHome));
            chooser.setMultiSelectionEnabled(true);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.chooserOpenHome = chooser.getSelectedFile().getPath();
                File[] files = chooser.getSelectedFiles();
                for (int i = 0; i < files.length; ++i) {
                    try {
                        this.handleOpenFile(files[i]);
                        continue;
                    }
                    catch (Exception ex) {
                        Main.warnUser("Can't load " + files[i].getName() + "\nPossibly wrong format.");
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            Main.warnUser("Loading failed. Possibly wrong format encountered.");
            ex.printStackTrace();
        }
    }

    private void toFrontBtnActionPerformed(ActionEvent evt) {
        List l = this.graphCanvas.getGraphs();
        Object key = this.graphsCombobox.getSelectedItem();
        Graph g = (Graph)this.graphs.get(key);
        l.remove(g);
        l.add(g);
        this.graphsCombobox.removeItem(key);
        this.graphsCombobox1.removeItem(key);
        this.graphsCombobox.addItem(key);
        this.graphsCombobox1.addItem(key);
        this.graphsCombobox1.setSelectedItem(key);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void yAxisLinearActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setLogarithmic(false, 1);
        if (this.graphCanvas.getAxis().getMin(1) == 1.0) {
            this.graphCanvas.getAxis().setMin(0.0, 1);
        }
        this.graphCanvas.getAxis().setTics();
        this.setLogTics(this.graphCanvas.getAxis());
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.zoomButton.setEnabled(true);
        }
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.panButton.setEnabled(true);
        }
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.evalButton.setEnabled(true);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void refreshCanvas() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlotPanel.this.graphCanvas.refresh();
                PlotPanel.this.graphCanvas.repaint();
            }
        });
    }

    private void xAxisLinearActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setLogarithmic(false, 0);
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.zoomButton.setEnabled(true);
        }
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.panButton.setEnabled(true);
        }
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.evalButton.setEnabled(true);
        }
        this.graphCanvas.getAxis().setTics();
        this.setLogTics(this.graphCanvas.getAxis());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void setLogTics(Axis axis) {
        int td;
        int y2;
        int y1;
        int i;
        int d;
        int j;
        int i2;
        int ind;
        double incr;
        double tic;
        double[] tics;
        if (axis.isLogarithmic(1)) {
            tics = new double[55];
            tic = 10.0;
            incr = 10.0;
            ind = 0;
            i2 = 0;
            while (ind < tics.length - 1) {
                for (j = 1; j < 10; ++j) {
                    tics[ind + 1] = (double)j * incr;
                    ++ind;
                }
                incr *= 10.0;
                ++i2;
            }
            tics[0] = 1.0;
            d = 100000000;
            for (i = 0; i < tics.length - 1; ++i) {
                y1 = this.getScreenY(tics[i]);
                y2 = this.getScreenY(tics[i + 1]);
                td = Math.abs(y1 - y2);
                if (Math.abs(y1 - y2) >= d) continue;
                d = Math.abs(y1 - y2);
            }
            if (d <= axis.getTicFont(1).getSize() - 3) {
                tics = new double[10];
                tic = 10.0;
                for (i = 1; i < tics.length; ++i) {
                    tics[i] = tic;
                    tic *= 10.0;
                }
                tics[0] = 1.0;
            }
            axis.setMin(1.0, 1);
            axis.setTics(tics, 1);
        }
        if (axis.isLogarithmic(0)) {
            tics = new double[55];
            tic = 10.0;
            incr = 10.0;
            ind = 0;
            i2 = 0;
            while (ind < tics.length - 1) {
                for (j = 1; j < 10; ++j) {
                    tics[ind + 1] = (double)j * incr;
                    ++ind;
                }
                incr *= 10.0;
                ++i2;
            }
            tics[0] = 1.0;
            d = 100000000;
            for (i = 0; i < tics.length - 1; ++i) {
                y1 = this.getScreenX(tics[i]);
                y2 = this.getScreenX(tics[i + 1]);
                td = Math.abs(y1 - y2);
                if (Math.abs(y1 - y2) >= d) continue;
                d = Math.abs(y1 - y2);
            }
            if (d <= axis.getTicFont(0).getSize() * 3) {
                tics = new double[10];
                tic = 10.0;
                for (i = 1; i < tics.length; ++i) {
                    tics[i] = tic;
                    tic *= 10.0;
                }
                tics[0] = 1.0;
            }
            axis.setMin(1.0, 0);
            axis.setTics(tics, 0);
        }
    }

    private void yAxisLogActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double min = a.getMin(1);
        double max = this.getMax();
        this.yAxisLog.setSelected(true);
        a.setMin(1.0, 1);
        a.setLogarithmic(true, 1);
        this.setLogTics(a);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xAxisLogActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double min = a.getMin(0);
        a.setMin(Math.max(min, 1.0), 0);
        a.setLogarithmic(true, 0);
        this.setLogTics(a);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void graphTitleFieldActionPerformed(ActionEvent evt) {
        HeaderLabel key = (HeaderLabel)this.graphsCombobox.getSelectedItem();
        key.setText(" " + this.graphTitleField.getText());
        Graph g = (Graph)this.graphs.get(this.graphsCombobox.getSelectedItem());
        g.setTitle(this.graphTitleField.getText());
        this.graphsCombobox.repaint();
        this.graphsCombobox1.repaint();
    }

    private void setWidth(Graph g, double d) {
        this.widths.put(g, new Double(d));
    }

    private double getWidth(Graph g) {
        Double d = (Double)this.widths.get(g);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private void graphsComboboxActionPerformed(ActionEvent evt) {
        HeaderLabel key = (HeaderLabel)this.graphsCombobox.getSelectedItem();
        if (key == null) {
            return;
        }
        Graph g = (Graph)this.graphs.get(key);
        if (g == null) {
            this.colorPanel.setBackground(Color.black);
            this.graphTitleField.setText("");
            return;
        }
        this.colorPanel.setBackground(g.getColor());
        this.plotColorPanel.setBackground(g.getColor());
        this.graphTitleField.setText(g.getTitle());
        this.widthField.setText(g.getStrokeWidth() + "");
        this.jCheckBox1.setSelected(g.isFilled());
        this.plotFillPanel.setBackground(g.isFilled() ? Color.gray : this.selectionLabel.getBackground());
        this.deleteGraphMenuItem.setText("Remove currently selected graph");
        this.toFrontItem.setText("Bring currently selected graph to front");
        this.toBackItem.setText("Send currently selected graph to back");
        this.saveSelectedMenuItem.setText("Save currently selected graph to disk");
        double of = g.getOffset();
        if (!Double.isNaN(of)) {
            this.correctionField.setEnabled(true);
            this.correctionField.setText(of + "");
            this.correctionField.setVisible(true);
            this.correction.setVisible(true);
            this.correction2.setVisible(true);
            this.width.setVisible(true);
            this.width2.setVisible(true);
            double w = this.getWidth(g);
            if (w != 0.0) {
                this.width2.setText(PlotPanel.simpleRound(w, 2) + " keV");
            } else if (g instanceof XYGraph) {
                double[] x = ((XYGraph)g).getX();
                w = (x[1] - x[0]) * 1000.0;
                w = (double)((long)(w * 100.0)) / 100.0;
                this.width2.setText(PlotPanel.simpleRound(w, 2) + " keV");
            } else {
                this.width2.setText("n/a");
            }
        } else {
            this.correctionField.setVisible(false);
            this.correction.setVisible(false);
            this.correctionField.setText("");
            this.correction2.setVisible(false);
            this.width.setVisible(false);
            this.width2.setVisible(false);
            this.correction.setVisible(false);
        }
        boolean old = this.loading;
        this.loading = true;
        this.graphsCombobox1.setSelectedItem(this.graphsCombobox.getSelectedItem());
        this.loading = old;
        if (this.tool == 5) {
            this.graphCanvas.setSelected(g);
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PlotPanel.this.drawAnchors();
                }
            });
        }
    }

    public static double simpleRound(double v, int decimals) {
        if (decimals == 0) {
            return Math.round(v);
        }
        double c = coeffs[decimals];
        return (double)((long)(v * c)) / c;
    }

    private void deleteGraphButtonActionPerformed(ActionEvent evt) {
        Object key = this.graphsCombobox.getSelectedItem();
        if (key == null) {
            return;
        }
        this.graphCanvas.getGraphs().remove(this.graphs.get(key));
        this.loading = true;
        this.graphsCombobox1.removeItem(this.graphsCombobox.getSelectedItem());
        this.loading = false;
        this.graphsCombobox.removeItem(this.graphsCombobox.getSelectedItem());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
        System.gc();
    }

    private void yTicsCheckboxActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setDrawTicks(this.yTicsCheckbox.isSelected(), 1);
        this.redoTicsY.setEnabled(this.yTicsCheckbox.isSelected());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void handleColorChooser_actionOK(ActionEvent e) {
        this.dialog.dispose();
        Color c = this.jcc.getColor();
        this.colorPanel.setBackground(c);
        this.plotColorPanel.setBackground(c);
        this.colorPanel.repaint();
        Graph g = (Graph)this.graphs.get(this.graphsCombobox.getSelectedItem());
        g.setColor(c);
        HeaderLabel h = (HeaderLabel)this.graphsCombobox.getSelectedItem();
        h.setFore(c);
        this.graphCanvas.refresh();
    }

    private void handleColorChooser_actionCancel(ActionEvent e) {
        this.dialog.dispose();
    }

    private void colorPanelMouseClicked(MouseEvent evt) {
        this.toolDisabled = true;
        if (this.jcc == null) {
            this.jcc = new JColorChooser();
        }
        this.dialog = JColorChooser.createDialog(this.colorPanel, "Graph color", true, this.jcc, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotPanel.this.handleColorChooser_actionOK(e);
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotPanel.this.handleColorChooser_actionCancel(e);
            }
        });
        this.dialog.show();
        this.graphCanvas.repaint();
    }

    private void graphCanvas_handleMouseDragged(MouseEvent evt) {
        this.isDragging = true;
        if (this.tool == 2) {
            Point p = evt.getPoint();
            if (this.prev != null) {
                int dx = p.x - this.prev.x;
                int dy = p.y - this.prev.y;
                if (this.panMode == 2) {
                    dy = 0;
                } else if (this.panMode == 3) {
                    dx = 0;
                }
                this.pan(-dx, dy);
            }
            this.prev = p;
        }
        if (this.tool == 1) {
            if (this.end != null) {
                this.fillRectXor();
            }
            this.end = evt.getPoint();
            this.fillRectXor();
        }
        if (this.tool == 8) {
            if (this.end != null) {
                this.fillRectXor();
            }
            this.end = evt.getPoint();
            this.fillRectXor();
        }
        if (this.tool == 5) {
            int indx;
            List l;
            if (this.selectedObj == null) {
                return;
            }
            if (this.selectedObj instanceof String) {
                l = this.graphCanvas.getAnnotations();
                indx = l.indexOf(this.selectedObj);
                Object location = l.get(indx + 1);
                if (this.toolCoordinates == 2) {
                    double[] loc;
                    if (location instanceof double[]) {
                        loc = (double[])location;
                    } else {
                        int[] lo = (int[])location;
                        loc = new double[]{this.getDomain(lo[0]), this.getValue(lo[0])};
                        l.remove(indx + 1);
                        l.add(indx + 1, loc);
                    }
                    loc[0] = this.getDomain(evt.getX());
                    loc[1] = this.getValue(evt.getY());
                    if (this.prev != null) {
                        this.drawDragStringXor(this.prev, this.ovx, this.ovy, this.selectedFont, this.prevCs);
                    }
                    this.drawDragStringXor(evt.getPoint(), loc[0], loc[1], this.selectedFont, this.cs);
                    this.ovx = loc[0];
                    this.ovy = loc[1];
                } else {
                    int[] loc;
                    if (location instanceof int[]) {
                        loc = (int[])l.get(indx + 1);
                    } else {
                        loc = new int[2];
                        l.remove(indx + 1);
                        l.add(indx + 1, loc);
                    }
                    loc[0] = evt.getX() / 10 * 10;
                    loc[1] = evt.getY() / 10 * 10;
                    if (this.prev != null) {
                        this.drawDragStringXor(this.prev, this.ovx, this.ovy, this.selectedFont, this.prevCs);
                    }
                    this.drawDragStringXor(new Point(loc[0], loc[1]), this.ovx, this.ovy, this.selectedFont, this.cs);
                }
            } else if (this.selectedObj instanceof Image) {
                l = this.graphCanvas.getAnnotations();
                indx = l.indexOf(this.selectedObj);
                if (this.toolCoordinates == 2) {
                    Object loca = l.get(indx + 1);
                    double[] loc = null;
                    if (loca instanceof double[]) {
                        loc = (double[])loca;
                    } else {
                        loc = new double[2];
                        l.remove(indx + 1);
                        l.add(indx + 1, loc);
                    }
                    loc[0] = this.getDomain(evt.getX());
                    loc[1] = this.getValue(evt.getY());
                    if (this.prev != null) {
                        this.drawDragImageXor(this.prev, this.ovx, this.ovy, this.prevCs);
                    }
                    this.drawDragImageXor(evt.getPoint(), loc[0], loc[1], this.cs);
                    this.ovx = loc[0];
                    this.ovy = loc[1];
                } else {
                    Object loca = l.get(indx + 1);
                    int[] loc = null;
                    if (loca instanceof int[]) {
                        loc = (int[])loca;
                    } else {
                        l.remove(indx + 1);
                        loc = new int[2];
                        l.add(indx + 1, loc);
                    }
                    loc[0] = evt.getX();
                    loc[1] = evt.getY();
                    if (this.prev != null) {
                        this.drawDragImageXor(this.prev, this.ovx, this.ovy, this.prevCs);
                    }
                    this.drawDragImageXor(evt.getPoint(), this.ovx, this.ovy, this.cs);
                }
                this.prevCs = this.cs;
            } else if (this.selectedObj instanceof double[]) {
                l = this.graphCanvas.getAnnotations();
                double[] loc = (double[])this.selectedObj;
                if (this.selectedPt == 1) {
                    loc[0] = this.getDomain(evt.getX());
                    loc[1] = this.getValue(evt.getY());
                } else {
                    loc[2] = this.getDomain(evt.getX());
                    loc[3] = this.getValue(evt.getY());
                }
                if (this.prev != null) {
                    this.drawLineXor(this.prev, this.prevCs);
                }
                this.drawLineXor(evt.getPoint(), this.cs);
                this.ovx = loc[0];
                this.ovy = loc[1];
            } else if (this.selectedObj instanceof int[]) {
                int[] loc = (int[])this.selectedObj;
                if (this.selectedPt == 1) {
                    loc[0] = evt.getX();
                    loc[1] = evt.getY();
                } else {
                    loc[2] = evt.getX();
                    loc[3] = evt.getY();
                }
                if (this.prev != null) {
                    this.drawLineXor(this.prev, this.prevCs);
                }
                this.drawLineXor(evt.getPoint(), this.cs);
                this.ovx = loc[0];
                this.ovy = loc[1];
            }
            this.prevCs = this.cs;
        }
        if (this.tool == 6) {
            if (this.prev != null) {
                this.drawLineXor(this.prev, this.prevCs);
            }
            this.p = evt.getPoint();
            this.drawLineXor(this.p, this.cs);
            this.prev = this.p;
        }
    }

    private void redoTicsYActionPerformed(ActionEvent evt) {
        Font f = this.graphCanvas.getAxis().getTicFont(1);
        this.graphCanvas.getAxis().setTicFont(f.deriveFont((float)f.getSize() + 1.0f), 1);
        if (this.graphCanvas.getAxis().isLogarithmic(1)) {
            this.setLogTics(this.graphCanvas.getAxis());
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void graphCanvasMouseExited(MouseEvent evt) {
        if (this.toolDisabled) {
            return;
        }
        if (this.tool == 1) {
            this.p = this.prev;
            this.drawRectXor();
            this.prev = null;
        }
        if (this.tool == 4) {
            this.p = this.prev;
            this.drawEvalXor(this.p, this.ovx, this.ovy);
            this.ovy = Double.NEGATIVE_INFINITY;
        }
        if (this.tool == 3) {
            this.p = this.prev;
            this.drawTextXor(this.p, this.ovx, this.ovy, this.prevCs);
            this.ovy = Double.NEGATIVE_INFINITY;
        }
    }

    private void resumeTool() {
        if (this.tool == 1) {
            this.prev = null;
            this.drawRectXor();
        }
        if (this.tool == 5) {
            this.drawAnchors();
        }
    }

    private void drawAnchor(int x, int y) {
        Graphics g = this.graphCanvas.getGraphics();
        g.setColor(Color.red);
        g.fillOval(x - 5, y - 5, 10, 10);
        g.setColor(Color.ORANGE);
        g.fillOval(x - 5, y - 5, 6, 6);
        g.setColor(Color.white);
        g.fillOval(x - 4, y - 4, 4, 4);
    }

    private void drawSelectedAnchor(int x, int y) {
        Graphics g = this.graphCanvas.getGraphics();
        g.setColor(Color.green);
        g.fillOval(x - 5, y - 5, 10, 10);
        g.setColor(Color.yellow);
        g.fillOval(x - 5, y - 5, 6, 6);
        g.setColor(Color.white);
        g.fillOval(x - 4, y - 4, 4, 4);
    }

    private void drawAnchors() {
        List l = this.graphCanvas.getAnnotations();
        int xi = this.graphCanvas.getXInset();
        int yi = this.graphCanvas.getYInset();
        int wi = xi + this.graphCanvas.getAxis().getSize(0);
        int hi = yi + this.graphCanvas.getAxis().getSize(1);
        Object last = null;
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Object[] loc;
            Object ann = iter.next();
            if (ann instanceof int[]) {
                loc = (int[])ann;
                if (loc.length < 4) {
                    if (last != this.selectedObj || this.graphsCombobox.getSelectedIndex() != -1) {
                        this.drawAnchor(loc[0], loc[1]);
                    } else {
                        this.drawSelectedAnchor(loc[0], loc[1]);
                    }
                } else if (this.selectedObj != ann || this.graphsCombobox.getSelectedIndex() != -1) {
                    this.drawAnchor(loc[0], loc[1]);
                    this.drawAnchor(loc[2], loc[3]);
                } else {
                    this.drawSelectedAnchor(loc[0], loc[1]);
                    this.drawSelectedAnchor(loc[2], loc[3]);
                }
            }
            if (ann instanceof double[]) {
                int y;
                int x;
                loc = (double[])ann;
                if (loc.length < 4) {
                    x = this.getScreenX(loc[0]);
                    y = this.getScreenY(loc[1]);
                    if (x > xi && y > yi && x < wi && y < hi) {
                        if (this.selectedObj != last) {
                            this.drawAnchor(this.getScreenX(loc[0]), this.getScreenY(loc[1]));
                        } else {
                            this.drawSelectedAnchor(this.getScreenX(loc[0]), this.getScreenY(loc[1]));
                        }
                    }
                } else {
                    x = this.getScreenX(loc[0]);
                    y = this.getScreenY(loc[1]);
                    if (x > xi && y > yi && x < wi && y < hi && this.selectedObj != ann) {
                        this.drawAnchor(this.getScreenX(loc[0]), this.getScreenY(loc[1]));
                    } else if (x > xi && y > yi && x < wi && y < hi && this.selectedObj == ann) {
                        this.drawSelectedAnchor(this.getScreenX(loc[0]), this.getScreenY(loc[1]));
                    }
                    x = this.getScreenX(loc[2]);
                    y = this.getScreenY(loc[3]);
                    if (x > xi && y > yi && x < wi && y < hi && this.selectedObj != ann) {
                        this.drawAnchor(this.getScreenX(loc[2]), this.getScreenY(loc[3]));
                    } else if (x > xi && y > yi && x < wi && y < hi && this.selectedObj == ann) {
                        this.drawSelectedAnchor(this.getScreenX(loc[2]), this.getScreenY(loc[3]));
                    }
                }
            }
            last = ann;
        }
    }

    private void drawRectXor() {
        Axis a = this.graphCanvas.getAxis();
        double lenx = a.getSize(0) / 5;
        double leny = a.getSize(1) / 5;
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.gray);
        if (this.p.x < this.graphCanvas.getXInset()) {
            g.drawRect(this.p.x - 4, this.p.y - (int)(leny / 2.0), 8, (int)leny);
            g.drawString("Left button - zoom in", this.p.x - 2, this.p.y - (int)(leny / 2.0) - 25);
            g.drawString("Right button - zoom out", this.p.x - 2, this.p.y - (int)(leny / 2.0) - 15);
            g.drawString("Drag to zoom region", this.p.x - 2, this.p.y - (int)(leny / 2.0) - 5);
        } else if (this.p.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            g.drawRect(this.p.x - (int)(lenx / 2.0), this.p.y - 4, (int)lenx, 8);
            g.drawString("Left button - zoom in", this.p.x - 2, this.p.y - 4 - 25);
            g.drawString("Right button - zoom out", this.p.x - 2, this.p.y - 4 - 15);
            g.drawString("Drag to zoom region", this.p.x - 2, this.p.y - 4 - 5);
        } else {
            g.drawString("< Move cursor to axis you want to zoom >", this.p.x - 2, this.p.y - 5);
        }
        this.prev = this.p;
    }

    private void drawPanXor(Point p) {
        Axis a = this.graphCanvas.getAxis();
        double lenx = a.getSize(0) / 5;
        double leny = a.getSize(1) / 5;
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.gray);
        if (p.x < this.graphCanvas.getXInset()) {
            g.drawString("< Drag to pan on y-axis >", p.x + 4, p.y - 8);
        } else if (p.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            g.drawString("< Drag to pan on x-axis >", p.x + 4, p.y - 8);
        } else {
            g.drawString("< Drag to pan >", p.x + 4, p.y - 8);
        }
        this.prev = p;
    }

    private void fillRectXor() {
        Axis a = this.graphCanvas.getAxis();
        int lenx = Math.abs(this.end.x - this.start.x);
        int leny = Math.abs(this.end.y - this.start.y);
        int sx = Math.min(this.start.x, this.end.x);
        int sy = Math.min(this.start.y, this.end.y);
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.red);
        if (this.start.x < this.graphCanvas.getXInset()) {
            g.fillRect(this.graphCanvas.getXInset(), sy, this.graphCanvas.getAxis().getSize(0), leny);
        } else if (this.start.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            g.fillRect(sx, this.graphCanvas.getYInset(), lenx, this.graphCanvas.getAxis().getSize(1));
        } else {
            this.end = this.start;
        }
        this.prev = this.p;
    }

    private void drawLineXor(Point p, String csMsg) {
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.gray);
        if (this.start == null) {
            String pos = "";
            if (this.toolCoordinates == 1) {
                g.drawString("< click and drag to add line > ", p.x + 2, p.y);
            } else if (this.insideAxis(p)) {
                g.drawString("< click and drag to add line tag > ", p.x + 2, p.y);
            } else {
                g.drawString("< Move the cursor inside the axis area > ", p.x + 2, p.y);
            }
            return;
        }
        if (this.prev != null && this.start != null) {
            g.drawLine(this.start.x, this.start.y, this.prev.x, this.prev.y);
        }
        if (this.tool == 6) {
            g.drawString("< release button to add this line >", p.x + 2, p.y - 2);
        } else {
            g.drawString("< release button to reposition this line >", p.x + 2, p.y - 2);
        }
        if (this.toolCoordinates == 2 && !this.insideAxis(p)) {
            g.drawString("Note: Line tag won't be displayed fully in current plot range.", p.x + 4, p.y + 10);
        }
        if (this.start != null) {
            g.drawLine(this.start.x, this.start.y, p.x, p.y);
        }
        this.prev = p;
    }

    private void drawTextXor(Point p, double vx, double vy, String csStr) {
        String yStr;
        boolean e = true;
        boolean c = true;
        Axis a = this.graphCanvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.gray);
        String xStr = e ? this.xAxisTitleField.getText() + ": " + this.format.format(vx) : "";
        String string = yStr = c ? this.yAxisTitleField.getText() + ": " + this.format.format(vy) : "";
        if (p != null && !this.tdialog.isShowing()) {
            if (this.toolCoordinates == 1) {
                g.drawString("< click to add text here > ", p.x + 2, p.y);
            } else if (this.insideAxis(p)) {
                g.drawString("< click to add text tag here > ", p.x + 2, p.y);
            } else {
                g.drawString("< Move the cursor inside the axis area > ", p.x + 2, p.y);
            }
        } else if (p != null && this.tdialog.isShowing()) {
            g.drawString("< click to end editing > ", p.x + 2, p.y);
        }
        this.prev = p;
    }

    private void drawDragStringXor(Point p, double vx, double vy, Font font, String csmsg) {
        boolean e = true;
        boolean c = true;
        Axis a = this.graphCanvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.gray);
        String xStr = e ? this.xAxisTitleField.getText() + ": " + this.format.format(vx) : "";
        String yStr = c ? this.yAxisTitleField.getText() + ": " + this.format.format(vy) : "";
        Font t = g.getFont();
        if (font != null) {
            g.setFont(font);
        }
        if (this.toolCoordinates == 1) {
            g.drawString((String)this.selectedObj, p.x, p.y);
            g.setFont(t);
        } else if (this.insideAxis(p)) {
            g.drawString((String)this.selectedObj, p.x, p.y);
            g.setFont(t);
        } else {
            g.drawString((String)this.selectedObj, p.x, p.y);
            g.setFont(t);
            g.drawString("Note: Text tag object will not be visible in current plot range", p.x + 4, p.y + 10);
        }
        this.prev = p;
    }

    private void drawDragImageXor(Point p, double vx, double vy, String csmsg) {
        boolean e = true;
        boolean c = true;
        Axis a = this.graphCanvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.gray);
        String xStr = e ? this.xAxisTitleField.getText() + ": " + this.format.format(vx) : "";
        String yStr = c ? this.yAxisTitleField.getText() + ": " + this.format.format(vy) : "";
        g.drawString(csmsg, p.x + 2, p.y - 10);
        Image sel = (Image)this.selectedObj;
        g.drawRect(p.x, p.y, sel.getWidth(null), sel.getHeight(null));
        this.prev = p;
    }

    private void drawEvalXor(Point p, double vx, double vy) {
        String yStr;
        boolean e = true;
        boolean c = true;
        if (p == null) {
            return;
        }
        Axis a = this.graphCanvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.gray);
        if (p.x < this.graphCanvas.getXInset()) {
            g.drawLine(0, p.y, lenx, p.y);
            e = false;
        } else if (p.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            c = false;
            g.drawLine(p.x, leny, p.x, 0);
        } else {
            g.drawLine(0, p.y, lenx, p.y);
            g.drawLine(p.x, leny, p.x, 0);
        }
        String xStr = e ? this.xAxisTitleField.getText() + ": " + this.format.format(vx) : "";
        String string = yStr = c ? this.yAxisTitleField.getText() + ": " + this.format2.format(vy) : "";
        if (this.tool == 4) {
            g.drawString(xStr + " " + yStr, p.x + 20, p.y - 20);
        } else {
            g.drawString(xStr + " <drag to define fit range>", p.x + 2, p.y - 2);
        }
        this.prev = p;
    }

    private void drawSelectXor(Point p, double vx, double vy, String typeStr) {
        boolean e = true;
        boolean c = true;
        Axis a = this.graphCanvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)this.graphCanvas.getGraphics();
        g.setXORMode(Color.gray);
        if (typeStr == null) {
            g.drawString("< Move cursor to an anchor >", p.x, p.y - 2);
            this.prev = p;
            return;
        }
        if (p.x < this.graphCanvas.getXInset()) {
            e = false;
        } else if (p.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            c = false;
        }
        String xStr = "x: " + p.x;
        String yStr = "y: " + p.y;
        int sw = SwingUtilities.computeStringWidth(g.getFontMetrics(), typeStr);
        g.drawString(typeStr, p.x - sw - 2, p.y - 16);
        this.prev = p;
    }

    private void eval(int x, int y) {
        Axis a = this.graphCanvas.getAxis();
        int ay = this.graphCanvas.getHeight() - this.graphCanvas.getYInset() - y;
        double vx = a.getValueForAxisCoordinate(x - this.graphCanvas.getXInset(), 0);
        double vy = a.getValueForAxisCoordinate(ay, 1);
        if (!Double.isInfinite(this.ovy)) {
            this.drawEvalXor(this.prev, this.ovx, this.ovy);
        }
        this.drawEvalXor(this.p, vx, vy);
        this.ovx = vx;
        this.ovy = vy;
    }

    private void text(int x, int y) {
        Axis a = this.graphCanvas.getAxis();
        int ay = this.graphCanvas.getHeight() - this.graphCanvas.getYInset() - y;
        double vx = a.getValueForAxisCoordinate(x - this.graphCanvas.getXInset(), 0);
        double vy = a.getValueForAxisCoordinate(ay, 1);
        String csStr = "";
        if (this.toolCoordinates == 1) {
            csStr = " (absolute positioning)";
        }
        if (this.toolCoordinates == 2) {
            csStr = " (relative positioning)";
        }
        if (!Double.isInfinite(this.ovy)) {
            this.drawTextXor(this.prev, this.ovx, this.ovy, this.prevCs);
        }
        this.drawTextXor(this.p, vx, vy, csStr);
        this.prev = this.p;
        this.ovx = vx;
        this.ovy = vy;
        this.prevCs = csStr;
    }

    private void select(int x, int y) {
        this.selectedObj = null;
        Axis a = this.graphCanvas.getAxis();
        int ay = this.graphCanvas.getHeight() - this.graphCanvas.getYInset() - y;
        double vx = a.getValueForAxisCoordinate(x - this.graphCanvas.getXInset(), 0);
        double vy = a.getValueForAxisCoordinate(ay, 1);
        double two = a.getValueForAxisCoordinate(2, 0);
        double one = a.getValueForAxisCoordinate(1, 0);
        double intrX = two - one;
        two = a.getValueForAxisCoordinate(2, 1);
        one = a.getValueForAxisCoordinate(1, 1);
        double intrY = two - one;
        List l = this.graphCanvas.getAnnotations();
        Iterator iter = l.iterator();
        int ind = 0;
        this.type = null;
        int xi = this.graphCanvas.getXInset();
        int yi = this.graphCanvas.getYInset();
        int wi = xi + this.graphCanvas.getAxis().getSize(0);
        int hi = yi + this.graphCanvas.getAxis().getSize(1);
        while (iter.hasNext()) {
            Object[] line;
            Object ann = iter.next();
            if (ann instanceof double[] && (line = (double[])ann).length == 4) {
                Axis ax;
                int x1 = this.getScreenX(line[0]);
                int y1 = this.getScreenY(line[1]);
                int x2 = this.getScreenX(line[2]);
                int y2 = this.getScreenY(line[3]);
                if (Math.abs(x1 - x) < 5 && Math.abs(y1 - y) < 5 && x1 > xi && x1 < wi && y1 > yi && y1 < hi) {
                    this.selectedObj = line;
                    this.selectedPt = 1;
                    this.toolCoordinates = 2;
                    this.type = this.tool == 5 ? "Line tag object - drag to reposition" : "Line tag object - click to delete";
                    ax = this.graphCanvas.getAxis();
                    this.start = new Point((int)ax.getAxisCoordinateForValue(line[2], 0) + ax.getLocation().x, this.graphCanvas.getHeight() - (int)ax.getAxisCoordinateForValue(line[3], 1) - this.graphCanvas.getYInset());
                } else if (Math.abs(x2 - x) < 5 && Math.abs(y2 - y) < 5 && x2 > xi && x2 < wi && y2 > yi && y2 < hi) {
                    this.selectedObj = line;
                    this.selectedPt = 2;
                    this.toolCoordinates = 2;
                    this.type = this.tool == 5 ? "Line tag object - drag to reposition" : "Line tag object - click to delete";
                    ax = this.graphCanvas.getAxis();
                    this.start = new Point((int)ax.getAxisCoordinateForValue(line[0], 0) + ax.getLocation().x, this.graphCanvas.getHeight() - (int)ax.getAxisCoordinateForValue(line[1], 1) - this.graphCanvas.getYInset());
                }
            }
            if (ann instanceof int[] && (line = (Object[])((int[])ann)).length == 4) {
                if (Math.abs((int)(line[0] - x)) < 5 && Math.abs((int)(line[1] - y)) < 5) {
                    this.selectedObj = line;
                    this.selectedPt = 1;
                    this.toolCoordinates = 1;
                    this.start = new Point((int)line[2], (int)line[3]);
                    this.type = this.tool == 5 ? "Line object - drag to reposition" : "Line object - click to delete";
                } else if (Math.abs((int)(line[2] - x)) < 5 && Math.abs((int)(line[3] - y)) < 5) {
                    this.selectedObj = line;
                    this.selectedPt = 2;
                    this.toolCoordinates = 1;
                    this.start = new Point((int)line[0], (int)line[1]);
                    this.type = this.tool == 5 ? "Line object - drag to reposition" : "Line object - click to delete";
                }
            }
            if (ann instanceof String || ann instanceof Image) {
                Object[] loc;
                Object location = iter.next();
                if (location instanceof double[]) {
                    loc = (double[])location;
                    int x1 = this.getScreenX(loc[0]);
                    int y1 = this.getScreenY(loc[1]);
                    if (Math.abs(x1 - x) < 5 && Math.abs(y1 - y) < 5 && x1 > xi && x1 < wi && y1 > yi && y1 < hi) {
                        this.selectedObj = ann;
                        vx = loc[0];
                        vy = loc[1];
                        this.toolCoordinates = 2;
                        if (ann instanceof String) {
                            this.type = this.tool == 5 ? "Text tag object - click to edit, drag to reposition" : "Text tag object - click to remove";
                            try {
                                this.selectedFont = (Font)l.get(l.indexOf(ann) - 1);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            this.type = this.tool == 5 ? "Image object - drag to reposition" : "Image object - click to delete";
                        }
                    }
                    ++ind;
                } else {
                    loc = (int[])location;
                    if (Math.abs((int)(loc[0] - x)) < 5 && Math.abs((int)(loc[1] - y)) < 5) {
                        this.selectedObj = ann;
                        vx = loc[0];
                        vy = loc[1];
                        this.toolCoordinates = 1;
                        if (ann instanceof String) {
                            this.type = this.tool == 5 ? "Text object - click to edit, drag to reposition" : "Text object - click to remove";
                            try {
                                this.selectedFont = (Font)l.get(l.indexOf(ann) - 1);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            this.type = this.tool == 5 ? "Image object - drag to reposition" : "Image object - click to delete";
                        }
                    }
                }
                ++ind;
            }
            ++ind;
        }
        this.prev = this.p;
        this.ovx = vx;
        this.ovy = vy;
        this.ptype = this.type;
    }

    private void pan(int dx, int dy) {
        double d;
        Axis a = this.graphCanvas.getAxis();
        double mix = a.getMin(0);
        double miy = a.getMin(1);
        double max = a.getMax(0);
        double may = a.getMax(1);
        int one = 1;
        int two = 2;
        double donex = a.getValueForAxisCoordinate(two, 0) - a.getValueForAxisCoordinate(one, 0);
        double doney = a.getValueForAxisCoordinate(two, 1) - a.getValueForAxisCoordinate(one, 1);
        double ddx = (double)dx * donex;
        double ddy = (double)dy * doney;
        a.setMinMax(mix + ddx, miy + ddy, max + ddx, may + ddy);
        mix = a.getMin(0);
        max = a.getMax(0);
        if (mix < 0.0) {
            d = max - mix;
            a.setMinMax(0.0, d, 0);
        }
        miy = a.getMin(1);
        may = a.getMax(1);
        if (miy < 0.0) {
            d = may - miy;
            a.setMinMax(0.0, d, 1);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void zoom(Point p, int button) {
        Axis a = this.graphCanvas.getAxis();
        double mix = a.getMin(0);
        double miy = a.getMin(1);
        double max = a.getMax(0);
        double may = a.getMax(1);
        double lenx = (max - mix) / 2.0;
        double leny = (may - miy) / 2.0;
        int px = p.x - this.graphCanvas.getXInset();
        int py = this.graphCanvas.getHeight() - p.y - this.graphCanvas.getYInset();
        double cx = a.getValueForAxisCoordinate(px, 0);
        double cy = a.getValueForAxisCoordinate(py, 1);
        double f = 0.0;
        double len1x = cx - mix;
        double len2x = max - cx;
        double len1y = cy - miy;
        double len2y = may - cy;
        f = button == 1 ? this.zoomf : 2.0 - this.zoomf;
        len1x /= f;
        len2x /= f;
        len1y /= f;
        len2y /= f;
        if (p.x < this.graphCanvas.getXInset()) {
            double my = cy - len1y;
            my = Math.max(my, 0.0);
            a.setMinMax(mix, my, max, cy + len2y);
            a.setTics(10);
            if (a.isLogarithmic(1)) {
                this.setLogTics(a);
            }
        } else if (p.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            double mx = cx - len1x;
            mx = Math.max(mx, 0.0);
            a.setMinMax(mx, miy, cx + len2x, may);
            a.setTics(10);
            if (a.isLogarithmic(1)) {
                this.setLogTics(a);
            }
        } else {
            double my = cy - len1y;
            my = Math.max(my, 0.0);
            double mx = cx - len1x;
            mx = Math.max(mx, 0.0);
            a.setMinMax(mx, my, cx + len2x, cy + len2y);
            a.setTics(10);
            if (a.isLogarithmic(1)) {
                this.setLogTics(a);
            }
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
        this.prev = null;
    }

    private void zoom() {
        Axis a = this.graphCanvas.getAxis();
        double mix = a.getMin(0);
        double miy = a.getMin(1);
        double max = a.getMax(0);
        double may = a.getMax(1);
        double lenx = (max - mix) / 2.0;
        double leny = (may - miy) / 2.0;
        int px1 = this.start.x - this.graphCanvas.getXInset();
        int py1 = this.graphCanvas.getHeight() - this.start.y - this.graphCanvas.getYInset();
        int px2 = this.end.x - this.graphCanvas.getXInset();
        int py2 = this.graphCanvas.getHeight() - this.end.y - this.graphCanvas.getYInset();
        double cx1 = a.getValueForAxisCoordinate(px1, 0);
        double cy1 = a.getValueForAxisCoordinate(py1, 1);
        double cx2 = a.getValueForAxisCoordinate(px2, 0);
        double cy2 = a.getValueForAxisCoordinate(py2, 1);
        double f = 0.0;
        double len1x = cx1 - mix;
        double len2x = max - cx1;
        double len1y = cy1 - miy;
        double len2y = may - cy1;
        len1x /= f;
        len2x /= f;
        len1y /= f;
        len2y /= f;
        if (this.p.x < this.graphCanvas.getXInset()) {
            double m = Math.min(cy1, cy2);
            m = Math.max(0.0, m);
            double M = Math.max(cy1, cy2);
            a.setMinMax(mix, m, max, M);
            a.setTics(10);
            if (a.isLogarithmic(1)) {
                this.setLogTics(a);
            }
        } else if (this.p.y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
            double m = Math.min(cx1, cx2);
            m = Math.max(0.0, m);
            double M = Math.max(cx1, cx2);
            a.setMinMax(m, miy, M, may);
            a.setTics(10);
            if (a.isLogarithmic(1)) {
                this.setLogTics(a);
            }
        } else {
            double my = Math.min(cy1, cy2);
            double My = Math.max(cy1, cy2);
            double mx = Math.min(cx1, cx2);
            double Mx = Math.max(cx1, cx2);
            my = Math.max(0.0, my);
            mx = Math.max(0.0, mx);
            a.setMinMax(mx, my, Mx, My);
            a.setTics(10);
            if (a.isLogarithmic(1)) {
                this.setLogTics(a);
            }
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
        this.prev = null;
    }

    private void graphCanvasMouseMoved(MouseEvent evt) {
        this.current = evt.getPoint();
        if (this.toolDisabled) {
            this.toolDisabled = false;
            return;
        }
        if (this.tool == 4) {
            this.p = evt.getPoint();
            this.eval(this.p.x, this.p.y);
        }
        if (this.tool == 8) {
            this.p = evt.getPoint();
            this.eval(this.p.x, this.p.y);
        }
        if (this.tool == 3) {
            this.p = evt.getPoint();
            if (this.toolCoordinates == 1) {
                this.p.x = this.p.x / 20 * 20;
                this.p.y = this.p.y / 20 * 20;
            }
            this.text(this.p.x, this.p.y);
        }
        if (this.tool == 1) {
            if (this.prev != null) {
                this.p = this.prev;
                this.drawRectXor();
            }
            this.p = evt.getPoint();
            this.drawRectXor();
            this.prev = this.p;
        }
        if (this.tool == 6) {
            if (this.prev != null) {
                this.drawLineXor(this.prev, this.prevCs);
            }
            this.p = evt.getPoint();
            this.drawLineXor(this.p, this.cs);
            this.prev = this.p;
        }
        if (this.tool == 5 || this.tool == 7) {
            this.p = evt.getPoint();
        }
        if (this.tool == 2) {
            int x = evt.getX();
            int y = evt.getY();
            if (y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
                this.panMode = 2;
                this.graphCanvas.setCursor(Cursor.getPredefinedCursor(10));
            } else if (x < this.graphCanvas.getXInset() && y < this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
                this.panMode = 3;
                this.graphCanvas.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                this.panMode = 1;
                this.graphCanvas.setCursor(Cursor.getPredefinedCursor(13));
            }
            if (this.prev != null) {
                this.drawPanXor(this.prev);
            }
            this.p = evt.getPoint();
            this.drawPanXor(this.p);
            this.prev = this.p;
        }
        this.prevCs = this.cs;
    }

    private void graphCanvas_handleMouseClicked(MouseEvent evt) {
        if (!this.isClick) {
            this.isClick = true;
            return;
        }
        if (this.tool == 2) {
            this.prev = null;
        }
        if (this.tool == 3) {
            this.p = evt.getPoint();
            if (this.toolCoordinates == 1 || this.toolCoordinates == 2 && this.insideAxis(this.p)) {
                this.p = this.prev;
                this.drawTextXor(this.p, this.ovx, this.ovy, this.prevCs);
                this.ovy = Double.NEGATIVE_INFINITY;
                this.p = evt.getPoint();
                if (this.toolCoordinates == 1) {
                    this.p.x = this.p.x / 20 * 20;
                    this.p.y = this.p.y / 20 * 20;
                }
                this.isEditing = false;
                this.prevTool = 3;
                this.addTextDialog(this.p.x, this.p.y);
            }
        }
        if (this.tool == 7) {
            this.deleteSelectedObject();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PlotPanel.this.drawAnchors();
                }
            });
        }
        if (this.tool == 5) {
            Object oldSel = this.selectedObj;
            List l = this.graphCanvas.getGraphs();
            boolean found = false;
            Graph selected = this.getSelectedGraph();
            for (int i = 0; i < l.size() && !found; ++i) {
                XYGraph g = (XYGraph)l.get(i);
                if (g == selected) continue;
                double[] x = g.getX();
                double[] y = g.getY();
                Point p = evt.getPoint();
                for (int j = 0; j < x.length - 1 && !found; ++j) {
                    double a;
                    double dx;
                    int sx = this.getScreenX(x[j]);
                    int sy = this.getScreenY(y[j]);
                    int sx2 = this.getScreenX(x[j + 1]);
                    int sy2 = this.getScreenY(y[j + 1]);
                    if (p.x < sx || p.x >= sx2) continue;
                    if (sy2 == sy) {
                        if (p.y < sy) continue;
                        found = true;
                        selected = g;
                        continue;
                    }
                    if (sx2 == sx || !((double)p.y >= (double)sy + (dx = (double)(p.x - sx)) * (a = (double)((sy2 - sy) / (sx2 - sx))))) continue;
                    found = true;
                    selected = g;
                }
            }
            if (!found) {
                if (this.isDragging) {
                    return;
                }
                this.select(evt.getX(), evt.getY());
                if (this.selectedObj == null) {
                    return;
                }
                this.graphsCombobox.setSelectedIndex(-1);
                if (this.selectedObj != oldSel) {
                    this.graphCanvas.setSelected(null);
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PlotPanel.this.drawAnchors();
                        }
                    });
                    return;
                }
                if (this.selectedObj instanceof String) {
                    Object[] loc;
                    this.tool = 3;
                    this.addTextButton.setSelected(true);
                    l = this.graphCanvas.getAnnotations();
                    int indx = l.indexOf(this.selectedObj);
                    if (indx == -1) {
                        return;
                    }
                    if (this.toolCoordinates == 1) {
                        loc = (int[])l.get(indx + 1);
                        if (this.p == null) {
                            this.p = new Point();
                        }
                        this.p.x = loc[0];
                        this.p.y = loc[1];
                    }
                    if (this.toolCoordinates == 2) {
                        loc = (double[])l.get(indx + 1);
                        if (this.p == null) {
                            this.p = new Point();
                        }
                        this.p.x = this.getScreenX(loc[0]);
                        this.p.y = this.getScreenY(loc[1]);
                    }
                    Color c = (Color)l.get(indx - 2);
                    Font f = (Font)l.get(indx - 1);
                    l.remove(indx - 2);
                    l.remove(indx - 2);
                    l.remove(indx - 2);
                    l.remove(indx - 2);
                    this.isEditing = true;
                    this.prevTool = 5;
                    this.addTextDialog(this.p.x, this.p.y, (String)this.selectedObj, f, c);
                }
            } else {
                this.setSelectedObject(selected);
                this.selectedObj = null;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PlotPanel.this.drawAnchors();
                    }
                });
            }
        }
    }

    private void setSelectedObject(Object o) {
        boolean found = false;
        for (int i = 0; i < this.graphsCombobox.getItemCount() && !found; ++i) {
            HeaderLabel l = (HeaderLabel)this.graphsCombobox.getItemAt(i);
            XYGraph g = (XYGraph)this.graphs.get(l);
            if (g == null || g != o) continue;
            found = true;
            this.graphsCombobox.setSelectedIndex(i);
        }
    }

    private boolean insideAxis(Point p) {
        int xi = this.graphCanvas.getXInset();
        int yi = this.graphCanvas.getYInset();
        int wa = this.graphCanvas.getAxis().getSize(0);
        int ha = this.graphCanvas.getAxis().getSize(1);
        return p.x > xi && p.x < xi + wa && p.y > yi && p.y < yi + ha;
    }

    private void panButtonActionPerformed(ActionEvent evt) {
        this.graphCanvas.repaint();
        if (this.panButton.isSelected()) {
            this.tool = 2;
        }
        this.prev = null;
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void zoomButtonActionPerformed(ActionEvent evt) {
        this.graphCanvas.repaint();
        if (this.zoomButton.isSelected()) {
            this.tool = 1;
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.prev = null;
    }

    private void yMaxFieldActionPerformed(ActionEvent evt) {
        this.yMinFieldActionPerformed(null);
    }

    private void yMinFieldActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setMin(Double.parseDouble(this.yMinField.getText()), 1);
        this.graphCanvas.getAxis().setMax(Double.parseDouble(this.yMaxField.getText()), 1);
        this.graphCanvas.getAxis().setTics(10);
        Axis a = this.graphCanvas.getAxis();
        if (a.isLogarithmic(1)) {
            this.setLogTics(a);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void yRangeAutoButtonActionPerformed(ActionEvent evt) {
        if (this.yRangeAutoButton.isSelected()) {
            this.yMinField.setEnabled(false);
            this.yMaxField.setEnabled(false);
            double yMin = Double.MAX_VALUE;
            double yMax = -1.7976931348623157E308;
            Iterator iter = this.graphCanvas.getGraphs().iterator();
            boolean hasGraphs = false;
            while (iter.hasNext()) {
                Graph graph = (Graph)iter.next();
                yMin = Math.min(yMin, graph.getYmin());
                yMax = Math.max(yMax, graph.getYmax());
                hasGraphs = true;
            }
            if (!hasGraphs) {
                yMin = 0.0;
                yMax = 10.0;
            }
            if (this.graphCanvas.getAxis().isLogarithmic(1)) {
                yMin = Math.max(yMin, 1.0);
            }
            this.graphCanvas.getAxis().setMinMax(yMin, yMax, 1);
            this.yMinField.setText(this.format.format(yMin));
            this.yMaxField.setText(this.format.format(yMax));
            this.graphCanvas.getAxis().setTics(10);
            if (this.graphCanvas.getAxis().isLogarithmic(1)) {
                this.setLogTics(this.graphCanvas.getAxis());
            }
            if (evt != null) {
                this.graphCanvas.refresh();
                this.graphCanvas.repaint();
            }
        }
    }

    private void yRangeButtonActionPerformed(ActionEvent evt) {
        if (this.yRangeButton.isSelected()) {
            this.yMinField.setEnabled(true);
            this.yMaxField.setEnabled(true);
        }
    }

    private void xMaxFieldActionPerformed(ActionEvent evt) {
        this.xMinFieldActionPerformed(null);
    }

    private void xMinFieldActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setMin(Double.parseDouble(this.xMinField.getText()), 0);
        this.graphCanvas.getAxis().setMax(Double.parseDouble(this.xMaxField.getText()), 0);
        this.graphCanvas.getAxis().setTics(10);
        if (this.graphCanvas.getAxis().isLogarithmic(1)) {
            this.setLogTics(this.graphCanvas.getAxis());
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xRangeAutoButtonActionPerformed(ActionEvent evt) {
        if (this.xRangeAutoButton.isSelected()) {
            this.xMinField.setEnabled(false);
            this.xMaxField.setEnabled(false);
            double xMin = Double.MAX_VALUE;
            double xMax = -1.7976931348623157E308;
            Iterator iter = this.graphCanvas.getGraphs().iterator();
            boolean hasGraphs = false;
            while (iter.hasNext()) {
                Graph graph = (Graph)iter.next();
                double offset = graph.getOffset();
                double offs = 0.0;
                if (!Double.isNaN(offset)) {
                    offs = offset;
                }
                xMin = Math.min(xMin, graph.getXmin() + offs);
                xMax = Math.max(xMax, graph.getXmax() + offs);
                hasGraphs = true;
            }
            if (!hasGraphs) {
                xMin = 0.0;
                xMax = 1.0;
            }
            if (Math.abs(xMin) < 0.001) {
                xMin = 0.0;
            }
            this.graphCanvas.getAxis().setMinMax(xMin, xMax, 0);
            this.xMinField.setText(this.format.format(xMin));
            this.xMaxField.setText(this.format.format(xMax));
            this.graphCanvas.getAxis().setTics(10);
            if (this.graphCanvas.getAxis().isLogarithmic(1)) {
                this.setLogTics(this.graphCanvas.getAxis());
            }
            if (evt != null) {
                this.graphCanvas.refresh();
                this.graphCanvas.repaint();
            }
        }
    }

    private void xRangeButtonActionPerformed(ActionEvent evt) {
        if (this.xRangeButton.isSelected()) {
            this.xMinField.setEnabled(true);
            this.xMaxField.setEnabled(true);
        }
    }

    private void yAxisTitleFieldActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setTitle(this.yAxisTitleField.getText(), 1);
        this.yRangeLabel.setText(" " + this.yAxisTitleField.getText() + " plot range");
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xTicsCheckboxActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setDrawTicks(this.xTicsCheckbox.isSelected(), 0);
        this.redoTicsX.setEnabled(this.xTicsCheckbox.isSelected());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xAxisTitleFieldActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setTitle(this.xAxisTitleField.getText(), 0);
        this.xRangeLabel.setText(" " + this.xAxisTitleField.getText() + " plot range");
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JFrame frame = new JFrame();
        PlotPanel pp = new PlotPanel();
        frame.getContentPane().add(pp);
        pp.graphCanvas.setAxis(new Axis());
        frame.setSize(674, 535);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ResultsReader r = new ResultsReader();
        List l = r.loadResults("d:/user/dev/java/projects/AASI Frontend/work/results.dat");
        XYGraph g = new XYGraph(true);
        g.setX((float[])l.get(0));
        g.setY((float[])l.get(1));
        g.setStrokeWidth(3.0f);
        pp.addGraph(g);
        frame.setVisible(true);
    }

    static {
        for (int i = 0; i < coeffs.length; ++i) {
            PlotPanel.coeffs[i] = Math.pow(10.0, i);
        }
    }
}

