/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.ParameterEditor;
import UI.ProportionPanel;
import core.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class ProportionEditor
extends AbstractCellEditor
implements TableCellEditor {
    ProportionPanel btn;
    ParameterEditor edit = new ParameterEditor();
    float val = 0.0f;
    float sval = 0.0f;
    float oldVal = 0.0f;
    Parameter p;
    int row = 0;
    JTable tab;
    float dval = 0.0f;
    boolean drag = false;

    public ProportionEditor() {
        this.btn = new ProportionPanel();
        this.btn.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                ProportionEditor.this.handle_mouseReleased(e);
            }
        });
        this.btn.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                ProportionEditor.this.handle_mouseDragged(e);
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void handle_mouseReleased(MouseEvent e) {
        if (this.drag) {
            this.fireEditingStopped();
        } else {
            this.p.setValue(new Float((int)(this.p.getFloatValue().floatValue() * 100.0f)));
            final JTextField comp = (JTextField)this.edit.getTableCellEditorComponent(this.tab, this.p, false, this.row, 4);
            final JDialog d = new JDialog();
            Point pt = e.getPoint();
            int col = this.tab.columnAtPoint(pt);
            int row = this.tab.rowAtPoint(pt);
            int w = this.tab.getColumnModel().getColumn(3).getWidth();
            int h = this.tab.getRowHeight(row);
            pt.setLocation(0.0, 0.0);
            SwingUtilities.convertPointToScreen(pt, this.btn);
            d.setLocation(pt);
            d.getContentPane().add(comp);
            d.setUndecorated(true);
            d.pack();
            d.setSize(w, h);
            d.setVisible(true);
            comp.grabFocus();
            comp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                    ProportionEditor.this.p.setValue(new Float(Float.parseFloat(comp.getText()) / 100.0f));
                    ProportionEditor.this.fireEditingStopped();
                }
            });
            comp.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    d.dispose();
                    ProportionEditor.this.p.setValue(new Float(Float.parseFloat(comp.getText()) / 100.0f));
                    ProportionEditor.this.fireEditingStopped();
                }
            });
        }
    }

    public void handle_mouseDragged(MouseEvent e) {
        this.drag = true;
        int x = e.getX();
        if (x < 1) {
            x = 1;
        }
        if (x > this.btn.getWidth()) {
            x = this.btn.getWidth();
        }
        this.val = (float)x / (float)this.btn.getWidth();
        this.btn.setMinMax(this.sval, this.val);
        this.btn.setAmount(this.val);
        this.btn.repaint();
        this.tab.repaint();
        this.p.setValue(new Float(this.val));
        this.oldVal = this.val;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        this.row = rowIndex;
        this.tab = table;
        this.drag = false;
        float kval = 0.0f;
        for (int i = 0; i < this.tab.getRowCount(); ++i) {
            if (i == this.row) continue;
            Parameter p2 = (Parameter)this.tab.getValueAt(i, 3);
            kval += ((Float)p2.getValue()).floatValue();
        }
        this.btn.setFullAmount(kval);
        if (isSelected) {
            this.btn.setBackground(table.getSelectionBackground());
        } else {
            this.btn.setBackground(Color.white);
        }
        System.out.println("START VALUE:" + this.sval);
        this.p = (Parameter)value;
        this.val = this.oldVal = ((Float)this.p.getValue()).floatValue();
        this.btn.setMinMax(this.sval, this.val);
        this.btn.setAmount(this.val);
        return this.btn;
    }

    public Object getCellEditorValue() {
        this.p.setValue(new Float(this.val));
        this.tab.repaint();
        return this.p;
    }
}

