/*
 * Decompiled with CFR 0.152.
 */
package UI;

import core.Main;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.SoftBevelBorder;

public class SimulationProgressMonitor
extends JDialog
implements Runnable {
    private int BUFFER_SIZE = 1024;
    private boolean stop = false;
    private InputStream inStream;
    private InputStream errorStream;
    private BufferedReader inReader;
    private BufferedReader errorReader;
    private Thread t;
    private byte[] buf;
    private boolean error = false;
    private boolean debug = Main.debug;
    private String err = "";
    private String log = "";
    private int n = 0;
    private int phase = 1;
    private int max = 0;
    private int cur = 0;
    private String titleInfo = "";
    private boolean finished = false;
    private boolean unbounded = false;
    private static int xpos = -1;
    private static int ypos = -1;
    String cat = "";
    private JButton cancelButton;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JProgressBar progressBar;
    private JLabel statusLabel;

    public SimulationProgressMonitor(JFrame owner) {
        super(owner);
        this.initComponents();
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.buf = new byte[this.BUFFER_SIZE];
        this.progressBar.setMaximum(10);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
    }

    public SimulationProgressMonitor(JFrame owner, String titleInfo) {
        this(owner);
        this.titleInfo = titleInfo;
    }

    public void setUnbounded(boolean d) {
        this.unbounded = d;
    }

    public void setInStream(InputStream os) {
        this.inStream = new BufferedInputStream(os, 1024);
        InputStreamReader reader = new InputStreamReader(os);
        this.inReader = new BufferedReader(reader);
    }

    public void setErrorStream(InputStream os) {
        this.errorStream = new BufferedInputStream(os);
        InputStreamReader reader = new InputStreamReader(os);
        this.errorReader = new BufferedReader(reader);
    }

    public boolean hadErrors() {
        while (!this.finished) {
            Thread.yield();
        }
        if (this.debug) {
            System.out.println("Error status query: result: " + this.error);
        }
        return this.error;
    }

    public String getErrorString() {
        return this.err;
    }

    public String getLogString() {
        return this.log;
    }

    public void read() {
        try {
            int read;
            while (this.inStream.available() != 0) {
                read = this.inStream.read(this.buf);
                this.log = this.log + new String(this.buf, 0, read);
                if (read == -1) continue;
                if (this.debug) {
                    System.out.print(new String(this.buf, 0, read));
                }
                if (this.phase != 1 && this.phase != 2 && this.phase != 3) continue;
                if (this.phase == 1) {
                    this.cat = this.cat + new String(this.buf, 0, read);
                }
                for (int i = 0; i < read; ++i) {
                    if (this.phase == 1 && this.buf[i] == 124) {
                        this.phase = 2;
                        continue;
                    }
                    if (this.phase == 2) {
                        if (this.buf[i] == 124) {
                            this.statusLabel.setText("Calculating " + this.titleInfo + "....");
                            this.progressBar.setMaximum(this.max);
                            this.phase = 3;
                            continue;
                        }
                        ++this.max;
                        continue;
                    }
                    if (this.phase != 3) continue;
                    this.progressBar.setValue(this.n++);
                    int perc = (int)((float)this.n / (float)this.max * 100.0f);
                    if (!this.unbounded) {
                        this.setTitle("(" + perc + "%) Simulation progress " + this.titleInfo);
                    } else {
                        this.setTitle("Simulation progress " + this.titleInfo);
                    }
                    if (this.n < this.max) continue;
                    this.statusLabel.setText("Finishing");
                    this.phase = 4;
                }
            }
            while (this.errorStream.available() != 0) {
                read = this.errorStream.read(this.buf);
                if (read <= 0) continue;
                this.err = this.err + new String(this.buf, 0, read);
                this.error = true;
                if (!this.debug) continue;
                System.out.print(new String(this.buf, 0, read));
                System.out.println("ERROR IN ERR STREAM!:" + this.err);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void run() {
        try {
            this.phase = 1;
            this.error = false;
            this.finished = false;
            if (this.debug) {
                System.out.println("Progress monitor started!!!");
            }
            if (this.unbounded) {
                this.progressBar.setForeground(Color.blue);
                this.setTitle("Simulation progress... " + this.titleInfo);
                this.statusLabel.setText("Calculating...");
                this.progressBar.setIndeterminate(true);
            }
            this.err = "";
            this.n = 0;
            this.max = 0;
            this.cur = 0;
            while (!this.stop) {
                this.read();
                Thread.sleep(100L);
            }
            this.read();
            this.finished = true;
            this.inStream.close();
            this.errorStream.close();
            if (this.debug) {
                System.out.println("Reading ended.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void start() {
        this.n = 0;
        this.max = 0;
        this.phase = 1;
        this.statusLabel.setText("Preparing " + this.titleInfo + "....");
        this.t.setName("Simulation progress panel");
        this.t.setDaemon(true);
        this.t.start();
    }

    public void stop() {
        this.stop = true;
    }

    public void setVisible(boolean vis) {
        if (xpos != -1) {
            this.setLocation(xpos, ypos);
        }
        super.setVisible(vis);
    }

    public void dispose() {
        xpos = this.getLocation().x;
        ypos = this.getLocation().y;
        super.dispose();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.progressBar = new JProgressBar();
        this.jPanel4 = new JPanel();
        this.cancelButton = new JButton();
        this.jPanel3 = new JPanel();
        this.statusLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("(0%) Simulation progress");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new SoftBevelBorder(0));
        this.progressBar.setForeground(new Color(0, 204, 0));
        this.progressBar.setFocusable(false);
        this.progressBar.setPreferredSize(new Dimension(100, 48));
        this.jPanel1.add((Component)this.progressBar, "Center");
        this.jPanel4.setLayout(new BorderLayout());
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulationProgressMonitor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.cancelButton, "East");
        this.jPanel3.setLayout(new FlowLayout(0, 0, 0));
        this.jPanel3.setBorder(new SoftBevelBorder(1));
        this.statusLabel.setText("Preparing....");
        this.jPanel3.add(this.statusLabel);
        this.jPanel4.add((Component)this.jPanel3, "Center");
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 401) / 2, (screenSize.height - 95) / 2, 401, 95);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        Main.stopSimulation();
        this.stop = true;
    }
}

