/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.HeaderLabel;
import UI.ImageUtil;
import UI.MainFrame;
import core.Main;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class WelcomePanel
extends JPanel {
    Image background;
    int welcomeWidth = 0;
    int startPosy = 0;
    int startPosx = 0;
    Properties props = null;
    private JPanel examplesPanel;
    private HeaderLabel headerLabel2;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public WelcomePanel() {
        this.initComponents();
        this.welcomeWidth = this.getWidth();
        this.loadExampleSettings();
        if (MainFrame.cookieExists()) {
            this.jCheckBox1.setSelected(true);
        }
        this.background = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/WelcomeBackground.png"));
        ImageUtil.waitForImage(this.background, this);
        this.jLabel13.setText("v. " + Main.getVersionString());
    }

    public void updateUI() {
        super.updateUI();
        if (this.jTextArea1 != null) {
            this.jTextArea1.setOpaque(false);
        }
    }

    private JPanel createExample(int numEx, String desc) {
        JPanel pan = new JPanel();
        pan.setLayout(new AbsoluteLayout());
        JLabel exLab = new JLabel("Example " + numEx + ":");
        exLab.setFont(new Font("Arial", 1, 12));
        pan.add((Component)exLab, new AbsoluteConstraints(0, 0, 80, 20));
        JLabel descLab = new JLabel(desc);
        JButton but = new JButton("Open");
        but.setActionCommand("" + numEx);
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JButton src = (JButton)evt.getSource();
                Main.mainFrame.open("../examples/Example" + src.getActionCommand() + ".inp");
                JTabbedPane pane = (JTabbedPane)WelcomePanel.this.getParent();
                try {
                    String s = WelcomePanel.this.props.getProperty("example_" + src.getActionCommand() + "_fig");
                    if (s != null) {
                        Main.mainFrame.plotPanel.handleOpenFile(new File("../examples/" + s));
                        pane.setSelectedIndex(6);
                    } else {
                        pane.setSelectedIndex(1);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        descLab.setFont(new Font("Arial", 0, 12));
        pan.add((Component)descLab, new AbsoluteConstraints(80, 0, 340, 20));
        pan.add((Component)but, new AbsoluteConstraints(420, 0, -1, -1));
        pan.setOpaque(false);
        return pan;
    }

    private void loadExampleSettings() {
        try {
            Properties settings;
            this.props = settings = new Properties();
            File f = new File("../examples/examples.prs");
            FileInputStream fis = new FileInputStream(f);
            settings.load(fis);
            fis.close();
            String s = "";
            int num = 1;
            JComponent last = null;
            while (s != null) {
                s = settings.getProperty("example_" + num + "_desc", null);
                if (s == null) continue;
                JPanel pan = this.createExample(num, s);
                last = pan;
                this.examplesPanel.add(pan);
                ++num;
            }
            this.examplesPanel.setPreferredSize(new Dimension(this.examplesPanel.getWidth(), (last.getPreferredSize().height + 5) * num));
            this.examplesPanel.setSize(new Dimension(this.examplesPanel.getWidth(), (last.getPreferredSize().height + 5) * num));
            this.examplesPanel.setMinimumSize(new Dimension(this.examplesPanel.getWidth(), (last.getPreferredSize().height + 5) * num));
            this.examplesPanel.setMaximumSize(new Dimension(this.examplesPanel.getWidth(), (last.getPreferredSize().height + 5) * num));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.headerLabel2 = new HeaderLabel();
        this.jPanel1 = new JPanel();
        this.jTextArea1 = new JTextArea();
        this.jLabel8 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.examplesPanel = new JPanel();
        this.examplesPanel = new JPanel(){

            public void paint(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                GradientPaint p = new GradientPaint(-WelcomePanel.this.startPosx, -WelcomePanel.this.startPosy, Color.white, WelcomePanel.this.welcomeWidth - WelcomePanel.this.startPosx, 900 - WelcomePanel.this.startPosy, new Color(180, 180, 180));
                g2d.setPaint(p);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(g);
            }
        };
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.setLayout(new FlowLayout(1, 0, 0));
        this.setBackground(new Color(42, 66, 128));
        this.setOpaque(false);
        this.headerLabel2.setBackground(new Color(125, 135, 62));
        this.headerLabel2.setBack(new Color(255, 255, 255));
        this.headerLabel2.setDark(true);
        this.headerLabel2.setFont(new Font("MS Sans Serif", 1, 12));
        this.headerLabel2.setPreferredSize(new Dimension(4300, 20));
        this.add(this.headerLabel2);
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setFocusable(false);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(690, 470));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Arial", 0, 12));
        this.jTextArea1.setRows(20);
        this.jTextArea1.setText("To get started in alpha-spectrometry simulation using AASI, we recommed familirising yourself with the\nexamples provided with this application.");
        this.jTextArea1.setOpaque(false);
        this.jPanel1.add((Component)this.jTextArea1, new AbsoluteConstraints(30, 300, 670, 30));
        this.jLabel8.setBackground(new Color(255, 255, 255));
        this.jLabel8.setFont(new Font("Arial", 1, 16));
        this.jLabel8.setText("G e t t i n g   s t a r t e d");
        this.jPanel1.add((Component)this.jLabel8, new AbsoluteConstraints(20, 270, 450, 20));
        this.jLabel10.setBackground(new Color(241, 241, 242));
        this.jLabel10.setFont(new Font("Times New Roman", 0, 54));
        this.jLabel10.setText("A    A    S    I");
        this.jPanel1.add((Component)this.jLabel10, new AbsoluteConstraints(190, 80, 440, 70));
        this.jLabel11.setFont(new Font("Times New Roman", 3, 12));
        this.jLabel11.setText("a d v a n c e d    a l p h a s p e c t r o m e t r i c    s i m u l a t i o n");
        this.jPanel1.add((Component)this.jLabel11, new AbsoluteConstraints(230, 140, 470, 20));
        this.jLabel12.setFont(new Font("Times New Roman", 0, 20));
        this.jLabel12.setText("Welcome to");
        this.jPanel1.add((Component)this.jLabel12, new AbsoluteConstraints(190, 60, 250, 20));
        this.jLabel13.setFont(new Font("Times New Roman", 3, 12));
        this.jPanel1.add((Component)this.jLabel13, new AbsoluteConstraints(230, 160, 360, 20));
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setFocusable(false);
        this.jScrollPane1.setOpaque(false);
        this.jScrollPane1.setPreferredSize(new Dimension(20, 20));
        this.examplesPanel.setLayout(new FlowLayout(0, 0, 5));
        this.examplesPanel.setOpaque(false);
        this.examplesPanel.setPreferredSize(new Dimension(610, 120));
        this.jScrollPane1.setViewportView(this.examplesPanel);
        this.jPanel1.add((Component)this.jScrollPane1, new AbsoluteConstraints(100, 350, 510, 125));
        this.add(this.jPanel1);
        this.jPanel2.setLayout(new FlowLayout(1, 5, 20));
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(4420, 65));
        this.jButton1.setText("Close this page");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WelcomePanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.jCheckBox1.setForeground(new Color(102, 102, 102));
        this.jCheckBox1.setText("Do not display this page again");
        this.jCheckBox1.setOpaque(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WelcomePanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jCheckBox1);
        this.add(this.jPanel2);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (!this.jCheckBox1.isSelected()) {
            MainFrame.removeCookie();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JTabbedPane pane = (JTabbedPane)this.getParent();
        if (this.jCheckBox1.isSelected()) {
            MainFrame.dropCookie();
        }
        pane.remove(0);
        pane.setSelectedIndex(0);
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        GradientPaint p = new GradientPaint(0.0f, 0.0f, Color.white, this.getWidth(), 900.0f, new Color(180, 180, 180));
        this.welcomeWidth = this.getWidth();
        this.startPosx = this.jScrollPane1.getLocationOnScreen().x;
        this.startPosy = this.jScrollPane1.getLocationOnScreen().y;
        g2d.setPaint(p);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int w = this.background.getWidth(this);
        int h = this.background.getHeight(this);
        int sx = this.getWidth() - this.getWidth() / 2;
        int sy = this.getHeight() - this.getHeight() / 2;
        g2d.drawImage(this.background, sx, sy, this.getWidth() - 10, this.getHeight() - 10, 0, 0, this.background.getWidth(this), this.background.getHeight(this), this);
        super.paint(g);
    }
}

