/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.AbstractReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FitInputReader
extends AbstractReader {
    Hashtable filesToAttribs = new Hashtable();
    int numInterval = 0;

    private Hashtable cloneAtts(Attributes att) {
        Hashtable<String, String> n = new Hashtable<String, String>();
        for (int i = 0; i < 10; ++i) {
            String atName = att.getLocalName(i);
            String atVal = att.getValue(i);
            if (atName == null) continue;
            n.put(atName, atVal);
        }
        return n;
    }

    public void read(String path) {
        InputStream instream = null;
        try {
            File xmlfile = new File(path);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            instream = this.getInputStream();
            if (instream == null) {
                instream = new FileInputStream(xmlfile);
            }
            reader.setContentHandler(new DefaultHandler(){

                public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
                    if (localName.equals("fitShape")) {
                        String val;
                        int ind = atts.getIndex("file");
                        String file = val = atts.getValue(ind);
                        FitInputReader.this.filesToAttribs.put(file, FitInputReader.this.cloneAtts(atts));
                        System.out.println("Added attribs for file:" + val);
                    }
                    if (localName.equals("fitInterval")) {
                        FitInputReader.this.filesToAttribs.put("fitInterval" + FitInputReader.this.numInterval, FitInputReader.this.cloneAtts(atts));
                        System.out.println("Added attribs for interval:" + FitInputReader.this.numInterval);
                        ++FitInputReader.this.numInterval;
                    }
                }
            });
            reader.parse(new InputSource(instream));
            instream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                instream.close();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
    }

    public String getAttributeFor(String file, String att) {
        Hashtable atts = (Hashtable)this.filesToAttribs.get(file);
        if (atts == null) {
            return null;
        }
        String val = (String)atts.get(att);
        return val;
    }
}

