/*
 * Decompiled with CFR 0.152.
 */
package core;

import UI.FittingProgressMonitor;
import UI.SimulationProgressMonitor;
import core.AbstractWriter;
import core.Main;
import core.PhdWriter;
import core.ResultsReader;
import core.ResultsWriter;
import core.SikaOutputReader;
import core.TextWriter;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.stuk.visualization.graphs.XYGraph;

public class Fitter
extends AbstractWriter {
    XYGraph target;
    XYGraph shape;
    double tStart = 0.001;
    double tEnd = 10.0;
    double sStart = -1.0;
    double sEnd = -1.0;
    List shapes = new ArrayList();
    List regions = new ArrayList();
    List targetRegions = new ArrayList();
    XYGraph resultGraph;
    XYGraph residualGraph;
    XYGraph specGraph;
    double chiSquared = -1.0;
    SimulationProgressMonitor monitor = null;
    List groups = new ArrayList();
    List fixed = new ArrayList();
    List retMultipliers = new ArrayList();
    List retMultiplierUncs = new ArrayList();
    List multipliers = new ArrayList();
    double ecalSlope = 0.0;
    double ecalOffs = 0.0;
    SikaOutputReader resReader;
    boolean fslope = false;
    boolean foffs = false;

    public void setProgressMonitor(SimulationProgressMonitor mon) {
        this.monitor = mon;
    }

    public void setFitTarget(XYGraph g) {
        this.target = g;
        this.tStart = 0.2;
        this.tEnd = g.getXmax();
    }

    public void addFitShape(XYGraph g, int group, boolean isFixed, double multiplier) {
        this.shapes.add(g);
        this.regions.add(new Double(-1.0));
        this.regions.add(new Double(-1.0));
        if (isFixed) {
            this.multipliers.add(new Double(multiplier));
        } else {
            this.multipliers.add(new Double(-1.0));
        }
        this.groups.add(new Integer(group));
        this.fixed.add(new Boolean(isFixed));
    }

    public void addFitShape(XYGraph g, double min, double max, int group, boolean isFixed, double multiplier) {
        this.shapes.add(g);
        this.regions.add(new Double(min));
        this.regions.add(new Double(max));
        this.groups.add(new Integer(group));
        this.fixed.add(new Boolean(isFixed));
        if (isFixed) {
            this.multipliers.add(new Double(multiplier));
        } else {
            this.multipliers.add(new Double(-1.0));
        }
    }

    public void setEnergyCalibration(double slope, double offs, boolean fitSlope, boolean fitOffset) {
        this.ecalSlope = slope;
        this.ecalOffs = offs;
        this.foffs = fitOffset;
        this.fslope = fitSlope;
    }

    public void addTargetFitRegion(double start, double end) {
        this.targetRegions.add(new Double(start));
        this.targetRegions.add(new Double(end));
        this.tStart = start;
        this.tEnd = end;
    }

    public void fit() {
        this.writeInputFiles("FitTarget.phd", "FitShape", "FitInput.xml");
        this.runFit();
    }

    private void runFit() {
        try {
            File dir = new File(".");
            String[] args = new String[]{"sika_data", "FitInput.xml"};
            Process fitp = Runtime.getRuntime().exec("./sika.exe sika_data FitInput.xml", null, dir);
            this.monitor.setInStream(fitp.getInputStream());
            this.monitor.setErrorStream(fitp.getInputStream());
            this.monitor.setUnbounded(true);
            this.monitor.start();
            this.monitor.setVisible(true);
            ((FittingProgressMonitor)this.monitor).setProcess(fitp);
            fitp.waitFor();
            this.monitor.stop();
            this.monitor.dispose();
            if (((FittingProgressMonitor)this.monitor).isCancelled()) {
                return;
            }
            this.readResults();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void removeShape(XYGraph shape) {
        int ind = this.shapes.indexOf(shape);
        if (ind == -1) {
            return;
        }
        this.shapes.remove(ind);
        this.regions.remove(ind * 2);
        this.regions.remove(ind * 2);
    }

    public List getMultipliers() {
        return this.retMultipliers;
    }

    public List getMultiplierUncertainty() {
        return this.retMultiplierUncs;
    }

    public void writeInputFiles(String targetName, String shapeName, String xmlName) {
        PhdWriter pwrt = new PhdWriter();
        ResultsWriter rwrt = new ResultsWriter();
        ArrayList<double[]> l = new ArrayList<double[]>();
        l.add(this.target.getX());
        l.add(this.target.getY());
        String out = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?>\n<fitDefinition>\n";
        if (this.getOutputStream() == null) {
            pwrt.writeResults("./sika_data/" + targetName, l);
        }
        out = out + "\t<fitTarget file=\"" + targetName + "\" regionStart=\"" + this.tStart + "\" regionEnd=\"" + this.tEnd + "\" />\n";
        if (this.targetRegions.size() > 0) {
            out = out + "\t<fitRegion>\n";
        }
        Iterator tr_iter = this.targetRegions.iterator();
        while (tr_iter.hasNext()) {
            Double start = (Double)tr_iter.next();
            Double end = (Double)tr_iter.next();
            out = out + "\t\t<fitInterval start=\"" + start + "\" end=\"" + end + "\" />\n";
        }
        if (this.targetRegions.size() > 0) {
            out = out + "\t</fitRegion>\n";
        }
        if (this.ecalSlope != 0.0) {
            out = out + "\t<energyCalibration>\n";
            out = out + "\t\t<offset value=\"" + this.ecalOffs / 1000.0 + "\" uncertainty=\"0\" isFixed=\"" + !this.foffs + "\" />\n";
            out = out + "\t\t<slope value=\"" + this.ecalSlope / 1000.0 + "\" uncertainty=\"0\" isFixed=\"" + !this.fslope + "\" />\n";
            out = out + "\t</energyCalibration>\n";
        }
        Iterator iter = this.shapes.iterator();
        Iterator r_iter = this.regions.iterator();
        Iterator g_iter = this.groups.iterator();
        Iterator f_iter = this.fixed.iterator();
        Iterator m_iter = this.multipliers.iterator();
        int ind = 0;
        while (iter.hasNext()) {
            this.shape = (XYGraph)iter.next();
            Double min = (Double)r_iter.next();
            Double max = (Double)r_iter.next();
            l.clear();
            l.add(this.shape.getX());
            l.add(this.shape.getY());
            String fname = shapeName + "-" + ind + ".graph";
            String oname = "sika_data/" + shapeName + "-" + ind + ".graph";
            if (this.getOutputStream() == null) {
                rwrt.writeResults(oname, l);
            }
            Integer group = (Integer)g_iter.next();
            Boolean fixed = (Boolean)f_iter.next();
            Double multiplier = (Double)m_iter.next();
            out = min != -1.0 ? out + "\t<fitShape name=\"" + this.shape.getTitle() + "\" file=\"" + fname + "\" priority=\"" + group + "\" regionStart=\"" + min + "\" regionEnd=\"" + max + "\"" + (fixed != false ? " isFixed=\"" + fixed + "\" multiplier=\"" + multiplier + "\"" : "") + " />\n" : out + "\t<fitShape name=\"" + this.shape.getTitle() + "\" file=\"" + fname + "\" priority=\"" + group + "\" regionStart=\"" + 0.001 + "\" regionEnd=\"" + 10.0 + "\"" + (fixed != false ? " isFixed=\"" + fixed + "\" multiplier=\"" + multiplier + "\"" : "") + " />\n";
            ++ind;
        }
        out = out + "</fitDefinition>";
        if (this.getOutputStream() != null) {
            try {
                OutputStream os = this.getOutputStream();
                os.write(out.getBytes());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            TextWriter wrt = new TextWriter();
            wrt.writeText("./sika_data/" + xmlName, out, false);
        }
    }

    public double getChiSquared() {
        return this.chiSquared;
    }

    public SikaOutputReader getResultReader() {
        return this.resReader;
    }

    public XYGraph getResultsGraph() {
        return this.resultGraph;
    }

    public XYGraph getResidualGraph() {
        return this.residualGraph;
    }

    public XYGraph getSpectrumGraph() {
        return this.specGraph;
    }

    private void readResults() {
        try {
            ResultsReader r = new ResultsReader();
            List l = r.loadResults("./sika_data/FittedTotal.graph");
            this.resultGraph = new XYGraph(true);
            this.resultGraph.setX((float[])l.get(0));
            this.resultGraph.setY((float[])l.get(1));
            l = r.loadResults("./sika_data/FittedScaledResid.graph");
            this.residualGraph = new XYGraph(true);
            this.residualGraph.setX((float[])l.get(0));
            this.residualGraph.setY((float[])l.get(1));
            l = r.loadResults("./sika_data/FittedSpectrum.graph");
            this.specGraph = new XYGraph(true);
            this.specGraph.setX((float[])l.get(0));
            this.specGraph.setY((float[])l.get(1));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            SikaOutputReader reader = new SikaOutputReader();
            reader.loadResults("./sika_data/FitResults.xml");
            this.chiSquared = reader.getChiSquared();
            this.retMultipliers.addAll(reader.getMultipliers());
            this.retMultiplierUncs.addAll(reader.getMultiplierUncertainties());
            this.resReader = reader;
        }
        catch (Exception ex) {
            Main.warnUser("There were errors. The results could not be read.\nError message:\n" + ex.getMessage());
        }
    }
}

