/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.AbstractReader;
import core.Main;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class PhdReader
extends AbstractReader {
    private int phase = 0;
    private int ENERGY = 1;
    private int SPECTRUM = 2;
    private int TAG = 3;
    private double offs = 0.0;
    private double slope = 0.0;
    double width = 0.0;
    float al = 1.0f;
    float bl = 1.0f;

    public double getChannelWidth() {
        return this.width * 1000.0;
    }

    public List read(String filePath) {
        ArrayList ret = new ArrayList();
        String line = "";
        boolean ctr = false;
        Object energy = null;
        Object counts = null;
        float[] x = new float[]{0.0f, 0.0f};
        float[] y = new float[]{0.0f, 0.0f};
        ArrayList xs = new ArrayList();
        ArrayList ys = new ArrayList();
        boolean pt = false;
        float a = 0.0f;
        float b = 0.0f;
        float w = 0.0f;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            line = in.readLine();
            if (line != null && (line.startsWith("BEGIN IMS2.0") || line.startsWith("BEGIN RMS2.0"))) {
                this.readPhd(in, ret);
            } else {
                this.readIEC(in, ret);
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static void lsq(float[] x, float[] y, float[] coeffs) {
        float sumY = 0.0f;
        float sumX = 0.0f;
        float sumXsq = 0.0f;
        float sumXY = 0.0f;
        float Xm = 0.0f;
        float Ym = 0.0f;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            sumX += x[i];
            sumY += y[i];
            sumXsq += x[i] * x[i];
            sumXY += x[i] * y[i];
        }
        Xm = sumX / (float)n;
        Ym = sumY / (float)n;
        coeffs[0] = (sumXY - (float)n * Xm * Ym) / (sumXsq - (float)n * Xm * Xm);
        coeffs[1] = (Ym * sumXsq - Xm * sumXY) / (sumXsq - (float)n * Xm * Xm);
    }

    private void readPhd(BufferedReader in, List ret) {
        int ctr = 0;
        float[] energy = null;
        float[] counts = null;
        float[] x = new float[]{0.0f, 0.0f};
        float[] y = new float[]{0.0f, 0.0f};
        ArrayList<Float> xs = new ArrayList<Float>();
        ArrayList<Float> ys = new ArrayList<Float>();
        int pt = 0;
        float a = 0.0f;
        float b = 0.0f;
        float w = 0.0f;
        String line = "";
        try {
            while ((line = in.readLine()) != null) {
                String[] tok;
                int len = line.length();
                if (len > 0 && Character.isWhitespace(line.charAt(0))) {
                    line = line.replaceFirst("\\s+", "");
                }
                line = line.replaceAll("\\s+", ",");
                if (len <= 0) continue;
                if (this.phase == this.ENERGY && Character.isDigit(line.charAt(0)) && pt < 122) {
                    tok = line.split(",");
                    if (pt < 2) {
                        x[pt] = Float.parseFloat(tok[0]);
                        y[pt] = Float.parseFloat(tok[1]);
                    }
                    Float xff = new Float(Float.parseFloat(tok[0]));
                    Float yff = new Float(Float.parseFloat(tok[1]));
                    xs.add(xff);
                    ys.add(yff);
                    if (++pt == 2) {
                        a = (y[1] - y[0]) / (x[1] - x[0]);
                        b = y[0] - a * x[0];
                        w = (2.0f / a + b) / 1000.0f - (1.0f / a + b) / 1000.0f;
                    }
                }
                if (this.phase == this.SPECTRUM) {
                    tok = line.split(",");
                    if (ctr == 0) {
                        float[] xt = new float[xs.size()];
                        float[] yt = new float[xs.size()];
                        for (int i = 0; i < xs.size(); ++i) {
                            xt[i] = ((Float)xs.get(i)).floatValue();
                            yt[i] = ((Float)ys.get(i)).floatValue();
                        }
                        float[] coeffs = new float[2];
                        PhdReader.lsq(yt, xt, coeffs);
                        a = coeffs[0];
                        b = coeffs[1];
                        System.out.println("\na*channel+b");
                        System.out.println("a:" + a + ",  b:" + b);
                        this.slope = a;
                        this.offs = b;
                        w = (2.0f * a + b) / 1000.0f - (1.0f * a + b) / 1000.0f;
                        energy = new float[Integer.parseInt(tok[0])];
                        counts = new float[energy.length];
                        ++ctr;
                    } else {
                        for (int i = 1; i < tok.length; ++i) {
                            int ind = i + ctr - 2;
                            float channel = ind + 1;
                            if (ind < energy.length) {
                                energy[ind] = (channel * a + b) / 1000.0f - w / 2.0f;
                                counts[ind] = Float.parseFloat(tok[i]);
                                if (counts[ind] > 3300000.0f) {
                                    counts[ind] = 0.0f;
                                }
                            }
                            if (ind != 1) continue;
                            this.width = (double)(energy[1] - energy[0]);
                        }
                        ctr += 5;
                    }
                }
                if (line.startsWith("#g_Energy") || line.startsWith("#Energy")) {
                    this.phase = this.ENERGY;
                    continue;
                }
                if (line.startsWith("#g_Spectrum") || line.startsWith("#Spectrum")) {
                    this.phase = this.SPECTRUM;
                    continue;
                }
                if (!line.startsWith("#")) continue;
                this.phase = this.TAG;
            }
            ret.add(energy);
            ret.add(counts);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readIEC(BufferedReader in, List ret) {
        int ctr = 0;
        float[] energy = null;
        float[] counts = null;
        float[] x = new float[]{0.0f, 0.0f};
        float[] y = new float[]{0.0f, 0.0f};
        ArrayList<Float> xs = new ArrayList<Float>();
        ArrayList<Float> ys = new ArrayList<Float>();
        ArrayList<Float> energies = new ArrayList<Float>();
        ArrayList<Float> countsies = new ArrayList<Float>();
        int pt = 0;
        float a = 0.0f;
        float b = 0.0f;
        float ba = 10.545455f;
        float bb = 77.85785f;
        float w = 0.0f;
        String line = "";
        try {
            while ((line = in.readLine()) != null) {
                String[] tok;
                int len = line.length();
                if (len > 0 && Character.isWhitespace(line.charAt(0))) {
                    line = line.replaceFirst("\\s+", "");
                }
                line = line.replaceAll("\\s+", ",");
                if (len <= 0) continue;
                if (this.phase == this.ENERGY && pt < 122) {
                    tok = line.split(",");
                    if (pt < 2) {
                        x[pt] = Float.parseFloat(tok[1]);
                        y[pt] = Float.parseFloat(tok[2]);
                    }
                    Float xff = new Float(Float.parseFloat(tok[1]));
                    Float yff = new Float(Float.parseFloat(tok[2]));
                    if ((double)xff.floatValue() != 0.0) {
                        xs.add(xff);
                        ys.add(yff);
                    } else {
                        this.phase = this.TAG;
                    }
                    xff = new Float(Float.parseFloat(tok[3]));
                    yff = new Float(Float.parseFloat(tok[4]));
                    if ((double)xff.floatValue() != 0.0) {
                        xs.add(xff);
                        ys.add(yff);
                    } else {
                        this.phase = this.TAG;
                    }
                    if (++pt == 2) {
                        a = (y[1] - y[0]) / (x[1] - x[0]);
                        b = y[0] - a * x[0];
                        w = (2.0f / a + b) / 1000.0f - (1.0f / a + b) / 1000.0f;
                    }
                }
                if (this.phase == this.SPECTRUM) {
                    tok = line.split(",");
                    if (ctr == 0) {
                        float[] xt = new float[xs.size()];
                        float[] yt = new float[xs.size()];
                        for (int i = 0; i < xs.size(); ++i) {
                            xt[i] = ((Float)xs.get(i)).floatValue();
                            yt[i] = ((Float)ys.get(i)).floatValue();
                        }
                        float[] coeffs = new float[2];
                        PhdReader.lsq(yt, xt, coeffs);
                        a = coeffs[0];
                        b = coeffs[1];
                        boolean backup = false;
                        if (a == 0.0f || Float.isInfinite(a) || Float.isNaN(a)) {
                            a = ba;
                            backup = true;
                        }
                        if (b == 0.0f || Float.isInfinite(b) || Float.isNaN(b)) {
                            b = bb;
                            backup = true;
                        }
                        if (backup) {
                            Main.warnUser("No energy calibration, using default!");
                        }
                        this.slope = a;
                        this.offs = b;
                        w = (2.0f * a + b) / 1000.0f - (1.0f * a + b) / 1000.0f;
                        this.width = w;
                        ++ctr;
                    } else {
                        for (int i = 1; i < tok.length - 1; ++i) {
                            int ind = i + ctr - 2;
                            float channel = ind + 1;
                            energies.add(new Float((channel * a + b) / 1000.0f + w / 2.0f));
                            float c = Float.parseFloat(tok[i + 1]);
                            if (c > 3300000.0f) {
                                c = 0.0f;
                            }
                            countsies.add(new Float(c));
                        }
                        ctr += 5;
                    }
                }
                if (line.startsWith("A004SPARE")) {
                    this.phase = this.ENERGY;
                    continue;
                }
                if (line.startsWith("A004USERDEFINED")) {
                    this.phase = this.SPECTRUM;
                    continue;
                }
                if (!line.startsWith("#")) continue;
                this.phase = this.TAG;
            }
            energy = new float[energies.size()];
            counts = new float[energy.length];
            for (int i = 0; i < counts.length; ++i) {
                counts[i] = ((Float)countsies.get(i)).floatValue();
                energy[i] = ((Float)energies.get(i)).floatValue();
            }
            ret.add(energy);
            ret.add(counts);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public double getEnergyOffset() {
        return this.offs;
    }

    public double getEnergySlope() {
        return this.slope;
    }
}

