/*
 * Decompiled with CFR 0.152.
 */
package org.stuk.visualization.graphs;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.SwingUtilities;
import org.stuk.visualization.graphs.GraphCanvas;

public class Axis {
    private Font font;
    private FontMetrics fontMetrics;
    private Point location;
    protected double[] min = new double[]{0.0, 0.0};
    protected double[] max = new double[]{0.0, 0.0};
    protected double[] lmin = new double[]{0.0, 0.0};
    protected double[] lmax = new double[]{0.0, 0.0};
    private double aspectRatio;
    protected int[] size = new int[]{0, 0};
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    protected double[] xTics;
    protected double[] yTics;
    boolean[] logarithmic = new boolean[]{false, false};
    int[] xpts = new int[]{0, 0, 0};
    int[] ypts = new int[]{0, 0, 0};
    DecimalFormat xformat;
    DecimalFormat yformat;
    int[] xpts2 = new int[]{0, 0, 0};
    int[] ypts2 = new int[]{0, 0, 0};
    Color color;
    String[] titles = new String[]{"X-Axis", "Y-Axis"};
    Font[] titleFonts = new Font[]{null, null};
    Font[] ticFonts = new Font[]{null, null};
    boolean[] autoDecimals = new boolean[]{true, true};
    boolean[] drawTicks = new boolean[]{true, true};
    boolean drawOriginTic = true;
    boolean[] drawTitle = new boolean[]{true, true};
    boolean[] drawAxis = new boolean[]{true, true};
    double base10 = Math.log(10.0);
    AffineTransform t;
    AffineTransform xt;
    AffineTransform yt;

    public Axis() {
        this.xformat = new DecimalFormat();
        this.yformat = new DecimalFormat();
        this.xformat.setMaximumFractionDigits(1);
        this.yformat.setMaximumFractionDigits(0);
        this.xformat.setGroupingSize(0);
        this.yformat.setGroupingSize(0);
        DecimalFormatSymbols sx = this.xformat.getDecimalFormatSymbols();
        DecimalFormatSymbols sy = this.yformat.getDecimalFormatSymbols();
        sx.setDecimalSeparator('.');
        sy.setDecimalSeparator('.');
        this.xformat.setDecimalFormatSymbols(sx);
        this.yformat.setDecimalFormatSymbols(sy);
        this.color = Color.black;
        this.font = Font.getFont("Arial");
        this.titleFonts[0] = new Font("Arial", 1, 18);
        this.titleFonts[1] = new Font("Arial", 1, 18);
        this.ticFonts[0] = new Font("Arial", 0, 10);
        this.ticFonts[1] = new Font("Arial", 0, 10);
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLogarithmic(boolean log, int axis) {
        this.logarithmic[axis] = log;
    }

    public boolean isLogarithmic(int axis) {
        return this.logarithmic[axis];
    }

    public void setSize(int x, int y) {
        this.size[0] = x;
        this.size[1] = y;
        this.xpts[0] = -5;
        this.ypts[0] = y;
        this.xpts[1] = 5;
        this.ypts[1] = y;
        this.xpts[2] = 0;
        this.ypts[2] = y + 10;
        this.xpts2[0] = x;
        this.ypts2[0] = -5;
        this.xpts2[1] = x;
        this.ypts2[1] = 5;
        this.xpts2[2] = x + 10;
        this.ypts2[2] = 0;
    }

    public void setMin(double value, int axis) {
        this.min[axis] = value;
    }

    public void setMax(double value, int axis) {
        this.max[axis] = value;
    }

    public void setMinMax(double min, double max, int axis) {
        this.setMin(min, axis);
        this.setMax(max, axis);
    }

    public void setMinMax(double xMin, double yMin, double xMax, double yMax) {
        this.min[0] = xMin;
        this.max[0] = xMax;
        this.min[1] = yMin;
        this.max[1] = yMax;
    }

    public void setDrawTicks(boolean draw, int axis) {
        this.drawTicks[axis] = draw;
    }

    public void setDrawOriginTick(boolean draw) {
        this.drawOriginTic = draw;
    }

    public void setDrawTitle(boolean draw, int axis) {
        this.drawTitle[axis] = draw;
    }

    public void setDrawAxis(boolean draw, int axis) {
        this.drawAxis[axis] = draw;
    }

    public double getMin(int axis) {
        return this.min[axis];
    }

    public double getMax(int axis) {
        return this.max[axis];
    }

    public void setTics() {
        int num = 0;
        if (this.xTics != null) {
            num = this.xTics.length - 1;
        }
        if (num == 0) {
            return;
        }
        this.setTics(this.min[0], this.max[0], num, 0);
        this.setTics(this.min[1], this.max[1], num, 1);
    }

    public void setTics(int num) {
        this.setTics(this.min[0], this.max[0], num, 0);
        this.setTics(this.min[1], this.max[1], num, 1);
    }

    public void setTics(int num, int axis) {
        this.setTics(this.min[axis], this.max[axis], num, axis);
    }

    public void setTics(double start, double end, int num, int axis) {
        double step = (end - start) / (double)num;
        double log = Math.log(Math.E / step);
        if (log < 1.0) {
            log = 1.0;
        }
        if (axis == 0) {
            if (this.autoDecimals[0]) {
                this.xformat.setMaximumFractionDigits(Math.min((int)log, 5));
            }
            this.xTics = new double[num + 1];
            for (int i = 0; i < this.xTics.length; ++i) {
                double tic = start + step * (double)i;
                this.xTics[i] = Double.parseDouble(this.xformat.format(tic));
            }
        } else {
            if (this.autoDecimals[1]) {
                this.yformat.setMaximumFractionDigits(Math.min((int)log, 5));
            }
            this.yTics = new double[num + 1];
            double val = 0.0;
            for (int i = 0; i < this.yTics.length; ++i) {
                double tic = start + step * (double)i;
                this.yTics[i] = Double.parseDouble(this.yformat.format(tic));
            }
        }
    }

    public void setTics(double[] tics, int axis) {
        if (axis == 0) {
            this.xTics = tics;
        }
        if (axis == 1) {
            this.yTics = tics;
        }
    }

    public double getValueForAxisCoordinate(double p, int axis) {
        double val = 0.0;
        if (this.logarithmic[axis]) {
            double maxV = Math.log(this.max[axis]);
            double s = p * (maxV /= this.base10) / (double)this.size[axis];
            s = Math.pow(10.0, s);
            return s;
        }
        val = this.min[axis] + p / (double)this.size[axis] * (this.max[axis] - this.min[axis]);
        return val;
    }

    public double getValueForAxisCoordinate(int p, int axis) {
        return this.getValueForAxisCoordinate((double)p, axis);
    }

    public double getAxisCoordinateForValue(double value, int axis) {
        if (this.logarithmic[axis]) {
            if (value <= 1.0) {
                return 0.0;
            }
            double v = Math.log(value);
            v /= this.base10;
            double maxV = Math.log(this.max[axis]);
            double f = v / (maxV /= this.base10);
            if (f < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return f * (double)this.size[axis];
        }
        return (double)this.size[axis] / (this.max[axis] - this.min[axis]) * (value - this.min[axis]);
    }

    public double getAxisCoordinateForValue(int value, int axis) {
        return this.getAxisCoordinateForValue((double)value, axis);
    }

    public void setTitle(String title, int axis) {
        this.titles[axis] = title;
    }

    public void setTitleFont(Font font, int axis) {
        this.titleFonts[axis] = font;
    }

    public void setTicFont(Font font, int axis) {
        this.ticFonts[axis] = font;
    }

    public Font getTicFont(int axis) {
        return this.ticFonts[axis];
    }

    public Font getTitleFont(int axis) {
        return this.titleFonts[axis];
    }

    public String getTitle(int axis) {
        return this.titles[axis];
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public int getSize(int axis) {
        return this.size[axis];
    }

    public AffineTransform getAxisScale() {
        return AffineTransform.getScaleInstance(this.size[0], this.size[1]);
    }

    public void render(GraphCanvas c, Graphics2D g) {
        int w;
        String fstr;
        double xx;
        if (this.t == null) {
            this.t = AffineTransform.getScaleInstance(1.0, -1.0);
        }
        if (this.xt == null) {
            this.xt = AffineTransform.getRotateInstance(-1.5707963267948966);
        }
        g.setColor(this.color);
        double xy = this.getAxisCoordinateForValue(0.0, 1);
        double oxx = xx = this.getAxisCoordinateForValue(0.0, 0);
        xx = Math.max(0.0, xx);
        xx = Math.min(xx, (double)this.size[0]);
        boolean xVisible = true;
        if (xx != oxx) {
            xVisible = false;
        }
        if (this.drawAxis[1]) {
            g.drawLine((int)xx, 0, (int)xx, this.size[1]);
        }
        if (xy == Double.NEGATIVE_INFINITY) {
            xy = 0.0;
        } else if (xy == Double.POSITIVE_INFINITY) {
            xy = this.size[1];
        }
        double oxy = xy;
        xy = Math.max(0.0, xy);
        xy = Math.min(xy, (double)this.size[1]);
        boolean yVisible = true;
        if (xy != oxy) {
            yVisible = false;
        }
        if (this.logarithmic[1]) {
            xy = this.getAxisCoordinateForValue(1.0, 1);
        }
        if (this.drawAxis[0]) {
            g.drawLine(0, (int)xy, this.size[0], (int)xy);
        }
        double x = 0.0;
        double y = 0.0;
        g.setFont(this.ticFonts[0]);
        int ticHX = g.getFontMetrics().getHeight();
        if (this.xTics != null && this.drawTicks[0]) {
            int w2 = SwingUtilities.computeStringWidth(g.getFontMetrics(), "0") / 2;
            int h = g.getFontMetrics().getHeight() / 2;
            double ww = w2;
            if (xVisible && this.drawOriginTic) {
                g.drawString("0", (int)xx + 3, (int)xy - h);
            } else {
                String strx = this.xformat.format(this.getValueForAxisCoordinate(0.0, 0));
                w2 = -SwingUtilities.computeStringWidth(g.getFontMetrics(), strx) / 2;
                ww = Math.abs(w2);
                h = g.getFontMetrics().getHeight();
                AffineTransform temp = g.getTransform();
                g.transform(this.t);
                if (this.drawOriginTic) {
                    g.drawString(strx, (int)xx - w2 - 5, -((int)xy) + h);
                }
                g.setTransform(temp);
            }
            for (int i = 0; i < this.xTics.length; ++i) {
                x = this.getAxisCoordinateForValue(this.xTics[i], 0);
                if (!(this.xTics[i] >= this.min[0]) || !(this.xTics[i] <= this.max[0]) || this.isNaN(x)) continue;
                fstr = this.xformat.format(this.xTics[i]);
                w2 = SwingUtilities.computeStringWidth(g.getFontMetrics(), fstr) / 2;
                if (!(Math.abs(x - xx) > ww * 2.0 + (double)(w2 * 2) + 5.0)) continue;
                g.drawLine((int)x, (int)xy, (int)x, (int)xy - 5);
                AffineTransform temp = g.getTransform();
                g.transform(this.t);
                w2 = SwingUtilities.computeStringWidth(g.getFontMetrics(), fstr) / 2;
                h = g.getFontMetrics().getHeight();
                g.drawString(fstr, (int)x - w2, -((int)xy) + h);
                g.setTransform(temp);
            }
        }
        g.setFont(this.ticFonts[1]);
        int ticHY = g.getFontMetrics().getHeight();
        if (this.yTics != null && this.drawTicks[1]) {
            w = SwingUtilities.computeStringWidth(g.getFontMetrics(), "0") + 5;
            int h = g.getFontMetrics().getHeight() / 2;
            if (yVisible && !this.logarithmic[1] && this.drawOriginTic) {
                g.drawString("0", (int)xx - w, (int)xy + h + 5);
            } else if (this.logarithmic[1]) {
                AffineTransform temp = g.getTransform();
                g.transform(this.t);
                g.drawString("1", (int)xx - w, (int)xy + h - 5);
                g.setTransform(temp);
            } else {
                String stry = this.yformat.format(this.getValueForAxisCoordinate(0.0, 1));
                w = SwingUtilities.computeStringWidth(g.getFontMetrics(), stry) + 5;
                h = g.getFontMetrics().getHeight() / 4;
                AffineTransform temp = g.getTransform();
                g.transform(this.t);
                if (this.drawOriginTic) {
                    g.drawString(stry, (int)xx - w, -((int)xy) - h);
                }
                g.setTransform(temp);
            }
            for (int i = 0; i < this.yTics.length; ++i) {
                y = this.getAxisCoordinateForValue(this.yTics[i], 1);
                if (!(this.yTics[i] >= this.min[1]) || !(this.yTics[i] <= this.max[1]) || this.isNaN(y)) continue;
                double d = Math.abs(y - xy);
                int n = this.drawOriginTic ? 1 : 0;
                if (!(d > (double)(25 * n))) continue;
                g.drawLine((int)xx, (int)y, (int)xx - 5, (int)y);
                AffineTransform temp = g.getTransform();
                g.transform(this.t);
                fstr = this.yformat.format(this.yTics[i]);
                w = SwingUtilities.computeStringWidth(g.getFontMetrics(), fstr) + 5;
                h = g.getFontMetrics().getHeight() / 4;
                g.drawString(fstr, (int)xx - w, -((int)y - h));
                g.setTransform(temp);
            }
        }
        if (this.drawTitle[0] || this.drawTitle[1]) {
            w = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.titles[0]) / 2;
            int h = g.getFontMetrics().getHeight();
            AffineTransform temp = g.getTransform();
            if (this.drawTitle[0]) {
                g.setFont(this.titleFonts[0]);
                g.transform(this.t);
                if (w <= this.getSize(0)) {
                    g.drawString(this.titles[0], this.size[0] / 2 - w, 2 * h + ticHX);
                }
                g.setTransform(temp);
            }
            if (this.drawTitle[1]) {
                g.setFont(this.titleFonts[1]);
                temp = g.getTransform();
                g.transform(this.t);
                g.transform(this.xt);
                w = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.titles[1]) / 2;
                h = g.getFontMetrics().getHeight();
                if ((double)w <= (double)this.getSize(1) / 1.5) {
                    g.drawString(this.titles[1], this.size[1] / 2 - w, -2 * h - ticHY);
                }
                g.setTransform(temp);
            }
        }
    }

    public boolean isNaN(double d) {
        return Double.isInfinite(d) || Double.isNaN(d);
    }

    public void setDecimalFormat(DecimalFormat format, int axis) {
        if (axis == 0) {
            this.xformat = format;
        } else {
            this.yformat = format;
        }
    }

    public void setNumberOfTicDecimals(int num, int axis) {
        if (axis == 0) {
            this.xformat.setMaximumFractionDigits(num);
        } else {
            this.yformat.setMaximumFractionDigits(num);
        }
        this.autoDecimals[axis] = false;
    }

    public void setNumberOfTicDecimals(int num) {
        this.setNumberOfTicDecimals(num, 0);
        this.setNumberOfTicDecimals(num, 1);
    }

    public Shape getShape() {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(this.size[0], 0.0f);
        path.moveTo(0.0f, 0.0f);
        path.lineTo(0.0f, this.size[1]);
        return path;
    }
}

