/*
 * Decompiled with CFR 0.152.
 */
package org.stuk.visualization.graphs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;
import org.stuk.visualization.graphs.Axis;
import org.stuk.visualization.graphs.Graph;
import org.stuk.visualization.graphs.GraphCanvas;
import org.stuk.visualization.graphs.XYGraph;

public class Test
extends JFrame {
    private GraphCanvas graphCanvas1;

    public Test() {
        this.initComponents();
        double m = 1.5;
        double s = 0.5;
        double mean = this.mean(m, s);
        double stdev = this.stdev(m, s);
        Graph g = this.lognormal(m, s);
        double M = this.M(mean, stdev);
        double S = this.S(mean, stdev);
        System.out.println("m: " + m + " s:" + s + " M(calc):" + M + " S(Calc):" + S);
        Graph g2 = this.lognormal(M, S);
        Axis axis = new Axis();
        axis.setMinMax(0.0, 0.0, 5.0, 1.0);
        axis.setTics(0.0, 5.0, 3, 0);
        axis.setTics(0.0, 1.0, 2, 1);
        axis.setTitle("frequency", 1);
        axis.setTitle("diameter", 0);
        axis.setLocation(new Point(50, 550));
        axis.setSize(200, 200);
        this.graphCanvas1.setAxis(axis);
        this.graphCanvas1.addGraph(g);
        g2.setColor(Color.blue);
        this.graphCanvas1.addGraph(g2);
    }

    private double M(double mean, double dev) {
        double mean2 = mean * mean;
        double dev2 = dev * dev;
        double M = Math.log(mean2 / Math.sqrt(mean2 + dev2));
        return M;
    }

    private double S(double mean, double dev) {
        double devpermean = dev / mean;
        double S = Math.sqrt(Math.log(devpermean * devpermean + 1.0));
        return S;
    }

    private double mean(double m, double s) {
        double mean = Math.pow(Math.E, 0.5 * (s * s + 2.0 * m));
        System.out.println("mean:" + mean);
        return mean;
    }

    private double stdev(double m, double s) {
        double es2m = Math.pow(Math.E, s * s + 2.0 * m);
        double es2 = Math.pow(Math.E, s * s);
        double stdev = Math.sqrt(es2m * (es2 - 1.0));
        System.out.println("stdev:" + stdev);
        return stdev;
    }

    private Graph lognormal(double m, double s) {
        double sqrt2pi = Math.sqrt(Math.PI * 2);
        double[] x = new double[180];
        double[] y = new double[180];
        double xdisp = (int)Math.random() * 2;
        double incr = 5.0 / (double)x.length;
        for (int i = 0; i < x.length; ++i) {
            x[i] = (double)(i + 1) * incr + xdisp;
            double prefix = 1.0 / (s * sqrt2pi * x[i]);
            double lnx = Math.log(x[i]);
            double ep = -((lnx - m) * (lnx - m)) / (2.0 * s * s);
            double postfix = Math.pow(Math.E, ep);
            y[i] = prefix * postfix;
        }
        XYGraph g = new XYGraph();
        g.setX(x);
        g.setY(y);
        return g;
    }

    private void initComponents() {
        this.graphCanvas1 = new GraphCanvas();
        this.setDefaultCloseOperation(3);
        this.graphCanvas1.setBackground(new Color(255, 255, 255));
        this.getContentPane().add((Component)this.graphCanvas1, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 169) / 2, (screenSize.height - 169) / 2, 169, 169);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Test().setVisible(true);
            }
        });
    }
}

