/*
 * Decompiled with CFR 0.152.
 */
package org.stuk.visualization.graphs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import org.stuk.visualization.graphs.Axis;
import org.stuk.visualization.graphs.Graph;
import org.stuk.visualization.graphs.GraphCanvas;

public class XYGraph
extends Graph
implements Serializable {
    double[] domain;
    boolean discrete = false;
    int lastInd = -1;
    int lastIndMinusOne = -1;
    int lastIndMinusTwo = -1;
    double max;
    double min;
    GeneralPath p;

    public XYGraph() {
    }

    public XYGraph(boolean discrete) {
        this.discrete = discrete;
    }

    public double[] getX() {
        return this.range;
    }

    public double[] getY() {
        return this.domain;
    }

    public double eval(double x) {
        int i;
        ++this.lastInd;
        if (this.lastInd == this.range.length) {
            this.lastInd = 0;
        }
        if (this.range[this.lastInd] == x) {
            return this.domain[this.lastInd];
        }
        this.lastIndMinusOne = this.lastInd - 1;
        if (this.lastIndMinusOne > -1 && this.range[this.lastIndMinusOne] == x) {
            this.lastInd = this.lastIndMinusOne;
            return this.domain[this.lastIndMinusOne];
        }
        for (i = this.lastInd; i > this.lastInd - 9 && i > -1; --i) {
            if (this.range[i] != x) continue;
            this.lastInd = i;
            return this.domain[i];
        }
        for (i = 0; i < this.range.length; ++i) {
            if (this.range[i] != x) continue;
            this.lastInd = i;
            if (this.lastInd == this.domain.length - 1) {
                this.lastInd = -1;
            }
            return this.domain[i];
        }
        return this.domain[0];
    }

    private void bounds(double[] data) {
        this.max = -1.7976931348623157E308;
        this.min = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] > this.max) {
                this.max = data[i];
            }
            if (!(data[i] < this.min)) continue;
            this.min = data[i];
        }
    }

    public void setX(double[] d) {
        this.bounds(d);
        this.xAxisMax = this.max;
        this.xAxisMin = this.min;
        this.range = d;
    }

    public void setY(double[] d) {
        this.bounds(d);
        this.yAxisMax = this.max;
        this.yAxisMin = this.min;
        this.domain = d;
    }

    public void setX(float[] d) {
        this.range = new double[d.length];
        for (int i = 0; i < this.range.length; ++i) {
            this.range[i] = d[i];
        }
        this.bounds(this.range);
        this.xAxisMax = this.max;
        this.xAxisMin = this.min;
    }

    public void setY(float[] d) {
        this.domain = new double[d.length];
        for (int i = 0; i < this.domain.length; ++i) {
            this.domain[i] = d[i];
        }
        this.bounds(this.domain);
        this.yAxisMax = this.max;
        this.yAxisMin = this.min;
    }

    public void renderHist(GraphCanvas c, Graphics2D g, Axis a) {
        int axisW = a.getSize(0);
        boolean carry = false;
        double trans = 0.0;
        double offs = this.getOffset();
        if (!Double.isNaN(offs)) {
            trans = offs;
        }
        g.setColor(this.color);
        if (c.getSelected() == this) {
            // empty if block
        }
        Stroke old = g.getStroke();
        g.setStroke(new BasicStroke(this.strokeWidth, 0, 2));
        int w = a.getSize(0);
        int h1 = 0;
        double x1 = 0.0;
        double y1 = 0.0;
        int px = 0;
        int py = 0;
        double minx = 0.0;
        double miny = 0.0;
        double maxx = a.getSize(0);
        double maxy = a.getSize(1);
        double cumY = 0.0;
        double cumHp = 0.0;
        double cumHm = 0.0;
        int cumNum = 0;
        double cumW = 0.0;
        for (int i = 1; i < this.range.length; ++i) {
            if (!carry) {
                x1 = this.fixCoord(a.getAxisCoordinateForValue(this.range[i - 1] + trans, 0), minx, maxx);
                y1 = this.fixCoord(a.getAxisCoordinateForValue(this.domain[i - 1], 1), miny, maxy);
            }
            double x2 = a.getAxisCoordinateForValue(this.range[i] + trans, 0);
            double y2 = a.getAxisCoordinateForValue(this.domain[i], 1);
            x2 = this.fixCoord(x2, minx, maxx);
            y2 = this.fixCoord(y2, miny, maxy);
            int w1 = (int)(x2 - x1);
            if (!carry && !this.fill) {
                if (Math.abs(w1) < 1) {
                    cumHp = Math.max(y1, y2);
                    cumHm = Math.min(y1, y2);
                    cumY = y1;
                    cumNum = 1;
                    carry = true;
                    px = (int)x1;
                    py = (int)y1;
                    cumW = x2 - x1;
                } else {
                    carry = false;
                }
            } else if (carry && Math.abs(cumW += x2 - x1) >= 1.0) {
                carry = false;
                if ((int)x2 != px) {
                    g.drawLine(px, py, (int)x2, (int)y2);
                }
                g.drawLine((int)x1, (int)cumHm, (int)x1, (int)cumHp);
            }
            if (carry) {
                cumHp = Math.max(y2, cumHp);
                cumHm = Math.min(y2, cumHm);
                ++cumNum;
                h1 = Math.max(h1, (int)(y2 - y1));
            } else {
                h1 = (int)(y2 - y1);
            }
            if (carry || !(x2 >= 0.0) || !(x2 <= (double)axisW)) continue;
            if (this.fill) {
                if (w1 > 10) {
                    g.fillRect((int)(x2 - (double)w1), 0, w1 - 1, (int)y1);
                    continue;
                }
                g.fillRect((int)(x2 - (double)w1), 0, w1 + 1, (int)y1);
                continue;
            }
            g.drawLine((int)x1, (int)y1, (int)(x1 + (double)w1), (int)y1);
            if (Math.abs(h1) <= 0) continue;
            g.drawLine((int)(x1 + (double)w1), (int)y1, (int)(x1 + (double)w1), (int)(y1 + (double)h1));
        }
        g.setStroke(old);
    }

    public synchronized void render(GraphCanvas c, Graphics2D g, Axis a) {
        boolean wide;
        double maxi = a.getMax(0);
        double mini = a.getMin(0);
        if (this.range == null) {
            return;
        }
        if (this.domain == null) {
            return;
        }
        double r2 = this.range[2];
        double r1 = this.range[1];
        boolean bl = wide = (maxi - mini) / (r2 - r1) <= (double)a.getSize(0);
        if (this.discrete) {
            this.renderHist(c, g, a);
            return;
        }
        GeneralPath p = new GeneralPath(1);
        p.reset();
        double trans = 0.0;
        double offs = this.getOffset();
        if (!Double.isNaN(offs)) {
            trans = offs;
        }
        double minx = 0.0;
        double miny = 0.0;
        double maxx = a.getSize(0);
        double maxy = a.getSize(1);
        double zeroY = a.getAxisCoordinateForValue(0, 1);
        double zeroX = a.getAxisCoordinateForValue(0, 0);
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        int ixc = 0;
        int ixlast = 0;
        int iyc = 0;
        int iyc2 = 0;
        boolean carryNum = false;
        boolean num = false;
        boolean begin = true;
        boolean carry = false;
        if (this.fill) {
            p.moveTo((float)zeroX, (float)zeroY);
            begin = false;
        }
        for (int i = 1; i < this.range.length; ++i) {
            if (!carry) {
                x1 = a.getAxisCoordinateForValue(this.range[i - 1] + trans, 0);
                y1 = a.getAxisCoordinateForValue(this.domain[i - 1], 1);
                num = false;
            } else {
                x1 = a.getAxisCoordinateForValue(this.range[i - 1] + trans, 0);
                double yval = this.domain[i - 1];
                y1 = Math.max(y1, a.getAxisCoordinateForValue(yval, 1));
                iyc2 = Math.max((int)y1, iyc2);
                y1 = a.getAxisCoordinateForValue(yval, 1);
                if (!Double.isInfinite(y1)) {
                    iyc = Math.min((int)y1, iyc);
                }
            }
            x2 = a.getAxisCoordinateForValue(this.range[i] + trans, 0);
            y2 = a.getAxisCoordinateForValue(this.domain[i], 1);
            if (x1 == Double.POSITIVE_INFINITY && x2 != Double.POSITIVE_INFINITY) {
                x1 = maxx;
            } else if (x2 == Double.POSITIVE_INFINITY && x1 != Double.POSITIVE_INFINITY) {
                x2 = maxx;
            }
            if (y1 == Double.POSITIVE_INFINITY && y2 != Double.POSITIVE_INFINITY) {
                y1 = maxy;
            } else if (y2 == Double.POSITIVE_INFINITY && y1 != Double.POSITIVE_INFINITY) {
                y2 = maxy;
            }
            if (x1 == Double.NEGATIVE_INFINITY && x2 != Double.NEGATIVE_INFINITY) {
                x1 = minx;
            } else if (x2 == Double.NEGATIVE_INFINITY && x1 != Double.NEGATIVE_INFINITY) {
                x2 = minx;
            }
            if (y1 == Double.NEGATIVE_INFINITY && y2 != Double.NEGATIVE_INFINITY) {
                y1 = miny;
            } else if (y2 == Double.NEGATIVE_INFINITY && y1 != Double.NEGATIVE_INFINITY) {
                y2 = miny;
            }
            int ix1 = (int)x1;
            int ix2 = (int)x2;
            int iy1 = (int)y1;
            int iy2 = (int)y2;
            if (Double.isInfinite(x1) || Double.isInfinite(y1)) continue;
            ix1 = Math.max(ix1, -10);
            if ((ix1 = Math.min(ix1, a.getSize(0) + 10)) != ix2) {
                if (carry) {
                    p.lineTo(ixc, iyc2);
                }
                carry = false;
                if (begin) {
                    p.moveTo(ix1, iy1);
                } else {
                    p.lineTo(ix1, iy1);
                }
                begin = false;
                ixlast = ix1;
                continue;
            }
            if (!carry) {
                ixc = ix1;
                iyc = iy1;
                iyc2 = iy1;
                if (begin) {
                    p.moveTo(ix1, iy1);
                } else {
                    p.lineTo(ix1, iy1);
                }
                begin = false;
            }
            carry = true;
        }
        Stroke old = g.getStroke();
        if (this.fill) {
            p.lineTo(ixlast, (float)zeroY);
        }
        g.setColor(this.color);
        if (c.getSelected() == this) {
            // empty if block
        }
        g.setStroke(new BasicStroke(this.strokeWidth, 0, 2));
        if (this.fill) {
            if (this.fillColor != null) {
                g.setColor(this.fillColor);
            }
            g.fill(p);
            g.setColor(this.color);
            if (c.getSelected() == this) {
                g.setXORMode(Color.red);
            }
        }
        g.draw(p);
        g.setStroke(old);
    }

    private double fixCoord(double coord, double low, double high) {
        int f = this.finite(coord);
        double ret = coord;
        if (f > 0) {
            ret = high;
        } else if (f < 0) {
            ret = low;
        }
        return ret;
    }

    private int finite(double d) {
        if (Double.isNaN(d)) {
            return -2;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return -1;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1;
        }
        return 0;
    }
}

