/*
 * Decompiled with CFR 0.152.
 */
package org.stuk.visualization.polygonal.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.stuk.visualization.polygonal.FrameBuffer;
import org.stuk.visualization.polygonal.RenderingPipeline;
import org.stuk.visualization.polygonal.ScanConverter;
import org.stuk.visualization.polygonal.Shader;
import org.stuk.visualization.polygonal.util.PolyUtils;

public class Utils3D {
    public static RenderingPipeline getRenderingPipeline(int numdatas, int w, int h, Shader shader, double[] vrp, double[] fp, double[] lp) {
        RenderingPipeline p = new RenderingPipeline();
        FrameBuffer fb = new FrameBuffer(w, h);
        ScanConverter sc = new ScanConverter(w, h, numdatas);
        ArrayList<double[]> lightList = new ArrayList<double[]>();
        double[] light = new double[]{0.0, 100.0, 100.0, 1.0};
        if (lp == null) {
            lightList.add(light);
        } else {
            lightList.add(lp);
        }
        p.setShader(shader);
        p.setLights(lightList);
        p.setFrameBuffer(fb);
        p.setScanConverter(sc);
        double[][] Tp = PolyUtils.getProjectionTransform(4.0, 1000.0, Math.toRadians(90.0), 1.0);
        p.setProjectionTransform(Tp);
        double[][] Tv = new double[4][4];
        double[] up = new double[]{0.0, 0.0, 1.0};
        PolyUtils.getViewingTransform(vrp, fp, up, Tv);
        p.setViewingTransform(Tv);
        return p;
    }

    public static BufferedImage renderRetained(RenderingPipeline p, List bin) {
        FrameBuffer fb = p.getFrameBuffer();
        fb.clear();
        int n = bin.size();
        int i = 0;
        while (i < n) {
            Object o;
            if ((o = bin.get(i++)) instanceof Shader) {
                p.setShader((Shader)o);
                continue;
            }
            List v = (List)o;
            List d = (List)bin.get(i++);
            p.setVertices(v);
            p.setVertexData(d);
            p.render();
        }
        return fb.getImage();
    }

    public static void renderAnnotations(List annotations, Graphics g, RenderingPipeline rp) {
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(Color.blue);
        double[][] Tv = rp.getViewingTransform();
        double[][] Tp = rp.getProjectionTransform();
        double[] loct = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] loct2 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] loct3 = new double[]{0.0, 0.0, 0.0, 0.0};
        int w = rp.getFrameBuffer().getWidth();
        int h = rp.getFrameBuffer().getHeight();
        int ox = w / 2;
        int oy = h / 2;
        int i = 0;
        while (i < annotations.size()) {
            Object o;
            if ((o = annotations.get(i++)) instanceof String) {
                Object oloc;
                String s = (String)o;
                if ((oloc = annotations.get(i++)) instanceof double[]) {
                    double[] loc = (double[])oloc;
                    PolyUtils.matMult4(loc, Tv, loct2);
                    PolyUtils.matMult4(loct2, Tp, loct);
                    loct[0] = loct[0] * (double)w;
                    loct[1] = loct[1] * (double)h;
                    loct[0] = loct[0] / loct[3];
                    loct[1] = loct[1] / loct[3];
                    loct[0] = loct[0] + (double)ox;
                    loct[1] = loct[1] + (double)oy;
                    g.drawString(s, (int)loct[0], h - (int)loct[1]);
                    continue;
                }
                int[] iloc = (int[])oloc;
                g.drawString(s, iloc[0], iloc[1]);
                continue;
            }
            if (o instanceof Image) {
                int[] loc = (int[])annotations.get(i++);
                continue;
            }
            if (o instanceof Color) {
                g2d.setColor((Color)o);
                continue;
            }
            double[] begin = (double[])o;
            double[] end = (double[])annotations.get(i++);
            PolyUtils.matMult4(begin, Tv, loct3);
            PolyUtils.matMult4(loct3, Tp, loct);
            PolyUtils.matMult4(end, Tv, loct3);
            PolyUtils.matMult4(loct3, Tp, loct2);
            loct[0] = loct[0] * (double)w;
            loct[1] = loct[1] * (double)h;
            loct[0] = loct[0] / loct[3];
            loct[1] = loct[1] / loct[3];
            loct[0] = loct[0] + (double)ox;
            loct[1] = loct[1] + (double)oy;
            loct2[0] = loct2[0] * (double)w;
            loct2[1] = loct2[1] * (double)h;
            loct2[0] = loct2[0] / loct[3];
            loct2[1] = loct2[1] / loct[3];
            loct2[0] = loct2[0] + (double)ox;
            loct2[1] = loct2[1] + (double)oy;
            g.drawLine((int)loct[0], h - (int)loct[1], (int)loct2[0], h - (int)loct2[1]);
        }
    }
}

