/*
 * Decompiled with CFR 0.152.
 */
package gov.stuk.visualization.graphs;

import gov.stuk.visualization.graphs.Axis;
import gov.stuk.visualization.graphs.Graph;
import gov.stuk.visualization.graphs.GraphCanvas;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.Serializable;

public class XYGraph
extends Graph
implements Serializable {
    double[] domain;
    int lastInd = -1;
    int lastIndMinusOne = -1;
    int lastIndMinusTwo = -1;
    double max;
    double min;
    GeneralPath p;
    double[] coord = new double[]{0.0, 0.0};

    public double[] getX() {
        return this.range;
    }

    public double[] getY() {
        return this.domain;
    }

    public double eval(double x) {
        int i;
        ++this.lastInd;
        if (this.lastInd == this.range.length) {
            this.lastInd = 0;
        }
        if (this.range[this.lastInd] == x) {
            return this.domain[this.lastInd];
        }
        this.lastIndMinusOne = this.lastInd - 1;
        if (this.lastIndMinusOne > -1 && this.range[this.lastIndMinusOne] == x) {
            this.lastInd = this.lastIndMinusOne;
            return this.domain[this.lastIndMinusOne];
        }
        for (i = this.lastInd; i > this.lastInd - 9 && i > -1; --i) {
            if (this.range[i] != x) continue;
            this.lastInd = i;
            return this.domain[i];
        }
        for (i = 0; i < this.range.length; ++i) {
            if (this.range[i] != x) continue;
            this.lastInd = i;
            if (this.lastInd == this.domain.length - 1) {
                this.lastInd = -1;
            }
            return this.domain[i];
        }
        return this.domain[0];
    }

    private void bounds(double[] data) {
        this.max = -1.7976931348623157E308;
        this.min = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] > this.max) {
                this.max = data[i];
            }
            if (!(data[i] < this.min)) continue;
            this.min = data[i];
        }
    }

    public void setX(double[] d) {
        this.bounds(d);
        this.xAxisMax = this.max;
        this.xAxisMin = this.min;
        this.range = d;
    }

    public void setY(double[] d) {
        this.bounds(d);
        this.yAxisMax = this.max;
        this.yAxisMin = this.min;
        this.domain = d;
    }

    public void setX(float[] d) {
        this.range = new double[d.length];
        for (int i = 0; i < this.range.length; ++i) {
            this.range[i] = d[i];
        }
        this.bounds(this.range);
        this.xAxisMax = this.max;
        this.xAxisMin = this.min;
    }

    public void setY(float[] d) {
        this.domain = new double[d.length];
        for (int i = 0; i < this.domain.length; ++i) {
            this.domain[i] = d[i];
        }
        this.bounds(this.domain);
        this.yAxisMax = this.max;
        this.yAxisMin = this.min;
    }

    public synchronized void render(GraphCanvas c, Graphics2D g, Axis a) {
        Stroke old = g.getStroke();
        g.setColor(this.color);
        g.setStroke(new BasicStroke(this.strokeWidth, 0, 2));
        GeneralPath p = new GeneralPath(1);
        p.reset();
        double trans = 0.0;
        double offs = this.getOffset();
        if (!Double.isNaN(offs)) {
            trans = offs;
        }
        double minx = 0.0;
        double miny = 0.0;
        double zeroY = a.getAxisCoordinateForValue(0, 1);
        double zeroX = a.getAxisCoordinateForValue(0, 0);
        double maxx = a.getSize(0);
        double maxy = a.getSize(1);
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        int ixc = 0;
        int ixlast = 0;
        int iyc = 0;
        int iyc2 = 0;
        boolean carryNum = false;
        boolean begin = true;
        boolean carry = false;
        if (this.fill) {
            p.moveTo((float)zeroX, (float)zeroY);
            begin = false;
        }
        for (int i = 1; i < this.range.length; ++i) {
            if (!carry) {
                x1 = a.getAxisCoordinateForValue(this.range[i - 1] + trans, 0);
                y1 = a.getAxisCoordinateForValue(this.domain[i - 1], 1);
            } else {
                x1 = a.getAxisCoordinateForValue(this.range[i - 1] + trans, 0);
                double yval = this.domain[i - 1];
                y1 = Math.max(y1, a.getAxisCoordinateForValue(yval, 1));
                iyc2 = Math.max((int)y1, iyc2);
                y1 = a.getAxisCoordinateForValue(yval, 1);
                if (!Double.isInfinite(y1)) {
                    iyc = Math.min((int)y1, iyc);
                }
            }
            x2 = a.getAxisCoordinateForValue(this.range[i] + trans, 0);
            y2 = a.getAxisCoordinateForValue(this.domain[i], 1);
            if (x1 == Double.POSITIVE_INFINITY && x2 != Double.POSITIVE_INFINITY) {
                x1 = maxx;
            } else if (x2 == Double.POSITIVE_INFINITY && x1 != Double.POSITIVE_INFINITY) {
                x2 = maxx;
            }
            if (y1 == Double.POSITIVE_INFINITY && y2 != Double.POSITIVE_INFINITY) {
                y1 = maxy;
            } else if (y2 == Double.POSITIVE_INFINITY && y1 != Double.POSITIVE_INFINITY) {
                y2 = maxy;
            }
            if (x1 == Double.NEGATIVE_INFINITY && x2 != Double.NEGATIVE_INFINITY) {
                x1 = minx;
            } else if (x2 == Double.NEGATIVE_INFINITY && x1 != Double.NEGATIVE_INFINITY) {
                x2 = minx;
            }
            if (y1 == Double.NEGATIVE_INFINITY && y2 != Double.NEGATIVE_INFINITY) {
                y1 = miny;
            } else if (y2 == Double.NEGATIVE_INFINITY && y1 != Double.NEGATIVE_INFINITY) {
                y2 = miny;
            }
            int ix1 = (int)x1;
            int ix2 = (int)x2;
            int iy1 = (int)y1;
            int iy2 = (int)y2;
            if (Double.isInfinite(x1) || Double.isInfinite(y1)) continue;
            if (ix1 != ix2) {
                if (carry) {
                    p.lineTo(ixc, iyc2);
                }
                carry = false;
                if (begin) {
                    p.moveTo(ix1, iy1);
                } else {
                    p.lineTo(ix2, iy2);
                }
                begin = false;
                ixlast = ix2;
                continue;
            }
            if (!carry) {
                ixc = ix1;
                iyc = iy1;
                iyc2 = iy1;
                if (begin) {
                    p.moveTo(ix1, iy1);
                } else {
                    p.lineTo(ix1, iy1);
                }
                begin = false;
            }
            carry = true;
        }
        if (this.fill) {
            p.lineTo(ixlast, (float)zeroY);
            if (this.fillColor != null) {
                g.setColor(this.fillColor);
            }
            g.fill(p);
            g.setColor(this.color);
        }
        g.draw(p);
        if (this.drawDataPoints) {
            PathIterator iter = p.getPathIterator(null);
            int ctr = 0;
            while (!iter.isDone()) {
                iter.currentSegment(this.coord);
                iter.next();
                if (iter.isDone() || ctr++ == 0) continue;
                g.fillRect((int)this.coord[0] - 2, (int)this.coord[1] - 2, 4, 4);
            }
        }
        g.setStroke(old);
    }
}

