/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.freehep.swing.ExtensionFileFilter;
import org.freehep.util.export.ExportFileTypeRegistry;

public abstract class ExportFileType
implements Comparable {
    private static ClassLoader loader;

    public abstract String getDescription();

    public abstract String[] getExtensions();

    public abstract String[] getMIMETypes();

    public void exportToFile(OutputStream os, Component target, Component parent, Properties properties, String creator) throws IOException {
        this.exportToFile(os, new Component[]{target}, parent, properties, creator);
    }

    public void exportToFile(File file, Component target, Component parent, Properties properties, String creator) throws IOException {
        this.exportToFile(file, new Component[]{target}, parent, properties, creator);
    }

    public abstract void exportToFile(OutputStream var1, Component[] var2, Component var3, Properties var4, String var5) throws IOException;

    public abstract void exportToFile(File var1, Component[] var2, Component var3, Properties var4, String var5) throws IOException;

    public int compareTo(Object o) {
        ExportFileType type = (ExportFileType)o;
        return this.getDescription().compareTo(type.getDescription());
    }

    public boolean hasOptionPanel() {
        return false;
    }

    public JPanel createOptionPanel(Properties options) {
        return null;
    }

    public boolean applyChangedOptions(JPanel optionPanel, Properties options) {
        return false;
    }

    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.getExtensions(), this.getDescription());
    }

    public File adjustFilename(File file, Properties properties) {
        return this.adjustFilename(file, "", properties);
    }

    public File adjustFilename(File file, String extension, Properties properties) {
        return ExportFileType.adjustExtension(file, this.getExtensions()[0], this.getExtensions(), extension);
    }

    public String getFileExtension(File file) {
        return ExportFileType.getExtension(file, this.getExtensions());
    }

    public boolean fileHasValidExtension(File file) {
        return ExportFileType.checkExtension(file, this.getExtensions());
    }

    public boolean isMultipageCapable() {
        return false;
    }

    public static void setClassLoader(ClassLoader loader) {
        ExportFileType.loader = loader;
    }

    public static List getExportFileTypes() {
        return ExportFileType.getExportFileTypes(null);
    }

    public static List getExportFileTypes(String format) {
        return ExportFileTypeRegistry.getDefaultInstance(loader).get(format);
    }

    public static String getExtension(File file, String[] acceptableExtensions) {
        String extension = "";
        if (file != null && acceptableExtensions != null) {
            String name = file.getName();
            name = name.toLowerCase();
            for (int i = 0; i < acceptableExtensions.length; ++i) {
                String acceptableExtension = acceptableExtensions[i].toLowerCase();
                if (!name.endsWith("." + acceptableExtension) || acceptableExtension.length() <= extension.length()) continue;
                extension = acceptableExtensions[i];
            }
        }
        return extension;
    }

    public static boolean checkExtension(File file, String[] acceptableExtensions) {
        return ExportFileType.getExtension(file, acceptableExtensions).length() > 0;
    }

    public static File adjustExtension(File file, String preferredExtension, String[] acceptableExtensions) {
        return ExportFileType.adjustExtension(file, preferredExtension, acceptableExtensions, "");
    }

    public static File adjustExtension(File file, String preferredExtension, String[] acceptableExtensions, String extension) {
        File returnValue = file;
        if (file != null) {
            String originalParent = file.getParent();
            String originalName = file.getName();
            String mainName = "";
            if (originalParent != null) {
                mainName = originalParent + File.separator;
            }
            if (extension.length() > 0 && originalName.endsWith(extension)) {
                mainName = mainName + originalName.substring(0, originalName.length() - extension.length() - 1);
            } else {
                int dotIndex = originalName.lastIndexOf(46);
                if (dotIndex > 0 && dotIndex < originalName.length() - 1) {
                    mainName = mainName + originalName.substring(0, dotIndex);
                    extension = originalName.substring(dotIndex + 1);
                } else {
                    mainName = mainName + originalName;
                    extension = "";
                }
            }
            returnValue = new File(mainName + "." + extension);
            if (!ExportFileType.checkExtension(returnValue, acceptableExtensions)) {
                returnValue = new File(mainName + "." + preferredExtension);
            }
        }
        return returnValue;
    }
}

