/*
 * Decompiled with CFR 0.152.
 */
package objectify;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import objectify.Parameter;

public class ObjectifyReader {
    private static boolean debug = false;
    static boolean blank = false;
    static boolean autoCreate = false;
    static BufferedReader r;
    static String delim;
    static Hashtable paramsTable;
    static String currentTempl;

    public void setAutoCreateParameters(boolean enabled) {
        autoCreate = enabled;
    }

    public void setParameterTable(Hashtable parameters) {
        paramsTable = parameters;
    }

    public void loadInput(Reader reader, List inputTemplate) throws Exception {
        BufferedReader in = new BufferedReader(reader);
        Object line = null;
        String[] tokens = null;
        Object param = null;
        r = in;
        boolean stop = false;
        Iterator iter = inputTemplate.iterator();
        while (iter.hasNext() && !stop) {
            if (!blank) {
                tokens = ObjectifyReader.nextLineTokens(in, delim);
            } else {
                blank = false;
            }
            if (tokens != null) {
                String s;
                String o = null;
                o = currentTempl.startsWith("#ForEach:") ? currentTempl : iter.next();
                if (o instanceof String) {
                    String s2 = o;
                    if (s2.startsWith("#ForEach:")) {
                        s2 = s2.substring(9, s2.length());
                    }
                    if (!s2.startsWith("blank")) {
                        ObjectifyReader.handleTokens(s2, tokens);
                        continue;
                    }
                    blank = true;
                    continue;
                }
                if (!(o instanceof List)) continue;
                List l = (List)((Object)o);
                currentTempl = s = (String)l.get(0);
                if (!s.startsWith("blank")) {
                    ObjectifyReader.handleTokens((List)((Object)o), tokens);
                    continue;
                }
                blank = true;
                continue;
            }
            stop = true;
        }
        in.close();
    }

    public void loadInput(String inputPath, List inputTemplate) throws Exception {
        this.loadInput(new FileReader(inputPath), inputTemplate);
    }

    private static void handleTokens(String s, String[] tokens) {
        if (s.charAt(0) == '#') {
            ObjectifyReader.handleLoop(s, tokens);
        } else {
            Parameter param = ObjectifyReader.getParameter(s);
            if (param == null && autoCreate) {
                param = ObjectifyReader.createParameter(s);
                param.setValue("");
                param.setName(s);
            }
            if (param != null) {
                Object value = param.getValue();
                ObjectifyReader.setParamValue(param, tokens[0]);
                if (debug) {
                    System.out.println("\t" + param.getName() + " (" + s + ")");
                    System.out.println("\t\t<-" + tokens[0]);
                }
            } else if (debug) {
                System.out.println("Skipped " + s);
            }
        }
    }

    private static void handleTokens(List temp, String[] tokens) {
        int i = 0;
        Iterator temp_iter = temp.iterator();
        while (temp_iter.hasNext()) {
            Object paramhash = temp_iter.next();
            String hash = (String)paramhash;
            if (paramhash.equals("1509")) {
                System.out.println("Here");
            }
            if (hash.charAt(0) == '?') {
                ObjectifyReader.handleConditional(hash, tokens);
                continue;
            }
            if (hash.charAt(0) == '#') {
                ObjectifyReader.handleLoop(hash, tokens);
                continue;
            }
            Parameter param = ObjectifyReader.getParameter((String)paramhash);
            if (param == null && autoCreate) {
                param = ObjectifyReader.createParameter((String)paramhash);
                param.setValue("");
                param.setName((String)paramhash);
            }
            if (param != null) {
                Object value = param.getValue();
                if (debug) {
                    System.out.println("\t" + param.getName() + " (" + paramhash + ")");
                    if (paramhash.equals("1509")) {
                        System.out.println("Here");
                    }
                    System.out.println("\t\t<-" + tokens[i]);
                }
                if (i >= tokens.length) continue;
                ObjectifyReader.setParamValue(param, tokens[i++]);
                continue;
            }
            if (!debug) continue;
            System.out.println("Skipped " + (String)paramhash);
        }
    }

    private static void handleConditional(String s, String[] tokens) {
        String cond = "=|<|>|:";
        s = s.substring(1, s.length());
        String[] expr = s.split(cond);
        Parameter operand = ObjectifyReader.getParameter(expr[0]);
        String operator = s.substring(expr[0].length(), expr[0].length() + 1);
        String literal = expr[1];
        int sepInd = s.lastIndexOf(58);
        int bInd = s.indexOf(58);
        String ctrue = s.substring(bInd + 1, sepInd);
        String cfalse = s.substring(sepInd + 1, s.length());
        Object templ = null;
        if (debug) {
            System.out.println("\n\n\nFound conditional!");
            System.out.println(expr.length + " tokens:");
            System.out.println("\t\tOperand:" + operand.getName());
            System.out.println("\t\tOperator:" + operator);
            System.out.println("\t\tLiteral:" + literal);
            System.out.println("\t\ttrue:" + ctrue);
            System.out.println("\t\tfalse:" + cfalse);
        }
        if ((templ = ObjectifyReader.compare(operand, literal, operator) ? ObjectifyReader.eval(ctrue) : ObjectifyReader.eval(cfalse)) == null) {
            blank = true;
            return;
        }
        if (templ instanceof String) {
            ObjectifyReader.handleTokens((String)templ, tokens);
        } else {
            ObjectifyReader.handleTokens((List)templ, tokens);
        }
    }

    public static void handleLoop(String s, String[] tokens) {
        block25: {
            Object templ;
            int compound;
            block27: {
                int rowLoop;
                block26: {
                    String[] newTokens;
                    block24: {
                        String cond = "c|r|\\{";
                        rowLoop = -1;
                        compound = -1;
                        int cInd = s.indexOf(99);
                        int rInd = s.indexOf(114);
                        int bInd = s.indexOf(123);
                        int opInd = -1;
                        if (cInd == -1) {
                            cInd = Integer.MAX_VALUE;
                        }
                        if (rInd == -1) {
                            rInd = Integer.MAX_VALUE;
                        }
                        if (bInd == -1) {
                            bInd = Integer.MAX_VALUE;
                        }
                        if (cInd < rInd && cInd < bInd) {
                            opInd = cInd;
                        } else if (rInd < cInd && rInd < bInd) {
                            opInd = rInd;
                            rowLoop = 1;
                        } else {
                            opInd = bInd;
                            compound = 1;
                        }
                        s = s.substring(1);
                        String operator = "" + s.charAt(opInd - 1);
                        String arg = s.substring(opInd);
                        String opKey = s.substring(0, opInd - 1);
                        boolean literalOperand = false;
                        if (opKey.startsWith("'")) {
                            literalOperand = true;
                        }
                        Parameter operand = null;
                        if (!literalOperand) {
                            operand = ObjectifyReader.getParameter(opKey);
                        } else {
                            operand = new Parameter();
                            operand.setValue(new Integer(Integer.parseInt(opKey.substring(1, opKey.length() - 1))));
                        }
                        if (arg.charAt(arg.length() - 1) == '}') {
                            arg = arg.substring(0, arg.length() - 1);
                        }
                        templ = null;
                        String str = ObjectifyReader.loop(operand, arg);
                        templ = ObjectifyReader.eval(str);
                        newTokens = new String[tokens.length - 1];
                        if (debug) {
                            System.out.println("\n\n\nFound loop!");
                            System.out.println("\t\tOperand hash:" + opKey);
                            System.out.println("\t\tIterations:" + operand.getValue());
                            System.out.println("\t\tOperator:" + operator);
                            System.out.println("\t\tArg:" + arg);
                        }
                        if (rowLoop == 1) {
                            rowLoop = (Integer)operand.getValue();
                        }
                        if (compound == 1) {
                            compound = (Integer)operand.getValue();
                        }
                        for (int i = 1; i < tokens.length; ++i) {
                            newTokens[i - 1] = tokens[i];
                        }
                        if (!(templ instanceof String) || rowLoop != -1 || compound != -1) break block24;
                        ObjectifyReader.handleTokens((String)templ, newTokens);
                        break block25;
                    }
                    if (!(templ instanceof List) || rowLoop != -1 || compound != -1) break block26;
                    ObjectifyReader.handleTokens((List)templ, newTokens);
                    break block25;
                }
                if (rowLoop == -1) break block27;
                List tList = (List)templ;
                int ind = 0;
                int i = 0;
                while (i < rowLoop) {
                    String[] rtokens = tokens;
                    if (rtokens != null) {
                        ArrayList<String> templElem = new ArrayList<String>();
                        int endInd = tList.size() / rowLoop;
                        for (int j = 0; j < endInd; ++j) {
                            String templStr = (String)tList.get(ind);
                            templElem.add(templStr);
                            ++ind;
                        }
                        ObjectifyReader.handleTokens(templElem, rtokens);
                        ++i;
                    }
                    if (i == rowLoop) continue;
                    tokens = ObjectifyReader.nextLineTokens(r, delim);
                }
                break block25;
            }
            if (compound == -1) break block25;
            List tList = (List)templ;
            int ind = 1;
            int i = 0;
            while (ind < tList.size()) {
                String[] rtokens = tokens;
                if (rtokens != null) {
                    ArrayList<String> templElem = new ArrayList<String>();
                    boolean nline = false;
                    int j = 0;
                    while (!nline && ind < tList.size()) {
                        String templStr = (String)tList.get(ind);
                        if (templStr.startsWith("\\")) {
                            nline = true;
                            ++ind;
                        } else {
                            templElem.add(templStr);
                            ++ind;
                        }
                        ++j;
                    }
                    ObjectifyReader.handleTokens(templElem, rtokens);
                }
                if (ind < tList.size()) {
                    tokens = ObjectifyReader.nextLineTokens(r, delim);
                }
                ++i;
            }
        }
    }

    private static void setParamValue(Parameter p, String value) {
        Object v = p.getValue();
        if (v instanceof Float) {
            if (p.getCoeff() == null) {
                p.setValue(new Float(value));
            } else {
                Float fval = new Float(value);
                p.setValue(new Float(fval.floatValue() / p.getCoeff().floatValue()));
            }
        } else if (v instanceof Integer) {
            p.setValue(new Integer(value));
        } else if (v instanceof String) {
            p.setValue(value);
        } else {
            throw new RuntimeException("Illegal parameter value! Must be one of: float, integer, string!");
        }
    }

    public static boolean compare(Parameter operand, String literal, String operator) {
        Object o = operand.getValue();
        if (o instanceof Float) {
            Float comp = new Float(literal);
            Float value = (Float)o;
            int res = value.compareTo(comp);
            if (operator.equals("=")) {
                return res == 0;
            }
            if (operator.equals("<")) {
                return res < 0;
            }
            return res > 0;
        }
        if (o instanceof String) {
            String value = (String)o;
            int res = value.compareTo(literal);
            if (operator.equals("=")) {
                return res == 0;
            }
            if (operator.equals("<")) {
                return res < 0;
            }
            return res > 0;
        }
        if (o instanceof Integer) {
            Integer comp = new Integer(literal);
            Integer value = (Integer)o;
            int res = value.compareTo(comp);
            if (operator.equals("=")) {
                return res == 0;
            }
            if (operator.equals("<")) {
                return res < 0;
            }
            return res > 0;
        }
        return false;
    }

    public static Object eval(String expr) {
        String delim = ",";
        if (expr.charAt(0) == '?' || expr.charAt(0) == '#') {
            return expr;
        }
        String[] tokens = expr.split(delim);
        ArrayList<String> tempList = new ArrayList<String>();
        boolean cat = false;
        String templS = tokens[0];
        for (int i = 1; i < tokens.length + 1; ++i) {
            templS = cat ? templS + "," + tokens[i - 1] : tokens[i - 1];
            if (tokens[i - 1].indexOf(114) != -1) {
                cat = true;
            }
            if (i == tokens.length) {
                cat = false;
            } else if (tokens[i].startsWith("\\")) {
                cat = false;
            }
            if (cat) continue;
            tempList.add(templS);
        }
        if (tokens.length == 1) {
            if (expr.equals("blank")) {
                return null;
            }
            return tokens[0];
        }
        return tempList;
    }

    public static String loop(Parameter op, String arg) {
        int lim = (Integer)op.getValue();
        String[] args = arg.split(",");
        String argn = "";
        String cat = "";
        for (int i = 0; i < lim; ++i) {
            for (int j = 0; j < args.length; ++j) {
                argn = args[j];
                if (argn.charAt(0) != '\\') {
                    if (argn.charAt(0) != '?' && argn.indexOf(35) == -1) {
                        ObjectifyReader.cloneParameter(argn, argn + "+" + i);
                        if (debug) {
                            System.out.println("Created param:" + argn + "+" + i);
                        }
                    } else {
                        String[] args2 = argn.split("r|c");
                        args2[0] = args2[0].substring(1);
                        ObjectifyReader.cloneParameter(args2[0], args2[0] + "+" + i);
                        if (debug) {
                            System.out.println("Created param:" + args2[0] + "+" + i);
                        }
                        ObjectifyReader.cloneParameter(args2[1], args2[1] + "+" + i);
                        if (debug) {
                            System.out.println("Created param:" + args2[1] + "+" + i);
                        }
                        argn = "#" + args2[0] + "+" + i + argn.charAt(args2[0].length() + 1) + args2[1];
                    }
                    if (i == 0 && j == 0) {
                        cat = cat + argn + "+" + i;
                        continue;
                    }
                    cat = cat + ',' + argn + "+" + i;
                    continue;
                }
                cat = i == 0 && j == 0 ? cat + "\\" : cat + ",\\";
            }
        }
        return cat;
    }

    private static String[] nextLineTokens(BufferedReader reader, String delim) {
        String[] tokens = null;
        boolean read = false;
        try {
            while (!read) {
                String line = reader.readLine();
                if (line == null) {
                    return null;
                }
                if ((line = line.replaceFirst("!.*", "")).length() == 0) {
                    return null;
                }
                if (Character.isWhitespace(line.charAt(0))) {
                    line = line.replaceFirst("\\s+", "");
                }
                if (line.length() != 0) {
                    tokens = line.split(delim);
                    read = true;
                    continue;
                }
                read = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tokens;
    }

    private static Parameter getParameter(String key) {
        return (Parameter)paramsTable.get(key);
    }

    private static Parameter createParameter(String key) {
        Parameter p = new Parameter();
        p.setHashKey(key);
        paramsTable.put(key, p);
        return p;
    }

    private static Parameter cloneParameter(String originalKey, String cloneKey) {
        Parameter orig = ObjectifyReader.getParameter(originalKey);
        if (orig == null && autoCreate) {
            orig = new Parameter();
            orig.setValue("");
            orig.setHashKey(originalKey);
            paramsTable.put(originalKey, orig);
        }
        Parameter clone = (Parameter)orig.clone();
        clone.setHashKey(cloneKey);
        paramsTable.put(cloneKey, clone);
        return clone;
    }

    static {
        delim = "\\s+,|,\\s+|\\s+|,";
        currentTempl = "";
    }
}

