/*
 * Decompiled with CFR 0.152.
 */
package fi.stuk.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComponent;

public class TileLayout
implements LayoutManager,
Serializable {
    private boolean modify = true;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int newAlign;
    int hgap;
    int vgap;
    private static final long serialVersionUID = -7262534875583282631L;
    boolean flag = false;
    Component[] comps = null;
    int laynum = 0;
    int maxwidth = 1;
    int maxheight = 1;
    int nmembers = 1;
    int x = 0;
    int y = 1;
    int rowh = 0;
    int start = 0;
    boolean ltr = true;
    int lastRowStart = -1;
    int lastRowEnd = -1;
    int row = 0;
    int totalH = 0;
    int totalW = 0;
    int ctr = 1;
    private static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;

    public TileLayout() {
        this(0, 1, 1);
    }

    public TileLayout(boolean modify) {
        this(0, 1, 1);
        this.modify = modify;
    }

    public TileLayout(int v, int h) {
        this(0, v, h);
    }

    public TileLayout(int align) {
        this(align, 1, 1);
    }

    public TileLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public TileLayout(int align, int hgap, int vgap, boolean modify) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
        this.modify = modify;
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int align) {
        this.newAlign = align;
        switch (align) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = align;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                dim.height = Math.max(dim.height, d.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                dim.height = Math.max(dim.height, d.height);
                if (i > 0) {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, int lastRowStart, int lastRowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.newAlign) {
                case 0: {
                    x += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x += width;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (lastRowStart != -1) {
                    int ind = lastRowStart + i - rowStart;
                    if (ind >= rowStart) {
                        ind = rowStart - 1;
                    }
                    if (ind == -1) {
                        ind = 0;
                    }
                    y = this.comps[ind].getY() + this.comps[ind].getHeight() + this.vgap;
                }
                m.setLocation(x, y);
                x += m.getWidth() + this.hgap;
            }
        }
        return x;
    }

    private void nextComp(Component m, int i) {
        Dimension d = m.getPreferredSize();
        m.setSize(d.width, d.height);
        if (this.x > 0) {
            this.x += this.hgap;
        }
        this.x += d.width;
        this.rowh = Math.max(this.rowh, d.height);
        this.totalW += d.width;
    }

    private void nextRow(Container target, Component m, int i, Insets ins, int hgap) {
        Dimension d = m.getPreferredSize();
        this.lastRowEnd = i - 1;
        this.totalH += this.rowh + this.vgap;
        this.totalW += this.moveComponents(target, ins.left + hgap, this.y, this.maxwidth - this.x, this.rowh, this.start, i, this.lastRowStart, this.lastRowEnd, this.ltr);
        ++this.ctr;
        this.x = d.width;
        this.y += this.vgap + this.rowh;
        this.rowh = d.height;
        this.lastRowStart = this.start;
        this.start = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        if (this.flag) {
            return;
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            this.maxwidth = target.getWidth();
            this.maxheight = target.getHeight();
            this.nmembers = target.getComponentCount();
            this.x = 0;
            this.y = insets.top + this.vgap;
            this.rowh = 0;
            this.start = 0;
            this.comps = target.getComponents();
            this.ltr = target.getComponentOrientation().isLeftToRight();
            this.lastRowStart = -1;
            this.lastRowEnd = -1;
            this.row = 0;
            this.totalH = 0;
            this.totalW = 0;
            this.ctr = 1;
            this.x = this.hgap;
            this.totalH = insets.top;
            boolean stop = false;
            for (int i = 0; i < this.nmembers && !stop; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (this.modify || this.totalW + d.width > this.maxwidth && this.totalH + d.height > this.maxheight - 20) {
                    if (!this.modify) {
                        this.totalH += this.rowh;
                    }
                    if (this.maxwidth - this.totalW > this.maxheight - this.totalH) {
                        this.nextComp(m, i);
                        continue;
                    }
                    if (this.x + d.width <= this.maxwidth) {
                        this.nextComp(m, i);
                        continue;
                    }
                    this.nextRow(target, m, i, insets, this.hgap);
                    continue;
                }
                if (i == 0 || this.x == 0 || this.x + d.width <= this.maxwidth) {
                    this.nextComp(m, i);
                    continue;
                }
                this.nextRow(target, m, i, insets, this.hgap);
            }
            int v = this.moveComponents(target, insets.left + this.hgap, this.y, this.maxwidth - this.x, this.rowh, this.start, this.nmembers, this.lastRowStart, this.lastRowEnd, this.ltr);
            if (this.modify) {
                this.totalH += this.rowh;
                this.totalW += v;
            }
            this.flag = true;
            if (target instanceof JComponent) {
                Container c;
                int w = target.getMinimumSize().width;
                int h = target.getMinimumSize().height;
                if (this.modify) {
                    ((JComponent)target).setPreferredSize(new Dimension(target.getMinimumSize().width, this.totalH));
                    ((JComponent)target).setMaximumSize(new Dimension(target.getMinimumSize().width, this.totalH));
                }
                if ((c = target.getParent()) != null) {
                    ((Component)c).doLayout();
                    ((Component)c).validate();
                }
            }
            ++this.laynum;
            this.flag = false;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.setAlignment(this.align);
        }
        this.serialVersionOnStream = 1;
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
                break;
            }
            case 3: {
                str = ",align=leading";
                break;
            }
            case 4: {
                str = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

