/*
 * Decompiled with CFR 0.152.
 */
package fi.stuk.visualization.graphs;

import fi.stuk.visualization.graphs.Axis;
import fi.stuk.visualization.graphs.GraphCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.io.Serializable;

public abstract class Graph
implements Serializable {
    private String title;
    private Font titleFont;
    private String xAxisTitle;
    private Font xAxisTitleFont;
    private String yAxisTitle;
    private Font yAxisTitleFont;
    private int type;
    protected Color color = Color.black;
    protected Color fillColor = null;
    private static int num;
    protected static Stroke stroke;
    protected float strokeWidth = 1.0f;
    private boolean autoScaleXAxis = false;
    private boolean autoScaleYaxis = false;
    protected boolean fill = false;
    double aspectRatio;
    private double offset = Double.NaN;
    private double scale = Double.NaN;
    protected double[] range;
    protected double xAxisMax;
    protected double xAxisMin;
    protected double yAxisMax;
    protected double yAxisMin;
    double max = 0.0;
    double min = 0.0;

    public Graph() {
        this.title = "Graph " + num++;
        stroke = new BasicStroke(1.0f, 2, 2);
    }

    public void setStrokeWidth(float w) {
        stroke = new BasicStroke(w);
        this.strokeWidth = w;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeStyle() {
    }

    public void setFilled(boolean enabled) {
        this.fill = enabled;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setXAxisTitle(String string) {
        this.xAxisTitle = string;
    }

    public double getXmax() {
        return this.xAxisMax;
    }

    public double getXmin() {
        return this.xAxisMin;
    }

    public double getYmax() {
        return this.yAxisMax;
    }

    public double getYmin() {
        return this.yAxisMin;
    }

    public void setRange(double[] range) {
        this.range = range;
    }

    private void bounds(double[] data) {
        this.max = -1.7976931348623157E308;
        this.min = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] > this.max) {
                this.max = data[i];
            }
            if (!(data[i] < this.min)) continue;
            this.min = data[i];
        }
    }

    public abstract double eval(double var1);

    public void setYAxisTitle(String string) {
        this.yAxisTitle = string;
    }

    public void setXAxisTitleFont(Font font) {
        this.xAxisTitleFont = font;
    }

    public void setYAxisTitleFont(Font font) {
        this.yAxisTitleFont = font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
    }

    public void render(GraphCanvas c, Graphics2D g, Axis a) {
        GeneralPath p = new GeneralPath(1);
        p.reset();
        p.moveTo(0.0f, 0.0f);
        double minx = 0.0;
        double miny = 0.0;
        double maxx = a.getSize(0);
        double maxy = a.getSize(1);
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        int ixc = 0;
        int ixlast = 0;
        int iyc = 0;
        int iyc2 = 0;
        boolean carryNum = false;
        boolean carry = false;
        for (int i = 1; i < this.range.length; ++i) {
            if (!carry) {
                x1 = a.getAxisCoordinateForValue(this.range[i - 1], 0);
                y1 = a.getAxisCoordinateForValue(this.eval(this.range[i - 1]), 1);
            } else {
                x1 = a.getAxisCoordinateForValue(this.range[i - 1], 0);
                double yval = this.eval(this.range[i - 1]);
                y1 = Math.max(y1, a.getAxisCoordinateForValue(yval, 1));
                iyc2 = Math.max((int)y1, iyc2);
                y1 = a.getAxisCoordinateForValue(yval, 1);
                if (!Double.isInfinite(y1)) {
                    iyc = Math.min((int)y1, iyc);
                }
            }
            x2 = a.getAxisCoordinateForValue(this.range[i], 0);
            y2 = a.getAxisCoordinateForValue(this.eval(this.range[i]), 1);
            if (x1 == Double.POSITIVE_INFINITY && x2 != Double.POSITIVE_INFINITY) {
                x1 = maxx;
            } else if (x2 == Double.POSITIVE_INFINITY && x1 != Double.POSITIVE_INFINITY) {
                x2 = maxx;
            }
            if (y1 == Double.POSITIVE_INFINITY && y2 != Double.POSITIVE_INFINITY) {
                y1 = maxy;
            } else if (y2 == Double.POSITIVE_INFINITY && y1 != Double.POSITIVE_INFINITY) {
                y2 = maxy;
            }
            if (x1 == Double.NEGATIVE_INFINITY && x2 != Double.NEGATIVE_INFINITY) {
                x1 = minx;
            } else if (x2 == Double.NEGATIVE_INFINITY && x1 != Double.NEGATIVE_INFINITY) {
                x2 = minx;
            }
            if (y1 == Double.NEGATIVE_INFINITY && y2 != Double.NEGATIVE_INFINITY) {
                y1 = miny;
            } else if (y2 == Double.NEGATIVE_INFINITY && y1 != Double.NEGATIVE_INFINITY) {
                y2 = miny;
            }
            int ix1 = (int)x1;
            int ix2 = (int)x2;
            int iy1 = (int)y1;
            int iy2 = (int)y2;
            if (Double.isInfinite(x1) || Double.isInfinite(y1)) continue;
            if (ix1 != ix2) {
                if (carry) {
                    p.lineTo(ixc, iyc2);
                }
                carry = false;
                p.lineTo(ix1, iy1);
                ixlast = ix1;
                continue;
            }
            if (!carry) {
                ixc = ix1;
                iyc = iy1;
                iyc2 = iy1;
                p.lineTo(ix1, iy1);
            }
            carry = true;
        }
        Stroke old = g.getStroke();
        if (this.fill) {
            p.lineTo(ixlast, 0.0f);
        }
        g.setColor(this.color);
        g.setStroke(new BasicStroke(this.strokeWidth, 0, 2));
        if (this.fill) {
            g.fill(p);
        }
        g.draw(p);
        g.setStroke(old);
    }

    public String toString() {
        return this.title;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }
}

