/*
 * Decompiled with CFR 0.152.
 */
package fi.stuk.visualization.polygonal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class FrameBuffer {
    int w;
    int h;
    BufferedImage im;
    double[] zBuffer;
    int tx;
    int ty;
    Color background;
    double[] backSampl = new double[]{0.0, 0.0, 0.0, 0.0};
    boolean alpha = false;

    public FrameBuffer(int w, int h) {
        this.im = new BufferedImage(w, h, 2);
        this.zBuffer = new double[w * h];
        this.background = Color.black;
        this.w = w;
        this.h = h;
        this.tx = w / 2;
        this.ty = h / 2;
    }

    public void setBackground(Color c) {
        this.background = c;
        this.backSampl[0] = c.getAlpha();
        this.backSampl[1] = (double)c.getRed() / 255.0;
        this.backSampl[2] = (double)c.getGreen() / 255.0;
        this.backSampl[3] = (double)c.getBlue() / 255.0;
    }

    public void setAlphaEnabled(boolean enabled) {
        this.alpha = enabled;
    }

    public void set(int x, int y, float[] fArray) {
        WritableRaster r = this.im.getRaster();
        y = this.h - y;
        if (x > this.w - 1 || x < 0) {
            return;
        }
        if (y > this.h - 1 || y < 0) {
            return;
        }
        r.setPixel(x, y, fArray);
    }

    public void set(int x, int y, double[] dArray) {
        WritableRaster r = this.im.getRaster();
        y = this.h - y;
        if (x > this.w - 1 || x < 0) {
            return;
        }
        if (y > this.h - 1 || y < 0) {
            return;
        }
        r.setPixel(x, y, dArray);
    }

    public void set(int x, int y, double z, double[] dArray) {
        WritableRaster r = this.im.getRaster();
        y = this.h - y;
        int ind = y * this.w + x;
        if (x > this.w - 1 || x < 0) {
            return;
        }
        if (y > this.h - 1 || y < 0) {
            return;
        }
        if (z < 0.0 || this.zBuffer[ind] < z) {
            return;
        }
        this.zBuffer[ind] = z;
        r.setPixel(x, y, dArray);
    }

    public void set(int x, int y, double z, float[] fArray) {
        WritableRaster r = this.im.getRaster();
        y = this.h - y;
        int ind = y * this.w + x;
        if (x > this.w - 1 || x < 0) {
            return;
        }
        if (y > this.h - 1 || y < 0) {
            return;
        }
        if (z < 0.0 || this.zBuffer[ind] < z) {
            return;
        }
        this.zBuffer[ind] = z;
        r.setPixel(x, y, fArray);
    }

    public BufferedImage getImage() {
        return this.im;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void clear() {
        if (!this.alpha) {
            Graphics g = this.im.getGraphics();
            g.setColor(this.background);
            g.fillRect(0, 0, this.w, this.h);
        } else {
            WritableRaster r = this.im.getRaster();
            for (int i = 0; i < this.w; ++i) {
                for (int j = 0; j < this.h; ++j) {
                    r.setPixel(i, j, this.backSampl);
                }
            }
        }
        for (int i = 0; i < this.zBuffer.length; ++i) {
            this.zBuffer[i] = Double.MAX_VALUE;
        }
    }
}

