/*
 * Decompiled with CFR 0.152.
 */
package fi.stuk.visualization.polygonal;

import fi.stuk.visualization.polygonal.Shader;
import java.util.List;

public class ScanConverter {
    Shader sh;
    int[] scanlinesStart;
    int[] scanlinesEnd;
    double[][] interpStart;
    double[][] interpEnd;
    int w = 300;
    int oy = 0;
    int ox = 0;
    boolean line = false;
    private double[] data;

    public ScanConverter(int sizex, int sizey, int numDatas) {
        this.scanlinesStart = new int[sizey];
        this.scanlinesEnd = new int[sizey];
        this.interpStart = new double[sizey][numDatas];
        this.interpEnd = new double[sizey][numDatas];
        this.data = new double[numDatas];
        this.oy = sizey / 2;
        this.ox = sizex / 2;
        this.w = sizex;
    }

    public void setShader(Shader shader) {
        this.sh = shader;
    }

    private void DDA(int x1, int y1, int x2, int y2, double[] ip1, double[] ip2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int steps = Math.abs(dy);
        double x_inc = (double)dx / (double)steps;
        double y_inc = (double)dy / (double)steps;
        for (int i = 0; i < steps; ++i) {
            double x = (double)x1 + (double)i * x_inc;
            double y = (double)y1 + (double)i * y_inc;
            int yi = (int)Math.round(y) + this.oy;
            int xi = (int)Math.round(x) + this.ox;
            for (int j = 0; j < this.interpStart[0].length; ++j) {
                double ip_inc = (ip2[j] - ip1[j]) / (double)steps;
                double ival = ip1[j] + (double)i * ip_inc;
                if (yi >= this.scanlinesStart.length || yi < 0) continue;
                if (Double.isNaN(this.interpStart[yi][j])) {
                    this.interpStart[yi][j] = ival;
                    continue;
                }
                this.interpEnd[yi][j] = ival;
            }
            if (yi >= this.scanlinesStart.length || yi < 0) continue;
            if (xi > this.w) {
                xi = this.w;
            }
            if (xi < 0) {
                xi = 0;
            }
            if (this.scanlinesStart[yi] == -2147483647) {
                this.scanlinesStart[yi] = xi;
                continue;
            }
            if (this.scanlinesEnd[yi] != -2147483647) continue;
            this.scanlinesEnd[yi] = xi;
        }
    }

    private void interpolate(double[] v1, double[] v2, double[] d1, double[] d2) {
        if (v2[1] < v1[1]) {
            double[] temp = v1;
            v1 = v2;
            v2 = temp;
            temp = d1;
            d1 = d2;
            d2 = temp;
        }
        this.DDA((int)Math.ceil(v1[0]), (int)Math.ceil(v1[1]), (int)Math.ceil(v2[0]), (int)Math.ceil(v2[1]), d1, d2);
    }

    private void renderScanlines() {
        for (int i = 0; i < this.scanlinesStart.length; ++i) {
            if (this.line && this.scanlinesStart[i] != -2147483647 && (this.scanlinesEnd[i] == -2147483647 || this.scanlinesEnd[i] == this.scanlinesStart[i])) {
                this.scanlinesEnd[i] = this.scanlinesStart[i] + 1;
            }
            if (this.scanlinesStart[i] == -2147483647 || this.scanlinesEnd[i] == -2147483647) continue;
            boolean swap = false;
            int y = i;
            int len = this.scanlinesEnd[i] - this.scanlinesStart[i];
            if (len < 0) {
                swap = true;
                int tmp = this.scanlinesStart[i];
                this.scanlinesStart[i] = this.scanlinesEnd[i];
                this.scanlinesEnd[i] = tmp;
                len = -len;
            }
            for (int j = 0; j < len; ++j) {
                int x = this.scanlinesStart[y] + j;
                for (int n = 0; n < this.interpStart[y].length; ++n) {
                    this.data[n] = !swap ? this.interpStart[y][n] + (this.interpEnd[y][n] - this.interpStart[y][n]) / (double)len * (double)j : this.interpEnd[y][n] + (this.interpStart[y][n] - this.interpEnd[y][n]) / (double)len * (double)j;
                }
                boolean edge = i == 0 || this.scanlinesStart[i - 1] == -2147483647 || this.scanlinesStart[i - 1] > x || this.scanlinesEnd[i - 1] < x;
                this.sh.shade(x, y, this.data, edge);
            }
        }
    }

    private void resetScanlines() {
        for (int i = 0; i < this.scanlinesStart.length; ++i) {
            this.scanlinesStart[i] = -2147483647;
            this.scanlinesEnd[i] = -2147483647;
            for (int n = 0; n < this.interpStart[i].length; ++n) {
                this.interpStart[i][n] = Double.NaN;
                this.interpEnd[i][n] = Double.NaN;
            }
        }
    }

    public void scanConvert(List vertices, List perVertexData) {
        int i = 0;
        double[] firstv = null;
        double[] lastv = null;
        double[] firstd = null;
        double[] lastd = null;
        this.resetScanlines();
        this.line = vertices.size() < 3;
        for (i = 0; i < vertices.size() - 1; ++i) {
            double[] v1 = (double[])vertices.get(i);
            double[] v2 = (double[])vertices.get(i + 1);
            double[] d1 = (double[])perVertexData.get(i);
            double[] d2 = (double[])perVertexData.get(i + 1);
            d1[0] = v1[3];
            d2[0] = v2[3];
            this.interpolate(v1, v2, d1, d2);
            if (i == 0) {
                firstv = v1;
                firstd = d1;
            }
            lastv = v2;
            lastd = d2;
        }
        this.interpolate(lastv, firstv, lastd, firstd);
        this.renderScanlines();
    }
}

