/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.BasicEditor;
import UI.BasicRenderer;
import UI.HeaderLabel;
import UI.HeaderRenderer;
import UI.MiniControlWidgets;
import UI.ParameterEditor;
import UI.ParameterRenderer;
import UI.ProportionEditor;
import UI.ProportionRenderer;
import core.Element;
import core.Main;
import core.Parameter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.stuk.visualization.graphs.GraphCanvas;
import org.stuk.visualization.graphs.XYGraph;

public class ElementEditorPanel
extends JPanel {
    private static Object[] presets = null;
    Object[] columnNames = new Object[]{"Element", "Z", "A", "Mass percentage", "Number of atoms"};
    Object[][] rowData = new Object[][]{{null, null, null, null}, {null, null, null, null}};
    JDialog dialog;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CANCEL = 2;
    int presStatus;
    int status;
    int hashBase;
    String numElemsHash;
    boolean loading = true;
    boolean begin = false;
    int index = -1;
    SimpleAttributeSet sub = new SimpleAttributeSet();
    SimpleAttributeSet sup = new SimpleAttributeSet();
    SimpleAttributeSet nor = new SimpleAttributeSet();
    SimpleAttributeSet nor2 = new SimpleAttributeSet();
    Style subStyle;
    Style supStyle;
    Style norStyle;
    boolean compound = true;
    float density = 0.0f;
    float minCoeff = 1000.0f;
    Parameter[] getFp;
    JDialog stopDiag;
    GraphCanvas gc;
    Color[] cycle = new Color[]{Color.black, Color.red, Color.blue};
    int ccolor = 0;
    MiniControlWidgets w;
    int numcaps = 0;
    JDialog dia;
    JLabel help;
    JDialog pdia = null;
    JToolTip tempTip = null;
    Object lock = new Integer(1);
    boolean superScript = true;
    int keyStrokes = 0;
    int phase = 0;
    StringBuffer sb = new StringBuffer();
    StringBuffer sbAtoms = new StringBuffer();
    StringBuffer sbIsotope = new StringBuffer();
    ArrayList list = new ArrayList();
    ArrayList atomsList = new ArrayList();
    boolean ambiguous = false;
    List zl = new ArrayList();
    List al = new ArrayList();
    List fl = new ArrayList();
    ArrayList typedElems = new ArrayList();
    List elements = null;
    Object ERROR = new Integer(1);
    ArrayList unknownSymbols = new ArrayList();
    JDialog sdialog;
    String presetName;
    JTextField pname;
    JTextField pdens;
    private JButton addBtn;
    private ButtonGroup buttonGroup1;
    private JButton cancelBtn;
    private JButton cancelPlot;
    private HeaderLabel compoundLabel;
    private JTextPane compoundPane;
    private JDialog densityDialog;
    private JTable elementPropertiesTable;
    private JTable elementTable;
    private JComboBox elementsCombobox;
    private JLabel elementsLabel;
    private HeaderLabel headerLabel1;
    private HeaderLabel headerLabel2;
    private JLabel hyphenLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private HeaderLabel lab1;
    private HeaderLabel lab2;
    private HeaderLabel lab3;
    private JButton okBtn;
    private JButton okBtn1;
    private JTextField plotDensityField;
    private JButton plotWithDensity;
    private JComboBox presetsBox;
    private JButton removeBtn;
    private JButton removePresetButton;
    private JPanel tabPanel;
    private JButton toPresetsBtn;

    public ElementEditorPanel(JDialog dialog) {
        this.dialog = dialog;
        this.numElemsHash = this.numElemsHash;
        this.hashBase = this.hashBase;
        if (presets == null) {
            ElementEditorPanel.loadPresets();
        }
        this.initComponents();
        this.loadPresetsBox();
        this.compoundPane.setBorder(this.elementsCombobox.getBorder());
        this.presetsBox.setSelectedIndex(-1);
        this.setValues();
        List l = Main.getElements();
        for (int i = 0; i < l.size(); ++i) {
            this.elementsCombobox.addItem(l.get(i));
        }
        StyleConstants.setSuperscript(this.sup, true);
        StyleConstants.setSubscript(this.sub, true);
        Style subStyle = StyleContext.getDefaultStyleContext().addStyle("_sub", null);
        subStyle.setResolveParent(this.sub);
        Style supStyle = StyleContext.getDefaultStyleContext().addStyle("_super", null);
        supStyle.setResolveParent(this.sup);
        Style norStyle = StyleContext.getDefaultStyleContext().addStyle("_normal", null);
        norStyle.setResolveParent(this.nor);
        StyleConstants.setSubscript(subStyle, true);
        StyleConstants.setSuperscript(supStyle, true);
        this.loading = false;
    }

    public void setPreset(int ind) {
        this.presetsBox.setSelectedIndex(ind);
    }

    public int getPreset() {
        return this.index;
    }

    public boolean isPresetModified() {
        return false;
    }

    public String getMixtureName(List list) {
        for (int i = 0; i < presets.length; ++i) {
            if (!(presets[i] instanceof String)) continue;
            String name = (String)presets[i++];
            Parameter dens = (Parameter)presets[i++];
            Integer numelems = (Integer)presets[i++];
            Parameter densc = (Parameter)list.get(0);
            Parameter numelemsc = (Parameter)list.get(1);
            int ind = 2;
            boolean match = densc.getFloatValue().equals(dens.getFloatValue()) && numelemsc.getIntegerValue().equals(numelems);
            for (int j = 0; j < numelems && match; ++j) {
                Parameter z = (Parameter)presets[i++];
                Parameter a = (Parameter)presets[i++];
                Parameter f = (Parameter)presets[i++];
                Parameter zc = (Parameter)list.get(ind++);
                Parameter ac = (Parameter)list.get(ind++);
                Parameter fc = (Parameter)list.get(ind++);
                match = zc.getIntegerValue().equals(z.getIntegerValue()) && ac.getIntegerValue().equals(a.getIntegerValue()) && fc.getFloatValue().equals(f.getFloatValue());
            }
            if (!match) continue;
            return name;
        }
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public int getNumElements() {
        if (!this.compound) {
            return this.elementTable.getRowCount();
        }
        return this.zl.size();
    }

    public void addElement() {
        DefaultTableModel m = (DefaultTableModel)this.elementTable.getModel();
        Parameter Z = new Parameter();
        Z.setValue(new Integer(0));
        Z.setName("dummy Z");
        Z.setDescription("Atomic number of the element.");
        Parameter A = new Parameter();
        A.setValue(new Integer(0));
        A.setName("dummy A");
        A.setHashKey("Dummy A");
        A.setDescription("Mass number of the element. Use this to specify an isotope.");
        Parameter F = new Parameter();
        F.setValue(new Integer(0));
        F.setName("dummy frac");
        F.setDescription("Percentage of the mass that is of this element. For compounds, set to 100%.");
        Parameter At = new Parameter();
        At.setValue(new Integer(1));
        At.setName("dummy atoms");
        At.setMinValue(new Integer(1));
        At.setMinBoundInclusive(true);
        At.setDescription("Number of atoms of this element in the compound/mixture.");
        Object[] rowData = new Object[]{"He", Z, A, F, At};
        m.addRow(rowData);
        this.elementTable.setPreferredSize(new Dimension(this.elementTable.getWidth(), this.elementTable.getRowCount() * this.elementTable.getRowHeight()));
    }

    public void setNumElements(int numElems) {
        int i;
        this.begin = false;
        DefaultTableModel m = (DefaultTableModel)this.elementTable.getModel();
        int rows = this.elementTable.getRowCount();
        for (i = 0; i < rows; ++i) {
            m.removeRow(0);
        }
        for (i = 0; i < numElems; ++i) {
            Parameter Z = new Parameter();
            Z.setValue(new Integer(0));
            Z.setName("dummy Z");
            Z.setDescription("Atomic number of the element.");
            Parameter A = new Parameter();
            A.setValue(new Integer(0));
            A.setName("dummy A");
            A.setHashKey("Dummy A");
            A.setDescription("Mass number of the element. Use this to specify an isotope.");
            Parameter F = new Parameter();
            F.setValue(new Integer(0));
            F.setName("dummy frac");
            F.setDescription("Percentage of the mass that is of this element. For compounds, set to 100%.");
            Parameter At = new Parameter();
            At.setValue(new Integer(1));
            At.setName("dummy atoms");
            At.setMinValue(new Integer(1));
            At.setMinBoundInclusive(true);
            At.setDescription("Number of atoms of this element in the compound/mixture.");
            Object[] rowData = new Object[]{"He", Z, A, F, At};
            m.addRow(rowData);
        }
        this.elementTable.setPreferredSize(new Dimension(this.elementTable.getWidth(), numElems * this.elementTable.getRowHeight()));
    }

    public void setDensity(Parameter p) {
        this.density = p.getFloatValue().floatValue();
    }

    public float getDensity() {
        return this.density;
    }

    public void setZ(int elem, int z) {
        Parameter p = (Parameter)this.elementTable.getValueAt(elem, 1);
        p.setValue(new Integer(z));
        this.elementTable.setValueAt(Main.getElement(z), elem, 0);
        if (this.compound) {
            try {
                StyledDocument doc = this.compoundPane.getStyledDocument();
                doc.insertString(doc.getLength(), "" + Element.determineAbbreviation(p.getIntegerValue()), this.nor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.loadPresetsBox();
    }

    public void setA(int elem, int a) {
        Parameter p = (Parameter)this.elementTable.getValueAt(elem, 2);
        p.setValue(new Integer(a));
        Parameter z = (Parameter)this.elementTable.getValueAt(elem, 1);
        if (z.getIntegerValue() < 1) {
            p.setValue(new Integer(-1));
        }
        if (this.compound) {
            try {
                Element e = Main.getElement(((Parameter)this.elementTable.getValueAt(elem, 1)).getIntegerValue());
                e.setA(new Integer(a));
                if (e.isIsotope()) {
                    StyledDocument doc = this.compoundPane.getStyledDocument();
                    doc.insertString(doc.getLength() - e.getAbbreviation().length(), "" + a, this.sup);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setFraction(int elem, float f) {
        if (this.compound) {
            this.compound = f - (float)((int)f) == 0.0f;
        }
        Parameter pP = (Parameter)this.elementTable.getValueAt(elem, 3);
        Parameter pAtoms = (Parameter)this.elementTable.getValueAt(elem, 4);
        pP.setValue(new Float(f));
        pAtoms.setValue(new Integer(1));
        if (this.compound) {
            try {
                StyledDocument doc = this.compoundPane.getStyledDocument();
                if ((int)f != 1) {
                    doc.insertString(doc.getLength(), "" + (int)f, this.sub);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.begin = true;
    }

    public void beginSetting() {
        this.compound = true;
        this.compoundPane.setText("");
    }

    public void endSetting() {
        this.popupPeriodicTable();
        if (this.compound) {
            this.jRadioButton1.setSelected(true);
            this.jRadioButton1ActionPerformed(null);
            this.ambiguous = false;
            this.parseCompound(this.compoundPane.getText(), this.compoundPane.getStyledDocument());
            this.superScript = false;
        } else {
            this.fixFractions();
            this.jRadioButton2.setSelected(true);
            this.compoundPane.setText("");
            this.jRadioButton2ActionPerformed(null);
        }
    }

    private boolean checkIsCompound() {
        int rows = this.elementTable.getRowCount();
        float minF = 1000.0f;
        for (int j = 0; j < rows; ++j) {
            Parameter p = (Parameter)this.elementTable.getValueAt(j, 3);
            float atoms = p.getFloatValue().floatValue();
            if (atoms < minF) {
                minF = atoms;
            }
            if ((p = (Parameter)this.elementTable.getValueAt(j, 2)).getIntegerValue() > 0) continue;
            return false;
        }
        boolean isCompound = true;
        for (int j = 0; j < rows; ++j) {
            Parameter p = (Parameter)this.elementTable.getValueAt(j, 3);
            float atoms = p.getFloatValue().floatValue();
            float f = atoms / minF;
            boolean bl = isCompound = f - (float)((int)f) == 0.0f;
            if (isCompound) continue;
            return false;
        }
        return true;
    }

    private void fixFractions() {
        float A;
        float atoms;
        Parameter p;
        int j;
        int rows = this.elementTable.getRowCount();
        float totalA = 0.0f;
        for (j = 0; j < rows; ++j) {
            p = (Parameter)this.elementTable.getValueAt(j, 3);
            atoms = p.getFloatValue().floatValue();
            p = (Parameter)this.elementTable.getValueAt(j, 2);
            A = p.getIntegerValue().intValue();
            totalA += A * atoms;
        }
        for (j = 0; j < rows; ++j) {
            p = (Parameter)this.elementTable.getValueAt(j, 3);
            atoms = p.getFloatValue().floatValue();
            p = (Parameter)this.elementTable.getValueAt(j, 2);
            A = p.getIntegerValue().intValue();
            p = (Parameter)this.elementTable.getValueAt(j, 3);
            if (totalA > 0.0f) {
                p.setValue(new Float(atoms * A / totalA));
                continue;
            }
            p.setValue(new Float(1.0f));
        }
    }

    public int getZ(int elem) {
        if (!this.compound) {
            Parameter p = (Parameter)this.elementTable.getValueAt(elem, 1);
            Integer val = (Integer)p.getValue();
            return val;
        }
        Integer v = (Integer)this.zl.get(elem);
        return v;
    }

    public int getA(int elem) {
        if (!this.compound) {
            Parameter p = (Parameter)this.elementTable.getValueAt(elem, 2);
            Integer val = (Integer)p.getValue();
            p = (Parameter)this.elementTable.getValueAt(elem, 1);
            if (p.getIntegerValue() <= 0) {
                return 20;
            }
            return val;
        }
        Integer v = (Integer)this.al.get(elem);
        return v;
    }

    public void beginGetting() {
        this.minCoeff = 1000.0f;
        this.getFp = new Parameter[this.elementTable.getRowCount()];
        for (int i = 0; i < this.elementTable.getRowCount(); ++i) {
            Parameter p = (Parameter)this.elementTable.getValueAt(i, 4);
            float atoms = p.getIntegerValue().intValue();
            p = (Parameter)this.elementTable.getValueAt(i, 3);
            float perc = p.getFloatValue().floatValue();
            p = (Parameter)this.elementTable.getValueAt(i, 2);
            float A = (float)p.getIntegerValue().intValue() * atoms;
            p = (Parameter)this.elementTable.getValueAt(i, 3);
            float ret = perc * 100.0f / A;
            if (ret < this.minCoeff) {
                this.minCoeff = ret;
            }
            if (A <= 0.0f) {
                ret = 1.001f;
            }
            if (this.getFp[i] == null) {
                this.getFp[i] = new Parameter();
            }
            this.getFp[i].setValue(new Float(ret));
        }
        if (!this.compound) {
            // empty if block
        }
    }

    public float getFraction(int elem) {
        if (!this.compound) {
            float ret = this.getFp[elem].getFloatValue().floatValue();
            return ret;
        }
        Float v = (Float)this.fl.get(elem);
        return v.floatValue();
    }

    public void endGetting() {
    }

    private void initTable(JTable table) {
        if (table == this.elementPropertiesTable) {
            table.getColumnModel().getColumn(0).setPreferredWidth(195);
            table.getColumnModel().getColumn(1).setPreferredWidth(52);
            table.getColumnModel().getColumn(2).setPreferredWidth(38);
            table.setRowHeight(table.getRowHeight() + 2);
        } else {
            table.getColumnModel().getColumn(0).setPreferredWidth(65);
            table.getColumnModel().getColumn(1).setPreferredWidth(20);
            table.getColumnModel().getColumn(2).setPreferredWidth(20);
            table.getColumnModel().getColumn(3).setPreferredWidth(93);
            table.getColumnModel().getColumn(4).setMinWidth(0);
            table.getColumnModel().getColumn(4).setMaxWidth(0);
            table.getColumnModel().getColumn(4).setPreferredWidth(0);
            table.getColumnModel().getColumn(0).setHeaderValue("Element");
            table.getColumnModel().getColumn(1).setHeaderValue("Z");
            table.getColumnModel().getColumn(2).setHeaderValue("A");
            table.getColumnModel().getColumn(3).setHeaderValue("Mass percentage");
            table.getColumnModel().getColumn(4).setHeaderValue("0");
        }
    }

    public void setValues() {
        Parameter p = new Parameter();
        p.setValue(new Float(0.4f));
        Parameter pZ = new Parameter();
        pZ.setValue(new Integer(4));
        Parameter pA = new Parameter();
        pA.setValue(new Integer(16));
        Parameter pZ2 = new Parameter();
        pZ2.setValue(new Integer(4));
        Parameter pA2 = new Parameter();
        pA2.setValue(new Integer(16));
        Parameter pZ3 = new Parameter();
        pZ3.setValue(new Integer(4));
        Parameter pA3 = new Parameter();
        pA3.setValue(new Integer(16));
        this.elementTable.setValueAt("Silicon", 0, 0);
        this.elementTable.setValueAt(pZ, 0, 1);
        this.elementTable.setValueAt(pA, 0, 2);
        this.elementTable.setValueAt(p, 0, 3);
        this.elementTable.setValueAt("Carbon", 1, 0);
        this.elementTable.setValueAt(pZ2, 1, 1);
        this.elementTable.setValueAt(pA2, 1, 2);
        this.elementTable.setValueAt("Cesium", 2, 0);
        this.elementTable.setValueAt(pZ3, 2, 1);
        this.elementTable.setValueAt(pA3, 2, 2);
        Parameter p2 = new Parameter();
        p2.setValue(new Float(0.3f));
        this.elementTable.setValueAt(p2, 1, 3);
        Parameter p3 = new Parameter();
        p3.setValue(new Float(0.3f));
        this.elementTable.setValueAt(p3, 2, 3);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ElementEditorPanel(null));
        frame.setSize(400, 200);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private void loadPresetsBox() {
        boolean t = this.loading;
        this.loading = true;
        this.presetsBox.removeAllItems();
        for (int i = 0; i < presets.length; ++i) {
            if (!(presets[i] instanceof String)) continue;
            this.presetsBox.addItem(presets[i]);
        }
        this.presetsBox.setSelectedIndex(this.index);
        this.loading = t;
    }

    private static void savePresets() {
        try {
            FileOutputStream fos = new FileOutputStream("./lib/mixtures.prs");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(presets);
            oos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadPresets() {
        try {
            FileInputStream fis = new FileInputStream("./lib/mixtures.prs");
            ObjectInputStream ois = new ObjectInputStream(fis);
            presets = (Object[])ois.readObject();
            ois.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (presets == null) {
            presets = new Object[0];
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.densityDialog = new JDialog();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.plotDensityField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.plotWithDensity = new JButton();
        this.cancelPlot = new JButton();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.headerLabel1 = new HeaderLabel();
        this.headerLabel2 = new HeaderLabel();
        this.presetsBox = new JComboBox();
        this.toPresetsBtn = new JButton();
        this.removePresetButton = new JButton();
        this.tabPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.elementTable = new JTable(this.rowData, this.columnNames);
        this.elementTable.getTableHeader().setReorderingAllowed(false);
        this.elementTable.getTableHeader().setResizingAllowed(false);
        this.lab1 = new HeaderLabel();
        this.elementsCombobox = new JComboBox();
        this.lab3 = new HeaderLabel();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.elementPropertiesTable = new JTable();
        this.lab2 = new HeaderLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.compoundPane = new JTextPane();
        this.hyphenLabel = new JLabel();
        this.elementsLabel = new JLabel();
        this.compoundLabel = new HeaderLabel();
        this.jPanel2 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.okBtn1 = new JButton();
        this.densityDialog.setTitle("Material density");
        this.densityDialog.setModal(true);
        this.jLabel1.setText("Material density for stopping power plot:");
        this.jPanel3.add(this.jLabel1);
        this.plotDensityField.setColumns(6);
        this.plotDensityField.setText("0.001");
        this.jPanel3.add(this.plotDensityField);
        this.jLabel2.setText(" g/cm3");
        this.jPanel3.add(this.jLabel2);
        this.densityDialog.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel4.setLayout(new FlowLayout(2));
        this.plotWithDensity.setText("Plot");
        this.plotWithDensity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.plotWithDensityActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.plotWithDensity);
        this.cancelPlot.setText("Cancel");
        this.cancelPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.cancelPlotActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cancelPlot);
        this.densityDialog.getContentPane().add((Component)this.jPanel4, "South");
        this.setBorder(new SoftBevelBorder(0));
        this.setLayout(new BorderLayout());
        this.jPanel1.setBackground(new Color(153, 153, 153));
        this.jPanel1.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOpaque(false);
        this.jToolBar1.setPreferredSize(new Dimension(648, 17));
        this.headerLabel1.setText(" Material editor");
        this.headerLabel1.setPreferredSize(new Dimension(410, 15));
        this.jToolBar1.add(this.headerLabel1);
        this.headerLabel2.setText("Presets:");
        this.jToolBar1.add(this.headerLabel2);
        this.presetsBox.setToolTipText("Select a predefined material");
        this.presetsBox.setPreferredSize(new Dimension(104, 19));
        this.presetsBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.presetsBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.presetsBox);
        this.toPresetsBtn.setBackground(new Color(153, 153, 153));
        this.toPresetsBtn.setText("<-Save");
        this.toPresetsBtn.setToolTipText("Save the current material as a preset");
        this.toPresetsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.toPresetsBtnActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toPresetsBtn);
        this.removePresetButton.setBackground(new Color(153, 153, 153));
        this.removePresetButton.setText("Remove");
        this.removePresetButton.setToolTipText("Remove the selected preset from the list");
        this.removePresetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.removePresetButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.removePresetButton);
        this.jPanel1.add((Component)this.jToolBar1, "West");
        this.add((Component)this.jPanel1, "North");
        this.tabPanel.setBorder(new SoftBevelBorder(1));
        this.tabPanel.setLayout(new AbsoluteLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.elementTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, true, true, true};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.elementTable.setGridColor(new Color(214, 217, 179));
        this.elementTable.setOpaque(false);
        this.elementTable.setPreferredSize(new Dimension(325, 48));
        this.initTable(this.elementTable);
        this.elementTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.elementTable.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.elementTable.getColumnModel().getColumn(2).setCellRenderer(new ParameterRenderer());
        this.elementTable.getColumnModel().getColumn(2).setCellEditor(new ParameterEditor());
        this.elementTable.getColumnModel().getColumn(3).setCellRenderer(new ProportionRenderer());
        this.elementTable.getColumnModel().getColumn(3).setCellEditor(new ProportionEditor());
        this.elementTable.getColumnModel().getColumn(4).setCellRenderer(new ParameterRenderer());
        this.elementTable.getColumnModel().getColumn(4).setCellEditor(new ParameterEditor());
        this.elementTable.getColumnModel().getColumn(0).setHeaderRenderer(new HeaderRenderer());
        this.elementTable.getColumnModel().getColumn(1).setHeaderRenderer(new HeaderRenderer());
        this.elementTable.getColumnModel().getColumn(2).setHeaderRenderer(new HeaderRenderer());
        this.elementTable.getColumnModel().getColumn(3).setHeaderRenderer(new HeaderRenderer());
        this.elementTable.getColumnModel().getColumn(4).setHeaderRenderer(new HeaderRenderer());
        this.elementTable.setSelectionMode(0);
        this.elementTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.elementTable);
        this.tabPanel.add((Component)this.jScrollPane1, new AbsoluteConstraints(310, 120, 330, 80));
        this.lab1.setText(" Element list");
        this.tabPanel.add((Component)this.lab1, new AbsoluteConstraints(40, 100, 200, -1));
        this.elementsCombobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.elementsComboboxActionPerformed(evt);
            }
        });
        this.tabPanel.add((Component)this.elementsCombobox, new AbsoluteConstraints(40, 120, 200, -1));
        this.lab3.setText(" Elements selected for simulation");
        this.tabPanel.add((Component)this.lab3, new AbsoluteConstraints(310, 100, 330, -1));
        this.addBtn.setText("->");
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.addBtnActionPerformed(evt);
            }
        });
        this.tabPanel.add((Component)this.addBtn, new AbsoluteConstraints(250, 130, -1, -1));
        this.removeBtn.setText("x");
        this.removeBtn.setPreferredSize(new Dimension(43, 23));
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.removeBtnActionPerformed(evt);
            }
        });
        this.tabPanel.add((Component)this.removeBtn, new AbsoluteConstraints(250, 160, -1, -1));
        this.elementPropertiesTable.setModel(new DefaultTableModel(new Object[][]{{"", null, ""}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.elementPropertiesTable.setAutoResizeMode(0);
        this.elementPropertiesTable.setGridColor(new Color(204, 204, 204));
        this.elementPropertiesTable.setOpaque(false);
        this.elementPropertiesTable.setRowSelectionAllowed(false);
        this.elementPropertiesTable.setShowHorizontalLines(false);
        this.elementPropertiesTable.setShowVerticalLines(false);
        this.initTable(this.elementPropertiesTable);
        this.elementPropertiesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.elementPropertiesTable.getColumnModel().getColumn(1).setCellRenderer(new BasicRenderer());
        this.elementPropertiesTable.getColumnModel().getColumn(2).setCellRenderer(new BasicRenderer());
        this.elementPropertiesTable.getColumnModel().getColumn(1).setCellEditor(new BasicEditor());
        this.tabPanel.add((Component)this.elementPropertiesTable, new AbsoluteConstraints(40, 170, 200, -1));
        this.lab2.setText(" Element properties");
        this.tabPanel.add((Component)this.lab2, new AbsoluteConstraints(40, 150, 200, -1));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setText("Compound material");
        this.jRadioButton1.setToolTipText("A material that is a chemical compound");
        this.jRadioButton1.setOpaque(false);
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.tabPanel.add((Component)this.jRadioButton1, new AbsoluteConstraints(10, 0, -1, -1));
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("Mixture material");
        this.jRadioButton2.setToolTipText("A material that is a mixture of elements.");
        this.jRadioButton2.setOpaque(false);
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.tabPanel.add((Component)this.jRadioButton2, new AbsoluteConstraints(10, 70, -1, -1));
        this.compoundPane.setToolTipText("The molecular or empirical formula of the compound. Make sure to use capital letters correctly");
        this.compoundPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ElementEditorPanel.this.compoundPaneKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                ElementEditorPanel.this.compoundPaneKeyReleased(evt);
            }
        });
        this.tabPanel.add((Component)this.compoundPane, new AbsoluteConstraints(40, 40, 110, 30));
        this.hyphenLabel.setText(" - ");
        this.tabPanel.add((Component)this.hyphenLabel, new AbsoluteConstraints(160, 40, 10, 30));
        this.tabPanel.add((Component)this.elementsLabel, new AbsoluteConstraints(180, 40, 330, 30));
        this.compoundLabel.setText(" Molecular formula");
        this.compoundLabel.setToolTipText(" The molecular or empirical formula of the compound");
        this.tabPanel.add((Component)this.compoundLabel, new AbsoluteConstraints(40, 22, 110, -1));
        this.add((Component)this.tabPanel, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 5, 1));
        this.okBtn.setText("Ok");
        this.okBtn.setToolTipText("Accept changes and quit editor");
        this.okBtn.setPreferredSize(new Dimension(155, 27));
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.setToolTipText("Cancel editing");
        this.cancelBtn.setPreferredSize(new Dimension(80, 25));
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelBtn);
        this.okBtn1.setText("Plot stopping power");
        this.okBtn1.setToolTipText("Plots the graph of E -> dE");
        this.okBtn1.setPreferredSize(new Dimension(155, 27));
        this.okBtn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementEditorPanel.this.okBtn1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okBtn1);
        this.add((Component)this.jPanel2, "South");
    }

    private void getStoppingForElem(double[] E, double Z2, double M2, double f, double[] c, double[] y, double dens) {
        double Z1 = 2.0;
        double M1 = 4.0;
        System.out.println("Target Atomic mass:" + M2 + "  f:" + f);
        y[0] = 0.0;
        int i = 1;
        while (i < E.length) {
            double Ep = E[i] / 4.0;
            double En = E[i];
            double sLow = c[1] * Math.pow(Ep, c[2]) + c[3] * Math.pow(Ep, c[4]);
            double sHigh = c[5] * Math.pow(Ep, -c[6]) * Math.log(c[7] * 1.0 / Ep + c[8] * Ep);
            double Se = 1.0 / (1.0 / sHigh + 1.0 / sLow);
            double B = Math.log(Ep);
            double c_ = 1.0 + (0.007 + 5.0E-5 * Z2) * Math.exp(-Math.pow(7.6 - B, 2.0));
            double gamma2 = 1.0 - Math.exp(-0.2865 - 0.1266 * B + 0.001429 * B * B - 0.02402 * B * B * B + 0.01135 * B * B * B * B - 0.001475 * B * B * B * B * B) * c_ * c_;
            Se = 4.0 * gamma2 * Se;
            double eps = 32.53 * M1 * M2 * (En / M1) / (Z1 * Z2 * (M1 + M2) * (Math.pow(Z1, 0.23) + Math.pow(Z2, 0.23)));
            double Seps = Math.log(1.0 + 1.1383 * eps) / (2.0 * (eps + 0.01321 * Math.pow(eps, 0.21226) + 0.19593 * Math.pow(eps, 0.5)));
            if (eps >= 30.0) {
                Seps = Math.log(eps) / (2.0 * eps);
            }
            double Sn = 8.462 * Z1 * Z2 * M1 * Seps / ((M1 + M2) * (Math.pow(Z1, 0.23) + Math.pow(Z2, 0.23)));
            double Stotal = Math.max(Se + Sn, 0.0) * f * 0.6022 / M2 * 1000.0;
            int n = i++;
            y[n] = y[n] + Stotal;
        }
    }

    private XYGraph getAttenuationGraph(double mdensity) {
        int NUM = 2000;
        double maxEp = 15000.0;
        double EpStep = maxEp / (double)NUM;
        XYGraph ret = new XYGraph();
        double[] x = new double[NUM];
        double[] y = new double[NUM];
        double[] c = new double[9];
        double Ep = 0.0;
        for (int i = 0; i < NUM; ++i) {
            x[i] = (double)i * EpStep;
        }
        this.beginGetting();
        int n = this.getNumElements();
        double totalF = 0.0;
        for (int i = 0; i < n; ++i) {
            int z = this.getZ(i);
            double Z2 = z;
            double M2 = this.getA(i);
            Element e = this.getElement(Element.determineAbbreviation(new Integer(z)), true);
            for (int j = 0; j < 8; ++j) {
                c[j + 1] = e.getCoefficent(j);
            }
            double f = this.getFraction(i);
            totalF += M2 * f;
            this.getStoppingForElem(x, Z2, M2, M2 * f, c, y, mdensity);
        }
        System.out.println("Total f:" + totalF);
        this.endGetting();
        double ymax = -1.0;
        double xmax = -1.0;
        int i = 0;
        while (i < y.length) {
            if (y[i] > ymax) {
                ymax = y[i];
                xmax = x[i] / 1000.0;
            }
            int n2 = i;
            y[n2] = y[n2] / totalF;
            int n3 = i++;
            x[n3] = x[n3] / 1000.0;
        }
        System.out.println("Xmax:" + xmax + " Ymax:" + ymax);
        ret.setX(x);
        ret.setY(y);
        return ret;
    }

    private void plotStopping(double mdensity) {
        if (this.stopDiag == null) {
            this.stopDiag = new JDialog(this.pdia);
            double[] xTics = new double[]{10.0, 100.0, 1000.0, 10000.0};
            double[] yTics = new double[]{10.0, 100.0, 1000.0, 10000.0};
            String[] xLab = new String[]{"0.01", "0.1", "1", "10", "100"};
            String[] yLab = new String[]{"0.001", "0.1", "1", "10", "100"};
            this.gc = new GraphCanvas();
            this.gc.setSize(400, 400);
            this.gc.setBackground(Color.white);
            this.gc.getAxis().setMinMax(0.0, 0.0, 10.0, 20.0);
            this.gc.getAxis().setTitle("Stopping power (MeV cm^2/g)", 1);
            this.gc.getAxis().setTitleFont(new Font("Arial", 1, 12), 0);
            this.gc.getAxis().setTitleFont(new Font("Arial", 1, 12), 1);
            this.gc.getAxis().setTitle("Energy (MeV)", 0);
            this.gc.setXInset(60);
            this.gc.setYInset(50);
            this.stopDiag.getContentPane().add((Component)this.gc, "Center");
            this.stopDiag.setTitle("Stopping power graph");
            JPanel pan = new JPanel();
            pan.setLayout(new FlowLayout(0, 1, 1));
            JButton close = new JButton("Close");
            JButton clear = new JButton("Clear");
            close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ElementEditorPanel.this.gc.getGraphs().clear();
                    ElementEditorPanel.this.stopDiag.dispose();
                }
            });
            clear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ElementEditorPanel.this.gc.getGraphs().clear();
                    ElementEditorPanel.this.gc.getAxis().setMinMax(0.0, 0.0, 10.0, 20.0);
                    ElementEditorPanel.this.gc.getAxis().setTics(10);
                    ElementEditorPanel.this.gc.refresh();
                    ElementEditorPanel.this.gc.repaint();
                }
            });
            this.w = new MiniControlWidgets();
            this.w.setHome(0.0, 0.0, 10.0, 20.0);
            pan.add(this.w);
            pan.add(clear);
            pan.add(close);
            pan.setBorder(new SoftBevelBorder(1));
            this.w.setCanvas(this.gc);
            this.w.constrainToPositive(true, true);
            this.stopDiag.getContentPane().add((Component)pan, "South");
            this.gc.start();
            this.gc.refresh();
            this.stopDiag.setSize(400, 400);
            this.stopDiag.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 3, Toolkit.getDefaultToolkit().getScreenSize().height / 3);
        }
        XYGraph g = this.getAttenuationGraph(mdensity);
        g.setColor(this.cycle[this.ccolor++ % this.cycle.length]);
        double max = this.gc.getAxis().getMax(1);
        if (g.getYmax() > max) {
            this.gc.getAxis().setMax(g.getYmax(), 1);
        }
        this.w.setHome(0.0, 0.0, 10.0, this.gc.getAxis().getMax(1));
        this.gc.getAxis().setTics(6);
        this.gc.addGraph(g);
        this.gc.refresh();
        this.gc.repaint();
        this.stopDiag.setVisible(true);
    }

    private void okBtn1ActionPerformed(ActionEvent evt) {
        try {
            this.plotStopping(1.0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void compoundPaneKeyPressed(KeyEvent evt) {
        int cursor;
        if (this.dia != null) {
            this.dia.dispose();
        }
        if ((cursor = this.compoundPane.getCaret().getDot()) == 0) {
            this.superScript = true;
        }
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.compound = false;
        this.compoundPane.setEnabled(false);
        this.compoundLabel.setEnabled(false);
        this.elementsLabel.setEnabled(false);
        this.hyphenLabel.setEnabled(false);
        this.lab1.setEnabled(true);
        this.lab2.setEnabled(true);
        this.lab3.setEnabled(true);
        this.compoundPane.setForeground(Color.gray);
        this.compoundPane.setBackground(this.elementsLabel.getBackground());
        this.elementsCombobox.setEnabled(true);
        this.elementPropertiesTable.setEnabled(true);
        this.elementTable.setEnabled(true);
        this.addBtn.setEnabled(true);
        this.removeBtn.setEnabled(true);
        this.okBtn.setText("Create mixture");
        this.okBtn.setToolTipText("Create the mixture from specified elements and proportions.");
        this.repaint();
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.compound = true;
        this.hyphenLabel.setEnabled(true);
        this.compoundPane.setEnabled(true);
        this.compoundLabel.setEnabled(true);
        this.compoundPane.setForeground(Color.black);
        this.compoundPane.setBackground(Color.white);
        this.elementsLabel.setEnabled(true);
        this.lab1.setEnabled(false);
        this.lab2.setEnabled(false);
        this.lab3.setEnabled(false);
        this.elementsCombobox.setEnabled(false);
        this.elementPropertiesTable.setEnabled(false);
        this.elementTable.setEnabled(false);
        this.addBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.okBtn.setText("ok");
        this.okBtn.setToolTipText("Accept changes and quit editor.");
        this.repaint();
    }

    private void compoundDocumentChanged(DocumentEvent e) {
    }

    private void popupHelp(String msg) {
        this.popupHelp(msg, null, null, 3);
    }

    private static Element e(int n) {
        return Main.getElement(n);
    }

    public static JTable getPeriodicTable() {
        Object s = null;
        JTable tab = new JTable();
        tab.setGridColor(new Color(204, 204, 204));
        Object[] row1 = new Object[]{ElementEditorPanel.e(1), s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, ElementEditorPanel.e(2)};
        Object[] row2 = new Object[]{ElementEditorPanel.e(3), ElementEditorPanel.e(4), s, s, s, s, s, s, s, s, s, s, ElementEditorPanel.e(5), ElementEditorPanel.e(6), ElementEditorPanel.e(7), ElementEditorPanel.e(8), ElementEditorPanel.e(9), ElementEditorPanel.e(10)};
        Object[] row3 = new Object[]{ElementEditorPanel.e(11), ElementEditorPanel.e(12), s, s, s, s, s, s, s, s, s, s, ElementEditorPanel.e(13), ElementEditorPanel.e(14), ElementEditorPanel.e(15), ElementEditorPanel.e(16), ElementEditorPanel.e(17), ElementEditorPanel.e(18)};
        Object[] row4 = new Object[row1.length];
        for (int i = 0; i < row4.length; ++i) {
            row4[i] = ElementEditorPanel.e(19 + i);
        }
        Object[] row5 = new Object[row1.length];
        for (int i = 0; i < row4.length; ++i) {
            row5[i] = ElementEditorPanel.e(37 + i);
        }
        Object[] row6 = new Object[row1.length];
        for (int i = 3; i < row4.length; ++i) {
            row6[i] = ElementEditorPanel.e(72 + i - 3);
        }
        row6[0] = ElementEditorPanel.e(55);
        row6[1] = ElementEditorPanel.e(56);
        Object[] row7 = new Object[row1.length];
        row7[0] = ElementEditorPanel.e(87);
        row7[1] = ElementEditorPanel.e(88);
        Object[] row8 = new Object[row1.length];
        for (int i = 3; i < row4.length; ++i) {
            row8[i] = ElementEditorPanel.e(57 + i - 3);
        }
        Object[] row9 = new Object[row1.length];
        for (int i = 3; i < 7; ++i) {
            row9[i] = ElementEditorPanel.e(89 + i - 3);
        }
        Object[] titles = new String[row1.length];
        for (int i = 0; i < row4.length; ++i) {
            titles[i] = ElementEditorPanel.e(19 + i).getName();
        }
        tab.setModel(new DefaultTableModel(new Object[][]{row1, row2, row3, row4, row5, row6, row7, row8, row9}, titles){

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        final Color yel = Color.yellow.brighter().brighter();
        final Color gre = Color.green.brighter().brighter();
        final Color cya = Color.cyan.brighter().brighter();
        tab.setPreferredSize(new Dimension(320, 156));
        DefaultTableCellRenderer rend = new DefaultTableCellRenderer(){
            JLabel lab = new JLabel();
            String empty = "";
            int z = 0;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                this.lab.setHorizontalAlignment(0);
                Element e = (Element)value;
                String abb = null;
                double dens = 0.0;
                if (e != null) {
                    abb = e.getAbbreviation();
                    this.z = e.getZ();
                    dens = e.getDensity();
                } else {
                    this.z = 0;
                }
                if (abb != null) {
                    this.lab.setText(abb);
                } else {
                    this.lab.setText(this.empty);
                }
                if (e != null) {
                    this.lab.setToolTipText(e.getName() + " (Z=" + e.getZ().toString() + " A=" + e.getA() + " \u03c1=" + (dens == 0.0 ? "?" : "" + dens) + " g/cm\u00b3)");
                }
                if (vColIndex == 17) {
                    this.lab.setBackground(Color.yellow);
                } else if (vColIndex == 0 && rowIndex == 0) {
                    this.lab.setBackground(yel);
                } else if (vColIndex == 16 && rowIndex == 3) {
                    this.lab.setBackground(cya);
                } else if (vColIndex == 11 && rowIndex == 5) {
                    this.lab.setBackground(cya);
                } else if (vColIndex > 13 && rowIndex == 1) {
                    this.lab.setBackground(yel);
                } else if (vColIndex > 15 && rowIndex == 2) {
                    this.lab.setBackground(yel);
                } else {
                    this.lab.setBackground(gre);
                }
                if (value == null) {
                    this.lab.setBackground(Color.white);
                }
                this.lab.setOpaque(true);
                return this.lab;
            }
        };
        for (int i = 0; i < tab.getColumnCount(); ++i) {
            tab.getColumnModel().getColumn(i).setPreferredWidth(45);
            tab.getColumnModel().getColumn(i).setCellRenderer(rend);
        }
        tab.setGridColor(new Color(214, 217, 179));
        tab.setRowSelectionAllowed(false);
        tab.setSelectionMode(0);
        return tab;
    }

    private void popupPeriodicTable() {
        if (this.pdia == null) {
            Object s = null;
            final JTable tab = ElementEditorPanel.getPeriodicTable();
            HeaderLabel l = new HeaderLabel();
            l.setBack(Color.white);
            l.setFore(Color.black);
            l.setText("Click an element to add to the material editor.");
            this.pdia = new JDialog(this.dialog);
            this.pdia.getContentPane().add((Component)tab, "Center");
            this.pdia.getContentPane().add((Component)l, "South");
            this.pdia.setTitle("Periodic table memo");
            tab.addMouseListener(new MouseAdapter(){
                Object last;
                int atoms = 1;

                public void mousePressed(MouseEvent e) {
                    int col;
                    Point p = e.getPoint();
                    int row = tab.rowAtPoint(p);
                    Object o = tab.getValueAt(row, col = tab.columnAtPoint(p));
                    if (o == null) {
                        return;
                    }
                    if (ElementEditorPanel.this.compound) {
                        StyledDocument doc = ElementEditorPanel.this.compoundPane.getStyledDocument();
                        if (o != this.last) {
                            this.atoms = 1;
                            Element elem = (Element)o;
                            String el = elem.getAbbreviation();
                            this.last = elem;
                            try {
                                doc.insertString(doc.getLength(), el, ElementEditorPanel.this.nor);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            try {
                                if (this.atoms > 1) {
                                    doc.remove(doc.getLength() - 1, 1);
                                }
                                doc.insertString(doc.getLength(), "" + (this.atoms + 1), ElementEditorPanel.this.sub);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            ++this.atoms;
                        }
                        ElementEditorPanel.this.parseCompound(ElementEditorPanel.this.compoundPane.getText(), doc);
                    } else {
                        Element elem = (Element)o;
                        int n = ElementEditorPanel.this.elementTable.getRowCount();
                        ElementEditorPanel.this.addElement();
                        ElementEditorPanel.this.setZ(n, elem.getZ());
                        ElementEditorPanel.this.setA(n, Math.round(elem.getA()));
                        ElementEditorPanel.this.setFraction(n, 1.0f);
                        ElementEditorPanel.this.elementTable.repaint();
                    }
                }
            });
        }
        this.pdia.setLocation(this.dialog.getLocation().x, this.dialog.getLocation().y + this.dialog.getHeight());
        this.pdia.pack();
        this.pdia.setVisible(true);
    }

    private void popupHelp(String msg, Color back, Color fore, int timeOutSeconds) {
        if (this.dia == null) {
            this.dia = new JDialog(this.dialog);
            this.help = new JLabel("msg");
            this.help.setToolTipText("D");
            this.tempTip = this.help.createToolTip();
            this.help.setBorder(new LineBorder(this.help.getForeground()));
            this.help.setOpaque(true);
            this.dia.setUndecorated(true);
            this.dia.getContentPane().add(this.help);
            this.dia.pack();
        } else if (this.dia.isVisible()) {
            return;
        }
        if (back != null) {
            this.help.setBackground(back);
        } else {
            this.help.setBackground(this.tempTip.getBackground());
        }
        if (fore != null) {
            this.help.setForeground(fore);
        } else {
            this.help.setForeground(this.tempTip.getForeground());
        }
        this.help.setText(msg);
        Point pt = this.compoundPane.getLocation();
        SwingUtilities.convertPointToScreen(pt, this.compoundPane);
        this.dia.pack();
        this.dia.setLocation(pt.x - this.dia.getWidth(), pt.y - this.dia.getHeight() - 5);
        this.dia.setVisible(true);
        final int s = timeOutSeconds;
        this.compoundPane.grabFocus();
        if (timeOutSeconds > 0) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(s * 1000);
                        if (ElementEditorPanel.this.dia != null) {
                            ElementEditorPanel.this.dia.dispose();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            t.start();
        }
    }

    private void compoundPaneKeyReleased(KeyEvent evt) {
        try {
            if (this.dia != null) {
                this.dia.dispose();
            }
            StyledDocument doc = this.compoundPane.getStyledDocument();
            char ch = evt.getKeyChar();
            int cursor = this.compoundPane.getCaret().getDot();
            Point p = this.compoundPane.getCaret().getMagicCaretPosition();
            if (Character.isDigit(ch)) {
                if (!this.superScript) {
                    doc.setCharacterAttributes(cursor - 1, 1, this.sub, true);
                } else {
                    doc.setCharacterAttributes(cursor - 1, 1, this.sup, true);
                }
                this.keyStrokes = 0;
                this.popupHelp(" Use up/down arrows to super/subscript ");
                this.compoundPane.repaint();
            } else if (Character.isLetter(ch)) {
                if (cursor != 1) {
                    String s = doc.getText(cursor - 2, 1);
                    Element e = this.getElement(s = s + ch, true);
                    if (e == null) {
                        this.keyStrokes = 0;
                    }
                }
                if (this.keyStrokes == 0) {
                    doc.remove(cursor - 1, 1);
                    ch = Character.toUpperCase(ch);
                    doc.insertString(cursor - 1, "" + ch, this.nor);
                }
                doc.setCharacterAttributes(cursor - 1, 1, this.nor, true);
                this.superScript = false;
                ++this.keyStrokes;
                if (this.dia != null) {
                    this.dia.dispose();
                }
                this.compoundPane.repaint();
            } else if (evt.getKeyCode() == 40) {
                String text;
                if (doc.getLength() < 1) {
                    return;
                }
                if (cursor == 0) {
                    cursor = 1;
                }
                if (!Character.isDigit((text = doc.getText(cursor - 1, 1)).charAt(0))) {
                    return;
                }
                doc.setCharacterAttributes(cursor - 1, 1, this.sub, true);
                if (this.dia != null) {
                    this.dia.dispose();
                }
            } else if (evt.getKeyCode() == 38) {
                String text;
                if (doc.getLength() < 1) {
                    return;
                }
                if (cursor == 0) {
                    cursor = 1;
                }
                if (!Character.isDigit((text = doc.getText(cursor - 1, 1)).charAt(0))) {
                    return;
                }
                doc.setCharacterAttributes(cursor - 1, 1, this.sup, true);
                this.superScript = true;
                if (this.dia != null) {
                    this.dia.dispose();
                }
            } else if (evt.getKeyCode() == 10) {
                doc.remove(cursor - 1, 1);
            } else {
                this.superScript = false;
                if (this.dia != null) {
                    this.dia.dispose();
                }
            }
            if (doc.getLength() > 0) {
                this.parseCompound(doc.getText(0, doc.getLength()), doc);
            } else {
                this.keyStrokes = 0;
                this.elementsLabel.setText("");
                this.zl.clear();
                this.fl.clear();
                this.al.clear();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void parseCompound(String s, StyledDocument d) {
        this.ambiguous = false;
        this.list.clear();
        this.atomsList.clear();
        this.phase = Character.isDigit(s.charAt(0)) ? 3 : 1;
        boolean letters = false;
        int caps = 0;
        this.sb.delete(0, this.sb.length());
        this.sbAtoms.delete(0, this.sbAtoms.length());
        for (int i = 0; i < s.length(); ++i) {
            AttributeSet style;
            char ch = s.charAt(i);
            if (this.phase == 1) {
                if (Character.isLetter(ch)) {
                    if (Character.isUpperCase(ch)) {
                        caps = caps == 0 ? ++caps : 1;
                    } else if (caps == 1) {
                        caps = 0;
                    } else {
                        this.ambiguous = true;
                        this.popupHelp(" You should write element symbols correctly with capital letters. E.g. Fe instead of fe for iron.");
                        caps = 0;
                    }
                    this.sb.append(ch);
                    continue;
                }
                this.sbAtoms.append(ch);
                if (this.sb.length() > 0) {
                    this.list.add(this.sb.toString());
                    this.sb.delete(0, this.sb.length());
                }
                if (StyleConstants.isSubscript(style = d.getCharacterElement(i).getAttributes())) {
                    this.phase = 2;
                    continue;
                }
                this.phase = 3;
                continue;
            }
            if (this.phase == 2) {
                caps = 0;
                if (Character.isDigit(ch)) {
                    style = d.getCharacterElement(i).getAttributes();
                    if (StyleConstants.isSuperscript(style)) {
                        this.list.add(this.sbAtoms.toString());
                        this.sbAtoms.delete(0, this.sbAtoms.length());
                        this.sbAtoms.append(ch);
                        this.phase = 3;
                        continue;
                    }
                    this.sbAtoms.append(ch);
                    continue;
                }
                this.list.add(this.sbAtoms.toString());
                this.sbAtoms.delete(0, this.sbAtoms.length());
                if (Character.isUpperCase(ch)) {
                    ++caps;
                } else {
                    this.ambiguous = true;
                    this.popupHelp(" You should write element symbols correctly with capital letters. E.g. Fe instead of fe for iron.");
                }
                this.phase = 1;
                this.sb.append(ch);
                continue;
            }
            if (this.phase != 3) continue;
            caps = 0;
            if (Character.isDigit(ch)) {
                style = d.getCharacterElement(i).getAttributes();
                if (StyleConstants.isSubscript(style)) {
                    this.list.add(this.sbAtoms.toString() + "A");
                    this.sbAtoms.delete(0, this.sbAtoms.length());
                    this.sbAtoms.append(ch);
                    this.phase = 2;
                    continue;
                }
                this.sbAtoms.append(ch);
                continue;
            }
            this.list.add(this.sbAtoms.toString() + "A");
            this.sbAtoms.delete(0, this.sbAtoms.length());
            if (Character.isUpperCase(ch)) {
                ++caps;
            } else {
                this.ambiguous = true;
                this.popupHelp(" You should write element symbols correctly with capital letters. E.g. Fe instead of fe for iron.");
            }
            this.phase = 1;
            this.sb.append(ch);
        }
        if (this.sb.length() > 0) {
            this.list.add(this.sb.toString());
        }
        if (this.sbAtoms.length() > 0) {
            this.atomsList.add(new Integer(this.list.size() - 1));
            this.list.add(this.sbAtoms.toString());
        }
        Iterator iter = this.list.iterator();
        int ind = 0;
        boolean cur = false;
        List l = this.getElements(this.list);
        iter = l.iterator();
        String str = "";
        cur = false;
        ind = 0;
        this.zl.clear();
        this.fl.clear();
        this.al.clear();
        Float pending = null;
        String pendingIso = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) continue;
            if (o instanceof Element) {
                if (ind != 0) {
                    str = str + ", ";
                }
                Element e = (Element)o;
                if (pending != null) {
                    this.fl.add(pending);
                }
                this.zl.add(new Integer(e.getZ()));
                if (pendingIso == null) {
                    this.al.add(new Integer(Math.round(e.getA())));
                } else {
                    this.al.add(new Integer(pendingIso));
                }
                pending = new Float(1.0f);
                if (pendingIso != null) {
                    str = str + pendingIso;
                }
                pendingIso = null;
                str = str + e.getName();
                ++ind;
                continue;
            }
            if (o instanceof Integer) {
                str = str + " * " + o.toString();
                pending = new Float(o.toString());
                continue;
            }
            String numOrIso = (String)o;
            pendingIso = numOrIso.substring(0, numOrIso.length() - 1);
        }
        this.fl.add(pending);
        this.elementsLabel.setText(str);
    }

    private List getElements(List parsed) {
        this.typedElems.clear();
        this.unknownSymbols.clear();
        List elements = Main.getElements();
        Iterator iter = parsed.iterator();
        int ind = 0;
        boolean cur = false;
        boolean symbolHandled = false;
        while (iter.hasNext()) {
            String symbol = (String)iter.next();
            int symLen = symbol.length();
            Element e = null;
            if (Character.isLetter(symbol.charAt(0))) {
                Element e2;
                if (symLen == 1) {
                    e = this.getElement(symbol, false);
                    if (e != null) {
                        this.typedElems.add(e);
                    } else {
                        this.unknownSymbols.add(symbol);
                    }
                } else if (symLen == 2 && !this.ambiguous) {
                    if (Character.isUpperCase(symbol.charAt(1))) {
                        String s1 = symbol.substring(0, 1);
                        String s2 = symbol.substring(1, 2);
                        Element e1 = this.getElement(s1, true);
                        Element e22 = this.getElement(s2, true);
                        if (e1 != null) {
                            this.typedElems.add(e1);
                        } else {
                            this.unknownSymbols.add(s1);
                        }
                        if (e22 != null) {
                            this.typedElems.add(e22);
                        } else {
                            this.unknownSymbols.add(s2);
                        }
                    } else {
                        Element e1 = this.getElement(symbol, true);
                        if (e1 != null) {
                            this.typedElems.add(e1);
                        } else {
                            this.unknownSymbols.add(symbol);
                        }
                    }
                } else if (symLen == 2) {
                    e = this.getElement(symbol, false);
                    if (e != null) {
                        this.typedElems.add(e);
                    } else {
                        boolean added = false;
                        String s1 = symbol.substring(0, 1);
                        String s2 = symbol.substring(1, 2);
                        Element e1 = this.getElement(s1, true);
                        e2 = this.getElement(s2, true);
                        if (e1 != null) {
                            added = true;
                            this.typedElems.add(e1);
                        }
                        if (e2 != null) {
                            added = true;
                            this.typedElems.add(e2);
                        }
                        if (e1 == null && e2 == null) {
                            e1 = this.getElement(s1, false);
                            e2 = this.getElement(s2, false);
                            if (e1 != null) {
                                this.typedElems.add(e1);
                                added = true;
                            }
                            if (e2 != null) {
                                added = true;
                                this.typedElems.add(e2);
                            }
                        }
                        if (!added) {
                            this.unknownSymbols.add(symbol);
                        }
                    }
                } else if (symLen > 2 && !this.ambiguous) {
                    String sym = "";
                    boolean cap = false;
                    for (int i = 0; i < symbol.length() + 1; ++i) {
                        Element el;
                        char ch = 'A';
                        if (i != symbol.length()) {
                            ch = symbol.charAt(i);
                        }
                        if (Character.isUpperCase(ch) && !cap) {
                            sym = sym + ch;
                            cap = true;
                        } else if (Character.isUpperCase(ch) && cap) {
                            el = this.getElement(sym, true);
                            if (el != null) {
                                this.typedElems.add(el);
                            } else {
                                this.unknownSymbols.add(sym);
                            }
                            sym = "" + ch;
                        }
                        if (Character.isUpperCase(ch)) continue;
                        el = this.getElement(sym = sym + ch, true);
                        if (el != null) {
                            this.typedElems.add(el);
                        } else {
                            this.unknownSymbols.add(sym);
                        }
                        cap = false;
                        sym = "";
                    }
                } else if (symLen > 2 && this.ambiguous) {
                    String[] strs = this.permutations(symbol);
                    boolean added = false;
                    for (int i = 0; i < strs.length; ++i) {
                        Element el = this.getElement(strs[i], true);
                        if (el != null) {
                            added = true;
                            this.typedElems.add(el);
                            if (i == strs.length - 1 || strs[i].length() != 2) continue;
                            i += 3;
                            continue;
                        }
                        e2 = this.getElement(strs[i], false);
                        if (e2 == null) continue;
                        added = true;
                        this.typedElems.add(e2);
                        if (i == strs.length - 1 || strs[i].length() != 2) continue;
                        i += 3;
                    }
                    if (!added) {
                        this.unknownSymbols.add(symbol);
                    }
                }
            } else if (symbol.charAt(symLen - 1) != 'A') {
                this.typedElems.add(new Integer(symbol));
            } else {
                this.typedElems.add(symbol);
            }
            ++ind;
        }
        return this.typedElems;
    }

    private String[] permutations(String symbol) {
        String[] ret = new String[2 * symbol.length()];
        int ind = 0;
        for (int i = 0; i < symbol.length(); ++i) {
            if (i != symbol.length() - 1) {
                ret[ind++] = symbol.substring(i, i + 2);
            }
            ret[ind++] = symbol.substring(i, i + 1);
        }
        return ret;
    }

    Element getElement(String symbol, boolean matchCase) {
        if (this.elements == null) {
            this.elements = Main.getElements();
        }
        boolean found = false;
        for (int i = 0; i < this.elements.size() && !found; ++i) {
            Element e = (Element)this.elements.get(i);
            if (!(matchCase ? Element.determineAbbreviation(e.getZ()).equals(symbol) : Element.determineAbbreviation(e.getZ()).equalsIgnoreCase(symbol))) continue;
            return e;
        }
        return null;
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        if (this.elementTable.getRowCount() == 1) {
            return;
        }
        if (this.elementTable.getRowCount() == 1) {
            DefaultTableModel m = (DefaultTableModel)this.elementTable.getModel();
            m.removeRow(0);
            return;
        }
        int row = this.elementTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        DefaultTableModel m = (DefaultTableModel)this.elementTable.getModel();
        m.removeRow(row);
        this.elementTable.setPreferredSize(new Dimension(this.elementTable.getWidth(), this.elementTable.getHeight() - this.elementTable.getRowHeight()));
        this.elementTable.repaint();
    }

    private void elementsComboboxActionPerformed(ActionEvent evt) {
        Element e = (Element)this.elementsCombobox.getSelectedItem();
        this.elementPropertiesTable.setValueAt("Atomic number", 1, 0);
        this.elementPropertiesTable.setValueAt(e.getZ(), 1, 1);
        this.elementPropertiesTable.setValueAt("Chemical symbol", 0, 0);
        this.elementPropertiesTable.setValueAt(Element.determineAbbreviation(e.getZ()), 0, 1);
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        this.addElement();
        Element e = (Element)this.elementsCombobox.getSelectedItem();
        int nelems = this.elementTable.getRowCount();
        this.setZ(nelems - 1, e.getZ());
        this.setA(nelems - 1, Math.round(e.getA()));
        this.setFraction(nelems - 1, 1.0f);
    }

    private void removePresetButtonActionPerformed(ActionEvent evt) {
        String preset = (String)this.presetsBox.getSelectedItem();
        ArrayList<Object> list = new ArrayList<Object>();
        boolean inRem = false;
        for (int i = 0; i < presets.length; ++i) {
            if (presets[i] instanceof String) {
                String p = (String)presets[i];
                inRem = p.equals(preset);
            }
            if (inRem) continue;
            list.add(presets[i]);
        }
        presets = list.toArray(new Object[list.size()]);
        ElementEditorPanel.savePresets();
        this.begin = false;
        this.index = -1;
        this.loadPresetsBox();
        this.begin = true;
    }

    private void presetsBoxActionPerformed(ActionEvent evt) {
        if (this.loading) {
            return;
        }
        this.compoundPane.setText("");
        this.setPreset();
        if (this.checkIsCompound()) {
            this.compound = true;
            this.compoundPane.setText("");
            this.setPreset();
            this.compound = true;
            this.jRadioButton1.setSelected(true);
            this.jRadioButton1ActionPerformed(null);
            this.parseCompound(this.compoundPane.getText(), this.compoundPane.getStyledDocument());
        } else {
            this.fixFractions();
            this.compound = false;
            this.jRadioButton2.setSelected(true);
            this.jRadioButton2ActionPerformed(null);
        }
    }

    private void setPreset() {
        String name = (String)this.presetsBox.getSelectedItem();
        this.index = this.presetsBox.getSelectedIndex();
        Parameter z = null;
        Parameter a = null;
        Parameter f = null;
        Parameter dens = null;
        Object t = null;
        Object tf = null;
        for (int i = 0; i < presets.length && z == null; ++i) {
            String pres;
            if (!(presets[i] instanceof String) || !(pres = (String)presets[i]).equals(name)) continue;
            int elem = 0;
            int ind = i + 1;
            if ((dens = (Parameter)presets[ind++]).getValue() != null) {
                this.density = dens.getFloatValue().floatValue();
            } else {
                dens.setValue(new Float(0.0f));
            }
            this.setDensity(dens);
            Integer numElems = (Integer)presets[ind++];
            this.setNumElements(numElems);
            int j = 0;
            while (ind < presets.length && !(presets[ind] instanceof String)) {
                z = (Parameter)presets[ind++];
                a = (Parameter)presets[ind++];
                f = (Parameter)presets[ind++];
                this.setZ(elem, (Integer)z.getValue());
                this.setA(elem, (Integer)a.getValue());
                this.setFraction(elem, ((Float)f.getValue()).floatValue());
                ++elem;
                ++j;
            }
        }
    }

    private void toPresets(String name) {
        if (!this.compound) {
            int numElems = this.elementTable.getRowCount() * 3;
            int ind = presets.length;
            Object[] newPres = new Object[ind + numElems + 2 + 1];
            System.arraycopy(presets, 0, newPres, 0, presets.length);
            Parameter pd = new Parameter();
            pd.setValue(new Float(this.density));
            newPres[ind++] = name;
            newPres[ind++] = pd;
            int row = this.elementTable.getRowCount();
            newPres[ind++] = new Integer(row);
            for (int i = 0; i < row; ++i) {
                newPres[ind++] = this.elementTable.getValueAt(i, 1);
                newPres[ind++] = this.elementTable.getValueAt(i, 2);
                newPres[ind++] = this.elementTable.getValueAt(i, 3);
            }
            presets = newPres;
        } else {
            int numElems = this.zl.size() * 3;
            int ind = presets.length;
            Object[] newPres = new Object[ind + numElems + 2 + 1];
            System.arraycopy(presets, 0, newPres, 0, presets.length);
            Parameter pd = new Parameter();
            pd.setValue(new Float(this.density));
            newPres[ind++] = name;
            newPres[ind++] = pd;
            int row = this.zl.size();
            newPres[ind++] = new Integer(row);
            for (int i = 0; i < row; ++i) {
                Integer in = (Integer)this.zl.get(i);
                Parameter p = new Parameter();
                p.setValue(in);
                newPres[ind++] = p;
                in = (Integer)this.al.get(i);
                p = new Parameter();
                p.setValue(in);
                newPres[ind++] = p;
                Float f = (Float)this.fl.get(i);
                p = new Parameter();
                p.setValue(f);
                newPres[ind++] = p;
            }
            presets = newPres;
        }
    }

    private void toPresetsBtnActionPerformed(ActionEvent evt) {
        this.sdialog = new JDialog(JOptionPane.getFrameForComponent(this), true);
        JPanel panel = new JPanel();
        JLabel label = new JLabel("Preset name:");
        this.pname = new JTextField(14);
        this.pdens = new JTextField(6);
        JLabel dlab = new JLabel(" Density:");
        JLabel dulab = new JLabel(" g/cm3");
        FlowLayout flow = new FlowLayout(0, 0, 0);
        panel.setLayout(flow);
        panel.add(label);
        panel.add(this.pname);
        panel.add(dlab);
        panel.add(this.pdens);
        panel.add(dulab);
        this.sdialog.setUndecorated(true);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new FlowLayout(0, 3, 0));
        HeaderLabel title = new HeaderLabel(" Save as preset");
        titlePanel.setBackground(new Color(153, 153, 153));
        title.setForeground(new Color(255, 255, 255));
        titlePanel.add(title);
        JPanel bpanel = new JPanel();
        bpanel.setLayout(new FlowLayout(2, 0, 0));
        JButton okbtn = new JButton("Ok");
        JButton cancelbtn = new JButton("Cancel");
        bpanel.add(okbtn);
        bpanel.add(cancelbtn);
        okbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ElementEditorPanel.this.sdialog.dispose();
                ElementEditorPanel.this.presStatus = 1;
                ElementEditorPanel.this.presetName = ElementEditorPanel.this.pname.getText();
                ElementEditorPanel.this.density = Float.parseFloat(ElementEditorPanel.this.pdens.getText());
            }
        });
        cancelbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ElementEditorPanel.this.sdialog.dispose();
                ElementEditorPanel.this.presStatus = 2;
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)panel, "Center");
        mainPanel.add((Component)title, "North");
        mainPanel.add((Component)bpanel, "South");
        mainPanel.setBorder(new SoftBevelBorder(0));
        this.sdialog.getContentPane().add((Component)mainPanel, "Center");
        this.sdialog.pack();
        Component c = (Component)evt.getSource();
        Point p = c.getLocation();
        this.sdialog.setLocation(this.getLocationOnScreen().x, this.getLocationOnScreen().y);
        this.sdialog.show();
        if (this.presStatus == 1) {
            this.toPresets(this.presetName);
            ElementEditorPanel.savePresets();
            this.presetsBox.addItem(this.presetName);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.dialog.dispose();
        this.pdia.dispose();
        this.status = 2;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.unknownSymbols.size() > 0) {
            String error = "";
            Iterator itera = this.unknownSymbols.iterator();
            while (itera.hasNext()) {
                String sym = (String)itera.next();
                error = error + sym;
                if (!itera.hasNext()) continue;
                error = error + ",";
            }
            this.popupHelp(" Contains unknown symbols: " + error + " ", Color.red, Color.white, -1);
        } else if (this.compound && this.zl.size() == 0) {
            if (this.dia != null) {
                this.dia.dispose();
            }
            this.popupHelp(" Must specify at least one element ", Color.red, Color.white, -1);
        } else {
            this.pdia.dispose();
            this.dialog.dispose();
            this.status = 1;
        }
    }

    private void plotWithDensityActionPerformed(ActionEvent evt) {
        String sDens = this.plotDensityField.getText();
        try {
            double d = Double.parseDouble(sDens);
            this.densityDialog.dispose();
            this.plotStopping(d);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void cancelPlotActionPerformed(ActionEvent evt) {
        this.densityDialog.dispose();
    }
}

