/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.CustomCellRenderer;
import core.Element;
import core.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ElementRenderer
extends CustomCellRenderer {
    SimpleAttributeSet sub = new SimpleAttributeSet();
    SimpleAttributeSet sup = new SimpleAttributeSet();
    SimpleAttributeSet nor = new SimpleAttributeSet();
    SimpleAttributeSet nor2 = new SimpleAttributeSet();
    JTextPane pane;
    JLabel lab = new JLabel();
    Color background;
    Color disabledColor;
    static JLabel disabled;

    public ElementRenderer() {
        if (disabled == null) {
            disabled = new JLabel();
            disabled.setEnabled(false);
        }
        this.background = new Color(246, 246, 235);
        this.disabledColor = this.lab.getBackground();
        this.lab.setBackground(this.background);
        this.lab.setText("< add element >");
        this.pane = new JTextPane();
        this.pane.setBackground(Color.white);
        this.pane.setOpaque(true);
        this.pane.setMargin(new Insets(0, 3, 1, 3));
        StyleConstants.setSuperscript(this.sup, true);
        StyleConstants.setSubscript(this.sub, true);
    }

    public void updateUI() {
        if (disabled == null || this.lab == null) {
            return;
        }
        disabled.updateUI();
        this.background = new Color(246, 246, 235);
        this.disabledColor = this.lab.getBackground();
        this.pane.updateUI();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        Vector par;
        block12: {
            this.lab.setEnabled(table.isEnabled());
            this.lab.setOpaque(!table.isEnabled());
            par = null;
            try {
                if (value != null && !(value instanceof String)) {
                    par = (Vector)value;
                    Element elem = (Element)par.get(0);
                    Parameter frac = (Parameter)par.get(1);
                    StyledDocument doc = this.pane.getStyledDocument();
                    doc.remove(0, doc.getLength());
                    float f = ((Float)frac.getValue()).floatValue();
                    Integer Z = elem.getZ();
                    if (Z > 0) {
                        boolean compound;
                        boolean bl = compound = f - (float)((int)f) == 0.0f;
                        if (elem.isIsotope()) {
                            doc.insertString(doc.getLength(), "" + (int)elem.getA(), this.sup);
                        }
                        doc.insertString(doc.getLength(), Element.determineAbbreviation(Z), this.nor);
                        if (!compound) {
                            float proc = f;
                            float total = 0.0f;
                            for (int i = 0; i < table.getRowCount(); ++i) {
                                Vector v = (Vector)table.getValueAt(i, 0);
                                Element e = (Element)v.get(0);
                                Parameter fr = (Parameter)v.get(1);
                                proc = f * elem.getA() / (total += fr.getFloatValue().floatValue() * e.getA());
                            }
                            doc.insertString(doc.getLength(), " (" + (int)(proc * 100.0f) + "%)", this.nor2);
                        } else {
                            if (f != 1.0f) {
                                doc.insertString(doc.getLength(), "" + (int)f, this.sub);
                            }
                            doc.insertString(doc.getLength(), "   (" + elem.getName() + ")", this.nor);
                        }
                        this.pane.setEnabled(table.isEnabled());
                        if (!table.isEnabled()) {
                            this.pane.setBackground(disabled.getBackground());
                            this.pane.setForeground(disabled.getBackground().darker());
                            table.setBackground(disabled.getBackground());
                            this.pane.setOpaque(true);
                        } else {
                            table.setBackground(Color.white);
                            this.pane.setBackground(Color.white);
                            this.pane.setForeground(Color.black);
                            this.pane.setOpaque(false);
                        }
                        break block12;
                    }
                    this.lab.setText(Element.determineAbbreviation(elem.getZ()) + " (" + (int)(f * 100.0f) + "%)");
                    this.lab.setBackground(Color.white);
                    this.lab.setOpaque(true);
                    return this.lab;
                }
                this.lab.setText("null");
                this.lab.setBackground(Color.white);
                return this.lab;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (par != null) {
            return this.pane;
        }
        return this.lab;
    }
}

