/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.BasicRenderer;
import UI.CustomCellRenderer;
import core.Main;
import core.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.TableCellRenderer;

public class ParameterRenderer
extends CustomCellRenderer
implements TableCellRenderer {
    JLabel lab;
    static JTextField field;
    JLabel label;
    static Parameter curVar;
    Color background;
    boolean uselabel = false;
    Border border = new SoftBevelBorder(1);
    static boolean variationMode;
    static JDialog diag;
    static float varAmount;
    static JLabel amntLabel;
    JButton plus = new JButton();
    JButton minus = new JButton();
    static JTextField amntField;
    static boolean dialogEnabled;
    static boolean dialogShowing;
    static JToggleButton abs;
    static JToggleButton perc;
    static boolean percVar;
    static JLabel labe2;
    static JTable tabl;
    boolean paintDiag = false;

    public ParameterRenderer() {
        this.plus.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/PlusSmall.png")));
        this.minus.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/MinusSmall.png")));
        this.plus.setPreferredSize(new Dimension(15, 15));
        this.minus.setPreferredSize(new Dimension(15, 15));
        this.lab = new JLabel();
        this.lab.setOpaque(false);
        this.label = new JLabel();
        if (field == null) {
            field = new JTextField();
        }
        this.label.setFont(field.getFont());
        this.label.setBorder(this.border);
        this.background = BasicRenderer.background;
        this.label.setBackground(this.background);
        this.lab.setBackground(this.background);
        this.label.setHorizontalAlignment(0);
        if (diag == null) {
            diag = new JDialog(Main.mainFrame);
            diag.setUndecorated(true);
            amntLabel.setBackground(Color.white);
            amntLabel.setOpaque(true);
            amntLabel.setText(" variate by \u00b1");
            JPanel pan = new JPanel();
            amntField.setText("" + varAmount);
            pan.setBorder(new LineBorder(Color.black, 1));
            pan.setLayout(new FlowLayout(0, 1, 1));
            labe2 = new JLabel();
            labe2.setBackground(Color.white);
            labe2.setText("%");
            labe2.setOpaque(true);
            diag.getContentPane().setLayout(new FlowLayout(0, 0, 0));
            pan.add(amntLabel);
            pan.add(amntField);
            Font f = new Font("Dialog", 0, 10);
            amntField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    String t = amntField.getText();
                    diag.pack();
                    try {
                        float f = Float.parseFloat(t);
                        ParameterRenderer.setVariationAmount(f, perc.isSelected());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            pan.add(labe2);
            abs.setFont(f);
            perc.setFont(f);
            pan.add(perc);
            pan.add(abs);
            perc.setSelected(true);
            perc.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    percVar = true;
                    labe2.setText("%");
                    perc.setSelected(true);
                    abs.setSelected(false);
                    diag.pack();
                }
            });
            abs.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    percVar = false;
                    if (curVar != null) {
                        labe2.setText(curVar.getUnit());
                    }
                    perc.setSelected(false);
                    abs.setSelected(true);
                    diag.pack();
                }
            });
            diag.getContentPane().add(pan);
            diag.getContentPane().setBackground(Color.black);
            diag.addWindowListener(new WindowAdapter(){

                public void windowDeactivated(WindowEvent evt) {
                    diag.dispose();
                    dialogShowing = false;
                }
            });
            diag.pack();
        }
    }

    public static void setVariationMode(boolean enabled) {
        variationMode = enabled;
    }

    public static void setVariationAmount(float amnt, boolean isPercentage) {
        if (isPercentage) {
            perc.setSelected(true);
            abs.setSelected(false);
        } else {
            abs.setSelected(true);
            perc.setSelected(false);
            if (curVar != null) {
                labe2.setText(curVar.getUnit());
            }
        }
        varAmount = amnt;
    }

    public void updateUI() {
        if (this.label == null) {
            return;
        }
        field.updateUI();
        this.lab.updateUI();
        this.label.updateUI();
    }

    public static void enableVariationDialog(boolean enable) {
    }

    public static void showVariationDialog() {
        if (curVar != null) {
            labe2.setText(curVar.getUnit());
        }
        if (!diag.isVisible()) {
            diag.setVisible(true);
        }
    }

    public static boolean isVariationPercentage() {
        return percVar;
    }

    public static float getVariationAmount() {
        float amnt = 0.0f;
        try {
            amnt = Float.parseFloat(amntField.getText());
        }
        catch (Exception ex) {
            amnt = 50.0f;
            ex.printStackTrace();
        }
        return amnt;
    }

    public ParameterRenderer(boolean alignRight) {
        this();
        if (alignRight) {
            this.label.setHorizontalAlignment(4);
        }
    }

    public ParameterRenderer(int align) {
        this();
        if (align == 1) {
            this.label.setHorizontalAlignment(4);
        } else if (align == 0) {
            this.label.setHorizontalAlignment(0);
        } else {
            this.label.setHorizontalAlignment(2);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        Parameter par = (Parameter)value;
        if (rowIndex == 0) {
            this.paintDiag = false;
        }
        boolean locked = false;
        this.label.setForeground(Color.black);
        if (par != null) {
            if (par.getDescription() != null) {
                this.label.setToolTipText(par.getDescription());
            }
            if (!isSelected && variationMode) {
                this.label.setToolTipText(null);
            }
            this.label.setText(par.getValue().toString());
            this.label.setFocusable(true);
            if (isSelected && variationMode) {
                tabl = table;
                Rectangle r = table.getCellRect(rowIndex, vColIndex, false);
                Point p = table.getLocationOnScreen();
                diag.setLocation(p.x - 145 + r.x, p.y - 22 + r.y);
                this.paintDiag = true;
                curVar = par;
                if (!dialogShowing) {
                    dialogShowing = true;
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (tabl.hasFocus()) {
                                ParameterRenderer.showVariationDialog();
                            } else {
                                diag.dispose();
                                dialogShowing = false;
                            }
                        }
                    });
                    t.start();
                }
            }
            this.label.setBackground(Color.white);
            if (isSelected) {
                this.label.setBackground(table.getSelectionBackground());
                this.label.setForeground(table.getSelectionForeground());
            }
        } else {
            this.lab.setText("");
            this.lab.setOpaque(false);
            return this.lab;
        }
        locked = par.isLocked();
        this.label.setEnabled(table.isEnabled() && !locked);
        this.label.setOpaque(table.isCellEditable(rowIndex, vColIndex));
        this.label.setBorder(table.isCellEditable(rowIndex, vColIndex) ? this.border : null);
        if (isSelected && par != null) {
            this.label.setOpaque(true);
            this.label.setBackground(table.getSelectionBackground());
            this.label.setForeground(table.getSelectionForeground());
        }
        return this.label;
    }

    public static JDialog getDialog() {
        return diag;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    static {
        variationMode = false;
        varAmount = 10.0f;
        amntLabel = new JLabel();
        amntField = new JTextField("100");
        dialogEnabled = false;
        dialogShowing = false;
        abs = new JToggleButton("abs");
        perc = new JToggleButton("%");
        percVar = true;
        tabl = null;
    }
}

