/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.HeaderLabel;
import UI.MiniControlWidgets;
import core.Main;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.stuk.visualization.graphs.GraphCanvas;
import org.stuk.visualization.graphs.Points;
import org.stuk.visualization.graphs.XYGraph;
import org.stuk.visualization.polygonal.RenderingPipeline;
import org.stuk.visualization.polygonal.ZShader;
import org.stuk.visualization.polygonal.util.PolyUtils;
import org.stuk.visualization.polygonal.util.Utils3D;

public class SimulationResultsFrame
extends JDialog {
    static int ctr = 1;
    Point init;
    boolean handled = false;
    public static final int INFO_GENERAL = 1;
    public static final int INFO_COINCIDENCES = 2;
    public static final int INFO_ANGULAR_DISTRIBUTION = 3;
    MiniControlWidgets ctrl = new MiniControlWidgets();
    RenderingPipeline rp;
    List renderingBin;
    double[] light = new double[]{1.0, 0.0, 0.0};
    double[] vrp = new double[]{100.0, 0.0, 0.0};
    double[] lp = new double[]{1.0, 0.0, 0.0};
    double[] fp = new double[]{0.0, 0.0, 0.01};
    double scale = 4.0;
    double rot = 0.0;
    Hashtable genInfos = new Hashtable();
    Hashtable coincInfos = new Hashtable();
    Hashtable positions = new Hashtable();
    Hashtable trackings = new Hashtable();
    Hashtable ds = new Hashtable();
    Hashtable zs = new Hashtable();
    float bin;
    float[] val;
    float[] cts;
    float min = 1.0E7f;
    float max = -1.0E7f;
    boolean loading = false;
    private JCheckBox clearCheckbox;
    private JTextArea coincidenceInfo;
    private JTextArea generalInfo;
    private GraphCanvas graphCanvas1;
    private GraphCanvas graphCanvas4;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane4;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextArea jTextArea3;
    private HeaderLabel layersHeader;
    private JButton okButton;
    private JPanel trackPanel;

    public SimulationResultsFrame() {
        super(Main.mainFrame);
        ZShader fs = new ZShader();
        this.renderingBin = new ArrayList();
        this.rp = Utils3D.getRenderingPipeline(2, 300, 300, fs, this.vrp, this.fp, this.lp);
        this.initComponents();
        this.ctrl.setCanvas(this.graphCanvas1);
        this.jPanel3.add(this.ctrl);
        this.setLocation(this.getX() + ctr * 10, this.getY() + ctr * 10);
        this.init = new Point(this.getLocation());
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowLostFocus(WindowEvent e) {
                if (!(SimulationResultsFrame.this.handled || SimulationResultsFrame.this.getLocation().x == SimulationResultsFrame.this.init.x && SimulationResultsFrame.this.getLocation().y == SimulationResultsFrame.this.init.y || ctr <= 1)) {
                    SimulationResultsFrame.this.handled = true;
                    --ctr;
                }
            }

            public void windowGainedFocus(WindowEvent e) {
            }
        });
        ++ctr;
    }

    private float[] hist(float[] arr, int nBins) {
        float[] bins = new float[nBins];
        float max = -1.0E7f;
        float min = 1.0E7f;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > max) {
                max = arr[i];
            }
            if (!(arr[i] < min)) continue;
            min = arr[i];
        }
        float range = max - min;
        this.bin = range / (float)nBins;
        for (int i = 0; i < arr.length; ++i) {
            float fbin = arr[i] / this.bin;
            int index = (int)fbin;
            if (index > bins.length - 1) {
                index = bins.length - 1;
            }
            int n = index;
            bins[n] = bins[n] + 1.0f;
        }
        return bins;
    }

    public String setText(String text, int infoType, String nuclide, boolean addItem) {
        this.loading = true;
        if (addItem) {
            for (int i = 0; i < this.jComboBox1.getItemCount(); ++i) {
                if (!this.jComboBox1.getItemAt(i).equals(nuclide)) continue;
                nuclide = nuclide + "*";
            }
            this.jComboBox1.addItem(nuclide);
            this.jComboBox1.setSelectedIndex(0);
        }
        if (infoType == 1) {
            this.genInfos.put(nuclide, text);
        } else if (infoType == 2) {
            this.coincInfos.put(nuclide, text);
        }
        this.loading = false;
        return nuclide;
    }

    public void setPositions(String nuclide, float[] x, float[] y, float[] z, float[] r) {
        Points xy = new Points();
        xy.setX(x);
        xy.setY(y);
        for (int i = 0; i < x.length; ++i) {
        }
        this.ds.put(nuclide, r);
        this.zs.put(nuclide, z);
        this.graphCanvas1.getAxis().setMinMax(xy.getXmin(), xy.getYmin(), xy.getXmax(), xy.getYmax());
        this.positions.put(nuclide, xy);
    }

    public void setTracking(String nuclide, float[] E, float[] x, float[] y, float[] z) {
        ArrayList<double[]> paths = new ArrayList<double[]>();
        for (int i = 0; i < x.length; ++i) {
            double[] pt1 = new double[]{x[i], y[i], z[i], E[i]};
            if (this.isDegenerate(pt1)) continue;
            paths.add(pt1);
        }
        this.trackings.put(nuclide, paths);
    }

    private boolean isDegenerate(double[] p) {
        for (int i = 0; i < p.length; ++i) {
            if (!Double.isNaN(p[i])) continue;
            p[i] = 0.0;
        }
        return false;
    }

    public void setAngularDistributions() {
    }

    private float span(float[] x) {
        this.min = 1.0E7f;
        this.max = -1.0E7f;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] < this.min) {
                this.min = x[i];
            }
            if (!(x[i] > this.max)) continue;
            this.max = x[i];
        }
        return this.max - this.min;
    }

    public void setNuclide(String text) {
        this.setTitle("Simulation info : " + text);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.generalInfo = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.coincidenceInfo = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea3 = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.graphCanvas1 = new GraphCanvas();
        this.jSplitPane4 = new JSplitPane();
        this.jScrollPane4 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.graphCanvas4 = new GraphCanvas();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.trackPanel = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jPanel6 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel4 = new JPanel();
        this.okButton = new JButton();
        this.clearCheckbox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.layersHeader = new HeaderLabel();
        this.jComboBox1 = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.jTabbedPane1.setPreferredSize(new Dimension(300, 345));
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimulationResultsFrame.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jScrollPane1.setPreferredSize(new Dimension(302, 200));
        this.generalInfo.setLineWrap(true);
        this.jScrollPane1.setViewportView(this.generalInfo);
        this.jTabbedPane1.addTab("General", this.jScrollPane1);
        this.jScrollPane2.setPreferredSize(new Dimension(302, 200));
        this.coincidenceInfo.setLineWrap(true);
        this.jScrollPane2.setViewportView(this.coincidenceInfo);
        this.jTabbedPane1.addTab("Coincidences", this.jScrollPane2);
        this.jScrollPane3.setPreferredSize(new Dimension(302, 200));
        this.jTextArea3.setLineWrap(true);
        this.jScrollPane3.setViewportView(this.jTextArea3);
        this.jTabbedPane1.addTab("Angular distribution", this.jScrollPane3);
        this.jPanel2.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(300);
        this.graphCanvas1.setBackground(new Color(255, 255, 255));
        this.graphCanvas1.setPreferredSize(new Dimension(300, 300));
        this.jSplitPane1.setLeftComponent(this.graphCanvas1);
        this.jSplitPane4.setDividerLocation(200);
        this.jSplitPane4.setOrientation(0);
        this.jScrollPane4.setViewportView(this.jTextArea1);
        this.jSplitPane4.setRightComponent(this.jScrollPane4);
        this.graphCanvas4.setBackground(new Color(255, 255, 255));
        this.jSplitPane4.setLeftComponent(this.graphCanvas4);
        this.jSplitPane1.setRightComponent(this.jSplitPane4);
        this.jPanel2.add((Component)this.jSplitPane1, "Center");
        this.jPanel3.setLayout(new FlowLayout(0, 0, 0));
        this.jPanel3.setPreferredSize(new Dimension(0, 20));
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.jTabbedPane1.addTab("Emitters", this.jPanel2);
        this.jPanel5.setLayout(new BorderLayout());
        this.jSplitPane2.setBackground(new Color(51, 51, 255));
        this.jSplitPane2.setDividerLocation(300);
        this.trackPanel.setBackground(new Color(153, 153, 153));
        this.trackPanel.setPreferredSize(new Dimension(310, 310));
        this.jSplitPane2.setLeftComponent(this.trackPanel);
        this.jTextArea2.setText(null);
        this.jScrollPane5.setViewportView(this.jTextArea2);
        this.jSplitPane2.setRightComponent(this.jScrollPane5);
        this.jPanel5.add((Component)this.jSplitPane2, "Center");
        this.jPanel6.setLayout(new FlowLayout(0, 3, 0));
        this.jPanel6.setPreferredSize(new Dimension(0, 20));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/ZoomSmall.png")));
        this.jLabel1.setText("+");
        this.jLabel1.setToolTipText("Zoom in");
        this.jLabel1.setIconTextGap(1);
        this.jLabel1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                SimulationResultsFrame.this.jLabel1MousePressed(evt);
            }
        });
        this.jPanel6.add(this.jLabel1);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/ZoomSmall.png")));
        this.jLabel2.setText("-");
        this.jLabel2.setToolTipText("Zoom out");
        this.jLabel2.setIconTextGap(1);
        this.jLabel2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                SimulationResultsFrame.this.jLabel2MousePressed(evt);
            }
        });
        this.jPanel6.add(this.jLabel2);
        this.jLabel4.setText("Rot cw");
        this.jLabel4.setToolTipText("Rotate clockwise");
        this.jLabel4.setIconTextGap(1);
        this.jLabel4.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                SimulationResultsFrame.this.jLabel4MousePressed(evt);
            }
        });
        this.jPanel6.add(this.jLabel4);
        this.jLabel5.setText("Rot ccw");
        this.jLabel5.setToolTipText("Rotate counter clockwise");
        this.jLabel5.setIconTextGap(1);
        this.jLabel5.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                SimulationResultsFrame.this.jLabel5MousePressed(evt);
            }
        });
        this.jPanel6.add(this.jLabel5);
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/ShowAllSmall.png")));
        this.jLabel3.setToolTipText("Back to initial view");
        this.jLabel3.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                SimulationResultsFrame.this.jLabel3MousePressed(evt);
            }
        });
        this.jPanel6.add(this.jLabel3);
        this.jPanel5.add((Component)this.jPanel6, "North");
        this.jTabbedPane1.addTab("e- tracking", this.jPanel5);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jPanel4.setLayout(new FlowLayout(1, 1, 1));
        this.okButton.setText("Ok");
        this.okButton.setPreferredSize(new Dimension(205, 23));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulationResultsFrame.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.okButton);
        this.clearCheckbox.setSelected(true);
        this.clearCheckbox.setText("Clear infos prior to a new run");
        this.clearCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulationResultsFrame.this.clearCheckboxActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.clearCheckbox);
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jPanel1.setLayout(new BorderLayout());
        this.layersHeader.setText(" Show simulation info for");
        this.layersHeader.setPreferredSize(new Dimension(217, 15));
        this.jPanel1.add((Component)this.layersHeader, "Center");
        this.jComboBox1.setPreferredSize(new Dimension(200, 19));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulationResultsFrame.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jComboBox1, "South");
        this.getContentPane().add((Component)this.jPanel1, "North");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 589) / 2, (screenSize.height - 428) / 2, 589, 428);
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getSelectedIndex() == 3) {
            String key = (String)this.jComboBox1.getSelectedItem();
            Points pts = (Points)this.positions.get(key);
            StringBuffer buf = new StringBuffer();
            buf.append("!Positions of the alpha emitters\n!The rows represent:\n!x,y,r,z \n!One row per emitter\n!-------------------\n");
            this.jTabbedPane1.setEnabledAt(3, true);
            this.graphCanvas1.getGraphs().clear();
            this.graphCanvas1.addGraph(pts);
            double[] x = pts.getX();
            double[] y = pts.getY();
            float[] z = (float[])this.zs.get(key);
            float[] r = (float[])this.ds.get(key);
            for (int i = 0; i < x.length; ++i) {
                buf.append(x[i]);
                buf.append(',');
                buf.append(' ');
                buf.append(y[i]);
                buf.append(',');
                buf.append(' ');
                buf.append(z[i]);
                buf.append(',');
                buf.append(' ');
                buf.append(r[i]);
                buf.append('\n');
            }
            float[] yr = this.hist(r, 20);
            XYGraph rd = new XYGraph(true);
            float[] xr = new float[yr.length];
            for (int i = 0; i < xr.length; ++i) {
                xr[i] = this.bin * (float)(i + 1);
            }
            rd.setX(xr);
            rd.setY(yr);
            this.graphCanvas4.getGraphs().clear();
            this.graphCanvas4.addGraph(rd);
            this.graphCanvas4.getAxis().setTitle("Depth", 0);
            this.graphCanvas4.getAxis().setTitle("Frequency", 1);
            this.graphCanvas4.setXInset(55);
            this.graphCanvas4.setYInset(55);
            this.graphCanvas4.getAxis().setTitleFont(GraphCanvas.FONT_SERIF12, 1);
            this.graphCanvas4.getAxis().setTitleFont(GraphCanvas.FONT_SERIF12, 0);
            rd.setColor(Color.red);
            rd.setFilled(true);
            this.graphCanvas4.getAxis().setMinMax(0.0, 0.0, rd.getXmax(), rd.getYmax());
            this.graphCanvas4.getAxis().setTics(10);
            this.graphCanvas4.start();
            this.graphCanvas4.refresh();
            this.graphCanvas4.repaint();
            this.jTextArea1.setText(buf.toString());
            this.jTextArea1.setCaretPosition(0);
            pts.setColor(Color.gray);
            this.graphCanvas1.getAxis().setTics(10);
            this.graphCanvas1.start();
            this.graphCanvas1.refresh();
            this.graphCanvas1.repaint();
        } else {
            this.jComboBox1ActionPerformed(null);
        }
    }

    private void drawElectrons() {
        Graphics2D g;
        String key = (String)this.jComboBox1.getSelectedItem();
        Points pts = (Points)this.positions.get(key);
        List paths = (List)this.trackings.get(key);
        this.renderingBin.clear();
        double[] zero = new double[]{0.0, 0.0, 0.0, 1.0};
        double[] lastPt = null;
        if (this.jTabbedPane1.getSelectedIndex() == 4) {
            this.vrp[0] = Math.sin(this.rot) * 100.0;
            this.vrp[1] = Math.cos(this.rot) * 100.0;
            this.rp = Utils3D.getRenderingPipeline(2, this.trackPanel.getWidth(), this.trackPanel.getHeight(), null, this.vrp, this.fp, this.lp);
            System.out.println("Found " + paths.size() + " electron paths");
            Color[] colors = new Color[]{Color.red, Color.green, Color.yellow, Color.orange};
            Iterator iter = paths.iterator();
            double lastE = -1.0;
            ArrayList<Object> poly = new ArrayList<Object>();
            poly.add(zero);
            int limit = 19225;
            for (int ind = 0; iter.hasNext() && ind < limit; ++ind) {
                double[] pt = (double[])iter.next();
                double[] pt2 = new double[]{0.0, 0.0, 0.0, 0.0};
                PolyUtils.set(pt2, pt);
                pt = pt2;
                double E = pt[3];
                if (E > lastE) {
                    System.out.println("New path begins at line " + ind);
                    lastPt = null;
                    if (ind != 0) {
                        this.renderingBin.add(poly);
                    }
                    poly = new ArrayList();
                    poly.add(colors[ind % colors.length]);
                    poly.add(zero);
                    PolyUtils.mul(this.scale, pt, pt);
                    pt[3] = 1.0;
                    poly.add(pt);
                    lastPt = pt;
                    lastE = E;
                    continue;
                }
                PolyUtils.mul(this.scale, pt, pt);
                PolyUtils.plus(pt, lastPt, pt);
                pt[3] = 1.0;
                poly.add(lastPt);
                poly.add(pt);
                lastPt = pt;
                lastE = E;
            }
            this.renderingBin.add(poly);
        }
        if ((g = (Graphics2D)this.trackPanel.getGraphics()) != null) {
            Iterator iter = this.renderingBin.iterator();
            while (iter.hasNext()) {
                ArrayList poly = (ArrayList)iter.next();
                Utils3D.renderAnnotations(poly, g, this.rp);
            }
        }
    }

    private void jLabel5MousePressed(MouseEvent evt) {
        Color c = this.trackPanel.getBackground();
        Graphics2D g = (Graphics2D)this.trackPanel.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, this.trackPanel.getWidth(), this.trackPanel.getHeight());
        this.rot -= 0.1;
        this.drawElectrons();
    }

    private void jLabel4MousePressed(MouseEvent evt) {
        Color c = this.trackPanel.getBackground();
        Graphics2D g = (Graphics2D)this.trackPanel.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, this.trackPanel.getWidth(), this.trackPanel.getHeight());
        this.rot += 0.1;
        this.drawElectrons();
    }

    private void jLabel3MousePressed(MouseEvent evt) {
        Color c = this.trackPanel.getBackground();
        Graphics2D g = (Graphics2D)this.trackPanel.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, this.trackPanel.getWidth(), this.trackPanel.getHeight());
        this.scale = 4.0;
        this.rot = 0.0;
        this.drawElectrons();
    }

    private void jLabel2MousePressed(MouseEvent evt) {
        Color c = this.trackPanel.getBackground();
        Graphics2D g = (Graphics2D)this.trackPanel.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, this.trackPanel.getWidth(), this.trackPanel.getHeight());
        this.scale -= 0.5;
        this.drawElectrons();
    }

    private void jLabel1MousePressed(MouseEvent evt) {
        Color c = this.trackPanel.getBackground();
        Graphics2D g = (Graphics2D)this.trackPanel.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, this.trackPanel.getWidth(), this.trackPanel.getHeight());
        this.scale += 0.5;
        this.drawElectrons();
    }

    public void clear() {
        if (this.clearCheckbox.isSelected()) {
            this.loading = true;
            this.coincInfos.clear();
            this.jComboBox1.removeAllItems();
            this.coincInfos.clear();
            this.genInfos.clear();
            this.generalInfo.setText("");
            this.coincidenceInfo.setText("");
            this.trackings.clear();
            this.positions.clear();
            this.positions.clear();
            this.loading = false;
            this.jTextArea2.setText(null);
        }
    }

    private void clearCheckboxActionPerformed(ActionEvent evt) {
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        Graphics2D g;
        if (this.loading) {
            return;
        }
        String key = (String)this.jComboBox1.getSelectedItem();
        if (key == null) {
            return;
        }
        String text = (String)this.genInfos.get(key);
        if (text == null) {
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.jTabbedPane1.setEnabledAt(0, true);
            this.generalInfo.setText(text);
        }
        text = (String)this.coincInfos.get(key);
        if (text == null) {
            this.jTabbedPane1.setEnabledAt(1, false);
        } else {
            this.jTabbedPane1.setEnabledAt(1, true);
            this.coincidenceInfo.setText(text);
        }
        this.jTabbedPane1.setEnabledAt(2, false);
        Points pts = (Points)this.positions.get(key);
        if (pts == null) {
            this.jTabbedPane1.setEnabledAt(3, false);
        } else {
            this.jTabbedPane1.setEnabledAt(3, true);
        }
        if (this.jTabbedPane1.getSelectedIndex() == 3) {
            StringBuffer buf = new StringBuffer();
            buf.append("!Positions of the alpha emitters\n!The rows represent:\n!x,y,r,z \n!One row per emitter\n!-------------------\n");
            this.jTabbedPane1.setEnabledAt(3, true);
            this.graphCanvas1.getGraphs().clear();
            this.graphCanvas1.addGraph(pts);
            double[] x = pts.getX();
            double[] y = pts.getY();
            float[] z = (float[])this.zs.get(key);
            float[] r = (float[])this.ds.get(key);
            for (int i = 0; i < x.length; ++i) {
                buf.append(x[i]);
                buf.append(',');
                buf.append(' ');
                buf.append(y[i]);
                buf.append(',');
                buf.append(' ');
                buf.append(z[i]);
                buf.append(',');
                buf.append(' ');
                buf.append(r[i]);
                buf.append('\n');
            }
            float[] yr = this.hist(r, 20);
            XYGraph rd = new XYGraph(true);
            float[] xr = new float[yr.length];
            for (int i = 0; i < xr.length; ++i) {
                xr[i] = this.bin * (float)(i + 1);
            }
            rd.setX(xr);
            rd.setY(yr);
            this.graphCanvas4.getGraphs().clear();
            this.graphCanvas4.addGraph(rd);
            this.graphCanvas4.getAxis().setTitle("Depth", 0);
            this.graphCanvas4.getAxis().setTitle("Frequency", 1);
            this.graphCanvas4.setXInset(55);
            this.graphCanvas4.setYInset(55);
            this.graphCanvas4.getAxis().setTitleFont(GraphCanvas.FONT_SERIF12, 1);
            this.graphCanvas4.getAxis().setTitleFont(GraphCanvas.FONT_SERIF12, 0);
            rd.setColor(Color.red);
            rd.setFilled(true);
            this.graphCanvas4.getAxis().setMinMax(0.0, 0.0, rd.getXmax(), rd.getYmax());
            this.graphCanvas4.getAxis().setTics(10);
            this.graphCanvas4.start();
            this.graphCanvas4.refresh();
            this.graphCanvas4.repaint();
            this.jTextArea1.setText(buf.toString());
            this.jTextArea1.setCaretPosition(0);
            pts.setColor(Color.gray);
            this.graphCanvas1.getAxis().setTics(10);
            this.graphCanvas1.start();
            this.graphCanvas1.refresh();
            this.graphCanvas1.repaint();
        }
        List paths = (List)this.trackings.get(key);
        this.renderingBin.clear();
        double[] zero = new double[]{0.0, 0.0, 0.0, 1.0};
        double[] lastPt = null;
        if (paths == null) {
            this.jTabbedPane1.setEnabledAt(4, false);
        } else {
            this.jTabbedPane1.setEnabledAt(4, true);
        }
        if (this.jTabbedPane1.getSelectedIndex() == 4) {
            this.vrp[0] = Math.sin(this.rot) * 100.0;
            this.vrp[1] = Math.cos(this.rot) * 100.0;
            this.rp = Utils3D.getRenderingPipeline(2, this.trackPanel.getWidth(), this.trackPanel.getHeight(), null, this.vrp, this.fp, this.lp);
            System.out.println("Found " + paths.size() + " electron paths");
            int ind = 0;
            Color[] colors = new Color[]{Color.red, Color.green, Color.yellow, Color.orange};
            Iterator iter = paths.iterator();
            double lastE = -1.0;
            ArrayList<Object> poly = new ArrayList<Object>();
            poly.add(zero);
            int limit = 19225;
            StringBuffer buf = new StringBuffer();
            buf.append("!Electron paths in the detector for first few electrons\n!The rows represent:\n!Energy (keV),dx,dy,dz \n!New electron begins when energy increases.\n!-------------------\n");
            for (int i = 0; i < paths.size(); ++i) {
                double[] pnts = (double[])paths.get(i);
                buf.append(pnts[3]);
                buf.append(',');
                buf.append(' ');
                buf.append(pnts[0]);
                buf.append(',');
                buf.append(' ');
                buf.append(pnts[1]);
                buf.append(',');
                buf.append(' ');
                buf.append(pnts[2]);
                buf.append('\n');
            }
            this.jTextArea2.setText(buf.toString());
            this.jTextArea2.setCaretPosition(0);
            while (iter.hasNext() && ind < limit) {
                double[] pt = (double[])iter.next();
                double[] pt2 = new double[]{0.0, 0.0, 0.0, 0.0};
                PolyUtils.set(pt2, pt);
                pt = pt2;
                double E = pt[3];
                if (E > lastE) {
                    System.out.println("New path begins at line " + ind);
                    lastPt = null;
                    if (ind != 0) {
                        this.renderingBin.add(poly);
                    }
                    poly = new ArrayList();
                    poly.add(colors[ind % colors.length]);
                    poly.add(zero);
                    PolyUtils.mul(this.scale, pt, pt);
                    pt[3] = 1.0;
                    poly.add(pt);
                    lastPt = pt;
                    lastE = E;
                } else {
                    PolyUtils.mul(this.scale, pt, pt);
                    PolyUtils.plus(pt, lastPt, pt);
                    pt[3] = 1.0;
                    poly.add(lastPt);
                    poly.add(pt);
                    lastPt = pt;
                    lastE = E;
                }
                ++ind;
            }
            this.renderingBin.add(poly);
        }
        if ((g = (Graphics2D)this.trackPanel.getGraphics()) != null) {
            Iterator iter = this.renderingBin.iterator();
            while (iter.hasNext()) {
                ArrayList poly = (ArrayList)iter.next();
                Utils3D.renderAnnotations(poly, g, this.rp);
            }
        }
        if (!this.jTabbedPane1.isEnabledAt(this.jTabbedPane1.getSelectedIndex())) {
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.jComboBox1.setSelectedIndex(0);
        }
        super.setVisible(visible);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void dispose() {
        super.dispose();
        if (!this.handled && ctr > 1) {
            --ctr;
        }
    }
}

