/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.ElementEditor;
import UI.ImageUtil;
import UI.MainFrame;
import UI.MetalShader;
import UI.ToonShader;
import core.Element;
import core.Main;
import core.Parameter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.stuk.visualization.graphs.Axis;
import org.stuk.visualization.graphs.Graph;
import org.stuk.visualization.graphs.GraphCanvas;
import org.stuk.visualization.graphs.XYGraph;
import org.stuk.visualization.polygonal.FrameBuffer;
import org.stuk.visualization.polygonal.RenderingPipeline;
import org.stuk.visualization.polygonal.ScanConverter;
import org.stuk.visualization.polygonal.Shader;
import org.stuk.visualization.polygonal.util.PolyUtils;

public class SketchPanel
extends JPanel {
    public static final int VIEW_GENERAL = 0;
    public static final int VIEW_SOURCE = 1;
    public static final int VIEW_GEOMETRY = 2;
    public static final int VIEW_PARTICLES = 3;
    public static final int VIEW_BACKINGPLATE = 4;
    public static final int VIEW_DETECTOR = 5;
    public static final int VIEW_LAYERS = 6;
    public static final int VIEW_NONE = 7;
    Thread t;
    Thread cons;
    int w = 300;
    int h = 300;
    int ox = 150;
    int oy = 150;
    RenderingPipeline p;
    RenderingHints hints;
    FrameBuffer fb;
    Shader metal;
    Shader toon;
    int numdatas;
    List bin = new ArrayList();
    List annotations = new ArrayList();
    Font font = new Font("Dialog", 0, 9);
    int currentView = 0;
    double[] vrp = new double[]{40.0, 0.0, 20.0};
    double[] fp = new double[]{0.0, 0.0, 20.0};
    double[] up = new double[]{0.0, 0.0, 1.0};
    double[][] Tv = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    double[][] Tp = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    static double[] light = new double[]{1.0, 0.0, 0.0};
    boolean first = true;
    boolean rendering = false;
    Object lock = new Object();
    ElementEditor ed = new ElementEditor(null, null, "", 1, "");
    private GraphCanvas graphCanvas = new GraphCanvas();
    double[] loct = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] loct2 = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] loct3 = new double[]{0.0, 0.0, 0.0, 0.0};

    public SketchPanel() {
        this.initComponents();
        this.setUpRenderer();
        this.setUpGeneralView();
        this.t = new Thread(new Runnable(){

            public void run() {
                SketchPanel.this.render();
                SketchPanel.this.repaint();
            }
        });
        this.hints = new RenderingHints(null);
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
    }

    public Image getImage() {
        return this.fb.getImage();
    }

    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        this.w = w;
        this.h = h;
        this.ox = w / 2;
        this.oy = h / 2;
        this.fb = new FrameBuffer(w, h);
        ScanConverter sc = new ScanConverter(w, h, this.numdatas);
        this.p.setFrameBuffer(this.fb);
        this.p.setScanConverter(sc);
        this.fb.clear();
        this.render();
        this.repaint();
        this.first = false;
    }

    private void setUpRenderer() {
        this.numdatas = 5;
        this.p = new RenderingPipeline();
        this.fb = new FrameBuffer(this.w, this.h);
        ScanConverter sc = new ScanConverter(this.w, this.h, this.numdatas);
        this.toon = new ToonShader();
        BufferedImage img = ImageUtil.getBufferedImage(this.getClass().getResource("images/EnvMap.png"), (Component)new JLabel());
        this.metal = new MetalShader(img, this.p);
        ArrayList<double[]> lightList = new ArrayList<double[]>();
        lightList.add(light);
        this.p.setLights(lightList);
        this.p.setFrameBuffer(this.fb);
        this.p.setShader(this.toon);
        this.p.setScanConverter(sc);
        this.Tp = PolyUtils.getProjectionTransform(4.0, 1000.0, Math.toRadians(90.0), 1.0);
        this.p.setProjectionTransform(this.Tp);
        PolyUtils.getViewingTransform(this.vrp, this.fp, this.up, this.Tv);
        this.p.setViewingTransform(this.Tv);
    }

    private void setViewInThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                int view = SketchPanel.this.currentView;
                if (view == 0) {
                    SketchPanel.this.setUpGeneralView();
                    SketchPanel.this.setUpGeneralAnnotations();
                } else if (view == 1) {
                    SketchPanel.this.setUpSourceView();
                    SketchPanel.this.setUpSourceAnnotations();
                } else if (view == 3) {
                    SketchPanel.this.setUpParticlesView();
                    SketchPanel.this.setUpParticlesAnnotations();
                } else if (view == 2) {
                    SketchPanel.this.setUpGeneralView();
                    SketchPanel.this.setUpGeometryAnnotations();
                } else if (view == 4) {
                    SketchPanel.this.setUpBackingplateView();
                    SketchPanel.this.setUpBackingplateAnnotations();
                } else if (view == 5) {
                    SketchPanel.this.setUpDetectorView();
                    SketchPanel.this.setUpDetectorAnnotations();
                } else if (view == 6) {
                    SketchPanel.this.setUpGeneralView();
                    SketchPanel.this.setUpLayerAnnotations();
                } else if (view == 7) {
                    SketchPanel.this.bin.clear();
                    SketchPanel.this.annotations.clear();
                }
                SketchPanel.this.render();
                SketchPanel.this.repaint();
                SketchPanel.this.rendering = false;
            }
        });
        t.start();
    }

    public void setView(int view) {
        this.currentView = view;
        this.setViewInThread();
        this.rendering = true;
    }

    public String getName(int layer) {
        String name = "";
        Parameter thickness = MainFrame.getLayerParam("1805", layer);
        Parameter elems = MainFrame.getLayerParam("1510", layer);
        int numElems = (Integer)elems.getValue();
        for (int j = 0; j < numElems; ++j) {
            if (j != 0) {
                name = name + "+";
            }
            Element e = new Element();
            Parameter z = MainFrame.getLayerElementParam("1802", layer, j);
            Parameter a = MainFrame.getLayerElementParam("1803", layer, j);
            Parameter f = MainFrame.getLayerElementParam("1804", layer, j);
            name = name + Element.determineAbbreviation((Integer)z.getValue());
        }
        return name;
    }

    private synchronized void setUpLayerAnnotations() {
        double scale = 10.0;
        double rdet = 11.96 * scale;
        Parameter numlayers = Main.getParameter("1008");
        Parameter sdd = Main.getParameter("1001");
        int num = numlayers.getIntegerValue();
        double dist = (double)sdd.getFloatValue().floatValue() * scale;
        double ystep = dist / (double)(num + 1);
        for (int i = 0; i < num; ++i) {
            List l = MainFrame.getLayerElementParams(i);
            Parameter dens = MainFrame.getLayerParam("1801", i);
            Parameter elems = MainFrame.getLayerParam("1510", i);
            l.add(0, elems);
            l.add(0, dens);
            String s = this.ed.getMixtureName(l);
            if (s == null) {
                s = this.getName(i);
            }
            if (s == null) continue;
            this.annotations.add("(" + (i + 1) + ") " + s);
            double[] loc = new double[]{0.0, -rdet - 10.0, ystep * (double)(i + 1) - 10.0, 1.0};
            if (i % 2 == 1) {
                double[] loc2 = new double[]{0.0, rdet + 120.0, ystep * (double)(i + 1) - 10.0, 1.0};
                loc = loc2;
            }
            this.annotations.add(loc);
            double[] b = new double[]{0.0, -rdet, ystep * (double)(i + 1), 1.0};
            this.annotations.add(b);
            double[] e = new double[]{0.0, rdet, ystep * (double)(i + 1), 1.0};
            this.annotations.add(e);
        }
    }

    private synchronized void setUpGeneralAnnotations() {
        double scale = 10.0;
        double sdd = 44.0 * scale;
        Parameter p = Main.getParameter("1001");
        sdd = (double)p.getFloatValue().floatValue() * scale;
        double rsrc = 6.96 * scale;
        double rdet = 11.96 * scale;
        double[] loc = new double[]{0.0, -rdet * 1.5, sdd + 30.0, 1.0};
        this.annotations.add("Detector");
        this.annotations.add(loc);
        double[] loc2 = new double[]{0.0, -rdet, sdd / 4.0, 1.0};
        this.annotations.add("Source");
        this.annotations.add(loc2);
        double[] loc3 = new double[]{0.0, -rdet, -50.0, 1.0};
        this.annotations.add("Backingplate");
        this.annotations.add(loc3);
        double[] b = new double[]{0.0, 0.0, sdd - 3.0, 1.0};
        double[] e = new double[]{0.0, -rdet * 1.5, sdd + 30.0, 1.0};
        this.annotations.add(b);
        this.annotations.add(e);
        double[] b2 = new double[]{0.0, 0.0, 0.0, 1.0};
        double[] e2 = new double[]{0.0, -rsrc * 1.5, sdd / 4.0, 1.0};
        this.annotations.add(b2);
        this.annotations.add(e2);
    }

    private synchronized void setUpGeometryAnnotations() {
        double scale = 10.0;
        double sdd = 44.0 * scale;
        Parameter p = Main.getParameter("1001");
        sdd = (double)p.getFloatValue().floatValue() * scale;
        double[] loc = new double[]{0.0, -10.0, sdd / 2.0, 1.0};
        this.annotations.add("Sdd");
        this.annotations.add(loc);
        double[] b = new double[]{0.0, 0.0, 0.0, 1.0};
        double[] e = new double[]{0.0, 0.0, sdd, 1.0};
        this.annotations.add(b);
        this.annotations.add(e);
    }

    private synchronized void setUpGeneralView() {
        ArrayList c1 = new ArrayList();
        ArrayList d1 = new ArrayList();
        ArrayList c2 = new ArrayList();
        ArrayList d2 = new ArrayList();
        this.bin.clear();
        this.annotations.clear();
        double amb = 0.3;
        double scale = 10.0;
        double tdet = 14.0 * scale;
        double rdet = 11.96 * scale;
        Parameter detR = Main.getParameter("12");
        double rdet2 = (double)(detR.getFloatValue().floatValue() / 2.0f) * scale;
        Parameter p = Main.getParameter("1001");
        double sdd = (double)p.getFloatValue().floatValue() * scale;
        this.bin.add(this.metal);
        this.createCylinder(0.0, 0.0, rdet, sdd, tdet, 18, this.bin, 0.4 + amb);
        this.bin.add(this.toon);
        this.createCylinder(0.0, 0.0, rdet2 / 2.0, sdd - 3.0, 3.0, 18, this.bin, 0.0);
        double tsrc = 1.0 * scale;
        Parameter r = Main.getParameter("1");
        double rsrc = (double)r.getFloatValue().floatValue() * scale / 2.0;
        this.createCylinder(0.0, 0.0, rsrc /= 2.0, -tsrc + 2.0, 10.0, 18, this.bin, 1.0 + amb);
        this.bin.add(this.metal);
        this.createCylinder(0.0, 0.0, rdet, -tsrc, tsrc, 18, this.bin, 0.8 + amb);
        double near = -(Math.min(100.0, sdd) - 100.0) * (100.0 / sdd / 1.2);
        double far = (Math.max(400.0, sdd) - 400.0) * (400.0 / sdd) * 2.0;
        this.vrp[0] = 670.5 + far - near;
        this.vrp[1] = -5.0;
        this.vrp[2] = sdd / 2.0;
        this.fp[0] = -830.0;
        this.fp[1] = -5.0;
        this.fp[2] = sdd / 2.0;
    }

    private synchronized void setUpSourceAnnotations() {
        double scale = 10.0;
        Parameter p = Main.getParameter("1606");
        double tsrc = 1.0 * scale;
        tsrc = p.getFloatValue().floatValue() / 100.0f;
        Parameter r = Main.getParameter("1");
        double rsrc = (double)r.getFloatValue().floatValue() * scale / 2.0;
        double[] loc = new double[]{(rsrc /= 2.0) - 20.0, 40.0, -(tsrc += 0.5) + 2.0, 1.0};
        this.annotations.add("Thickness");
        this.annotations.add(loc);
        double[] b = new double[]{rsrc - 4.0, 0.0, 0.0, 1.0};
        double[] e = new double[]{rsrc - 4.0, 0.0, tsrc, 1.0};
        this.annotations.add(b);
        this.annotations.add(e);
        double[] loc2 = new double[]{0.0, -rsrc + 30.0, tsrc + 5.0, 1.0};
        this.annotations.add("Diameter");
        this.annotations.add(loc2);
        double[] b2 = new double[]{0.0, rsrc, tsrc, 1.0};
        double[] e2 = new double[]{0.0, -rsrc, tsrc, 1.0};
        this.annotations.add(b2);
        this.annotations.add(e2);
    }

    private synchronized void setUpSourceView() {
        ArrayList c1 = new ArrayList();
        ArrayList d1 = new ArrayList();
        ArrayList c2 = new ArrayList();
        ArrayList d2 = new ArrayList();
        this.bin.clear();
        this.annotations.clear();
        double scale = 10.0;
        double tdet = 14.0 * scale;
        double rdet = 11.96 * scale;
        double sdd = 44.0 * scale;
        Parameter p = Main.getParameter("1606");
        double tsrc = 1.0 * scale;
        tsrc = p.getFloatValue().floatValue() / 100.0f;
        Parameter r = Main.getParameter("1");
        double rsrc = (double)r.getFloatValue().floatValue() * scale / 2.0;
        this.createCylinder(0.0, 0.0, rsrc /= 2.0, 1.0, tsrc += 0.5, 18, this.bin, 1.0);
        this.bin.add(this.metal);
        this.createCylinder(0.0, 0.0, rdet, -40.0, 40.0, 18, this.bin, 0.8);
        this.vrp[0] = 205.5;
        this.vrp[1] = -5.0;
        this.vrp[2] = 55.0;
        this.fp[0] = -1395.0;
        this.fp[1] = -5.0;
        this.fp[2] = 55.0;
    }

    private double M(double mean, double dev) {
        double mean2 = mean * mean;
        double dev2 = dev * dev;
        double M = Math.log(mean2 / Math.sqrt(mean2 + dev2));
        return M;
    }

    private double S(double mean, double dev) {
        double devpermean = dev / mean;
        double S = Math.sqrt(Math.log(devpermean * devpermean + 1.0));
        return S;
    }

    private double mean(double m, double s) {
        double mean = Math.pow(Math.E, 0.5 * (s * s + 2.0 * m));
        System.out.println("mean:" + mean);
        return mean;
    }

    private double stdev(double m, double s) {
        double es2m = Math.pow(Math.E, s * s + 2.0 * m);
        double es2 = Math.pow(Math.E, s * s);
        double stdev = Math.sqrt(es2m * (es2 - 1.0));
        System.out.println("stdev:" + stdev);
        return stdev;
    }

    private Graph exponential(double mean, double ceil) {
        double[] x = new double[80];
        double[] y = new double[80];
        double incr = ceil / (double)x.length;
        double lambda = 1.0 / mean;
        for (int i = 0; i < x.length; ++i) {
            x[i] = ((double)i + 0.01) * incr;
            y[i] = lambda * Math.exp(-lambda * x[i]);
        }
        XYGraph g = new XYGraph();
        g.setX(x);
        g.setY(y);
        return g;
    }

    private Graph lognormal(double m, double s, double ceil) {
        double sqrt2pi = Math.sqrt(Math.PI * 2);
        double[] x = new double[80];
        double[] y = new double[80];
        double incr = ceil / (double)x.length;
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            x[i] = (double)(i + 1) * incr;
            double prefix = 1.0 / (s * sqrt2pi * x[i]);
            double lnx = Math.log(x[i]);
            double ep = -((lnx - m) * (lnx - m) / (s * s)) * 0.5;
            double postfix = Math.pow(Math.E, ep);
            y[i] = prefix * postfix;
            sum += y[i];
        }
        System.out.println("SUM:" + sum);
        XYGraph g = new XYGraph();
        g.setX(x);
        g.setY(y);
        return g;
    }

    private synchronized void setUpParticlesAnnotations() {
        double scale = 1000.0;
        double rx = 0.1 * scale;
        double ry = 0.2 * scale;
        double rz = 0.1194 * scale;
        Parameter p = Main.getParameter("1003");
        if (p.getStringValue().equals("e")) {
            this.annotations.add("x-axis");
            double[] loc = new double[]{-rx, -ry + 60.0, -rz, 1.0};
            this.annotations.add(loc);
            double[] b = new double[]{-rx, -ry, -rz, 1.0};
            double[] e = new double[]{rx, -ry - 20.0, -rz, 1.0};
            this.annotations.add(b);
            this.annotations.add(e);
            this.annotations.add("y-axis");
            double[] loc2 = new double[]{rx, ry, -rz, 1.0};
            this.annotations.add(loc2);
            double[] b2 = new double[]{rx, -ry, -rz, 1.0};
            double[] e2 = new double[]{rx, ry, -rz, 1.0};
            this.annotations.add(b2);
            this.annotations.add(e2);
            this.annotations.add("z-axis");
            double[] loc3 = new double[]{rx, -ry + 60.0, rz, 1.0};
            this.annotations.add(loc3);
            double[] b3 = new double[]{rx, -ry, -rz, 1.0};
            double[] e3 = new double[]{rx, -ry, rz, 1.0};
            this.annotations.add(b3);
            this.annotations.add(e3);
        } else {
            Parameter r = Main.getParameter("7");
            double rad = r.getFloatValue().floatValue();
            scale = 150.0 / rad;
            this.annotations.add("Diameter");
            double[] loc = new double[]{0.0, 0.0, -(rad *= scale) - 95.0, 1.0};
            this.annotations.add(loc);
            double[] b = new double[]{0.0, 0.0, rad, 1.0};
            double[] e = new double[]{0.0, 0.0, -rad - 35.0, 1.0};
            this.annotations.add(b);
            this.annotations.add(e);
        }
        if (Main.getParameter("1010").getStringValue().equals("y")) {
            double mean = Main.getParameter("23").getFloatValue().floatValue();
            double dev = Math.log(Main.getParameter("24").getFloatValue().floatValue());
            double ceil = Main.getParameter("25").getFloatValue().floatValue();
            double M = this.M(mean, dev);
            double S = this.S(mean, dev);
            Graph g = this.lognormal(M, S, ceil);
            Axis axis = new Axis();
            double ymax = g.getYmax();
            axis.setMinMax(0.0, 0.0, ceil * 1.2, ymax);
            double[] tics = new double[]{mean, ceil};
            axis.setTics(tics, 0);
            axis.setNumberOfTicDecimals(3, 0);
            axis.setTitle("frequency", 1);
            axis.setTitle("diameter", 0);
            axis.setSize(150, 150);
            this.graphCanvas.setSize(150, 100);
            this.graphCanvas.getAnnotations().clear();
            this.graphCanvas.getGraphs().clear();
            Color b = new Color(255, 255, 255, 255);
            this.graphCanvas.setBackground(b);
            this.graphCanvas.setAxis(axis);
            g.setColor(Color.blue);
            g.setFillColor(Color.green);
            g.setFilled(true);
            this.graphCanvas.addGraph(g);
            this.graphCanvas.start();
            this.graphCanvas.refresh();
            this.annotations.add(this.graphCanvas.getImage());
            int[] locI = new int[]{10, 180};
            this.annotations.add(locI);
            this.annotations.add("Particle size distribution");
            int[] locI2 = new int[]{10, 180};
            this.annotations.add(locI2);
        }
        if (Main.getParameter("1007").getStringValue().equals("y")) {
            double mean = Main.getParameter("20").getFloatValue().floatValue();
            this.graphCanvas.getAnnotations().clear();
            this.graphCanvas.getGraphs().clear();
            Graph g = this.exponential(mean, 4.0 * mean);
            Axis axis = new Axis();
            double ymax = g.getYmax();
            double thickn = Main.getParameter("1606").getFloatValue().floatValue();
            double ty = 1.0 / mean * Math.exp(-1.0 / mean * thickn);
            double[] line = new double[]{thickn, 0.0, thickn, ymax};
            this.graphCanvas.addAnnotation(Color.red);
            this.graphCanvas.addAnnotation(line);
            axis.setMinMax(0.0, 0.0, 4.0 * mean, ymax);
            double[] tics = new double[]{mean};
            axis.setTics(tics, 0);
            axis.setNumberOfTicDecimals(3, 0);
            axis.setTitle("frequency", 1);
            axis.setTitle("depth", 0);
            axis.setSize(150, 150);
            this.graphCanvas.setSize(150, 100);
            Color b = new Color(255, 255, 255, 255);
            this.graphCanvas.setBackground(b);
            this.graphCanvas.setAxis(axis);
            g.setColor(Color.green.darker());
            g.setFillColor(Color.orange);
            g.setFilled(true);
            this.graphCanvas.addGraph(g);
            this.graphCanvas.start();
            this.graphCanvas.refresh();
            this.annotations.add(this.graphCanvas.getImage());
            int[] locI = new int[]{150, 180};
            this.annotations.add(locI);
            this.annotations.add(Color.green.darker());
            this.annotations.add("Penetration depth distribution");
            int[] locI2 = new int[]{150, 180};
            this.annotations.add(locI2);
        }
    }

    private synchronized void setUpParticlesView() {
        this.bin.clear();
        this.annotations.clear();
        Parameter p = Main.getParameter("1003");
        double scale = 100000.0;
        double rx = 0.1 * scale;
        double ry = 0.2 * scale;
        double rz = 0.1194 * scale;
        if (p.getStringValue().equals("b")) {
            Parameter r = Main.getParameter("7");
            double rad = r.getFloatValue().floatValue();
            scale = 150.0 / rad;
            rx = rad *= scale;
            ry = rad;
            rz = rad;
        } else {
            Parameter x = Main.getParameter("9");
            Parameter y = Main.getParameter("10");
            Parameter z = Main.getParameter("11");
            rx = x.getFloatValue().floatValue();
            ry = y.getFloatValue().floatValue();
            rz = z.getFloatValue().floatValue();
            double max = Math.max(rx, ry);
            max = Math.max(max, rz);
            scale = 150.0 / max;
            rx *= scale;
            ry *= scale;
            rz *= scale;
        }
        SketchPanel.createEllipsoid(0.0, 0.0, 0.0, rx, ry, rz, 30, this.bin);
        this.vrp[0] = 452.5;
        this.vrp[1] = -435.0;
        this.vrp[2] = 295.0;
        this.fp[0] = -22.5;
        this.fp[1] = 40.0;
        this.fp[2] = -250.0;
    }

    private synchronized void setUpBackingplateView() {
        this.bin.clear();
        this.annotations.clear();
        double scale = 20.0;
        double tsrc = 1.0 * scale;
        double rsrc = 6.96 * scale;
        double rdet = 11.96 * scale;
        this.createCylinder(0.0, 0.0, rsrc, -tsrc + 2.0, scale, 15, this.bin, 1.0);
        this.bin.add(this.metal);
        this.createCylinder(0.0, 0.0, rdet, -tsrc, tsrc, 20, this.bin, 0.8);
        double sdd = 44.0 * scale;
        this.vrp[0] = 362.5;
        this.vrp[1] = -185.0;
        this.vrp[2] = 45.5;
        this.fp[0] = -1237.5;
        this.fp[1] = -185.0;
        this.fp[2] = 45.5;
    }

    private synchronized void setUpBackingplateAnnotations() {
        double scale = 20.0;
        double tsrc = 1.0 * scale;
        double rsrc = 6.96 * scale;
        double rdet = 11.96 * scale;
        this.annotations.add("Thickness");
        double[] loc = new double[]{0.0, -rdet, -25.0, 1.0};
        this.annotations.add(loc);
        double[] b = new double[]{0.0, -rdet + 10.0, -15.0, 1.0};
        double[] e = new double[]{0.0, -rdet + 10.0, -40.0, 1.0};
        this.annotations.add(b);
        this.annotations.add(e);
    }

    private synchronized void setUpDetectorAnnotations() {
        double scale = 10.0;
        double tdet = 14.0 * scale;
        double rdet2 = 11.0 * scale;
        Parameter detR = Main.getParameter("12");
        double rdet = (double)detR.getFloatValue().floatValue() * scale / 2.0;
        double sdd = 44.0 * scale;
        this.annotations.add("Diameter");
        double[] loc = new double[]{0.0, 0.0, sdd - 60.0, 1.0};
        this.annotations.add(loc);
        this.annotations.add("Thickness");
        double[] loc2 = new double[]{0.0, 2.0 * rdet2 - 30.0, sdd - 20.0, 1.0};
        this.annotations.add(loc2);
        double[] b = new double[]{-rdet / 2.0, 0.0, sdd, 1.0};
        double[] e = new double[]{rdet / 2.0, 0.0, sdd, 1.0};
        this.annotations.add(b);
        this.annotations.add(e);
        double[] b2 = new double[]{0.0, rdet / 2.0, sdd, 1.0};
        double[] e2 = new double[]{0.0, rdet / 2.0, sdd - 3.0, 1.0};
        this.annotations.add(b2);
        this.annotations.add(e2);
    }

    private synchronized void setUpDetectorView() {
        this.bin.clear();
        this.annotations.clear();
        this.bin.add(this.metal);
        ArrayList c1 = new ArrayList();
        ArrayList d1 = new ArrayList();
        ArrayList c2 = new ArrayList();
        ArrayList d2 = new ArrayList();
        double scale = 10.0;
        double tdet = 14.0 * scale;
        Parameter detR = Main.getParameter("12");
        double rdet = (double)detR.getFloatValue().floatValue() * scale / 2.0;
        double rdet2 = 11.0 * scale;
        double sdd = 44.0 * scale;
        this.createCylinder(0.0, 0.0, rdet2, sdd, tdet, 18, this.bin, 0.4);
        this.bin.add(this.toon);
        this.createCylinder(0.0, 0.0, rdet / 2.0, sdd - 3.0, 3.0, 18, this.bin, 0.0);
        this.vrp[0] = 517.5;
        this.vrp[1] = 0.0;
        this.vrp[2] = 222.5;
        this.fp[0] = -1082.5;
        this.fp[1] = 0.0;
        this.fp[2] = 822.5;
    }

    public synchronized void render() {
        PolyUtils.getViewingTransform(this.vrp, this.fp, this.up, this.Tv);
        this.p.setViewingTransform(this.Tv);
        this.p.setShader(this.toon);
        this.fb.clear();
        int i = 0;
        while (i < this.bin.size()) {
            Object o;
            if ((o = this.bin.get(i++)) instanceof Shader) {
                this.p.setShader((Shader)o);
                continue;
            }
            List v = (List)o;
            List d = (List)this.bin.get(i++);
            this.p.setVertices(v);
            this.p.setVertexData(d);
            this.p.render();
        }
        this.renderAnnotations(this.fb.getImage().getGraphics());
    }

    private void renderAnnotations(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(this.hints);
        g.setColor(Color.blue);
        int i = 0;
        while (i < this.annotations.size()) {
            Object o;
            if ((o = this.annotations.get(i++)) instanceof String) {
                Object oloc;
                String s = (String)o;
                if ((oloc = this.annotations.get(i++)) instanceof double[]) {
                    double[] loc = (double[])oloc;
                    PolyUtils.matMult4(loc, this.Tv, this.loct2);
                    PolyUtils.matMult4(this.loct2, this.Tp, this.loct);
                    this.loct[0] = this.loct[0] * (double)this.w;
                    this.loct[1] = this.loct[1] * (double)this.h;
                    this.loct[0] = this.loct[0] / this.loct[3];
                    this.loct[1] = this.loct[1] / this.loct[3];
                    this.loct[0] = this.loct[0] + (double)this.ox;
                    this.loct[1] = this.loct[1] + (double)this.oy;
                    g.setFont(this.font);
                    g.drawString(s, (int)this.loct[0], this.h - (int)this.loct[1]);
                    continue;
                }
                int[] iloc = (int[])oloc;
                g.setFont(this.font);
                g.drawString(s, iloc[0], iloc[1]);
                continue;
            }
            if (o instanceof Image) {
                BufferedImage img = (BufferedImage)o;
                int[] loc = (int[])this.annotations.get(i++);
                g2d.drawImage(img, null, loc[0], loc[1]);
                continue;
            }
            if (o instanceof Color) {
                g2d.setColor((Color)o);
                continue;
            }
            double[] begin = (double[])o;
            double[] end = (double[])this.annotations.get(i++);
            PolyUtils.matMult4(begin, this.Tv, this.loct3);
            PolyUtils.matMult4(this.loct3, this.Tp, this.loct);
            PolyUtils.matMult4(end, this.Tv, this.loct3);
            PolyUtils.matMult4(this.loct3, this.Tp, this.loct2);
            this.loct[0] = this.loct[0] * (double)this.w;
            this.loct[1] = this.loct[1] * (double)this.h;
            this.loct[0] = this.loct[0] / this.loct[3];
            this.loct[1] = this.loct[1] / this.loct[3];
            this.loct[0] = this.loct[0] + (double)this.ox;
            this.loct[1] = this.loct[1] + (double)this.oy;
            this.loct2[0] = this.loct2[0] * (double)this.w;
            this.loct2[1] = this.loct2[1] * (double)this.h;
            this.loct2[0] = this.loct2[0] / this.loct[3];
            this.loct2[1] = this.loct2[1] / this.loct[3];
            this.loct2[0] = this.loct2[0] + (double)this.ox;
            this.loct2[1] = this.loct2[1] + (double)this.oy;
            g.drawLine((int)this.loct[0], this.h - (int)this.loct[1], (int)this.loct2[0], this.h - (int)this.loct2[1]);
        }
    }

    public void refresh() {
        this.setView(this.currentView);
    }

    public void paint(Graphics g) {
        Graphics2D gr = (Graphics2D)g;
        gr.drawImage(this.fb.getImage(), null, 0, 0);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(255, 255, 255));
    }

    private void createCircle(double x, double y, double r, double z, int numSegs, List vertices, List datas, double in) {
        double ang = 0.0;
        double angIncr = Math.PI * 2 / (double)numSegs;
        for (int i = 0; i < numSegs; ++i) {
            double[] v = new double[]{0.0, 0.0, 0.0, 1.0};
            double[] d = new double[]{0.0, in, 0.0, 0.0, 1.0};
            v[0] = x + Math.cos(ang) * r;
            v[1] = y + Math.sin(ang) * r;
            v[2] = z;
            ang += angIncr;
            vertices.add(v);
            datas.add(d);
        }
    }

    private void createCylinder(List cap1, List cap1d, List cap2, List cap2d, List target) {
        target.add(cap1);
        target.add(cap1d);
        target.add(cap2);
        target.add(cap2d);
        this.createSides(cap1, cap1d, cap2, cap2d, target);
    }

    private void createCylinder(double x, double y, double r, double z, double h, int numSegs, List target, double i) {
        ArrayList cap1 = new ArrayList();
        ArrayList cap1d = new ArrayList();
        ArrayList cap2 = new ArrayList();
        ArrayList cap2d = new ArrayList();
        this.createCircle(x, y, r, z, numSegs, cap1, cap1d, i);
        this.createCircle(x, y, r, z + h, numSegs, cap2, cap2d, i);
        this.createCylinder(cap1, cap1d, cap2, cap2d, target);
    }

    private void createSides(List cap1, List cap1d, List cap2, List cap2d, List target) {
        for (int i = 0; i < cap1.size() - 1; ++i) {
            double[] v1 = (double[])cap1.get(i);
            double[] v2 = (double[])cap1.get(i + 1);
            double[] v3 = (double[])cap2.get(i + 1);
            double[] v4 = (double[])cap2.get(i);
            double[] d1 = (double[])cap1d.get(i);
            double[] d2 = (double[])cap1d.get(i + 1);
            double[] d3 = (double[])cap2d.get(i + 1);
            double[] d4 = (double[])cap2d.get(i);
            ArrayList<double[]> sidePoly = new ArrayList<double[]>();
            ArrayList<double[]> sideData = new ArrayList<double[]>();
            sidePoly.add(v1);
            sidePoly.add(v2);
            sidePoly.add(v3);
            sidePoly.add(v4);
            double[] n = (double[])v1.clone();
            PolyUtils.normalize(n);
            double[] dt1 = new double[]{0.0, 0.6, n[0], n[1], n[2]};
            n = (double[])v2.clone();
            PolyUtils.normalize(n);
            double[] dt2 = new double[]{0.0, 0.6, n[0], n[1], n[2]};
            n = (double[])v3.clone();
            PolyUtils.normalize(n);
            double[] dt3 = new double[]{0.0, 0.6, n[0], n[1], n[2]};
            n = (double[])v4.clone();
            PolyUtils.normalize(n);
            double[] dt4 = new double[]{0.0, 0.6, n[0], n[1], n[2]};
            sideData.add(dt1);
            sideData.add(dt2);
            sideData.add(dt3);
            sideData.add(dt4);
            target.add(sidePoly);
            target.add(sideData);
        }
        double[] v1 = (double[])cap1.get(cap1.size() - 1);
        double[] v2 = (double[])cap1.get(0);
        double[] v3 = (double[])cap2.get(0);
        double[] v4 = (double[])cap2.get(cap2.size() - 1);
        ArrayList<double[]> sidePoly = new ArrayList<double[]>();
        ArrayList<double[]> sideData = new ArrayList<double[]>();
        sidePoly.add(v1);
        sidePoly.add(v2);
        sidePoly.add(v3);
        sidePoly.add(v4);
        double[] n = (double[])v1.clone();
        PolyUtils.normalize(n);
        double[] dt1 = new double[]{0.0, 0.6, n[0], n[1], n[2]};
        n = (double[])v2.clone();
        PolyUtils.normalize(n);
        double[] dt2 = new double[]{0.0, 0.6, n[0], n[1], n[2]};
        n = (double[])v3.clone();
        PolyUtils.normalize(n);
        double[] dt3 = new double[]{0.0, 0.6, n[0], n[1], n[2]};
        n = (double[])v4.clone();
        PolyUtils.normalize(n);
        double[] dt4 = new double[]{0.0, 0.6, n[0], n[1], n[2]};
        sideData.add(dt1);
        sideData.add(dt2);
        sideData.add(dt3);
        sideData.add(dt4);
        target.add(sidePoly);
        target.add(sideData);
    }

    public static void createEllipsoid(double x, double y, double z, double rX, double rY, double rZ, int numSeg, List target) {
        double full = Math.PI * 2;
        double half = Math.PI;
        double quart = 1.5707963267948966;
        int N = numSeg;
        double[] u = new double[4];
        double[] v = new double[4];
        int n = N - 2;
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                u[0] = (double)i * full / (double)n;
                v[0] = quart - (double)j * half / (double)n;
                u[1] = (double)((i + 1) % n) * full / (double)n;
                v[1] = quart - (double)j * half / (double)n;
                u[2] = (double)((i + 1) % n) * full / (double)n;
                v[2] = quart - (double)((j + 1) % n) * half / (double)n;
                u[3] = (double)i * full / (double)n;
                v[3] = quart - (double)((j + 1) % n) * half / (double)n;
                ArrayList<double[]> poly = new ArrayList<double[]>();
                poly.add(SketchPanel.eVertex(u[0], v[0], rX, rY, rZ));
                poly.add(SketchPanel.eVertex(u[1], v[1], rX, rY, rZ));
                poly.add(SketchPanel.eVertex(u[2], v[2], rX, rY, rZ));
                poly.add(SketchPanel.eVertex(u[3], v[3], rX, rY, rZ));
                target.add(poly);
                ArrayList<double[]> data = new ArrayList<double[]>();
                data.add(SketchPanel.eData(u[0], v[0], rX, rY, rZ));
                data.add(SketchPanel.eData(u[1], v[1], rX, rY, rZ));
                data.add(SketchPanel.eData(u[2], v[2], rX, rY, rZ));
                data.add(SketchPanel.eData(u[3], v[3], rX, rY, rZ));
                target.add(data);
            }
        }
    }

    private static double[] eVertex(double u, double v, double rx, double ry, double rz) {
        double[] v1 = new double[]{Math.round(rx * Math.cos(u) * Math.cos(v)), Math.round(ry * Math.cos(u) * Math.sin(v)), Math.round(rz * Math.sin(u)), 1.0};
        return v1;
    }

    private static double[] eData(double u, double v, double rx, double ry, double rz) {
        double[] v1 = new double[]{Math.round(rx * Math.cos(u) * Math.cos(v)), Math.round(ry * Math.cos(u) * Math.sin(v)), Math.round(rz * Math.sin(u))};
        PolyUtils.normalize(v1);
        double[] d = new double[]{0.0, Math.pow(PolyUtils.dot(v1, light), 3.0) + 0.3, v1[0], v1[1], v1[2]};
        return d;
    }
}

