/*
 * Decompiled with CFR 0.152.
 */
package UI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SplashWindow
extends JWindow {
    public JProgressBar bar = new JProgressBar();
    public JLabel status = new JLabel();

    public SplashWindow(Frame f, int waitTime) {
        super(f);
        this.bar = new JProgressBar(){

            public void paint(Graphics g) {
                float range = this.getMaximum() - this.getMinimum();
                float ex = (float)this.getValue() / range;
                g.setColor(this.getForeground());
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.fillRect(0, 0, (int)(ex * (float)this.getWidth()), this.getHeight());
            }
        };
        this.bar.setString("");
        this.bar.setPreferredSize(new Dimension(440, 8));
        this.status = new JLabel(){

            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(g);
            }
        };
        this.status.setText("Loading....");
        this.status.setOpaque(false);
        this.status.setForeground(new Color(210, 210, 210));
        this.bar.setForeground(new Color(210, 210, 210));
        this.bar.setBorderPainted(false);
        this.bar.setOpaque(false);
        this.bar.setMinimum(0);
        this.bar.setMaximum(100);
        this.bar.setValue(0);
        JPanel p = new JPanel();
        p.setLayout(new AbsoluteLayout());
        p.add((Component)this.status, new AbsoluteConstraints(40, 180));
        p.add((Component)this.bar, new AbsoluteConstraints(0, 200));
        p.setOpaque(false);
        this.setGlassPane(p);
        p.setVisible(true);
        JLabel l = new JLabel(new ImageIcon(this.getClass().getResource("images/SplashImage.png")));
        this.getContentPane().add((Component)l, "Center");
        this.pack();
        ((JPanel)this.getContentPane()).setOpaque(false);
        this.getRootPane().setOpaque(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        });
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable(){

            public void run() {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        };
        Runnable waitRunner = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(pause);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.setVisible(true);
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.start();
    }
}

