/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class Element {
    private Integer Z;
    private Integer A;
    private Float density;
    private List energy = new ArrayList();
    private List attenuation = new ArrayList();
    private String name;
    private float[] coefficents = new float[9];
    static String[] names;
    static float[] weights;
    static String[] abbreviations;
    static float[] densities;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            this.name = Element.determineName(this.Z);
        }
        return this.name;
    }

    public List getEnergyList() {
        return this.energy;
    }

    public List getAttenuationList() {
        return this.attenuation;
    }

    public void setZ(Integer z) {
        this.Z = z;
        if (this.name == null) {
            this.setName(Element.determineName(this.Z));
        }
    }

    public void setA(Integer a) {
        this.A = a;
    }

    public Integer getZ() {
        return this.Z;
    }

    public void addAttenuationForEnergy(Float energy, Float attenuation) {
        this.energy.add(energy);
        this.attenuation.add(attenuation);
    }

    public String toString() {
        return this.name;
    }

    public boolean isIsotope() {
        if (this.A == null) {
            return false;
        }
        Integer t = this.A;
        this.A = null;
        float f = this.getA();
        this.A = t;
        return t != Math.round(f);
    }

    public void setCoefficent(int index, float value) {
        this.coefficents[index] = value;
    }

    public float getCoefficent(int index) {
        return this.coefficents[index];
    }

    public float getA() {
        if (this.A != null) {
            return this.A.intValue();
        }
        int z = this.Z;
        if (z < 1) {
            return 0.0f;
        }
        if (z == -1) {
            return -1.0f;
        }
        if (z == -2) {
            return -2.0f;
        }
        if (z == -3) {
            return -3.0f;
        }
        if (z == -4) {
            return -4.0f;
        }
        if (z < 1) {
            return 0.0f;
        }
        return weights[z - 1];
    }

    public static String determineName(Integer Z) {
        int z = Z;
        if (z == -1) {
            return "UO2";
        }
        if (z == -2) {
            return "ThO2";
        }
        if (z == -3) {
            return "UO2";
        }
        if (z == -4) {
            return "U3O8";
        }
        if (z < 1) {
            return "Unknown";
        }
        return names[z - 1];
    }

    public String getAbbreviation() {
        return Element.determineAbbreviation(this.Z);
    }

    public static String determineAbbreviation(Integer Z) {
        int z = Z;
        if (z == -1) {
            return "UO2";
        }
        if (z == -2) {
            return "ThO2";
        }
        if (z == -3) {
            return "UO2";
        }
        if (z == -4) {
            return "U3O8";
        }
        if (z < 1) {
            return "n/a";
        }
        return abbreviations[z - 1];
    }

    public double getDensity() {
        if (this.density == null) {
            return densities[this.Z - 1];
        }
        return this.density.floatValue();
    }

    public void setDensity(double density) {
        this.density = new Float((float)density);
    }

    static {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader("./lib/Elements.dat"));
            int ind = 0;
            names = new String[92];
            abbreviations = new String[92];
            weights = new float[92];
            densities = new float[92];
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split("\\s+");
                if (ind >= names.length) continue;
                Element.abbreviations[ind] = tokens[1];
                Element.weights[ind] = Float.parseFloat(tokens[3]);
                Element.names[ind] = tokens[2];
                if (!tokens[4].equals("?")) {
                    Element.densities[ind] = Float.parseFloat(tokens[4]);
                }
                ++ind;
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

